/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.formatters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.CmsPropertyConfig;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsMacroFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentRootLocation;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsFormatterBeanParser {
    public static final String N_AUTO_ENABLED = "AutoEnabled";
    public static final String N_CHOICE_NEW_LINK = "ChoiceNewLink";
    public static final String N_CONTAINER_TYPE = "ContainerType";
    public static final String N_CSS_INLINE = "CssInline";
    public static final String N_CSS_LINK = "CssLink";
    public static final String N_DETAIL = "Detail";
    public static final String N_DISPLAY = "Display";
    public static final String N_FORMATTER = "Formatter";
    public static final String N_FORMATTERS = "Formatters";
    public static final String N_HEAD_INCLUDE_CSS = "HeadIncludeCss";
    public static final String N_HEAD_INCLUDE_JS = "HeadIncludeJs";
    public static final String N_DEFAULT_CONTENT = "DefaultContent";
    public static final String N_JAVASCRIPT_INLINE = "JavascriptInline";
    public static final String N_JAVASCRIPT_LINK = "JavascriptLink";
    public static final String N_JSP = "Jsp";
    public static final String N_MACRO = "Macro";
    public static final String N_MACRO_NAME = "MacroName";
    public static final String N_MATCH = "Match";
    public static final String N_MAX_WIDTH = "MaxWidth";
    public static final String N_NESTED_CONTAINERS = "NestedContainers";
    public static final String N_NICE_NAME = "NiceName";
    public static final String N_PLACEHOLDER_MACRO = "PlaceholderMacro";
    public static final String N_PREVIEW = "Preview";
    public static final String N_RANK = "Rank";
    public static final String N_SEARCH_CONTENT = "SearchContent";
    public static final String N_SETTING = "Setting";
    public static final String N_STRICT_CONTAINERS = "StrictContainers";
    public static final String N_TYPE = "Type";
    public static final String N_TYPES = "Types";
    public static final String N_WIDTH = "Width";
    private static final Log LOG = CmsLog.getLog(CmsFormatterBeanParser.class);
    int m_width;
    private boolean m_autoEnabled;
    private CmsObject m_cms;
    private Set<String> m_containerTypes;
    private List<String> m_cssPaths = new ArrayList<String>();
    private boolean m_extractContent;
    private CmsResource m_formatterResource;
    private StringBuffer m_inlineCss = new StringBuffer();
    private StringBuffer m_inlineJs = new StringBuffer();
    private List<String> m_jsPaths = new ArrayList<String>();
    private int m_maxWidth;
    private String m_niceName;
    private boolean m_preview;
    private int m_rank;
    private Set<String> m_resourceType;
    private Map<String, CmsXmlContentProperty> m_settings = new LinkedHashMap<String, CmsXmlContentProperty>();

    public CmsFormatterBeanParser(CmsObject cms) {
        this.m_cms = cms;
    }

    public static String path(String ... components) {
        return CmsStringUtil.joinPaths(components);
    }

    public CmsFormatterBean parse(CmsXmlContent content, String location, String id) throws CmsException, ParseException {
        CmsFormatterBean formatterBean;
        int rank;
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(content.getFile());
        boolean isMacroFromatter = "macro_formatter".equals(type.getTypeName());
        Locale en = Locale.ENGLISH;
        I_CmsXmlContentValue niceName = content.getValue(N_NICE_NAME, en);
        this.m_niceName = niceName != null ? niceName.getStringValue(this.m_cms) : null;
        CmsXmlContentRootLocation root = new CmsXmlContentRootLocation(content, en);
        I_CmsXmlContentValueLocation rankLoc = root.getSubValue(N_RANK);
        String rankStr = rankLoc.getValue().getStringValue(this.m_cms);
        if (rankStr != null) {
            rankStr = rankStr.trim();
        }
        try {
            rank = Integer.parseInt(rankStr);
        }
        catch (NumberFormatException e) {
            rank = 1000;
            LOG.debug((Object)"Error parsing formatter rank.", (Throwable)e);
        }
        this.m_rank = rank;
        this.m_resourceType = this.getStringSet(root, N_TYPE);
        this.parseSettings(root);
        String isDetailStr = this.getString(root, N_DETAIL, "true");
        boolean isDetail = Boolean.parseBoolean(isDetailStr);
        String isDisplayStr = this.getString(root, N_DISPLAY, "false");
        boolean isDisplay = Boolean.parseBoolean(isDisplayStr);
        String isStrictContainersStr = this.getString(root, N_STRICT_CONTAINERS, "false");
        boolean isStrictContainers = Boolean.parseBoolean(isStrictContainersStr);
        String autoEnabled = this.getString(root, N_AUTO_ENABLED, "false");
        this.m_autoEnabled = Boolean.parseBoolean(autoEnabled);
        this.parseMatch(root);
        if (isMacroFromatter) {
            CmsXmlVfsFileValue defContentValue;
            CmsLink defContentLink;
            this.m_formatterResource = content.getFile();
            this.m_preview = false;
            this.m_extractContent = true;
            boolean hasNestedContainers = false;
            CmsResource defContentRes = null;
            I_CmsXmlContentValueLocation defContentLoc = root.getSubValue(N_DEFAULT_CONTENT);
            if (defContentLoc != null && (defContentLink = (defContentValue = (CmsXmlVfsFileValue)defContentLoc.getValue()).getLink(this.m_cms)) != null) {
                CmsUUID defContentID = defContentLink.getStructureId();
                defContentRes = this.m_cms.readResource(defContentID);
            }
            String macroInput = this.getString(root, N_MACRO, "");
            String placeholderMacroInput = this.getString(root, N_PLACEHOLDER_MACRO, "");
            Map<String, CmsUUID> referencedFormatters = this.readReferencedFormatters(content);
            formatterBean = new CmsMacroFormatterBean(this.m_containerTypes, this.m_formatterResource.getRootPath(), this.m_formatterResource.getStructureId(), this.m_width, this.m_maxWidth, this.m_extractContent, location, this.m_niceName, this.m_resourceType, rank, id, defContentRes != null ? defContentRes.getRootPath() : null, defContentRes != null ? defContentRes.getStructureId() : null, this.m_settings, this.m_autoEnabled, isDetail, isDisplay, macroInput, placeholderMacroInput, referencedFormatters, this.m_cms.getRequestContext().getCurrentProject().isOnlineProject());
        } else {
            CmsResource formatterRes;
            I_CmsXmlContentValueLocation jspLoc = root.getSubValue(N_JSP);
            CmsXmlVfsFileValue jspValue = (CmsXmlVfsFileValue)jspLoc.getValue();
            CmsLink link = jspValue.getLink(this.m_cms);
            if (link == null) {
                LOG.info((Object)("JSP link is null in formatter configuration: " + content.getFile().getRootPath()));
                return null;
            }
            CmsUUID jspID = link.getStructureId();
            this.m_formatterResource = formatterRes = this.m_cms.readResource(jspID);
            String previewStr = this.getString(root, N_PREVIEW, "false");
            this.m_preview = Boolean.parseBoolean(previewStr);
            String searchableStr = this.getString(root, N_SEARCH_CONTENT, "true");
            this.m_extractContent = Boolean.parseBoolean(searchableStr);
            String hasNestedContainersString = this.getString(root, N_NESTED_CONTAINERS, "false");
            boolean hasNestedContainers = Boolean.parseBoolean(hasNestedContainersString);
            this.parseHeadIncludes(root);
            formatterBean = new CmsFormatterBean(this.m_containerTypes, this.m_formatterResource.getRootPath(), this.m_formatterResource.getStructureId(), this.m_width, this.m_maxWidth, this.m_preview, this.m_extractContent, location, this.m_cssPaths, this.m_inlineCss.toString(), this.m_jsPaths, this.m_inlineJs.toString(), this.m_niceName, this.m_resourceType, this.m_rank, id, this.m_settings, true, this.m_autoEnabled, isDetail, isDisplay, hasNestedContainers, isStrictContainers);
        }
        return formatterBean;
    }

    private String getString(I_CmsXmlContentLocation val, String path, String defaultValue) {
        I_CmsXmlContentValueLocation subVal;
        if (val != null && (subVal = val.getSubValue(path)) != null && subVal.getValue() != null) {
            return subVal.getValue().getStringValue(this.m_cms);
        }
        return defaultValue;
    }

    private Set<String> getStringSet(I_CmsXmlContentLocation val, String path) {
        HashSet<String> valueSet = new HashSet<String>();
        if (val != null) {
            List<I_CmsXmlContentValueLocation> singleValueLocs = val.getSubValues(path);
            for (I_CmsXmlContentValueLocation singleValueLoc : singleValueLocs) {
                String value = singleValueLoc.getValue().getStringValue(this.m_cms).trim();
                valueSet.add(value);
            }
        }
        return valueSet;
    }

    private void parseHeadIncludes(I_CmsXmlContentLocation formatterLoc) {
        I_CmsXmlContentValueLocation headIncludeJs;
        I_CmsXmlContentValueLocation headIncludeCss = formatterLoc.getSubValue(N_HEAD_INCLUDE_CSS);
        if (headIncludeCss != null) {
            for (I_CmsXmlContentValueLocation inlineCssLoc : headIncludeCss.getSubValues(N_CSS_INLINE)) {
                String inlineCss = inlineCssLoc.getValue().getStringValue(this.m_cms);
                this.m_inlineCss.append(inlineCss);
            }
            for (I_CmsXmlContentValueLocation cssLinkLoc : headIncludeCss.getSubValues(N_CSS_LINK)) {
                CmsXmlVfsFileValue fileValue = (CmsXmlVfsFileValue)cssLinkLoc.getValue();
                CmsLink link = fileValue.getLink(this.m_cms);
                if (link == null) continue;
                String cssPath = link.getTarget();
                this.m_cssPaths.add(cssPath);
            }
        }
        if ((headIncludeJs = formatterLoc.getSubValue(N_HEAD_INCLUDE_JS)) != null) {
            for (I_CmsXmlContentValueLocation inlineJsLoc : headIncludeJs.getSubValues(N_JAVASCRIPT_INLINE)) {
                String inlineJs = inlineJsLoc.getValue().getStringValue(this.m_cms);
                this.m_inlineJs.append(inlineJs);
            }
            for (I_CmsXmlContentValueLocation jsLinkLoc : headIncludeJs.getSubValues(N_JAVASCRIPT_LINK)) {
                CmsXmlVfsFileValue fileValue = (CmsXmlVfsFileValue)jsLinkLoc.getValue();
                CmsLink link = fileValue.getLink(this.m_cms);
                if (link == null) continue;
                String jsPath = link.getTarget();
                this.m_jsPaths.add(jsPath);
            }
        }
    }

    private void parseMatch(I_CmsXmlContentLocation linkFormatterLoc) throws ParseException {
        HashSet<String> containerTypes = new HashSet<String>();
        I_CmsXmlContentValueLocation typesLoc = linkFormatterLoc.getSubValue(CmsFormatterBeanParser.path(N_MATCH, N_TYPES));
        I_CmsXmlContentValueLocation widthLoc = linkFormatterLoc.getSubValue(CmsFormatterBeanParser.path(N_MATCH, N_WIDTH));
        if (typesLoc != null) {
            List<I_CmsXmlContentValueLocation> singleTypeLocs = typesLoc.getSubValues(N_CONTAINER_TYPE);
            for (I_CmsXmlContentValueLocation singleTypeLoc : singleTypeLocs) {
                String containerType = singleTypeLoc.getValue().getStringValue(this.m_cms).trim();
                containerTypes.add(containerType);
            }
            this.m_containerTypes = containerTypes;
        } else if (widthLoc != null) {
            String widthStr = this.getString(widthLoc, N_WIDTH, null);
            String maxWidthStr = this.getString(widthLoc, N_MAX_WIDTH, null);
            try {
                this.m_width = Integer.parseInt(widthStr);
            }
            catch (Exception e) {
                throw new ParseException("Invalid container width: [" + widthStr + "]", e);
            }
            try {
                this.m_maxWidth = Integer.parseInt(maxWidthStr);
            }
            catch (Exception e) {
                this.m_maxWidth = Integer.MAX_VALUE;
                LOG.debug((Object)maxWidthStr, (Throwable)e);
            }
        } else {
            throw new ParseException("Neither container types nor container widths defined!");
        }
    }

    private void parseSettings(I_CmsXmlContentLocation formatterLoc) {
        for (I_CmsXmlContentValueLocation settingLoc : formatterLoc.getSubValues(N_SETTING)) {
            CmsPropertyConfig propConfig = CmsConfigurationReader.parseProperty(this.m_cms, settingLoc);
            CmsXmlContentProperty property = propConfig.getPropertyData();
            this.m_settings.put(property.getName(), property);
        }
    }

    private Map<String, CmsUUID> readReferencedFormatters(CmsXmlContent xmlContent) {
        LinkedHashMap<String, CmsUUID> result = new LinkedHashMap<String, CmsUUID>();
        List<I_CmsXmlContentValue> formatters = xmlContent.getValues(N_FORMATTERS, CmsLocaleManager.MASTER_LOCALE);
        for (I_CmsXmlContentValue formatterValue : formatters) {
            CmsXmlVfsFileValue file = (CmsXmlVfsFileValue)xmlContent.getValue(formatterValue.getPath() + "/" + N_FORMATTER, CmsLocaleManager.MASTER_LOCALE);
            CmsUUID formatterId = file.getLink(this.m_cms).getStructureId();
            String macroName = xmlContent.getStringValue(this.m_cms, formatterValue.getPath() + "/" + N_MACRO_NAME, CmsLocaleManager.MASTER_LOCALE);
            result.put(macroName, formatterId);
        }
        return result;
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(String message) {
            super(message);
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

