/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;

public class CmsModelGroupHelper {
    public static final String MODEL_GROUP_BASE_CONTAINER = "base_container";
    private static final Log LOG = CmsLog.getLog(CmsModelGroupHelper.class);
    private CmsObject m_cms;
    private CmsADESessionCache m_sessionCache;
    private CmsADEConfigData m_configData;
    private boolean m_isEditingModelGroups;

    public CmsModelGroupHelper(CmsObject cms, CmsADEConfigData configData, CmsADESessionCache sessionCache, boolean isEditingModelGroups) {
        this.m_cms = cms;
        this.m_sessionCache = sessionCache;
        this.m_configData = configData;
        this.m_isEditingModelGroups = isEditingModelGroups;
    }

    public static CmsResource createModelGroup(CmsObject cms, CmsADEConfigData configData) throws CmsException {
        CmsResourceTypeConfig typeConfig = configData.getResourceType("modelgroup");
        return typeConfig.createNewElement(cms, configData.getBasePath());
    }

    public static boolean isModelGroupResource(CmsResource resource) {
        return "modelgroup".equals(OpenCms.getResourceManager().getResourceType(resource).getTypeName());
    }

    public static boolean updateModelGroupResource(CmsObject cms, CmsResource group, String baseContainerName) {
        if (!CmsModelGroupHelper.isModelGroupResource(group)) {
            return false;
        }
        try {
            CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, group);
            CmsContainerPageBean pageBean = xmlContainerPage.getContainerPage(cms);
            CmsContainerBean baseContainer = pageBean.getContainers().get(MODEL_GROUP_BASE_CONTAINER);
            boolean changedContent = false;
            if (baseContainer != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(baseContainerName)) {
                ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
                for (CmsContainerBean container : pageBean.getContainers().values()) {
                    if (container.getName().equals(MODEL_GROUP_BASE_CONTAINER)) {
                        CmsContainerBean replacer = new CmsContainerBean(baseContainerName, container.getType(), container.getParentInstanceId(), container.isRootContainer(), container.getElements());
                        containers.add(replacer);
                        changedContent = true;
                        continue;
                    }
                    containers.add(container);
                }
                if (changedContent) {
                    pageBean = new CmsContainerPageBean(containers);
                }
            }
            if (changedContent) {
                CmsModelGroupHelper.ensureLock(cms, group);
                if (changedContent) {
                    xmlContainerPage.save(cms, pageBean);
                }
                if (group.getName().endsWith(".xml")) {
                    String targetPath = cms.getSitePath(group);
                    targetPath = targetPath.substring(0, targetPath.length() - 4) + ".html";
                    cms.renameResource(cms.getSitePath(group), targetPath);
                    group = cms.readResource(group.getStructureId());
                }
                CmsModelGroupHelper.tryUnlock(cms, group);
                return true;
            }
            return false;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public static void updateModelGroupResources(HttpServletRequest request, HttpServletResponse response, String basePath, String baseContainerName) throws IOException {
        if (CmsFlexController.isCmsRequest((ServletRequest)request)) {
            try {
                CmsFlexController controller = CmsFlexController.getController((ServletRequest)request);
                CmsObject cms = controller.getCmsObject();
                CmsResource base = cms.readResource(basePath);
                I_CmsResourceType groupType = OpenCms.getResourceManager().getResourceType("modelgroup");
                List<CmsResource> resources = base.isFolder() ? cms.readResources(basePath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(groupType)) : (OpenCms.getResourceManager().getResourceType(base).equals(groupType) ? Collections.singletonList(base) : Collections.emptyList());
                if (resources.isEmpty()) {
                    response.getWriter().println("No model group resources found at " + basePath + "<br />");
                } else {
                    for (CmsResource group : resources) {
                        boolean updated = CmsModelGroupHelper.updateModelGroupResource(cms, group, baseContainerName);
                        response.getWriter().println("Group '" + group.getRootPath() + "' was updated " + updated + "<br />");
                    }
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                e.printStackTrace(response.getWriter());
            }
        }
    }

    private static void ensureLock(CmsObject cms, CmsResource resource) throws CmsException {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsLock lock = cms.getLock(resource);
        if (!lock.isOwnedBy(user)) {
            cms.lockResourceTemporary(resource);
        } else if (!lock.isOwnedInProjectBy(user, cms.getRequestContext().getCurrentProject())) {
            cms.changeLock(resource);
        }
    }

    private static void tryUnlock(CmsObject cms, CmsResource resource) {
        try {
            cms.unlockResource(resource);
        }
        catch (CmsException e) {
            LOG.debug((Object)("Unable to unlock " + resource.getRootPath()), (Throwable)e);
        }
    }

    public CmsContainerPageBean prepareforModelGroupContent(Map<String, CmsContainerElementBean> elements, List<String> foundGroups, CmsContainerPageBean page, boolean alwaysCopy, Locale locale) throws CmsException {
        for (Map.Entry<String, CmsContainerElementBean> entry : elements.entrySet()) {
            CmsContainerElementBean element = entry.getValue();
            CmsContainerPageBean modelPage = null;
            String modelInstanceId = null;
            boolean foundInstance = false;
            if (CmsModelGroupHelper.isModelGroupResource(element.getResource())) {
                modelPage = this.getContainerPageBean(element.getResource());
                CmsContainerElementBean baseElement = this.getModelBaseElement(modelPage, element.getResource());
                if (baseElement == null) break;
                String baseInstanceId = baseElement.getInstanceId();
                String originalInstanceId = element.getInstanceId();
                element = this.getModelReplacementElement(element, baseElement, true);
                List<CmsContainerBean> modelContainers = this.readModelContainers(baseInstanceId, originalInstanceId, modelPage);
                if (!this.m_isEditingModelGroups && baseElement.isCopyModel()) {
                    modelContainers = this.createNewElementsForModelGroup(this.m_cms, modelContainers, locale);
                }
                modelContainers.addAll(page.getContainers().values());
                page = new CmsContainerPageBean(modelContainers);
                entry.setValue(element);
                if (this.m_sessionCache == null) continue;
                this.m_sessionCache.setCacheContainerElement(element.editorHash(), element);
                continue;
            }
            HashMap<String, String> settings = new HashMap<String, String>(element.getIndividualSettings());
            String source = (String)settings.get("source_containerpage_id");
            settings.remove("source_containerpage_id");
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(source)) continue;
            try {
                CmsUUID sourceId = new CmsUUID(source);
                CmsResource sourcePage = this.m_cms.readResource(sourceId);
                if (CmsResourceTypeXmlContainerPage.isContainerPage(sourcePage)) {
                    CmsXmlContainerPage xmlCnt = CmsXmlContainerPageFactory.unmarshal(this.m_cms, this.m_cms.readFile(sourcePage));
                    modelPage = xmlCnt.getContainerPage(this.m_cms);
                    modelInstanceId = element.getInstanceId();
                }
                settings.remove("element_instance_id");
                boolean copyRoot = false;
                if (alwaysCopy && modelInstanceId != null && modelPage != null) {
                    for (CmsContainerElementBean el : modelPage.getElements()) {
                        if (!modelInstanceId.equals(el.getInstanceId())) continue;
                        copyRoot = el.isCreateNew();
                        break;
                    }
                }
                if (copyRoot) {
                    CmsObject cloneCms = OpenCms.initCmsObject(this.m_cms);
                    cloneCms.getRequestContext().setLocale(locale);
                    String typeName = OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName();
                    CmsResourceTypeConfig typeConfig = this.m_configData.getResourceType(typeName);
                    if (typeConfig == null) {
                        throw new IllegalArgumentException("Can not copy template model element '" + element.getResource().getRootPath() + "' because the resource type '" + (String)typeName + "' is not available in this sitemap.");
                    }
                    CmsResource newResource = typeConfig.createNewElement(cloneCms, element.getResource(), this.m_configData.getBasePath());
                    element = new CmsContainerElementBean(newResource.getStructureId(), element.getFormatterId(), settings, false);
                } else {
                    element = CmsContainerElementBean.cloneWithSettings(element, settings);
                }
                if (modelPage != null) {
                    HashMap<String, List<CmsContainerBean>> containerByParent = new HashMap<String, List<CmsContainerBean>>();
                    block4: for (CmsContainerBean container : modelPage.getContainers().values()) {
                        if (container.getParentInstanceId() != null) {
                            if (!containerByParent.containsKey(container.getParentInstanceId())) {
                                containerByParent.put(container.getParentInstanceId(), new ArrayList());
                            }
                            ((List)containerByParent.get(container.getParentInstanceId())).add(container);
                        }
                        if (foundInstance) continue;
                        for (CmsContainerElementBean child : container.getElements()) {
                            if (modelInstanceId == null) {
                                if (!child.getId().equals(element.getId())) continue;
                                modelInstanceId = child.getInstanceId();
                                foundInstance = true;
                                HashMap<String, String> setting = new HashMap<String, String>(child.getIndividualSettings());
                                setting.remove("element_instance_id");
                                element = CmsContainerElementBean.cloneWithSettings(element, setting);
                                continue block4;
                            }
                            if (!modelInstanceId.equals(child.getInstanceId())) continue;
                            foundInstance = true;
                            continue block4;
                        }
                    }
                    if (foundInstance && containerByParent.containsKey(modelInstanceId)) {
                        List<CmsContainerBean> modelContainers = this.collectModelStructure(modelInstanceId, element.getInstanceId(), containerByParent);
                        if (alwaysCopy) {
                            modelContainers = this.createNewElementsForModelGroup(this.m_cms, modelContainers, locale);
                        }
                        foundGroups.add(element.editorHash());
                        modelContainers.addAll(page.getContainers().values());
                        page = new CmsContainerPageBean(modelContainers);
                    }
                }
                entry.setValue(element);
                if (this.m_sessionCache == null) continue;
                this.m_sessionCache.setCacheContainerElement(element.editorHash(), element);
            }
            catch (Exception e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return page;
    }

    public CmsContainerPageBean readModelGroups(CmsContainerPageBean page) {
        ArrayList<CmsContainerBean> resultContainers = new ArrayList<CmsContainerBean>();
        for (CmsContainerBean container : page.getContainers().values()) {
            boolean hasModels = false;
            ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
            for (CmsContainerElementBean element : container.getElements()) {
                try {
                    element.initResource(this.m_cms);
                    if (CmsModelGroupHelper.isModelGroupResource(element.getResource())) {
                        hasModels = true;
                        CmsContainerPageBean modelGroupPage = this.getContainerPageBean(element.getResource());
                        CmsContainerElementBean baseElement = this.getModelBaseElement(modelGroupPage, element.getResource());
                        if (baseElement == null) {
                            LOG.error((Object)("Error rendering model group '" + element.getResource().getRootPath() + "', base element could not be determind."));
                            continue;
                        }
                        String baseInstanceId = baseElement.getInstanceId();
                        CmsContainerElementBean replaceElement = this.getModelReplacementElement(element, baseElement, false);
                        if (this.m_sessionCache != null) {
                            this.m_sessionCache.setCacheContainerElement(replaceElement.editorHash(), replaceElement);
                        }
                        elements.add(replaceElement);
                        resultContainers.addAll(this.readModelContainers(baseInstanceId, element.getInstanceId(), modelGroupPage));
                        continue;
                    }
                    elements.add(element);
                }
                catch (CmsException e) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (hasModels) {
                resultContainers.add(new CmsContainerBean(container.getName(), container.getType(), container.getParentInstanceId(), container.isRootContainer(), container.getMaxElements(), elements));
                continue;
            }
            resultContainers.add(container);
        }
        return new CmsContainerPageBean(resultContainers);
    }

    public CmsContainerPageBean removeModelGroupContainers(CmsContainerPageBean page) {
        Map<String, List<CmsContainerBean>> containersByParent = this.getContainerByParent(page);
        HashSet<String> modelInstances = new HashSet<String>();
        for (CmsContainerElementBean cmsContainerElementBean : page.getElements()) {
            if (!cmsContainerElementBean.getIndividualSettings().containsKey("model_group_id")) continue;
            modelInstances.add(cmsContainerElementBean.getInstanceId());
        }
        HashSet<String> descendingInstances = new HashSet<String>();
        for (String modelInstance : modelInstances) {
            descendingInstances.addAll(this.collectDescendingInstances(modelInstance, containersByParent));
        }
        ArrayList<CmsContainerBean> arrayList = new ArrayList<CmsContainerBean>();
        for (CmsContainerBean container : page.getContainers().values()) {
            if (container.getParentInstanceId() != null && descendingInstances.contains(container.getParentInstanceId())) continue;
            ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
            for (CmsContainerElementBean element : container.getElements()) {
                if (modelInstances.contains(element.getInstanceId())) {
                    CmsUUID modelId = new CmsUUID(element.getIndividualSettings().get("model_group_id"));
                    CmsContainerElementBean replacer = new CmsContainerElementBean(modelId, element.getFormatterId(), element.getIndividualSettings(), false);
                    elements.add(replacer);
                    continue;
                }
                elements.add(element);
            }
            arrayList.add(new CmsContainerBean(container.getName(), container.getType(), container.getParentInstanceId(), container.isRootContainer(), container.getMaxElements(), elements));
        }
        return new CmsContainerPageBean(arrayList);
    }

    public CmsContainerPageBean saveModelGroups(CmsContainerPageBean page, CmsResource pageResource) throws CmsException {
        CmsUUID modelElementId = null;
        CmsContainerElementBean baseElement = null;
        for (CmsContainerElementBean cmsContainerElementBean : page.getElements()) {
            if (!cmsContainerElementBean.isModelGroup()) continue;
            modelElementId = cmsContainerElementBean.getId();
            baseElement = cmsContainerElementBean;
            break;
        }
        ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
        for (CmsContainerBean container : page.getContainers().values()) {
            ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
            boolean hasChanges = false;
            for (CmsContainerElementBean element : container.getElements()) {
                if (element.isModelGroup() && !element.getId().equals(modelElementId)) {
                    HashMap<String, String> settings = new HashMap<String, String>(element.getIndividualSettings());
                    settings.remove("model_group_id");
                    settings.remove("model_group_state");
                    elements.add(new CmsContainerElementBean(element.getId(), element.getFormatterId(), settings, false));
                    hasChanges = true;
                    continue;
                }
                elements.add(element);
            }
            if (hasChanges) {
                containers.add(new CmsContainerBean(container.getName(), container.getType(), container.getParentInstanceId(), container.isRootContainer(), container.getMaxElements(), elements));
                continue;
            }
            containers.add(container);
        }
        ArrayList<CmsProperty> arrayList = new ArrayList<CmsProperty>();
        if (baseElement != null) {
            String val = Boolean.parseBoolean(baseElement.getIndividualSettings().get("use_as_copy_model")) ? "use_as_copy_model" : "";
            arrayList.add(new CmsProperty("template-elements", val, val));
        }
        this.m_cms.writePropertyObjects(pageResource, arrayList);
        return new CmsContainerPageBean(containers);
    }

    private CmsContainerElementBean adjustSettings(CmsContainerElementBean element, String originalContainer, String adjustedContainer) {
        HashMap<String, String> settings = new HashMap<String, String>(element.getIndividualSettings());
        settings.put("element_instance_id", new CmsUUID().toString());
        String formatterId = (String)settings.remove(CmsFormatterConfig.getSettingsKeyForContainer(originalContainer));
        settings.put(CmsFormatterConfig.getSettingsKeyForContainer(adjustedContainer), formatterId);
        return CmsContainerElementBean.cloneWithSettings(element, settings);
    }

    private Set<String> collectDescendingInstances(String instanceId, Map<String, List<CmsContainerBean>> containersByParent) {
        HashSet<String> descendingInstances = new HashSet<String>();
        descendingInstances.add(instanceId);
        if (containersByParent.containsKey(instanceId)) {
            for (CmsContainerBean container : containersByParent.get(instanceId)) {
                for (CmsContainerElementBean element : container.getElements()) {
                    descendingInstances.addAll(this.collectDescendingInstances(element.getInstanceId(), containersByParent));
                }
            }
        }
        return descendingInstances;
    }

    private List<CmsContainerBean> collectModelStructure(String modelInstanceId, String replaceModelId, Map<String, List<CmsContainerBean>> containerByParent) {
        ArrayList<CmsContainerBean> result = new ArrayList<CmsContainerBean>();
        if (containerByParent.containsKey(modelInstanceId)) {
            for (CmsContainerBean container : containerByParent.get(modelInstanceId)) {
                String adjustedContainerName = replaceModelId + container.getName().substring(modelInstanceId.length());
                ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
                for (CmsContainerElementBean element : container.getElements()) {
                    CmsContainerElementBean copyElement = this.adjustSettings(element, container.getName(), adjustedContainerName);
                    if (this.m_sessionCache != null) {
                        this.m_sessionCache.setCacheContainerElement(copyElement.editorHash(), copyElement);
                    }
                    elements.add(copyElement);
                    result.addAll(this.collectModelStructure(element.getInstanceId(), copyElement.getInstanceId(), containerByParent));
                }
                result.add(new CmsContainerBean(adjustedContainerName, container.getType(), replaceModelId, container.isRootContainer(), container.getMaxElements(), elements));
            }
        }
        return result;
    }

    private List<CmsContainerBean> createNewElementsForModelGroup(CmsObject cms, List<CmsContainerBean> modelContainers, Locale locale) throws CmsException {
        HashMap<CmsUUID, CmsResource> newResources = new HashMap<CmsUUID, CmsResource>();
        CmsObject cloneCms = OpenCms.initCmsObject(cms);
        cloneCms.getRequestContext().setLocale(locale);
        for (CmsContainerBean container : modelContainers) {
            for (CmsContainerElementBean element : container.getElements()) {
                if (!element.isCreateNew() || newResources.containsKey(element.getId())) continue;
                element.initResource(cms);
                String typeName = OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName();
                CmsResourceTypeConfig typeConfig = this.m_configData.getResourceType(typeName);
                if (typeConfig == null) {
                    throw new IllegalArgumentException("Can not copy template model element '" + element.getResource().getRootPath() + "' because the resource type '" + (String)typeName + "' is not available in this sitemap.");
                }
                CmsResource newResource = typeConfig.createNewElement(cloneCms, element.getResource(), this.m_configData.getBasePath());
                newResources.put(element.getId(), newResource);
            }
        }
        if (!newResources.isEmpty()) {
            ArrayList<CmsContainerBean> updatedContainers = new ArrayList<CmsContainerBean>();
            for (CmsContainerBean container : modelContainers) {
                ArrayList<CmsContainerElementBean> updatedElements = new ArrayList<CmsContainerElementBean>();
                for (CmsContainerElementBean element : container.getElements()) {
                    if (newResources.containsKey(element.getId())) {
                        CmsContainerElementBean newBean = new CmsContainerElementBean(((CmsResource)newResources.get(element.getId())).getStructureId(), element.getFormatterId(), element.getIndividualSettings(), false);
                        updatedElements.add(newBean);
                        continue;
                    }
                    updatedElements.add(element);
                }
                CmsContainerBean updatedContainer = new CmsContainerBean(container.getName(), container.getType(), container.getParentInstanceId(), container.isRootContainer(), container.getMaxElements(), updatedElements);
                updatedContainers.add(updatedContainer);
            }
            modelContainers = updatedContainers;
        }
        return modelContainers;
    }

    private Map<String, List<CmsContainerBean>> getContainerByParent(CmsContainerPageBean page) {
        HashMap<String, List<CmsContainerBean>> containerByParent = new HashMap<String, List<CmsContainerBean>>();
        for (CmsContainerBean container : page.getContainers().values()) {
            if (container.getParentInstanceId() == null) continue;
            if (!containerByParent.containsKey(container.getParentInstanceId())) {
                containerByParent.put(container.getParentInstanceId(), new ArrayList());
            }
            ((List)containerByParent.get(container.getParentInstanceId())).add(container);
        }
        return containerByParent;
    }

    private CmsContainerPageBean getContainerPageBean(CmsResource resource) throws CmsException {
        CmsXmlContainerPage xmlCnt = CmsXmlContainerPageFactory.unmarshal(this.m_cms, this.m_cms.readFile(resource));
        return xmlCnt.getContainerPage(this.m_cms);
    }

    private CmsContainerElementBean getModelBaseElement(CmsContainerPageBean modelGroupPage, CmsResource modelGroupResource) {
        CmsContainerElementBean result = null;
        for (CmsContainerElementBean element : modelGroupPage.getElements()) {
            if (!CmsContainerElement.ModelGroupState.isModelGroup.name().equals(element.getIndividualSettings().get("model_group_state"))) continue;
            result = element;
            break;
        }
        return result;
    }

    private CmsContainerElementBean getModelReplacementElement(CmsContainerElementBean element, CmsContainerElementBean baseElement, boolean allowCopyModel) {
        HashMap<String, String> settings = new HashMap<String, String>(element.getIndividualSettings());
        if (!baseElement.isCopyModel() || !allowCopyModel) {
            settings.put("model_group_id", element.getId().toString());
            if (allowCopyModel) {
                for (Map.Entry<String, String> settingEntry : baseElement.getIndividualSettings().entrySet()) {
                    if (settings.containsKey(settingEntry.getKey())) continue;
                    settings.put(settingEntry.getKey(), settingEntry.getValue());
                }
            }
        } else if (baseElement.isCopyModel()) {
            settings.put("model_group_state", CmsContainerElement.ModelGroupState.wasModelGroup.name());
        }
        return CmsContainerElementBean.cloneWithSettings(baseElement, settings);
    }

    private List<CmsContainerBean> readModelContainers(String modelInstanceId, String localInstanceId, CmsContainerPageBean modelPage) {
        Map<String, List<CmsContainerBean>> containerByParent = this.getContainerByParent(modelPage);
        List<CmsContainerBean> modelContainers = containerByParent.containsKey(modelInstanceId) ? this.collectModelStructure(modelInstanceId, localInstanceId, containerByParent) : new ArrayList<CmsContainerBean>();
        return modelContainers;
    }
}

