/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.acacia.shared.CmsAttributeConfiguration;
import org.opencms.acacia.shared.CmsEntity;
import org.opencms.acacia.shared.CmsEntityAttribute;
import org.opencms.acacia.shared.CmsEntityHtml;
import org.opencms.acacia.shared.CmsType;
import org.opencms.acacia.shared.CmsValidationResult;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.containerpage.CmsElementUtil;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.contenteditor.CmsContentTypeVisitor;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.ade.contenteditor.shared.CmsContentDefinition;
import org.opencms.ade.contenteditor.shared.rpc.I_CmsContentService;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspTagEdit;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsCategoryWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.editors.CmsXmlContentEditor;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.I_CmsXmlContentEditorChangeHandler;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsContentService
extends CmsGwtService
implements I_CmsContentService {
    protected static final Log LOG = CmsLog.getLog(CmsContentService.class);
    static final String TYPE_NAME_PREFIX = "http://opencms.org/types/";
    private static final long serialVersionUID = 7873052619331296648L;
    private CmsADESessionCache m_sessionCache;
    private Locale m_workplaceLocale;

    public static String getAttributeName(I_CmsXmlContentValue contentValue) {
        return CmsContentService.getTypeUri(contentValue.getContentDefinition()) + "/" + contentValue.getName();
    }

    public static String getAttributeName(String elementName, String parentType) {
        return parentType + "/" + elementName;
    }

    public static String getEntityId(I_CmsXmlContentValue contentValue) {
        String result = CmsContentDefinition.uuidToEntityId(contentValue.getDocument().getFile().getStructureId(), contentValue.getLocale().toString());
        String valuePath = contentValue.getPath();
        if (valuePath.contains("/")) {
            result = result + "/" + valuePath.substring(0, valuePath.lastIndexOf("/"));
        }
        if (contentValue.isChoiceOption()) {
            result = result + "/ATTRIBUTE_CHOICE_" + contentValue.getName() + "[" + contentValue.getXmlIndex() + "]";
        }
        return result;
    }

    public static String getRdfaAttributes(I_CmsXmlContentValue value) {
        return "about=\"" + CmsContentService.getEntityId(value) + "\" property=\"" + CmsContentService.getAttributeName(value) + "\"";
    }

    public static String getRdfaAttributes(I_CmsXmlContentValue parentValue, String childNames) {
        StringBuffer result = new StringBuffer();
        result.append("about=\"");
        result.append(CmsContentDefinition.uuidToEntityId(parentValue.getDocument().getFile().getStructureId(), parentValue.getLocale().toString()));
        result.append("/").append(parentValue.getPath());
        result.append("\" ");
        String[] children = childNames.split("\\|");
        result.append("property=\"");
        for (int i = 0; i < children.length; ++i) {
            I_CmsXmlSchemaType schemaType = parentValue.getContentDefinition().getSchemaType(parentValue.getName() + "/" + children[i]);
            if (schemaType == null) continue;
            if (i > 0) {
                result.append(" ");
            }
            result.append(CmsContentService.getTypeUri(schemaType.getContentDefinition())).append("/").append(children[i]);
        }
        result.append("\"");
        return result.toString();
    }

    public static String getRdfaAttributes(I_CmsXmlDocument document, Locale contentLocale, String elementPath) {
        I_CmsXmlSchemaType schemaType = document.getContentDefinition().getSchemaType(elementPath);
        StringBuffer result = new StringBuffer();
        if (schemaType != null) {
            result.append("about=\"");
            result.append(CmsContentDefinition.uuidToEntityId(document.getFile().getStructureId(), contentLocale.toString()));
            result.append("\" property=\"");
            result.append(CmsContentService.getTypeUri(schemaType.getContentDefinition())).append("/").append(elementPath);
            result.append("\"");
        }
        return result.toString();
    }

    public static String getTypeUri(CmsXmlContentDefinition xmlContentDefinition) {
        return xmlContentDefinition.getSchemaLocation() + "/" + xmlContentDefinition.getTypeName();
    }

    public static CmsContentDefinition prefetch(HttpServletRequest request) throws CmsRpcException {
        CmsContentService srv = new CmsContentService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsContentDefinition result = null;
        try {
            result = srv.prefetch();
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    @Override
    public CmsContentDefinition callEditorChangeHandlers(String entityId, CmsEntity editedLocaleEntity, Collection<String> skipPaths, Collection<String> changedScopes) throws CmsRpcException {
        CmsContentDefinition result = null;
        CmsUUID structureId = CmsContentDefinition.entityIdToUuid(editedLocaleEntity.getId());
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = null;
            Locale locale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            try {
                resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                this.ensureLock(resource);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = this.getContentDocument(file, true).clone();
                this.checkAutoCorrection(cms, content);
                this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, editedLocaleEntity);
                for (I_CmsXmlContentEditorChangeHandler handler : content.getContentDefinition().getContentHandler().getEditorChangeHandlers()) {
                    Set<String> handlerScopes = this.evaluateScope(handler.getScope(), content.getContentDefinition());
                    if (Collections.disjoint(changedScopes, handlerScopes)) continue;
                    handler.handleChange(cms, content, locale, changedScopes);
                }
                result = this.readContentDefinition(file, content, entityId, locale, false, null, editedLocaleEntity);
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        return result;
    }

    @Override
    public void cancelEdit(CmsUUID structureId, boolean delete) throws CmsRpcException {
        try {
            this.getSessionCache().uncacheXmlContent(structureId);
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            if (delete) {
                this.ensureLock(resource);
                this.getCmsObject().deleteResource(this.getCmsObject().getSitePath(resource), CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
            this.tryUnlock(resource);
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    @Override
    public void copyLocale(Collection<String> locales, CmsEntity sourceLocale) throws CmsRpcException {
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(sourceLocale.getId());
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsFile file = this.getCmsObject().readFile(resource);
            CmsXmlContent content = this.getSessionCache().getCacheXmlContent(structureId);
            this.synchronizeLocaleIndependentForEntity(file, content, Collections.emptyList(), sourceLocale);
            Locale sourceContentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(sourceLocale.getId()));
            for (String loc : locales) {
                Locale targetLocale = CmsLocaleManager.getLocale(loc);
                if (content.hasLocale(targetLocale)) {
                    content.removeLocale(targetLocale);
                }
                content.copyLocale(sourceContentLocale, targetLocale);
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    @Override
    public CmsObject getCmsObject() {
        CmsObject result = super.getCmsObject();
        result.getRequestContext().setRequestTime(Long.MIN_VALUE);
        return result;
    }

    @Override
    public CmsContentDefinition loadContentDefinition(String entityId) throws CmsRpcException {
        throw new CmsRpcException(new UnsupportedOperationException());
    }

    @Override
    public CmsContentDefinition loadDefinition(String entityId, CmsEntity editedLocaleEntity, Collection<String> skipPaths) throws CmsRpcException {
        CmsContentDefinition definition = null;
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            CmsFile file = this.getCmsObject().readFile(resource);
            CmsXmlContent content = this.getContentDocument(file, true);
            if (editedLocaleEntity != null) {
                this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, editedLocaleEntity);
            }
            definition = this.readContentDefinition(file, content, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), contentLocale, false, null, editedLocaleEntity);
        }
        catch (Exception e) {
            this.error(e);
        }
        return definition;
    }

    @Override
    public CmsContentDefinition loadInitialDefinition(String entityId, String newLink, CmsUUID modelFileId, String editContext, String mainLocale, String mode, String postCreateHandler) throws CmsRpcException {
        CmsContentDefinition result = null;
        this.getCmsObject().getRequestContext().setAttribute(CmsXmlContentEditor.ATTRIBUTE_EDITCONTEXT, editContext);
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            this.getSessionCache().clearDynamicValues();
            this.getSessionCache().uncacheXmlContent(structureId);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(newLink)) {
                result = this.readContentDefnitionForNew(newLink, resource, modelFileId, contentLocale, mode, postCreateHandler);
            } else {
                CmsFile file = this.getCmsObject().readFile(resource);
                CmsXmlContent content = this.getContentDocument(file, false);
                result = this.readContentDefinition(file, content, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), contentLocale, false, mainLocale != null ? CmsLocaleManager.getLocale(mainLocale) : null, null);
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
        return result;
    }

    @Override
    public CmsContentDefinition loadNewDefinition(String entityId, CmsEntity editedLocaleEntity, Collection<String> skipPaths) throws CmsRpcException {
        CmsContentDefinition definition = null;
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            CmsFile file = this.getCmsObject().readFile(resource);
            CmsXmlContent content = this.getContentDocument(file, true);
            this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, editedLocaleEntity);
            definition = this.readContentDefinition(file, content, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), contentLocale, true, null, editedLocaleEntity);
        }
        catch (Exception e) {
            this.error(e);
        }
        return definition;
    }

    @Override
    public CmsContentDefinition prefetch() throws CmsRpcException {
        String paramResource = this.getRequest().getParameter("resource");
        String paramDirectEdit = this.getRequest().getParameter("directedit");
        boolean isDirectEdit = false;
        if (paramDirectEdit != null) {
            isDirectEdit = Boolean.parseBoolean(paramDirectEdit);
        }
        String paramNewLink = this.getRequest().getParameter("newlink");
        boolean createNew = false;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramNewLink)) {
            createNew = true;
            paramNewLink = this.decodeNewLink(paramNewLink);
        }
        String paramLocale = this.getRequest().getParameter("elementlanguage");
        Locale locale = null;
        CmsObject cms = this.getCmsObject();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramResource)) {
            try {
                CmsResource resource = cms.readResource(paramResource, CmsResourceFilter.IGNORE_EXPIRATION);
                if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
                    CmsContentDefinition result;
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramLocale)) {
                        locale = CmsLocaleManager.getLocale(paramLocale);
                    }
                    this.getSessionCache().clearDynamicValues();
                    if (createNew) {
                        if (locale == null) {
                            locale = OpenCms.getLocaleManager().getDefaultLocale(cms, paramResource);
                        }
                        CmsUUID modelFileId = null;
                        String paramModelFile = this.getRequest().getParameter("modelfile");
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramModelFile)) {
                            modelFileId = cms.readResource(paramModelFile).getStructureId();
                        }
                        String mode = this.getRequest().getParameter("mode");
                        String postCreateHandler = this.getRequest().getParameter("postCreateHandler");
                        result = this.readContentDefnitionForNew(paramNewLink, resource, modelFileId, locale, mode, postCreateHandler);
                    } else {
                        CmsFile file = cms.readFile(resource);
                        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                        this.getSessionCache().setCacheXmlContent(resource.getStructureId(), content);
                        if (locale == null) {
                            locale = OpenCms.getLocaleManager().getBestAvailableLocaleForXmlContent(this.getCmsObject(), resource, content);
                        }
                        result = this.readContentDefinition(file, content, null, locale, false, null, null);
                    }
                    result.setDirectEdit(isDirectEdit);
                    return result;
                }
            }
            catch (Throwable e) {
                this.error(e);
            }
        }
        return null;
    }

    @Override
    public CmsValidationResult saveAndDeleteEntities(CmsEntity lastEditedEntity, List<String> deletedEntities, Collection<String> skipPaths, String lastEditedLocale, boolean clearOnSuccess) throws CmsRpcException {
        CmsUUID structureId = null;
        if (lastEditedEntity != null) {
            structureId = CmsContentDefinition.entityIdToUuid(lastEditedEntity.getId());
        }
        if (structureId == null && !deletedEntities.isEmpty()) {
            structureId = CmsContentDefinition.entityIdToUuid(deletedEntities.get(0));
        }
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = null;
            try {
                resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                this.ensureLock(resource);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = this.getContentDocument(file, true);
                this.checkAutoCorrection(cms, content);
                if (lastEditedEntity != null) {
                    this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, lastEditedEntity);
                }
                for (String deleteId : deletedEntities) {
                    Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(deleteId));
                    if (!content.hasLocale(contentLocale)) continue;
                    content.removeLocale(contentLocale);
                }
                CmsValidationResult validationResult = this.validateContent(cms, structureId, content);
                if (validationResult.hasErrors()) {
                    return validationResult;
                }
                this.writeContent(cms, file, content, this.getFileEncoding(cms, file));
                this.writeCategories(file, content, lastEditedEntity);
                OpenCms.getSearchManager().updateOfflineIndexes();
                if (clearOnSuccess) {
                    this.tryUnlock(resource);
                    this.getSessionCache().uncacheXmlContent(structureId);
                }
            }
            catch (Exception e) {
                if (resource != null) {
                    this.tryUnlock(resource);
                    this.getSessionCache().uncacheXmlContent(structureId);
                }
                this.error(e);
            }
        }
        return null;
    }

    @Override
    public CmsValidationResult saveEntities(List<CmsEntity> entities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CmsValidationResult saveEntity(CmsEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String saveValue(String contentId, String contentPath, String localeString, String newValue) throws CmsRpcException {
        OpenCms.getLocaleManager();
        Locale locale = CmsLocaleManager.getLocale(localeString);
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource element = cms.readResource(new CmsUUID(contentId), CmsResourceFilter.IGNORE_EXPIRATION);
            this.ensureLock(element);
            CmsFile elementFile = cms.readFile(element);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, elementFile);
            I_CmsXmlContentValue value = content.getValue(contentPath, locale);
            value.setStringValue(cms, newValue);
            for (I_CmsXmlContentEditorChangeHandler handler : content.getContentDefinition().getContentHandler().getEditorChangeHandlers()) {
                Set<String> handlerScopes = this.evaluateScope(handler.getScope(), content.getContentDefinition());
                if (!handlerScopes.contains(contentPath)) continue;
                handler.handleChange(cms, content, locale, Collections.singletonList(contentPath));
            }
            content.synchronizeLocaleIndependentValues(cms, Collections.emptyList(), locale);
            byte[] newData = content.marshal();
            elementFile.setContents(newData);
            cms.writeFile(elementFile);
            this.tryUnlock(elementFile);
            return "";
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsEntityHtml updateEntityHtml(CmsEntity entity, String contextUri, String htmlContextInfo) throws Exception {
        CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entity.getId());
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            try {
                CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                String entityId = entity.getId();
                Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                if (content.hasLocale(contentLocale)) {
                    content.removeLocale(contentLocale);
                }
                content.addLocale(cms, contentLocale);
                this.addEntityAttributes(cms, content, "", entity, contentLocale);
                CmsValidationResult validationResult = this.validateContent(cms, structureId, content);
                String htmlContent = null;
                if (!validationResult.hasErrors()) {
                    file.setContents(content.marshal());
                    JSONObject contextInfo = new JSONObject(htmlContextInfo);
                    String containerName = contextInfo.getString("name");
                    String containerType = contextInfo.getString("type");
                    int containerWidth = contextInfo.getInt("width");
                    int maxElements = contextInfo.getInt("maxElements");
                    boolean detailView = contextInfo.getBoolean("isDetailView");
                    CmsContainer container = new CmsContainer(containerName, containerType, null, containerWidth, maxElements, detailView, true, Collections.emptyList(), null, null);
                    CmsUUID detailContentId = null;
                    if (contextInfo.has("detailElementId")) {
                        detailContentId = new CmsUUID(contextInfo.getString("detailElementId"));
                    }
                    CmsElementUtil elementUtil = new CmsElementUtil(cms, contextUri, detailContentId, this.getThreadLocalRequest(), this.getThreadLocalResponse(), contentLocale);
                    htmlContent = elementUtil.getContentByContainer(file, contextInfo.getString("elementId"), container, true);
                }
                return new CmsEntityHtml(htmlContent, validationResult);
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        return null;
    }

    @Override
    public CmsValidationResult validateEntities(List<CmsEntity> changedEntities) throws CmsRpcException {
        CmsUUID structureId = null;
        if (changedEntities.isEmpty()) {
            return new CmsValidationResult(null, null);
        }
        structureId = CmsContentDefinition.entityIdToUuid(changedEntities.get(0).getId());
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            HashSet setFieldNames = Sets.newHashSet();
            try {
                CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                for (CmsEntity entity : changedEntities) {
                    String entityId = entity.getId();
                    Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                    if (content.hasLocale(contentLocale)) {
                        content.removeLocale(contentLocale);
                    }
                    content.addLocale(cms, contentLocale);
                    setFieldNames.addAll(this.addEntityAttributes(cms, content, "", entity, contentLocale));
                }
                return this.validateContent(cms, structureId, content, setFieldNames);
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        return new CmsValidationResult(null, null);
    }

    protected String decodeNewLink(String newLink) {
        String result = newLink;
        if (result == null) {
            return null;
        }
        try {
            result = CmsEncoder.decode(result);
            try {
                result = CmsEncoder.decode(result);
            }
            catch (Throwable e) {
                LOG.info((Object)e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable e) {
            LOG.info((Object)e.getLocalizedMessage(), e);
        }
        return result;
    }

    protected String getElementName(String attributeName) {
        if (attributeName.contains("/")) {
            return attributeName.substring(attributeName.lastIndexOf("/") + 1);
        }
        return attributeName;
    }

    protected String getFileEncoding(CmsObject cms, CmsResource file) {
        String result;
        try {
            result = cms.readPropertyObject(file, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
        }
        catch (CmsException e) {
            result = OpenCms.getSystemInfo().getDefaultEncoding();
        }
        return CmsEncoder.lookupEncoding(result, OpenCms.getSystemInfo().getDefaultEncoding());
    }

    protected CmsEntity readEntity(CmsXmlContent content, Element element, Locale locale, String entityId, String parentPath, String typeName, CmsContentTypeVisitor visitor, boolean includeInvisible, CmsEntity editedLocalEntity) {
        CmsEntity newEntity;
        String newEntityId = entityId + (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parentPath) ? "/" + parentPath : "");
        CmsEntity result = newEntity = new CmsEntity(newEntityId, typeName);
        List elements = element.elements();
        CmsType type = visitor.getTypes().get(typeName);
        boolean isChoice = type.isChoice();
        String choiceTypeName = null;
        HashMap<String, Integer> attributeCounter = null;
        if (isChoice) {
            choiceTypeName = type.getAttributeTypeName("ATTRIBUTE_CHOICE");
            type = visitor.getTypes().get(type.getAttributeTypeName("ATTRIBUTE_CHOICE"));
            attributeCounter = new HashMap<String, Integer>();
        }
        int counter = 0;
        CmsObject cms = this.getCmsObject();
        String previousName = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parentPath)) {
            parentPath = parentPath + "/";
        }
        for (Element child : elements) {
            I_CmsXmlContentValue value;
            String attributeName = CmsContentService.getAttributeName(child.getName(), typeName);
            String subTypeName = type.getAttributeTypeName(attributeName);
            if (visitor.getTypes().get(subTypeName) == null || !includeInvisible && !visitor.getAttributeConfigurations().get(attributeName).isVisible()) continue;
            if (isChoice && attributeCounter != null) {
                if (!attributeName.equals(previousName)) {
                    counter = attributeCounter.get(attributeName) != null ? (Integer)attributeCounter.get(attributeName) : 0;
                    previousName = attributeName;
                }
                attributeCounter.put(attributeName, counter + 1);
            } else if (!attributeName.equals(previousName)) {
                counter = 0;
                previousName = attributeName;
            }
            if (isChoice) {
                result = new CmsEntity(newEntityId + "/" + "ATTRIBUTE_CHOICE" + "_" + child.getName() + "[" + counter + "]", choiceTypeName);
                newEntity.addAttributeValue("ATTRIBUTE_CHOICE", result);
            }
            String path = parentPath + child.getName();
            if (visitor.isDynamicallyLoaded(attributeName)) {
                value = content.getValue(path, locale, counter);
                String attributeValue = this.getDynamicAttributeValue(content.getFile(), value, attributeName, editedLocalEntity);
                result.addAttributeValue(attributeName, attributeValue);
            } else if (visitor.getTypes().get(subTypeName).isSimpleType()) {
                value = content.getValue(path, locale, counter);
                result.addAttributeValue(attributeName, value.getStringValue(cms));
            } else {
                CmsEntity subEntity = this.readEntity(content, child, locale, entityId, path + "[" + (counter + 1) + "]", subTypeName, visitor, includeInvisible, editedLocalEntity);
                result.addAttributeValue(attributeName, subEntity);
            }
            ++counter;
        }
        return newEntity;
    }

    protected Map<String, CmsType> readTypes(CmsXmlContentDefinition xmlContentDefinition, Locale locale) {
        CmsContentTypeVisitor visitor = new CmsContentTypeVisitor(this.getCmsObject(), null, locale);
        visitor.visitTypes(xmlContentDefinition, locale);
        return visitor.getTypes();
    }

    protected void synchronizeLocaleIndependentFields(CmsFile file, CmsXmlContent content, Collection<String> skipPaths, Collection<CmsEntity> entities, Locale lastEdited) throws CmsXmlException {
        CmsEntity lastEditedEntity = null;
        for (CmsEntity entity : entities) {
            if (lastEdited.equals(CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entity.getId())))) {
                lastEditedEntity = entity;
                continue;
            }
            this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, entity);
        }
        if (lastEditedEntity != null) {
            this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, lastEditedEntity);
        }
    }

    protected void transferInvisibleValues(CmsEntity original, CmsEntity target, CmsContentTypeVisitor visitor) {
        ArrayList<String> invisibleAttributes = new ArrayList<String>();
        for (Map.Entry<String, CmsAttributeConfiguration> configEntry : visitor.getAttributeConfigurations().entrySet()) {
            if (configEntry.getValue().isVisible()) continue;
            invisibleAttributes.add(configEntry.getKey());
        }
        CmsContentDefinition.transferValues(original, target, invisibleAttributes, visitor.getTypes(), visitor.getAttributeConfigurations(), true);
    }

    private Set<String> addEntityAttributes(CmsObject cms, CmsXmlContent content, String parentPath, CmsEntity entity, Locale contentLocale) {
        HashSet fieldsSet = Sets.newHashSet();
        this.addEntityAttributes(cms, content, parentPath, entity, contentLocale, fieldsSet);
        return fieldsSet;
    }

    private void addEntityAttributes(CmsObject cms, CmsXmlContent content, String parentPath, CmsEntity entity, Locale contentLocale, Set<String> fieldsSet) {
        for (CmsEntityAttribute attribute : entity.getAttributes()) {
            I_CmsXmlContentValue field;
            int i;
            if ("ATTRIBUTE_CHOICE".equals(attribute.getAttributeName())) {
                List<CmsEntity> choiceEntities = attribute.getComplexValues();
                for (int i2 = 0; i2 < choiceEntities.size(); ++i2) {
                    I_CmsXmlContentValue field2;
                    List<CmsEntityAttribute> choiceAttributes = choiceEntities.get(i2).getAttributes();
                    assert (choiceAttributes.size() == 1 && choiceAttributes.get(0).isSingleValue()) : "each choice entity may only have a single attribute with a single value";
                    CmsEntityAttribute choiceAttribute = choiceAttributes.get(0);
                    String elementPath = parentPath + this.getElementName(choiceAttribute.getAttributeName());
                    if (choiceAttribute.isSimpleValue()) {
                        String value = choiceAttribute.getSimpleValue();
                        field2 = content.getValue(elementPath, contentLocale, i2);
                        if (field2 == null) {
                            field2 = content.addValue(cms, elementPath, contentLocale, i2);
                        }
                        field2.setStringValue(cms, value);
                        fieldsSet.add(field2.getPath());
                        continue;
                    }
                    CmsEntity child = choiceAttribute.getComplexValue();
                    field2 = content.getValue(elementPath, contentLocale, i2);
                    if (field2 == null) {
                        field2 = content.addValue(cms, elementPath, contentLocale, i2);
                    }
                    this.addEntityAttributes(cms, content, field2.getPath() + "/", child, contentLocale, fieldsSet);
                }
                continue;
            }
            String elementPath = parentPath + this.getElementName(attribute.getAttributeName());
            if (attribute.isSimpleValue()) {
                List<String> values = attribute.getSimpleValues();
                for (i = 0; i < values.size(); ++i) {
                    String value = values.get(i);
                    field = content.getValue(elementPath, contentLocale, i);
                    if (field == null) {
                        field = content.addValue(cms, elementPath, contentLocale, i);
                    }
                    field.setStringValue(cms, value);
                    fieldsSet.add(field.getPath());
                }
                continue;
            }
            List<CmsEntity> entities = attribute.getComplexValues();
            for (i = 0; i < entities.size(); ++i) {
                CmsEntity child = entities.get(i);
                field = content.getValue(elementPath, contentLocale, i);
                if (field == null) {
                    field = content.addValue(cms, elementPath, contentLocale, i);
                }
                this.addEntityAttributes(cms, content, field.getPath() + "/", child, contentLocale, fieldsSet);
            }
        }
    }

    private boolean checkAutoCorrection(CmsObject cms, CmsXmlContent content) throws CmsXmlException {
        boolean performedAutoCorrection = false;
        try {
            content.validateXmlStructure(new CmsXmlEntityResolver(cms));
        }
        catch (CmsXmlException eXml) {
            content.setAutoCorrectionEnabled(true);
            content.correctXmlStructure(cms);
            performedAutoCorrection = true;
        }
        return performedAutoCorrection;
    }

    private Set<String> evaluateScope(String scope, CmsXmlContentDefinition definition) {
        HashSet<String> evaluatedScopes = new HashSet<String>();
        if (scope.contains("*")) {
            String[] pathElements = scope.split("/");
            String parentPath = "";
            for (int i = 0; i < pathElements.length; ++i) {
                String elementName = pathElements[i];
                boolean hasWildCard = elementName.endsWith("*");
                if (hasWildCard) {
                    elementName = elementName.substring(0, elementName.length() - 1);
                    parentPath = CmsStringUtil.joinPaths(parentPath, elementName);
                    I_CmsXmlSchemaType type = definition.getSchemaType(parentPath);
                    HashSet<String> tempScopes = new HashSet<String>();
                    if (type.getMaxOccurs() == Integer.MAX_VALUE) {
                        throw new IllegalStateException("Can not use fields with unbounded maxOccurs in scopes for editor change handler.");
                    }
                    for (int j = 0; j < type.getMaxOccurs(); ++j) {
                        if (evaluatedScopes.isEmpty()) {
                            tempScopes.add(elementName + "[" + (j + 1) + "]");
                            continue;
                        }
                        for (String evScope : evaluatedScopes) {
                            tempScopes.add(CmsStringUtil.joinPaths(evScope, elementName + "[" + (j + 1) + "]"));
                        }
                    }
                    evaluatedScopes = tempScopes;
                    continue;
                }
                parentPath = CmsStringUtil.joinPaths(parentPath, elementName);
                HashSet<String> tempScopes = new HashSet<String>();
                if (evaluatedScopes.isEmpty()) {
                    tempScopes.add(elementName);
                } else {
                    for (String evScope : evaluatedScopes) {
                        tempScopes.add(CmsStringUtil.joinPaths(evScope, elementName));
                    }
                }
                evaluatedScopes = tempScopes;
            }
        } else {
            evaluatedScopes.add(scope);
        }
        return evaluatedScopes;
    }

    private void evaluateSyncLocaleValues(CmsXmlContent content, Map<String, String> syncValues, Collection<String> skipPaths) {
        CmsObject cms = this.getCmsObject();
        for (Locale locale : content.getLocales()) {
            for (String elementPath : content.getContentDefinition().getContentHandler().getSynchronizations()) {
                for (I_CmsXmlContentValue contentValue : content.getSimpleValuesBelowPath(elementPath, locale)) {
                    String valuePath = contentValue.getPath();
                    boolean skip = false;
                    for (String skipPath : skipPaths) {
                        if (!valuePath.startsWith(skipPath)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    String value = contentValue.getStringValue(cms);
                    if (syncValues.containsKey(valuePath)) {
                        if (syncValues.get(valuePath).equals(value)) continue;
                        syncValues.remove(valuePath);
                        int pathLevelDiff = CmsResource.getPathLevel(valuePath) - CmsResource.getPathLevel(elementPath) + 1;
                        for (int i = 0; i < pathLevelDiff; ++i) {
                            valuePath = CmsXmlUtils.removeLastXpathElement(valuePath);
                        }
                        skipPaths.add(valuePath);
                        continue;
                    }
                    syncValues.put(valuePath, value);
                }
            }
        }
    }

    private Set<String> getChangeHandlerScopes(CmsXmlContentDefinition definition) {
        List<I_CmsXmlContentEditorChangeHandler> changeHandlers = definition.getContentHandler().getEditorChangeHandlers();
        HashSet<String> scopes = new HashSet<String>();
        for (I_CmsXmlContentEditorChangeHandler handler : changeHandlers) {
            String scope = handler.getScope();
            scopes.addAll(this.evaluateScope(scope, definition));
        }
        return scopes;
    }

    private CmsXmlContent getContentDocument(CmsFile file, boolean fromCache) throws CmsXmlException {
        CmsXmlContent content = null;
        if (fromCache) {
            content = this.getSessionCache().getCacheXmlContent(file.getStructureId());
        }
        if (content == null) {
            content = CmsXmlContentFactory.unmarshal(this.getCmsObject(), file);
            this.getSessionCache().setCacheXmlContent(file.getStructureId(), content);
        }
        return content;
    }

    private String getDynamicAttributeValue(CmsFile file, I_CmsXmlContentValue value, String attributeName, CmsEntity editedLocalEntity) {
        String currentValue;
        if (null != editedLocalEntity && editedLocalEntity.getAttribute(attributeName) != null) {
            this.getSessionCache().setDynamicValue(attributeName, editedLocalEntity.getAttribute(attributeName).getSimpleValue());
        }
        if (null != (currentValue = this.getSessionCache().getDynamicValue(attributeName))) {
            return currentValue;
        }
        if (null != file && value.getTypeName().equals("OpenCmsDynamicCategory")) {
            List<Object> categories = new ArrayList(0);
            try {
                categories = CmsCategoryService.getInstance().readResourceCategories(this.getCmsObject(), file);
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERROR_FAILED_READING_CATEGORIES_1"), (Throwable)e);
            }
            I_CmsWidget widget = null;
            try {
                widget = value.getContentDefinition().getContentHandler().getWidget(value);
            }
            catch (CmsXmlException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (null != widget && widget instanceof CmsCategoryWidget) {
                String mainCategoryPath = ((CmsCategoryWidget)widget).getStartingCategory(this.getCmsObject(), this.getCmsObject().getSitePath(file));
                StringBuffer pathes = new StringBuffer();
                for (CmsCategory cmsCategory : categories) {
                    if (!cmsCategory.getPath().startsWith(mainCategoryPath)) continue;
                    pathes.append(cmsCategory.getBasePath()).append(cmsCategory.getPath()).append(',');
                }
                String dynamicConfigString = pathes.length() > 0 ? pathes.substring(0, pathes.length() - 1) : "";
                this.getSessionCache().setDynamicValue(attributeName, dynamicConfigString);
                return dynamicConfigString;
            }
        }
        return "";
    }

    private String[] getPathElements(CmsXmlContent content, I_CmsXmlContentValue value) {
        ArrayList<String> pathElements = new ArrayList<String>();
        String[] paths = value.getPath().split("/");
        String path = "";
        for (int i = 0; i < paths.length; ++i) {
            path = path + paths[i];
            I_CmsXmlContentValue ancestor = content.getValue(path, value.getLocale());
            int valueIndex = ancestor.getXmlIndex();
            if (ancestor.isChoiceOption()) {
                Element parent = ancestor.getElement().getParent();
                valueIndex = parent.indexOf((Node)ancestor.getElement());
            }
            String pathElement = CmsContentService.getAttributeName(ancestor.getName(), CmsContentService.getTypeUri(ancestor.getContentDefinition()));
            pathElements.add(pathElement + "[" + valueIndex + "]");
            path = path + "/";
        }
        return pathElements.toArray(new String[pathElements.size()]);
    }

    private CmsADESessionCache getSessionCache() {
        if (this.m_sessionCache == null) {
            this.m_sessionCache = CmsADESessionCache.getCache(this.getRequest(), this.getCmsObject());
        }
        return this.m_sessionCache;
    }

    private Locale getWorkplaceLocale(CmsObject cms) {
        if (this.m_workplaceLocale == null) {
            this.m_workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        }
        return this.m_workplaceLocale;
    }

    private CmsContentDefinition readContentDefinition(CmsFile file, CmsXmlContent content, String entityId, Locale locale, boolean newLocale, Locale mainLocale, CmsEntity editedLocaleEntity) throws CmsException {
        boolean performedAutoCorrection;
        long timer = 0L;
        if (LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        CmsObject cms = this.getCmsObject();
        List<Locale> availableLocalesList = OpenCms.getLocaleManager().getAvailableLocales(cms, file);
        if (!availableLocalesList.contains(locale)) {
            availableLocalesList.retainAll(content.getLocales());
            List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, file);
            Locale replacementLocale = OpenCms.getLocaleManager().getBestMatchingLocale(locale, defaultLocales, availableLocalesList);
            LOG.info((Object)("Can't edit locale " + locale + " of file " + file.getRootPath() + " because it is not configured as available locale. Using locale " + replacementLocale + " instead."));
            locale = replacementLocale;
            entityId = CmsContentDefinition.uuidToEntityId(file.getStructureId(), locale.toString());
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(entityId)) {
            entityId = CmsContentDefinition.uuidToEntityId(file.getStructureId(), locale.toString());
        }
        if (performedAutoCorrection = this.checkAutoCorrection(cms, content)) {
            content.initDocument();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_UNMARSHALING_TIME_1", "" + (System.currentTimeMillis() - timer)));
        }
        CmsContentTypeVisitor visitor = new CmsContentTypeVisitor(cms, file, locale);
        if (LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        visitor.visitTypes(content.getContentDefinition(), this.getWorkplaceLocale(cms));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_VISITING_TYPES_TIME_1", "" + (System.currentTimeMillis() - timer)));
        }
        CmsEntity entity = null;
        HashMap<String, String> syncValues = new HashMap<String, String>();
        HashSet<String> skipPaths = new HashSet<String>();
        this.evaluateSyncLocaleValues(content, syncValues, skipPaths);
        if (content.hasLocale(locale) && newLocale) {
            content.removeLocale(locale);
        }
        if (!content.hasLocale(locale)) {
            if (mainLocale != null && content.hasLocale(mainLocale)) {
                content.copyLocale(mainLocale, locale);
            } else {
                content.addLocale(cms, locale);
            }
            if (!visitor.getLocaleSynchronizations().isEmpty() && content.getLocales().size() > 1) {
                for (Locale contentLocale : content.getLocales()) {
                    if (contentLocale.equals(locale)) continue;
                    content.synchronizeLocaleIndependentValues(cms, skipPaths, contentLocale);
                }
            }
        }
        Element element = content.getLocaleNode(locale);
        if (LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        entity = this.readEntity(content, element, locale, entityId, "", CmsContentService.getTypeUri(content.getContentDefinition()), visitor, false, editedLocaleEntity);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_READING_ENTITY_TIME_1", "" + (System.currentTimeMillis() - timer)));
        }
        ArrayList<String> contentLocales = new ArrayList<String>();
        for (Locale contentLocale : content.getLocales()) {
            contentLocales.add(contentLocale.toString());
        }
        Locale workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        TreeMap<String, String> availableLocales = new TreeMap<String, String>();
        for (Locale availableLocale : OpenCms.getLocaleManager().getAvailableLocales(cms, file)) {
            availableLocales.put(availableLocale.toString(), availableLocale.getDisplayName(workplaceLocale));
        }
        String title = cms.readPropertyObject(file, "Title", false).getValue();
        try {
            CmsGallerySearchResult searchResult = CmsGallerySearch.searchById(cms, file.getStructureId(), locale);
            title = searchResult.getTitle();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        String typeName = OpenCms.getResourceManager().getResourceType(file.getTypeId()).getTypeName();
        boolean autoUnlock = OpenCms.getWorkplaceManager().shouldAcaciaUnlock();
        HashMap<String, CmsEntity> entities = new HashMap<String, CmsEntity>();
        entities.put(entityId, entity);
        return new CmsContentDefinition(entityId, entities, visitor.getAttributeConfigurations(), visitor.getWidgetConfigurations(), visitor.getComplexWidgetData(), visitor.getTypes(), visitor.getTabInfos(), locale.toString(), contentLocales, availableLocales, visitor.getLocaleSynchronizations(), syncValues, skipPaths, title, cms.getSitePath(file), typeName, performedAutoCorrection, autoUnlock, this.getChangeHandlerScopes(content.getContentDefinition()));
    }

    private CmsContentDefinition readContentDefnitionForNew(String newLink, CmsResource referenceResource, CmsUUID modelFileId, Locale locale, String mode, String postCreateHandler) throws CmsException {
        String sitePath = this.getCmsObject().getSitePath(referenceResource);
        String resourceType = OpenCms.getResourceManager().getResourceType(referenceResource.getTypeId()).getTypeName();
        String modelFile = null;
        if (modelFileId == null) {
            List<CmsResource> modelResources = CmsResourceTypeXmlContent.getModelFiles(this.getCmsObject(), CmsResource.getFolderPath(sitePath), resourceType);
            if (!modelResources.isEmpty()) {
                List<CmsModelResourceInfo> modelInfos = CmsContainerpageService.generateModelResourceList(this.getCmsObject(), resourceType, modelResources, locale);
                return new CmsContentDefinition(modelInfos, newLink, referenceResource.getStructureId(), locale.toString());
            }
        } else if (!modelFileId.isNullUUID()) {
            modelFile = this.getCmsObject().getSitePath(this.getCmsObject().readResource(modelFileId, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        String newFileName = null;
        newFileName = null != newLink && newLink.startsWith("__edit__") ? CmsJspTagEdit.createResource(this.getCmsObject(), newLink, locale, sitePath, modelFile, mode, postCreateHandler) : A_CmsResourceCollector.createResourceForCollector(this.getCmsObject(), newLink, locale, sitePath, modelFile, mode, postCreateHandler);
        CmsResource resource = this.getCmsObject().readResource(newFileName, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsFile file = this.getCmsObject().readFile(resource);
        CmsXmlContent content = this.getContentDocument(file, false);
        CmsContentDefinition contentDefinition = this.readContentDefinition(file, content, null, locale, false, null, null);
        contentDefinition.setDeleteOnCancel(true);
        return contentDefinition;
    }

    private void synchronizeLocaleIndependentForEntity(CmsFile file, CmsXmlContent content, Collection<String> skipPaths, CmsEntity entity) throws CmsXmlException {
        CmsObject cms = this.getCmsObject();
        String entityId = entity.getId();
        Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
        CmsContentTypeVisitor visitor = null;
        CmsEntity originalEntity = null;
        if (content.getHandler().hasVisibilityHandlers()) {
            visitor = new CmsContentTypeVisitor(cms, file, contentLocale);
            visitor.visitTypes(content.getContentDefinition(), this.getWorkplaceLocale(cms));
        }
        if (content.hasLocale(contentLocale)) {
            if (visitor != null && visitor.hasInvisibleFields()) {
                Element element = content.getLocaleNode(contentLocale);
                originalEntity = this.readEntity(content, element, contentLocale, entityId, "", CmsContentService.getTypeUri(content.getContentDefinition()), visitor, true, entity);
            }
            content.removeLocale(contentLocale);
        }
        content.addLocale(cms, contentLocale);
        if (visitor != null && visitor.hasInvisibleFields()) {
            this.transferInvisibleValues(originalEntity, entity, visitor);
        }
        this.addEntityAttributes(cms, content, "", entity, contentLocale);
        content.synchronizeLocaleIndependentValues(cms, skipPaths, contentLocale);
    }

    private CmsValidationResult validateContent(CmsObject cms, CmsUUID structureId, CmsXmlContent content) {
        return this.validateContent(cms, structureId, content, null);
    }

    private CmsValidationResult validateContent(CmsObject cms, CmsUUID structureId, CmsXmlContent content, Set<String> fieldNames) {
        CmsXmlContentErrorHandler errorHandler = content.validate(cms);
        HashMap<String, Map<String[], String>> errorsByEntity = new HashMap<String, Map<String[], String>>();
        if (errorHandler.hasErrors()) {
            boolean reallyHasErrors = false;
            for (Map.Entry<Locale, Map<String, String>> localeEntry : errorHandler.getErrors().entrySet()) {
                HashMap<String[], String> errors = new HashMap<String[], String>();
                for (Map.Entry<String, String> error : localeEntry.getValue().entrySet()) {
                    I_CmsXmlContentValue value = content.getValue(error.getKey(), localeEntry.getKey());
                    if (fieldNames != null && !fieldNames.contains(value.getPath())) continue;
                    errors.put(this.getPathElements(content, value), error.getValue());
                    reallyHasErrors = true;
                }
                if (!reallyHasErrors) continue;
                errorsByEntity.put(CmsContentDefinition.uuidToEntityId(structureId, localeEntry.getKey().toString()), errors);
            }
        }
        HashMap<String, Map<String[], String>> warningsByEntity = new HashMap<String, Map<String[], String>>();
        if (errorHandler.hasWarnings()) {
            boolean reallyHasErrors = false;
            for (Map.Entry<Locale, Map<String, String>> localeEntry : errorHandler.getWarnings().entrySet()) {
                HashMap<String[], String> warnings = new HashMap<String[], String>();
                for (Map.Entry<String, String> warning : localeEntry.getValue().entrySet()) {
                    I_CmsXmlContentValue value = content.getValue(warning.getKey(), localeEntry.getKey());
                    if (fieldNames != null && !fieldNames.contains(value.getPath())) continue;
                    warnings.put(this.getPathElements(content, value), warning.getValue());
                    reallyHasErrors = true;
                }
                if (!reallyHasErrors) continue;
                warningsByEntity.put(CmsContentDefinition.uuidToEntityId(structureId, localeEntry.getKey().toString()), warnings);
            }
        }
        return new CmsValidationResult(errorsByEntity, warningsByEntity);
    }

    private void writeCategories(CmsFile file, CmsXmlContent content, CmsEntity lastEditedEntity) {
        if (null == content || null == file) {
            return;
        }
        CmsObject cms = this.getCmsObject();
        if (!content.getLocales().isEmpty()) {
            Locale locale = content.getLocales().iterator().next();
            CmsEntity entity = lastEditedEntity;
            List<I_CmsXmlContentValue> values = content.getValues(locale);
            for (I_CmsXmlContentValue value : values) {
                if (!value.getTypeName().equals("OpenCmsDynamicCategory")) continue;
                I_CmsWidget widget = null;
                try {
                    widget = value.getContentDefinition().getContentHandler().getWidget(value);
                }
                catch (CmsXmlException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                List<Object> categories = new ArrayList(0);
                try {
                    categories = CmsCategoryService.getInstance().readResourceCategories(cms, file);
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERROR_FAILED_READING_CATEGORIES_1"), (Throwable)e);
                }
                if (null == widget || !(widget instanceof CmsCategoryWidget)) continue;
                String mainCategoryPath = ((CmsCategoryWidget)widget).getStartingCategory(cms, cms.getSitePath(file));
                for (CmsCategory cmsCategory : categories) {
                    if (!cmsCategory.getPath().startsWith(mainCategoryPath)) continue;
                    try {
                        CmsCategoryService.getInstance().removeResourceFromCategory(cms, cms.getSitePath(file), cmsCategory);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (null == entity) {
                    try {
                        CmsContentDefinition definition = this.readContentDefinition(file, content, "dummy", locale, false, null, null);
                        entity = definition.getEntity();
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                String checkedCategories = "";
                if (null != entity) {
                    checkedCategories = CmsEntity.getValueForPath(entity, new String[]{value.getPath()});
                }
                List<String> list = Arrays.asList(checkedCategories.split(","));
                for (String category : list) {
                    try {
                        CmsCategoryService.getInstance().addResourceToCategory(cms, cms.getSitePath(file), CmsCategoryService.getInstance().getCategory(cms, category));
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private CmsXmlContent writeContent(CmsObject cms, CmsFile file, CmsXmlContent content, String encoding) throws CmsException {
        String decodedContent = content.toString();
        try {
            file.setContents(decodedContent.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new CmsException(org.opencms.workplace.editors.Messages.get().container("ERR_INVALID_CONTENT_ENC_1", file.getRootPath()), (Throwable)e);
        }
        file = cms.writeFile(file);
        return CmsXmlContentFactory.unmarshal(cms, file);
    }
}

