/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.contenteditor.A_CmsXmlContentEditorChangeHandler;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.widgets.A_CmsFormatterWidget;
import org.opencms.widgets.CmsAddFormatterWidget;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentValueSequence;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsEditorChangeHandlerFormatterSelection
extends A_CmsXmlContentEditorChangeHandler {
    private static final Log LOG = CmsLog.getLog(A_CmsFormatterWidget.class);
    private static final String REMOVE_PATH = "/RemoveFormatters";
    private static final String ADD_PATH = "/AddFormatters";
    private static final String ADD_PATH_SINGLE_NODE = "/AddFormatters/AddFormatter";

    @Override
    public CmsXmlContent handleChange(CmsObject cms, CmsXmlContent content, Locale locale, Collection<String> changedPaths) {
        if (changedPaths.size() != 1 && content.getValue(changedPaths.iterator().next(), locale).getTypeName().equals("OpenCmsBoolean")) {
            LOG.error((Object)Messages.get().container("ERROR_CONFIGURATION_EDITOR_CHANGE_HANDLER_FORMATTER_SELECTION_1", content.getContentDefinition().getSchemaLocation()));
            return content;
        }
        String removeAllPath = changedPaths.iterator().next();
        String removeAllStringValue = content.getStringValue(cms, removeAllPath, locale);
        boolean removeAll = Boolean.valueOf(removeAllStringValue);
        if (removeAll && content.hasValue(REMOVE_PATH, locale)) {
            content.removeValue(REMOVE_PATH, locale, 0);
        } else if (content.hasValue(ADD_PATH, locale)) {
            String rootPath = content.getFile().getRootPath();
            List<String> optionValues = CmsAddFormatterWidget.getSelectOptionValues(cms, rootPath, false);
            CmsXmlContentValueSequence addSequence = content.getValueSequence(ADD_PATH_SINGLE_NODE, locale);
            List<I_CmsXmlContentValue> values = addSequence.getValues();
            boolean removeMainAddNode = true;
            for (int i = values.size() - 1; i >= 0; --i) {
                if (optionValues.contains(values.get(i).getStringValue(cms))) {
                    removeMainAddNode = false;
                    continue;
                }
                content.removeValue(ADD_PATH_SINGLE_NODE, locale, i);
            }
            if (removeMainAddNode) {
                content.removeValue(ADD_PATH, locale, 0);
            }
        }
        return content;
    }
}

