/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.galleries.Messages;
import org.opencms.ade.galleries.shared.CmsSiteSelectorOption;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.util.CmsStringUtil;

public class CmsSiteSelectorOptionBuilder {
    private static final Log LOG = CmsLog.getLog(CmsSiteSelectorOptionBuilder.class.getName());
    private CmsObject m_cms;
    private List<CmsSiteSelectorOption> m_options = new ArrayList<CmsSiteSelectorOption>();
    private String m_siteRoot;
    private Set<String> m_usedSiteRoots = new HashSet<String>();

    public CmsSiteSelectorOptionBuilder(CmsObject cms) {
        this.m_cms = cms;
        this.m_siteRoot = this.m_cms.getRequestContext().getSiteRoot();
    }

    public void addCurrentSubsite(String referencePath) {
        CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(this.m_cms, referencePath);
        String basePath = configData.getBasePath();
        if (basePath != null) {
            this.addOption(CmsSiteSelectorOption.Type.currentSubsite, basePath, Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms)).key("GUI_SITESELECTOR_CURRENT_SUBSITE_0"));
        }
    }

    public void addNormalSites(boolean includeRoot, String startFolder) {
        CmsSiteManagerImpl siteManager = OpenCms.getSiteManager();
        List<CmsSite> sites = siteManager.getAvailableSites(this.m_cms, true, false, this.m_cms.getRequestContext().getOuFqn());
        try {
            CmsObject rootCms = OpenCms.initCmsObject(this.m_cms);
            rootCms.getRequestContext().setSiteRoot("/");
            if (sites.isEmpty()) {
                String siteRoot = this.m_cms.getRequestContext().getSiteRoot();
                if (!rootCms.existsResource(siteRoot, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                    if (startFolder != null) {
                        siteRoot = CmsStringUtil.joinPaths(siteRoot, startFolder);
                    }
                    if (startFolder == null || !rootCms.existsResource(siteRoot, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                        siteRoot = null;
                    }
                }
                if (siteRoot != null) {
                    CmsSiteSelectorOption.Type type = CmsSiteSelectorOption.Type.site;
                    String message = siteRoot;
                    this.addOption(type, siteRoot, message);
                }
            }
            for (CmsSite site : sites) {
                if (site.isSharedSite()) continue;
                String siteRoot = site.getSiteRoot();
                if (!rootCms.existsResource(siteRoot, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                    if (startFolder != null) {
                        siteRoot = CmsStringUtil.joinPaths(siteRoot, startFolder);
                    }
                    if (startFolder == null || !rootCms.existsResource(siteRoot, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                        siteRoot = null;
                    }
                }
                if (siteRoot == null) continue;
                CmsSiteSelectorOption.Type type = CmsSiteSelectorOption.Type.site;
                String message = null;
                String title = site.getTitle();
                message = !CmsStringUtil.isEmptyOrWhitespaceOnly(title) ? title : siteRoot;
                if (siteRoot.equals("")) {
                    type = CmsSiteSelectorOption.Type.root;
                    Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
                    message = Messages.get().getBundle(locale).key("GUI_ROOT_SITE_0");
                    if (!includeRoot) continue;
                }
                this.addOption(type, siteRoot, message);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e);
        }
    }

    public void addSharedSite() {
        String shared = OpenCms.getSiteManager().getSharedFolder();
        if (shared.endsWith("/")) {
            shared = shared.substring(0, shared.length() - 1);
        }
        if (shared != null && this.m_cms.existsResource(shared, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
            this.addOption(CmsSiteSelectorOption.Type.shared, shared, org.opencms.workplace.Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms)).key("GUI_SHARED_TITLE_0"));
        }
    }

    public List<CmsSiteSelectorOption> getOptions() {
        return this.m_options;
    }

    private void addOption(CmsSiteSelectorOption.Type type, String siteRoot, String message) {
        if (this.m_usedSiteRoots.contains(CmsStringUtil.joinPaths(siteRoot, "/"))) {
            return;
        }
        CmsSiteSelectorOption option = new CmsSiteSelectorOption(type, siteRoot, this.m_siteRoot.equals(siteRoot), message);
        if (CmsSiteSelectorOption.Type.root.equals((Object)type)) {
            this.m_options.add(0, option);
        } else if (CmsSiteSelectorOption.Type.shared.equals((Object)type)) {
            if (!this.m_options.isEmpty() && CmsSiteSelectorOption.Type.root.equals((Object)this.m_options.get(0).getType())) {
                this.m_options.add(1, option);
            } else {
                this.m_options.add(0, option);
            }
        } else {
            this.m_options.add(option);
        }
        this.m_usedSiteRoots.add(CmsStringUtil.joinPaths(siteRoot, "/"));
    }
}

