/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;

public class CmsGalleryTabConfiguration
implements IsSerializable {
    public static final Map<String, CmsGalleryTabConfiguration> DEFAULT_CONFIGURATIONS;
    public static final String TC_ADE_ADD = "adeAdd";
    public static final String TC_FOLDERS = "folders";
    public static final String TC_GALLERIES = "galleries";
    public static final String TC_SELECT_ALL = "selectAll";
    public static final String TC_SELECT_DOC = "selectDoc";
    public static final String TC_SELECT_ALL_NO_SITEMAP = "selectAllNoSitemap";
    protected I_CmsGalleryProviderConstants.GalleryTabId m_defaultTab;
    private List<I_CmsGalleryProviderConstants.GalleryTabId> m_tabs;

    public CmsGalleryTabConfiguration(List<I_CmsGalleryProviderConstants.GalleryTabId> tabsList) {
        this.m_tabs = tabsList;
    }

    protected CmsGalleryTabConfiguration() {
    }

    public static CmsGalleryTabConfiguration getDefault() {
        return CmsGalleryTabConfiguration.resolve(TC_SELECT_ALL);
    }

    public static CmsGalleryTabConfiguration parse(String configStr) {
        String[] tokens = configStr.split(" *, *");
        I_CmsGalleryProviderConstants.GalleryTabId defaultTabId = null;
        LinkedHashMap tabs = new LinkedHashMap();
        for (String token : tokens) {
            I_CmsGalleryProviderConstants.GalleryTabId tab;
            token = token.trim();
            boolean isDefault = false;
            if (token.startsWith("*")) {
                token = token.substring(1).trim();
                isDefault = true;
            }
            if ((tab = CmsGalleryTabConfiguration.parseTabId(token)) == null) continue;
            tabs.put(tab, null);
            if (!isDefault || defaultTabId != null) continue;
            defaultTabId = tab;
        }
        ArrayList<I_CmsGalleryProviderConstants.GalleryTabId> tabsList = new ArrayList<I_CmsGalleryProviderConstants.GalleryTabId>();
        for (I_CmsGalleryProviderConstants.GalleryTabId tab : tabs.keySet()) {
            tabsList.add(tab);
        }
        if (defaultTabId == null) {
            defaultTabId = (I_CmsGalleryProviderConstants.GalleryTabId)((Object)tabsList.get(0));
        }
        return new CmsGalleryTabConfiguration(tabsList).withDefault(defaultTabId);
    }

    public static I_CmsGalleryProviderConstants.GalleryTabId parseTabId(String tabId) {
        try {
            return I_CmsGalleryProviderConstants.GalleryTabId.valueOf("cms_tab_" + tabId);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static CmsGalleryTabConfiguration resolve(String configStr) {
        CmsGalleryTabConfiguration tabConfig;
        if (DEFAULT_CONFIGURATIONS != null && (tabConfig = DEFAULT_CONFIGURATIONS.get(configStr)) != null) {
            return tabConfig;
        }
        return CmsGalleryTabConfiguration.parse(configStr);
    }

    public I_CmsGalleryProviderConstants.GalleryTabId getDefaultTab() {
        return this.m_defaultTab;
    }

    public List<I_CmsGalleryProviderConstants.GalleryTabId> getTabs() {
        return Collections.unmodifiableList(this.m_tabs);
    }

    public CmsGalleryTabConfiguration withDefault(I_CmsGalleryProviderConstants.GalleryTabId defaultTab) {
        CmsGalleryTabConfiguration result = new CmsGalleryTabConfiguration(this.m_tabs);
        result.m_defaultTab = defaultTab;
        return result;
    }

    static {
        HashMap<String, CmsGalleryTabConfiguration> defaultConfigs = new HashMap<String, CmsGalleryTabConfiguration>();
        defaultConfigs.put(TC_SELECT_ALL, CmsGalleryTabConfiguration.parse("*sitemap,types,galleries,categories,vfstree,search,results"));
        defaultConfigs.put(TC_SELECT_ALL_NO_SITEMAP, CmsGalleryTabConfiguration.parse("*types,galleries,categories,vfstree,search,results"));
        defaultConfigs.put(TC_SELECT_DOC, CmsGalleryTabConfiguration.parse("types,*galleries,categories,vfstree,search,results"));
        defaultConfigs.put(TC_ADE_ADD, CmsGalleryTabConfiguration.parse("*types,galleries,categories,vfstree,search,results"));
        defaultConfigs.put(TC_FOLDERS, CmsGalleryTabConfiguration.parse("*vfstree"));
        defaultConfigs.put(TC_GALLERIES, CmsGalleryTabConfiguration.parse("*galleries,vfstree,results"));
        DEFAULT_CONFIGURATIONS = Collections.unmodifiableMap(defaultConfigs);
    }
}

