/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.I_CmsPublishRelatedResourceProvider;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.I_CmsCollectorPublishListProvider;
import org.opencms.gwt.shared.I_CmsCollectorInfoFactory;
import org.opencms.gwt.shared.I_CmsContentLoadCollectorInfo;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsCurrentPageProject
implements I_CmsVirtualProject {
    public static final CmsUUID ID = CmsUUID.getConstantUUID("currentpage");
    static final Log LOG = CmsLog.getLog(CmsCurrentPageProject.class);

    @Override
    public CmsProjectBean getProjectBean(CmsObject cms, Map<String, String> params) {
        String pageId = params.get("containerpage");
        String elementId = params.get("content");
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String title = Messages.get().getBundle(locale).key("GUI_CURRENTPAGE_PROJECT_0");
        if (pageId == null && elementId == null) {
            return null;
        }
        CmsUUID structureIdForTitle = pageId != null ? new CmsUUID(pageId) : new CmsUUID(elementId);
        CmsProjectBean bean = new CmsProjectBean(ID, 0, title, title);
        bean.setRank(100);
        bean.setDefaultGroupName("");
        try {
            CmsResource titleResource = cms.readResource(structureIdForTitle, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsProperty titleProp = cms.readPropertyObject(titleResource, "Title", true);
            String rawName = titleProp.isNullProperty() ? cms.getSitePath(titleResource) : titleProp.getValue();
            bean.setDefaultGroupName(Messages.get().getBundle(locale).key("GUI_PAGE_1", rawName));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return bean;
    }

    @Override
    public CmsUUID getProjectId() {
        return ID;
    }

    @Override
    public I_CmsPublishRelatedResourceProvider getRelatedResourceProvider(final CmsObject cmsObject, final CmsPublishOptions options) {
        return new I_CmsPublishRelatedResourceProvider(){

            @Override
            public Set<CmsResource> getAdditionalRelatedResources(CmsObject cms, CmsResource res) {
                Map<String, String> params = options.getParameters();
                String pageId = options.getParameters().get("containerpage");
                String detailId = options.getParameters().get("detail");
                HashSet result = Sets.newHashSet();
                if (res.getStructureId().toString().equals(detailId)) {
                    result.addAll(CmsJspTagContainer.getDetailOnlyResources(cms, res));
                }
                if (res.getStructureId().toString().equals(pageId)) {
                    I_CmsCollectorInfoFactory collectorInfoFactory = (I_CmsCollectorInfoFactory)AutoBeanFactorySource.create(I_CmsCollectorInfoFactory.class);
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        if (!entry.getKey().startsWith("collectorInfo")) continue;
                        try {
                            AutoBean autoBean = AutoBeanCodex.decode((AutoBeanFactory)collectorInfoFactory, I_CmsContentLoadCollectorInfo.class, (String)entry.getValue());
                            String collectorName = ((I_CmsContentLoadCollectorInfo)autoBean.as()).getCollectorName();
                            I_CmsCollectorPublishListProvider publishListProvider = null;
                            if (null != collectorName) {
                                publishListProvider = OpenCms.getResourceManager().getContentCollector(collectorName);
                            }
                            if (null == publishListProvider) {
                                String collectorClassName = ((I_CmsContentLoadCollectorInfo)autoBean.as()).getCollectorClass();
                                Class<?> collectorClass = Class.forName(collectorClassName);
                                publishListProvider = (I_CmsCollectorPublishListProvider)collectorClass.newInstance();
                            }
                            if (publishListProvider == null) continue;
                            result.addAll(publishListProvider.getPublishResources(cmsObject, (I_CmsContentLoadCollectorInfo)autoBean.as()));
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    String collectorItemsStr = options.getParameters().get("collectorItems");
                    if (collectorItemsStr != null) {
                        for (String token : collectorItemsStr.split(",")) {
                            try {
                                CmsResource collectorRes;
                                if (!CmsUUID.isValidUUID(token) || (collectorRes = cms.readResource(new CmsUUID(token), CmsResourceFilter.ALL)).getState().isUnchanged()) continue;
                                result.add(collectorRes);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Error processing collector item " + token + ": " + e.getLocalizedMessage()), (Throwable)e);
                            }
                        }
                    }
                }
                return result;
            }
        };
    }

    @Override
    public List<CmsResource> getResources(CmsObject cms, Map<String, String> params, String workflowId) {
        String containerpageId = params.get("containerpage");
        String elementId = params.get("content");
        String detailId = params.get("detail");
        HashSet<CmsResource> resources = new HashSet<CmsResource>();
        for (String id : new String[]{containerpageId, elementId, detailId}) {
            if (!CmsUUID.isValidUUID(id)) continue;
            try {
                CmsResource resource = cms.readResource(new CmsUUID(id), CmsResourceFilter.ALL);
                resources.add(resource);
                CmsResource parent = cms.readParentFolder(resource.getStructureId());
                if (parent.getState().isUnchanged()) continue;
                resources.add(parent);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Lists.newArrayList(resources);
    }

    @Override
    public boolean isAutoSelectable() {
        return true;
    }
}

