/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.A_CmsPublishGroupHelper;
import org.opencms.ade.publish.CmsCurrentPageProject;
import org.opencms.ade.publish.CmsDefaultPublishGroupHelper;
import org.opencms.ade.publish.CmsDirectPublishProject;
import org.opencms.ade.publish.CmsPublish;
import org.opencms.ade.publish.CmsPublishRelationFinder;
import org.opencms.ade.publish.CmsSinglePublishGroupHelper;
import org.opencms.ade.publish.I_CmsPublishRelatedResourceProvider;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishData;
import org.opencms.ade.publish.shared.CmsPublishGroup;
import org.opencms.ade.publish.shared.CmsPublishGroupList;
import org.opencms.ade.publish.shared.CmsPublishListToken;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.CmsWorkflow;
import org.opencms.ade.publish.shared.CmsWorkflowAction;
import org.opencms.ade.publish.shared.CmsWorkflowActionParams;
import org.opencms.ade.publish.shared.CmsWorkflowResponse;
import org.opencms.ade.publish.shared.rpc.I_CmsPublishService;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workflow.CmsWorkflowResources;
import org.opencms.workflow.I_CmsPublishResourceFormatter;
import org.opencms.workflow.I_CmsWorkflowManager;

public class CmsPublishService
extends CmsGwtService
implements I_CmsPublishService {
    public static final String PARAM_CONFIRM = "confirm";
    public static final String PARAM_PUBLISH_PROJECT_ID = "publishProjectId";
    public static final String PARAM_WORKFLOW_ID = "workflowId";
    private static final Log LOG = CmsLog.getLog(CmsPublishService.class);
    private static final long serialVersionUID = 3852074177607037076L;
    private static final String SESSION_ATTR_ADE_PUB_OPTS_CACHE = "__OCMS_ADE_PUB_OPTS_CACHE__";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsPublishData prefetch(HttpServletRequest request) throws CmsRpcException {
        CmsPublishService srv = new CmsPublishService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsPublishData result = null;
        HashMap params = Maps.newHashMap();
        try {
            result = srv.getInitData(params);
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    public static String wrapProjectName(CmsObject cms, String name) {
        return Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_NORMAL_PROJECT_1", name);
    }

    @Override
    public CmsWorkflowResponse executeAction(CmsWorkflowAction action, CmsWorkflowActionParams params) throws CmsRpcException {
        CmsWorkflowResponse response = null;
        try {
            CmsObject cms = this.getCmsObject();
            if (params.getToken() == null) {
                CmsPublishOptions options = this.getCachedOptions();
                CmsPublish pub = new CmsPublish(cms, options);
                List<CmsResource> publishResources = this.idsToResources(cms, params.getPublishIds());
                HashSet<CmsUUID> toRemove = new HashSet<CmsUUID>(params.getRemoveIds());
                pub.removeResourcesFromPublishList(toRemove);
                response = OpenCms.getWorkflowManager().executeAction(cms, action, options, publishResources);
            } else {
                response = OpenCms.getWorkflowManager().executeAction(cms, action, params.getToken());
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return response;
    }

    @Override
    public CmsPublishData getInitData(HashMap<String, String> params) throws CmsRpcException {
        CmsPublishData result = null;
        CmsObject cms = this.getCmsObject();
        String closeLink = this.getRequest().getParameter("closelink");
        String confirmStr = this.getRequest().getParameter(PARAM_CONFIRM);
        boolean confirm = Boolean.parseBoolean(confirmStr);
        String workflowId = this.getRequest().getParameter(PARAM_WORKFLOW_ID);
        String projectParam = this.getRequest().getParameter(PARAM_PUBLISH_PROJECT_ID);
        String filesParam = this.getRequest().getParameter("resourcelist");
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(filesParam)) {
            filesParam = this.getRequest().getParameter("resource");
        }
        List<Object> pathList = Lists.newArrayList();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(filesParam)) {
            pathList = CmsStringUtil.splitAsList(filesParam, "|");
        }
        try {
            result = this.getPublishData(cms, params, workflowId, projectParam, pathList, closeLink, confirm);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    public CmsPublishData getPublishData(CmsObject cms, HashMap<String, String> params, String workflowId, String projectParam, List<String> pathList, String closeLink, boolean confirm) throws Exception {
        boolean canOverrideWorkflow = true;
        Map<String, CmsWorkflow> workflows = OpenCms.getWorkflowManager().getWorkflows(cms);
        if (workflows.isEmpty()) {
            throw new Exception("No workflow available for the current user");
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(workflowId) || !workflows.containsKey(workflowId)) {
            workflowId = this.getLastWorkflowForUser();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(workflowId) || !workflows.containsKey(workflowId)) {
                workflowId = workflows.values().iterator().next().getId();
            }
        } else {
            canOverrideWorkflow = false;
        }
        this.setLastWorkflowForUser(workflowId);
        if (!pathList.isEmpty()) {
            params.put("files", CmsStringUtil.listAsString(pathList, "|"));
        }
        boolean useCurrentPageAsDefault = params.containsKey("startWithCurrentPage");
        CmsPublishOptions options = this.getCachedOptions();
        List<CmsProjectBean> projects = OpenCms.getWorkflowManager().getManageableProjects(cms, params);
        HashSet availableProjectIds = Sets.newHashSet();
        for (CmsProjectBean projectBean : projects) {
            availableProjectIds.add(projectBean.getId());
        }
        CmsUUID defaultProjectId = CmsUUID.getNullUUID();
        if (useCurrentPageAsDefault && availableProjectIds.contains(CmsCurrentPageProject.ID)) {
            defaultProjectId = CmsCurrentPageProject.ID;
        }
        boolean foundProject = false;
        CmsUUID selectedProject = null;
        if (!pathList.isEmpty()) {
            params.put("enable_include_contents", Boolean.TRUE.toString());
            params.put("include_contents", Boolean.TRUE.toString());
            selectedProject = CmsDirectPublishProject.ID;
            foundProject = true;
        } else {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(projectParam) && CmsUUID.isValidUUID(projectParam)) {
                selectedProject = new CmsUUID(projectParam);
                for (CmsProjectBean project : projects) {
                    if (!selectedProject.equals(project.getId())) continue;
                    foundProject = true;
                    if (!project.isWorkflowProject()) break;
                    canOverrideWorkflow = false;
                    workflowId = OpenCms.getWorkflowManager().getWorkflowForWorkflowProject(selectedProject);
                    break;
                }
            }
            if (!foundProject) {
                selectedProject = options.getProjectId();
                if (selectedProject == null) {
                    selectedProject = defaultProjectId;
                    foundProject = true;
                } else {
                    for (CmsProjectBean project : projects) {
                        if (!selectedProject.equals(project.getId())) continue;
                        foundProject = true;
                        if (!project.isWorkflowProject()) break;
                        canOverrideWorkflow = false;
                        workflowId = OpenCms.getWorkflowManager().getWorkflowForWorkflowProject(selectedProject);
                        break;
                    }
                }
            }
        }
        if (foundProject) {
            options.setProjectId(selectedProject);
        } else {
            options.setProjectId(CmsUUID.getNullUUID());
        }
        options.setParameters(params);
        CmsPublishData result = new CmsPublishData(options, projects, this.getResourceGroups(workflows.get(workflowId), options, canOverrideWorkflow), workflows, workflowId);
        result.setCloseLink(closeLink);
        result.setShowConfirmation(confirm);
        return result;
    }

    @Override
    public CmsPublishGroupList getResourceGroups(CmsWorkflow workflow, CmsPublishOptions options, boolean projectChanged) throws CmsRpcException {
        List results = null;
        CmsObject cms = this.getCmsObject();
        String overrideWorkflowId = null;
        try {
            A_CmsPublishGroupHelper groupHelper;
            List<CmsResource> resources;
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            I_CmsWorkflowManager workflowManager = OpenCms.getWorkflowManager();
            I_CmsPublishResourceFormatter formatter = workflowManager.createFormatter(cms, workflow, options);
            CmsWorkflowResources workflowResources = workflowManager.getWorkflowResources(cms, workflow, options, projectChanged);
            if (workflowResources.getOverrideWorkflow() != null) {
                overrideWorkflowId = workflowResources.getOverrideWorkflow().getId();
                formatter = workflowManager.createFormatter(cms, workflowResources.getOverrideWorkflow(), options);
            }
            if ((resources = workflowResources.getWorkflowResources()).size() > workflowManager.getResourceLimit()) {
                CmsPublishListToken token = workflowManager.getPublishListToken(cms, workflow, options);
                CmsPublishGroupList result = new CmsPublishGroupList(token);
                result.setTooManyResourcesMessage(Messages.get().getBundle(locale).key("GUI_TOO_MANY_RESOURCES_2", "" + resources.size(), "" + OpenCms.getWorkflowManager().getResourceLimit()));
                return result;
            }
            I_CmsVirtualProject virtualProject = workflowManager.getRealOrVirtualProject(options.getProjectId());
            I_CmsPublishRelatedResourceProvider relProvider = virtualProject.getRelatedResourceProvider(this.getCmsObject(), options);
            CmsPublishRelationFinder.ResourceMap resourcesAndRelated = this.getResourcesAndRelated(resources, options.isIncludeRelated(), options.isIncludeSiblings(), options.getProjectId() == null || options.getProjectId().isNullUUID(), relProvider);
            formatter.initialize(options, resourcesAndRelated);
            List<CmsPublishResource> publishResources = formatter.getPublishResources();
            boolean autoSelectable = true;
            if (options.getProjectId() == null || options.getProjectId().isNullUUID()) {
                groupHelper = new CmsDefaultPublishGroupHelper(locale);
            } else {
                String title = "";
                CmsProjectBean projectBean = virtualProject.getProjectBean(cms, options.getParameters());
                title = projectBean.getDefaultGroupName();
                if (title == null) {
                    title = "";
                }
                autoSelectable = virtualProject.isAutoSelectable();
                groupHelper = new CmsSinglePublishGroupHelper(locale, title);
            }
            results = groupHelper.getGroups(publishResources);
            for (CmsPublishGroup group : results) {
                group.setAutoSelectable(autoSelectable);
            }
            this.setCachedOptions(options);
            this.setLastWorkflowForUser(workflow.getId());
        }
        catch (Throwable e) {
            this.error(e);
        }
        CmsPublishGroupList wrapper = new CmsPublishGroupList();
        wrapper.setOverrideWorkflowId(overrideWorkflowId);
        wrapper.setGroups(results);
        return wrapper;
    }

    @Override
    public CmsPublishOptions getResourceOptions() throws CmsRpcException {
        CmsPublishOptions result = null;
        try {
            result = this.getCachedOptions();
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    protected void addSiblings(Set<CmsResource> publishResources) {
        ArrayList toAdd = Lists.newArrayList();
        for (CmsResource resource : publishResources) {
            if (resource.getState().isUnchanged()) continue;
            try {
                List<CmsResource> changedSiblings = this.getCmsObject().readSiblings(resource, CmsResourceFilter.ALL_MODIFIED);
                toAdd.addAll(changedSiblings);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        publishResources.addAll(toAdd);
    }

    private CmsPublishOptions getCachedOptions() {
        CmsPublishOptions cache = (CmsPublishOptions)this.getRequest().getSession().getAttribute(SESSION_ATTR_ADE_PUB_OPTS_CACHE);
        if (cache == null) {
            cache = new CmsPublishOptions();
            this.getRequest().getSession().setAttribute(SESSION_ATTR_ADE_PUB_OPTS_CACHE, (Object)cache);
        }
        return cache;
    }

    private String getLastWorkflowForUser() {
        CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
        return (String)user.getAdditionalInfo(PARAM_WORKFLOW_ID);
    }

    private CmsPublishRelationFinder.ResourceMap getResourcesAndRelated(List<CmsResource> resources, boolean includeRelated, boolean includeSiblings, boolean keepOriginalUnchangedResources, I_CmsPublishRelatedResourceProvider relProvider) {
        CmsPublishRelationFinder.ResourceMap result;
        HashSet<CmsResource> publishResources = new HashSet<CmsResource>();
        publishResources.addAll(resources);
        if (includeSiblings) {
            this.addSiblings(publishResources);
        }
        if (includeRelated) {
            CmsPublishRelationFinder relationFinder = new CmsPublishRelationFinder(this.getCmsObject(), publishResources, keepOriginalUnchangedResources, relProvider);
            result = relationFinder.getPublishRelatedResources();
        } else {
            result = new CmsPublishRelationFinder.ResourceMap();
            for (CmsResource resource : publishResources) {
                if (!keepOriginalUnchangedResources && resource.getState().isUnchanged()) continue;
                result.put(resource, new HashSet());
            }
        }
        return result;
    }

    private List<CmsResource> idsToResources(CmsObject cms, List<CmsUUID> ids) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsUUID id : ids) {
            try {
                CmsResource resource = cms.readResource(id, CmsResourceFilter.ALL);
                result.add(resource);
            }
            catch (CmsException e) {
                this.logError(e);
            }
        }
        return result;
    }

    private void setCachedOptions(CmsPublishOptions options) {
        this.getRequest().getSession().setAttribute(SESSION_ATTR_ADE_PUB_OPTS_CACHE, (Object)options);
    }

    private void setLastWorkflowForUser(String workflowId) throws CmsException {
        CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
        user.setAdditionalInfo(PARAM_WORKFLOW_ID, workflowId);
        this.getCmsObject().writeUser(user);
    }
}

