/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.I_CmsXmlConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlErrorHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CmsConfigurationManager
implements I_CmsXmlConfiguration {
    public static final String DEFAULT_DTD_LOCATION = "org/opencms/configuration/";
    public static final String DEFAULT_XSLT_FILENAME = "opencms-configuration.xslt";
    public static final String DEFAULT_DTD_PREFIX = "http://www.opencms.org/dtd/6.0/";
    public static final String DEFAULT_XML_FILE_NAME = "opencms.xml";
    public static final String DTD_FILE_NAME = "opencms-configuration.dtd";
    public static final String N_ROOT = "opencms";
    public static final String POSTFIX_ORI = ".ori";
    protected static final String N_CONFIG = "config";
    protected static final String N_CONFIGURATION = "configuration";
    private static final SimpleDateFormat BACKUP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_");
    private static final Log LOG = CmsLog.getLog(CmsConfigurationManager.class);
    private static final long MAX_BACKUP_DAYS = 15L;
    private File m_backupFolder;
    private File m_baseFolder;
    private List<I_CmsXmlConfiguration> m_configurations;
    private Digester m_digester;
    private CmsParameterConfiguration m_propertyConfiguration;

    public CmsConfigurationManager(String baseFolder) {
        this.m_baseFolder = new File(baseFolder);
        if (!this.m_baseFolder.exists() && LOG.isErrorEnabled()) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_CONFIG_BASE_FOLDER_1", this.m_baseFolder.getAbsolutePath()));
        }
        this.m_backupFolder = new File(this.m_baseFolder.getAbsolutePath() + File.separatorChar + "backup");
        if (!this.m_backupFolder.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_CONFIG_BKP_FOLDER_1", this.m_backupFolder.getAbsolutePath()));
            }
            this.m_backupFolder.mkdirs();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CONFIG_BASE_FOLDER_1", this.m_baseFolder.getAbsolutePath()));
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CONFIG_BKP_FOLDER_1", this.m_backupFolder.getAbsolutePath()));
        }
        this.cacheDtdSystemId(this);
        this.m_configurations = new ArrayList<I_CmsXmlConfiguration>();
    }

    public void addConfiguration(I_CmsXmlConfiguration configuration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_CONFIG_1", configuration));
        }
        this.m_configurations.add(configuration);
        this.cacheDtdSystemId(configuration);
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
    }

    @Override
    public void addXmlDigesterRules(Digester digester) {
        digester.addObjectCreate("*/configuration/config", "class", CmsConfigurationException.class);
        digester.addSetNext("*/configuration/config", "addConfiguration");
    }

    @Override
    public Element generateXml(Element parent) {
        Element configurationElement = parent.addElement(N_CONFIGURATION);
        for (int i = 0; i < this.m_configurations.size(); ++i) {
            I_CmsXmlConfiguration configuration = this.m_configurations.get(i);
            configurationElement.addElement(N_CONFIG).addAttribute("class", configuration.getClass().getName());
        }
        return parent;
    }

    public Document generateXml(I_CmsXmlConfiguration configuration) {
        Document result = DocumentHelper.createDocument();
        DOMDocumentType docType = new DOMDocumentType();
        docType.setElementName(N_ROOT);
        docType.setSystemID(configuration.getDtdUrlPrefix() + configuration.getDtdFilename());
        result.setDocType((DocumentType)docType);
        Element root = result.addElement(N_ROOT);
        configuration.generateXml(root);
        return result;
    }

    public File getBackupFolder() {
        return this.m_backupFolder;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_propertyConfiguration;
    }

    public I_CmsXmlConfiguration getConfiguration(Class<?> clazz) {
        for (int i = 0; i < this.m_configurations.size(); ++i) {
            I_CmsXmlConfiguration configuration = this.m_configurations.get(i);
            if (!clazz.equals(configuration.getClass())) continue;
            return configuration;
        }
        return null;
    }

    public List<I_CmsXmlConfiguration> getConfigurations() {
        return this.m_configurations;
    }

    @Override
    public String getDtdFilename() {
        return DTD_FILE_NAME;
    }

    @Override
    public String getDtdSystemLocation() {
        return DEFAULT_DTD_LOCATION;
    }

    @Override
    public String getDtdUrlPrefix() {
        return DEFAULT_DTD_PREFIX;
    }

    @Override
    public String getXmlFileName() {
        return DEFAULT_XML_FILE_NAME;
    }

    @Override
    public void initConfiguration() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_INIT_CONFIGURATION_1", this));
        }
    }

    public void loadXmlConfiguration() throws SAXException, IOException {
        URL baseUrl = this.m_baseFolder.toURI().toURL();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_BASE_URL_1", baseUrl));
        }
        this.loadXmlConfiguration(baseUrl, this);
        Iterator<I_CmsXmlConfiguration> i = this.m_configurations.iterator();
        while (i.hasNext()) {
            this.loadXmlConfiguration(baseUrl, i.next());
        }
        this.removeOldBackups(15L);
    }

    public void setConfiguration(CmsParameterConfiguration propertyConfiguration) {
        this.m_propertyConfiguration = propertyConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfiguration(Class<?> clazz) throws IOException, CmsConfigurationException {
        I_CmsXmlConfiguration configuration = this.getConfiguration(clazz);
        if (configuration == null) {
            throw new CmsConfigurationException(Messages.get().container("ERR_CONFIG_WITH_UNKNOWN_CLASS_1", clazz.getName()));
        }
        File file = new File(this.m_baseFolder, configuration.getXmlFileName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_WRITE_CONFIG_XMLFILE_1", file.getAbsolutePath()));
        }
        Document config = this.generateXml(configuration);
        XMLWriter writer = null;
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndentSize(4);
        format.setTrimText(false);
        format.setEncoding("UTF-8");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            writer = new XMLWriter((OutputStream)out, format);
            writer.write(config);
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_WRITE_CONFIG_SUCCESS_2", file.getAbsolutePath(), configuration.getClass().getName()));
        }
    }

    String getTransformationPath() {
        String path = System.getProperty("opencms.config.transform");
        if (path == null) {
            path = CmsStringUtil.joinPaths(this.m_baseFolder.getAbsolutePath(), DEFAULT_XSLT_FILENAME);
        }
        return path;
    }

    boolean hasTransformation() {
        boolean result;
        String transformationPath = this.getTransformationPath();
        boolean bl = result = transformationPath != null && new File(transformationPath).exists();
        if (result) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_XSLT_CONFIG_ENABLED_1", transformationPath));
        } else {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_XSLT_CONFIG_DISABLED_0"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputSource transformConfiguration(URL url, I_CmsXmlConfiguration config) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        String configPath = CmsStringUtil.joinPaths(url.getFile(), config.getXmlFileName());
        String transformPath = this.getTransformationPath();
        TransformerFactory factory = TransformerFactory.newInstance();
        ByteArrayOutputStream errBaos = new ByteArrayOutputStream();
        PrintStream oldErr = System.err;
        System.setErr(new PrintStream(errBaos));
        try {
            LOG.info((Object)("Transforming '" + configPath + "' with transformation '" + transformPath + "'"));
            Transformer transformer = factory.newTransformer(new StreamSource(new File(transformPath)));
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setParameter("file", config.getXmlFileName());
            InetAddress localhost = InetAddress.getLocalHost();
            transformer.setParameter("hostName", localhost.getHostName());
            transformer.setParameter("canonicalHostName", localhost.getCanonicalHostName());
            transformer.setParameter("hostAddress", localhost.getHostAddress());
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
            XMLReader reader = parserFactory.newSAXParser().getXMLReader();
            reader.setEntityResolver(new CmsXmlEntityResolver(null));
            SAXSource source = new SAXSource(reader, new InputSource(configPath));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult target = new StreamResult(baos);
            transformer.transform(source, target);
            byte[] transformedConfig = baos.toByteArray();
            String transformedConfigStr = new String(transformedConfig, "UTF-8").replaceFirst("@dtd@", config.getDtdUrlPrefix() + config.getDtdFilename());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"");
                LOG.debug((Object)("=================== Transformation result for config file '" + config.getXmlFileName() + "':"));
                LOG.debug((Object)transformedConfigStr);
            }
            InputSource inputSource = new InputSource(new ByteArrayInputStream(transformedConfigStr.getBytes("UTF-8")));
            return inputSource;
        }
        finally {
            System.setErr(oldErr);
            byte[] errorBytes = errBaos.toByteArray();
            if (errorBytes.length > 0) {
                LOG.warn((Object)new String(errorBytes, "UTF-8"));
            }
        }
    }

    private void backupXmlConfiguration(I_CmsXmlConfiguration configuration) {
        String fromName = this.m_baseFolder.getAbsolutePath() + File.separatorChar + configuration.getXmlFileName();
        String toDatePrefix = BACKUP_DATE_FORMAT.format(new Date());
        String toName = this.m_backupFolder.getAbsolutePath() + File.separatorChar + toDatePrefix + configuration.getXmlFileName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_CONFIG_BKP_2", fromName, toName));
        }
        try {
            CmsFileUtil.copy(fromName, toName);
        }
        catch (IOException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CREATE_CONFIG_BKP_FAILURE_1", toName), (Throwable)e);
        }
    }

    private void cacheDtdSystemId(I_CmsXmlConfiguration configuration) {
        if (configuration.getDtdSystemLocation() != null) {
            try {
                String file = CmsFileUtil.readFile(configuration.getDtdSystemLocation() + configuration.getDtdFilename(), "UTF-8");
                CmsXmlEntityResolver.cacheSystemId(configuration.getDtdUrlPrefix() + configuration.getDtdFilename(), file.getBytes("UTF-8"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_CACHE_DTD_SYSTEM_ID_1", configuration.getDtdUrlPrefix() + configuration.getDtdFilename() + " --> " + configuration.getDtdSystemLocation() + configuration.getDtdFilename()));
                }
            }
            catch (IOException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_CACHE_DTD_SYSTEM_ID_FAILURE_1", configuration.getDtdSystemLocation() + configuration.getDtdFilename()), (Throwable)e);
            }
        }
    }

    private void loadXmlConfiguration(URL url, I_CmsXmlConfiguration configuration) throws SAXException, IOException {
        URL fileUrl = new URL(url, configuration.getXmlFileName());
        CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOAD_CONFIG_XMLFILE_1", fileUrl));
        boolean hasTransformation = this.hasTransformation();
        this.backupXmlConfiguration(configuration);
        this.m_digester = new Digester();
        this.m_digester.setUseContextClassLoader(true);
        this.m_digester.setValidating(true);
        this.m_digester.setEntityResolver((EntityResolver)new CmsXmlEntityResolver(null));
        this.m_digester.setRuleNamespaceURI(null);
        this.m_digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler(fileUrl.getFile()));
        this.m_digester.push((Object)configuration);
        configuration.addXmlDigesterRules(this.m_digester);
        InputSource inputSource = null;
        if (hasTransformation) {
            try {
                inputSource = this.transformConfiguration(url, configuration);
            }
            catch (Exception e) {
                LOG.error((Object)("Error transforming " + configuration.getXmlFileName() + ": " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        if (inputSource == null) {
            inputSource = new InputSource(fileUrl.openStream());
        }
        this.m_digester.parse(inputSource);
    }

    private void removeOldBackups(long daysToKeep) {
        long maxAge = System.currentTimeMillis() - daysToKeep * 24L * 60L * 60L * 1000L;
        File[] files = this.m_backupFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            long lastMod = file.lastModified();
            if (!(lastMod < maxAge & !file.getAbsolutePath().endsWith(POSTFIX_ORI))) continue;
            file.delete();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)Messages.get().getBundle().key("LOG_REMOVE_CONFIG_FILE_1", file.getAbsolutePath()));
        }
    }

    class MyStream
    extends OutputStream {
        private ByteArrayOutputStream m_baos = new ByteArrayOutputStream();

        MyStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.m_baos.write(b);
            if (b == 10 || b == 13) {
                System.out.println("*");
            }
        }
    }
}

