/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import java.util.List;
import java.util.Locale;
import org.opencms.configuration.preferences.CmsBuiltinPreference;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsLanguagePreference
extends CmsBuiltinPreference {
    private static final String NICE_NAME = "%(key.GUI_LABEL_LANGUAGE_0)";

    public CmsLanguagePreference(String name) {
        super(name);
        this.m_basic = true;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", null, null, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String options = this.getOptionsForLanguage(locale);
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", "select_notnull", options, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    private String getOptionsForLanguage(Locale setLocale) {
        List<Locale> locales = OpenCms.getWorkplaceManager().getLocales();
        StringBuffer resultBuffer = new StringBuffer();
        int counter = 0;
        for (Locale currentLocale : locales) {
            String language = currentLocale.getDisplayLanguage(setLocale);
            if (CmsStringUtil.isNotEmpty(currentLocale.getCountry())) {
                language = language + " (" + currentLocale.getDisplayCountry(setLocale) + ")";
            }
            if (CmsStringUtil.isNotEmpty(currentLocale.getVariant())) {
                language = language + " (" + currentLocale.getDisplayVariant(setLocale) + ")";
            }
            if (counter != 0) {
                resultBuffer.append("|");
            }
            resultBuffer.append(currentLocale.toString()).append(":").append(language);
            ++counter;
        }
        return resultBuffer.toString();
    }
}

