/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.configuration.preferences.CmsBuiltinPreference;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsMacroResolver;
import org.opencms.workplace.CmsWorkplaceView;
import org.opencms.workplace.commons.Messages;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsStartViewPreference
extends CmsBuiltinPreference {
    private static final Log LOG = CmsLog.getLog(CmsStartViewPreference.class);
    private static final String NICE_NAME = "%(key.GUI_PREF_STARTUP_VIEW_0)";

    public CmsStartViewPreference(String name) {
        super(name);
    }

    public static CmsBuiltinPreference.SelectOptions getViewSelectOptions(CmsObject cms, String value) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int selectedIndex = 0;
        ArrayList<CmsWorkplaceView> list = new ArrayList<CmsWorkplaceView>(OpenCms.getWorkplaceManager().getViews());
        CmsWorkplaceView directEditView = new CmsWorkplaceView(Messages.get().getBundle(locale).key("GUI_LABEL_DIRECT_EDIT_VIEW_0"), "/system/workplace/views/explorer/directEdit.jsp", Float.valueOf(100.0f));
        list.add(directEditView);
        Iterator i = list.iterator();
        int count = -1;
        while (i.hasNext()) {
            ++count;
            CmsWorkplaceView view = (CmsWorkplaceView)i.next();
            boolean visible = true;
            try {
                cms.readResource(view.getUri());
            }
            catch (CmsException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e.getLocalizedMessage());
                }
                visible = false;
            }
            if (!visible) continue;
            CmsMacroResolver resolver = new CmsMacroResolver();
            resolver.setCmsObject(cms);
            resolver.setMessages(OpenCms.getWorkplaceManager().getMessages(locale));
            String localizedKey = resolver.resolveMacros(view.getKey());
            options.add(localizedKey);
            values.add(view.getUri());
            if (!view.getUri().equals(value)) continue;
            selectedIndex = count;
        }
        CmsBuiltinPreference.SelectOptions optionBean = new CmsBuiltinPreference.SelectOptions(options, values, selectedIndex);
        return optionBean;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", null, null, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        String options = CmsStartViewPreference.getViewSelectOptions(cms, null).toClientSelectWidgetConfiguration();
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", "select_notnull", options, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    @Override
    public boolean isDisabled(CmsObject cms) {
        return !OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_USER);
    }
}

