/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.generic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsProject;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSqlManager
extends org.opencms.db.CmsSqlManager {
    protected static final String QUERY_PROJECT_SEARCH_PATTERN = "_${PROJECT}_";
    private static final Log LOG = CmsLog.getLog(CmsSqlManager.class);
    private static final String QUERY_PROPERTIES = "org/opencms/db/generic/query.properties";
    protected ConcurrentHashMap<String, String> m_cachedQueries = new ConcurrentHashMap();
    protected int m_driverType;
    protected String m_poolUrl;
    protected Map<String, String> m_queries = new HashMap<String, String>();

    public CmsSqlManager() {
        this.loadQueryProperties(QUERY_PROPERTIES);
    }

    public static CmsSqlManager getInstance(String classname) {
        CmsSqlManager sqlManager;
        try {
            Object objectInstance = Class.forName(classname).newInstance();
            sqlManager = (CmsSqlManager)objectInstance;
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_SQL_MANAGER_INIT_FAILED_1", classname), t);
            sqlManager = null;
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DRIVER_SQL_MANAGER_1", classname));
        }
        return sqlManager;
    }

    protected static String replaceProjectPattern(CmsUUID projectId, String query) {
        String replacePattern = projectId == null || projectId.equals(CmsProject.ONLINE_PROJECT_ID) ? "_ONLINE_" : "_OFFLINE_";
        return CmsStringUtil.substitute(query, QUERY_PROJECT_SEARCH_PATTERN, replacePattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(CmsDbContext dbc, Connection con, Statement stmnt, ResultSet res) {
        if (dbc == null) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_NULL_DB_CONTEXT_0"));
        }
        try {
            if (res != null) {
                res.close();
            }
        }
        catch (SQLException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            res = null;
        }
        try {
            if (stmnt != null) {
                stmnt.close();
            }
        }
        catch (SQLException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            stmnt = null;
        }
        try {
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        catch (SQLException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            con = null;
        }
    }

    public byte[] getBytes(ResultSet res, String attributeName) throws SQLException {
        return res.getBytes(attributeName);
    }

    public Connection getConnection(CmsDbContext dbc) throws SQLException {
        if (dbc == null) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_NULL_DB_CONTEXT_0"));
        }
        return this.getConnectionByUrl(this.m_poolUrl);
    }

    public PreparedStatement getPreparedStatement(Connection con, CmsProject project, String queryKey) throws SQLException {
        return this.getPreparedStatement(con, project.getUuid(), queryKey);
    }

    public PreparedStatement getPreparedStatement(Connection con, CmsUUID projectId, String queryKey) throws SQLException {
        String rawSql = this.readQuery(projectId, queryKey);
        return this.getPreparedStatementForSql(con, rawSql);
    }

    public PreparedStatement getPreparedStatement(Connection con, String queryKey) throws SQLException {
        String rawSql = this.readQuery(CmsUUID.getNullUUID(), queryKey);
        return this.getPreparedStatementForSql(con, rawSql);
    }

    public PreparedStatement getPreparedStatementForSql(Connection con, String query) throws SQLException {
        return con.prepareStatement(query);
    }

    public void init(int driverType, String poolUrl) {
        if (!poolUrl.startsWith("jdbc:apache:commons:dbcp:")) {
            poolUrl = "jdbc:apache:commons:dbcp:" + poolUrl;
        }
        this.m_driverType = driverType;
        this.m_poolUrl = poolUrl;
    }

    public String readQuery(CmsProject project, String queryKey) {
        return this.readQuery(project.getUuid(), queryKey);
    }

    public String readQuery(CmsUUID projectId, String queryKey) {
        String key;
        if (projectId != null && !projectId.isNullUUID()) {
            StringBuffer buffer = new StringBuffer(128);
            buffer.append(queryKey);
            if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                buffer.append("_ONLINE");
            } else {
                buffer.append("_OFFLINE");
            }
            key = buffer.toString();
        } else {
            key = queryKey;
        }
        String query = this.m_cachedQueries.get(key);
        if (query == null) {
            query = this.readQuery(queryKey);
            if (query == null) {
                throw new CmsRuntimeException(Messages.get().container("ERR_QUERY_NOT_FOUND_1", queryKey));
            }
            query = CmsStringUtil.substitute(query, "\t", " ");
            query = CmsStringUtil.substitute(query, "\n", " ");
            if (projectId != null && !projectId.isNullUUID()) {
                query = CmsSqlManager.replaceProjectPattern(projectId, query);
            }
            this.m_cachedQueries.put(key, query);
        }
        return query;
    }

    public String readQuery(String queryKey) {
        String value = this.m_queries.get(queryKey);
        if (value == null && LOG.isErrorEnabled()) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_QUERY_NOT_FOUND_1", queryKey));
        }
        return value;
    }

    public void setBytes(PreparedStatement statement, int pos, byte[] content) throws SQLException {
        if (content.length < 2000) {
            statement.setBytes(pos, content);
        } else {
            statement.setBinaryStream(pos, (InputStream)new ByteArrayInputStream(content), content.length);
        }
    }

    public String validateEmpty(String value) {
        if (CmsStringUtil.isNotEmpty(value)) {
            return value;
        }
        return " ";
    }

    protected void loadQueryProperties(String propertyFilename) {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream(propertyFilename));
            this.m_queries.putAll(CmsCollectionsGenericWrapper.map(properties));
            this.replaceQuerySearchPatterns();
        }
        catch (Throwable t) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_LOAD_QUERY_PROP_FILE_FAILED_1", propertyFilename), t);
            }
            properties = null;
        }
    }

    protected synchronized void replaceQuerySearchPatterns() {
        String currentKey2 = null;
        String currentValue = null;
        int startIndex = 0;
        int endIndex = 0;
        int lastIndex = 0;
        for (String currentKey2 : this.m_queries.keySet()) {
            currentValue = this.m_queries.get(currentKey2);
            startIndex = 0;
            endIndex = 0;
            lastIndex = 0;
            while ((startIndex = currentValue.indexOf("${", lastIndex)) != -1) {
                endIndex = currentValue.indexOf(125, startIndex);
                if (endIndex != -1 && !currentValue.startsWith(QUERY_PROJECT_SEARCH_PATTERN, startIndex - 1)) {
                    String replaceKey = currentValue.substring(startIndex + 2, endIndex);
                    String searchPattern = currentValue.substring(startIndex, endIndex + 1);
                    String replacePattern = this.readQuery(replaceKey);
                    if (replacePattern != null) {
                        currentValue = CmsStringUtil.substitute(currentValue, searchPattern, replacePattern);
                    }
                }
                lastIndex = endIndex + 2;
            }
            this.m_queries.put(currentKey2, currentValue);
        }
    }
}

