/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.mssql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.I_CmsHistoryDriver;
import org.opencms.db.generic.CmsSqlManager;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.history.CmsHistoryProject;

public class CmsHistoryDriver
extends org.opencms.db.generic.CmsHistoryDriver {
    @Override
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    @Override
    public List<CmsHistoryProject> readProjects(CmsDbContext dbc) throws CmsDataAccessException {
        ArrayList<CmsHistoryProject> projects = new ArrayList<CmsHistoryProject>();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        HashMap<Integer, CmsHistoryProject> tmpProjects = new HashMap<Integer, CmsHistoryProject>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_MSSQL_PROJECTS_READLAST_HISTORY");
            res = stmt.executeQuery();
            while (res.next()) {
                tmpProjects.put(res.getInt("PUBLISH_TAG"), this.internalCreateProject(res, null));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        I_CmsHistoryDriver historyDriver = this.m_driverManager.getHistoryDriver(dbc);
        for (Map.Entry entry : tmpProjects.entrySet()) {
            List<String> resources = historyDriver.readProjectResources(dbc, (Integer)entry.getKey());
            ((CmsHistoryProject)entry.getValue()).setProjectResources(resources);
            projects.add((CmsHistoryProject)entry.getValue());
        }
        return projects;
    }
}

