/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import java.io.Serializable;
import java.util.Date;
import org.opencms.db.CmsResourceState;
import org.opencms.file.I_CmsResource;
import org.opencms.file.Messages;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.A_CmsModeIntEnumeration;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsResource
implements I_CmsResource,
Cloneable,
Serializable,
Comparable<I_CmsResource> {
    public static final CmsResourceCopyMode COPY_AS_NEW = CmsResourceCopyMode.MODE_COPY_AS_NEW;
    public static final CmsResourceCopyMode COPY_AS_SIBLING = CmsResourceCopyMode.MODE_COPY_AS_SIBLING;
    public static final CmsResourceCopyMode COPY_PRESERVE_SIBLING = CmsResourceCopyMode.MODE_COPY_PRESERVE_SIBLING;
    public static final long DATE_EXPIRED_DEFAULT = Long.MAX_VALUE;
    public static final long DATE_RELEASED_DEFAULT = 0L;
    public static final long DATE_RELEASED_EXPIRED_IGNORE = Long.MIN_VALUE;
    public static final CmsResourceDeleteMode DELETE_PRESERVE_SIBLINGS = CmsResourceDeleteMode.MODE_DELETE_PRESERVE_SIBLINGS;
    public static final CmsResourceDeleteMode DELETE_REMOVE_SIBLINGS = CmsResourceDeleteMode.MODE_DELETE_REMOVE_SIBLINGS;
    public static final int FLAG_INTERNAL = 512;
    public static final int FLAG_LABELED = 2;
    public static final int FLAG_TEMPFILE = 1024;
    public static final String NAME_CONSTRAINTS = "-._~$";
    public static final CmsResourceState STATE_CHANGED = CmsResourceState.STATE_CHANGED;
    public static final CmsResourceState STATE_DELETED = CmsResourceState.STATE_DELETED;
    public static final CmsResourceState STATE_KEEP = CmsResourceState.STATE_KEEP;
    public static final CmsResourceState STATE_NEW = CmsResourceState.STATE_NEW;
    public static final CmsResourceState STATE_UNCHANGED = CmsResourceState.STATE_UNCHANGED;
    public static final String TEMP_FILE_PREFIX = "~";
    public static final long TOUCH_DATE_UNCHANGED = -1L;
    public static final CmsResourceUndoMode UNDO_CONTENT = CmsResourceUndoMode.MODE_UNDO_CONTENT;
    public static final CmsResourceUndoMode UNDO_CONTENT_RECURSIVE = CmsResourceUndoMode.MODE_UNDO_CONTENT_RECURSIVE;
    public static final CmsResourceUndoMode UNDO_MOVE_CONTENT = CmsResourceUndoMode.MODE_UNDO_MOVE_CONTENT;
    public static final CmsResourceUndoMode UNDO_MOVE_CONTENT_RECURSIVE = CmsResourceUndoMode.MODE_UNDO_MOVE_CONTENT_RECURSIVE;
    public static final String VFS_FOLDER_SITES = "/sites";
    public static final String VFS_FOLDER_SYSTEM = "/system";
    private static final long serialVersionUID = 257325098790850498L;
    protected long m_dateContent = System.currentTimeMillis();
    protected int m_length;
    private long m_dateCreated;
    private long m_dateExpired;
    private long m_dateLastModified;
    private long m_dateReleased;
    private int m_flags;
    private boolean m_isFolder;
    private boolean m_isTouched;
    private CmsUUID m_projectLastModified;
    private CmsUUID m_resourceId;
    private String m_rootPath;
    private int m_siblingCount;
    private CmsResourceState m_state;
    private CmsUUID m_structureId;
    private int m_typeId;
    private CmsUUID m_userCreated;
    private CmsUUID m_userLastModified;
    private int m_version;

    public CmsResource(CmsUUID structureId, CmsUUID resourceId, String rootPath, I_CmsResourceType type, int flags, CmsUUID projectId, CmsResourceState state, long dateCreated, CmsUUID userCreated, long dateLastModified, CmsUUID userLastModified, long dateReleased, long dateExpired, int linkCount, int size, long dateContent, int version) {
        this(structureId, resourceId, rootPath, type.getTypeId(), type.isFolder(), flags, projectId, state, dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, linkCount, size, dateContent, version);
    }

    public CmsResource(CmsUUID structureId, CmsUUID resourceId, String rootPath, int type, boolean isFolder, int flags, CmsUUID projectId, CmsResourceState state, long dateCreated, CmsUUID userCreated, long dateLastModified, CmsUUID userLastModified, long dateReleased, long dateExpired, int linkCount, int size, long dateContent, int version) {
        this.m_structureId = structureId;
        this.m_resourceId = resourceId;
        this.m_rootPath = rootPath;
        this.m_typeId = type;
        this.m_isFolder = isFolder;
        this.m_flags = flags;
        this.m_projectLastModified = projectId;
        this.m_state = state;
        this.m_dateCreated = dateCreated;
        this.m_userCreated = userCreated;
        this.m_dateLastModified = dateLastModified;
        this.m_userLastModified = userLastModified;
        this.m_dateReleased = dateReleased;
        this.m_dateExpired = dateExpired;
        this.m_siblingCount = linkCount;
        this.m_length = size;
        this.m_dateContent = dateContent;
        this.m_version = version;
        this.m_isTouched = false;
    }

    public static void checkResourceName(String name) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_RESOURCENAME_EMPTY_0", name));
        }
        CmsStringUtil.checkName(name, NAME_CONSTRAINTS, "ERR_BAD_RESOURCENAME_4", Messages.get());
        boolean onlydots = true;
        String lastName = CmsResource.getName(name);
        int l = lastName.length();
        for (int i = 0; i < l; ++i) {
            char c = lastName.charAt(i);
            if (c == '.' || c == '/') continue;
            onlydots = false;
        }
        if (onlydots) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_RESOURCENAME_DOTS_1", lastName));
        }
    }

    public static String getFolderPath(String resource) {
        return resource.substring(0, resource.lastIndexOf(47) + 1);
    }

    public static String getName(String resource) {
        if ("/".equals(resource)) {
            return "/";
        }
        String parent = resource.substring(0, resource.length() - 1);
        return resource.substring(parent.lastIndexOf(47) + 1);
    }

    public static String getParentFolder(String resource) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(resource) || "/".equals(resource)) {
            return null;
        }
        String parent = resource.substring(0, resource.length() - 1);
        return parent.substring(0, parent.lastIndexOf(47) + 1);
    }

    public static int getPathLevel(String resource) {
        int level = -1;
        int pos = 0;
        while (resource.indexOf(47, pos) >= 0) {
            pos = resource.indexOf(47, pos) + 1;
            ++level;
        }
        return level;
    }

    public static String getPathPart(String resource, int level) {
        int count;
        resource = CmsResource.getFolderPath(resource);
        String result = null;
        int pos = 0;
        if (level >= 0) {
            for (count = 0; count < level && pos > -1; ++count) {
                pos = resource.indexOf(47, pos + 1);
            }
        } else {
            pos = resource.length();
            while (count > level && pos > -1) {
                --count;
                pos = resource.lastIndexOf(47, pos - 1);
            }
        }
        result = pos > -1 ? resource.substring(0, pos + 1) : (level < 0 ? "/" : resource);
        return result;
    }

    public static boolean isFolder(String resource) {
        return CmsStringUtil.isNotEmpty(resource) && resource.charAt(resource.length() - 1) == '/';
    }

    public static boolean isTemporaryFileName(String path) {
        return path != null && CmsResource.getName(path).startsWith(TEMP_FILE_PREFIX);
    }

    public Object clone() {
        return this.getCopy();
    }

    @Override
    public int compareTo(I_CmsResource obj) {
        if (obj == this) {
            return 0;
        }
        return this.m_rootPath.compareTo(obj.getRootPath());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsResource) {
            return ((CmsResource)obj).m_structureId.equals(this.m_structureId);
        }
        return false;
    }

    public CmsResource getCopy() {
        CmsResource result = new CmsResource(this.m_structureId, this.m_resourceId, this.m_rootPath, this.m_typeId, this.m_isFolder, this.m_flags, this.m_projectLastModified, this.m_state, this.m_dateCreated, this.m_userCreated, this.m_dateLastModified, this.m_userLastModified, this.m_dateReleased, this.m_dateExpired, this.m_siblingCount, this.m_length, this.m_dateContent, this.m_version);
        if (this.isTouched()) {
            result.setDateLastModified(this.m_dateLastModified);
        }
        return result;
    }

    @Override
    public long getDateContent() {
        return this.m_dateContent;
    }

    @Override
    public long getDateCreated() {
        return this.m_dateCreated;
    }

    @Override
    public long getDateExpired() {
        return this.m_dateExpired;
    }

    @Override
    public long getDateLastModified() {
        return this.m_dateLastModified;
    }

    @Override
    public long getDateReleased() {
        return this.m_dateReleased;
    }

    @Override
    public int getFlags() {
        return this.m_flags;
    }

    @Override
    public int getLength() {
        return this.m_isFolder ? -1 : this.m_length;
    }

    @Override
    public String getName() {
        String name = CmsResource.getName(this.m_rootPath);
        if (name.charAt(name.length() - 1) == '/') {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    @Override
    public CmsUUID getProjectLastModified() {
        return this.m_projectLastModified;
    }

    @Override
    public CmsUUID getResourceId() {
        return this.m_resourceId;
    }

    @Override
    public String getRootPath() {
        return this.m_rootPath;
    }

    @Override
    public int getSiblingCount() {
        return this.m_siblingCount;
    }

    @Override
    public CmsResourceState getState() {
        return this.m_state;
    }

    @Override
    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    @Override
    public int getTypeId() {
        return this.m_typeId;
    }

    @Override
    public CmsUUID getUserCreated() {
        return this.m_userCreated;
    }

    @Override
    public CmsUUID getUserLastModified() {
        return this.m_userLastModified;
    }

    @Override
    public int getVersion() {
        return this.m_version;
    }

    public int hashCode() {
        if (this.m_structureId != null) {
            return this.m_structureId.hashCode();
        }
        return CmsUUID.getNullUUID().hashCode();
    }

    @Override
    public boolean isExpired(long time) {
        return time > this.m_dateExpired && time != Long.MIN_VALUE;
    }

    @Override
    public boolean isFile() {
        return !this.m_isFolder;
    }

    @Override
    public boolean isFolder() {
        return this.m_isFolder;
    }

    @Override
    public boolean isInternal() {
        return (this.m_flags & 0x200) > 0;
    }

    @Override
    public boolean isLabeled() {
        return (this.m_flags & 2) > 0;
    }

    @Override
    public boolean isReleased(long time) {
        return time > this.m_dateReleased || time == Long.MIN_VALUE;
    }

    @Override
    public boolean isReleasedAndNotExpired(long time) {
        return time < this.m_dateExpired && time > this.m_dateReleased || time == Long.MIN_VALUE;
    }

    public boolean isTemporaryFile() {
        return this.isFile() && ((this.getFlags() & 0x400) > 0 || CmsResource.isTemporaryFileName(this.getName()));
    }

    @Override
    public boolean isTouched() {
        return this.m_isTouched;
    }

    public void setDateExpired(long time) {
        this.m_dateExpired = time;
    }

    public void setDateLastModified(long time) {
        this.m_isTouched = true;
        this.m_dateLastModified = time;
    }

    public void setDateReleased(long time) {
        this.m_dateReleased = time;
    }

    public void setFlags(int flags) {
        this.m_flags = flags;
    }

    public void setInternal(boolean internal) {
        this.m_flags = this.m_flags & 0xFFFFFDFF | (internal ? 512 : 0);
    }

    public void setState(CmsResourceState state) {
        this.m_state = state;
    }

    public void setType(int type) {
        this.m_typeId = type;
    }

    public void setUserLastModified(CmsUUID resourceLastModifiedByUserId) {
        this.m_userLastModified = resourceLastModifiedByUserId;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(this.getClass().getName());
        result.append(", path: ");
        result.append(this.m_rootPath);
        result.append(", structure id ");
        result.append(this.m_structureId);
        result.append(", resource id: ");
        result.append(this.m_resourceId);
        result.append(", type id: ");
        result.append(this.m_typeId);
        result.append(", folder: ");
        result.append(this.m_isFolder);
        result.append(", flags: ");
        result.append(this.m_flags);
        result.append(", project: ");
        result.append(this.m_projectLastModified);
        result.append(", state: ");
        result.append(this.m_state);
        result.append(", date created: ");
        result.append(new Date(this.m_dateCreated));
        result.append(", user created: ");
        result.append(this.m_userCreated);
        result.append(", date lastmodified: ");
        result.append(new Date(this.m_dateLastModified));
        result.append(", user lastmodified: ");
        result.append(this.m_userLastModified);
        result.append(", date released: ");
        result.append(new Date(this.m_dateReleased));
        result.append(", date expired: ");
        result.append(new Date(this.m_dateExpired));
        result.append(", date content: ");
        result.append(new Date(this.m_dateContent));
        result.append(", size: ");
        result.append(this.m_length);
        result.append(", sibling count: ");
        result.append(this.m_siblingCount);
        result.append(", version: ");
        result.append(this.m_version);
        result.append("]");
        return result.toString();
    }

    public static final class CmsResourceUndoMode
    extends A_CmsModeIntEnumeration {
        public static final CmsResourceUndoMode MODE_UNDO_CONTENT = new CmsResourceUndoMode(1);
        public static final CmsResourceUndoMode MODE_UNDO_CONTENT_RECURSIVE = new CmsResourceUndoMode(2);
        public static final CmsResourceUndoMode MODE_UNDO_MOVE_CONTENT = new CmsResourceUndoMode(3);
        public static final CmsResourceUndoMode MODE_UNDO_MOVE_CONTENT_RECURSIVE = new CmsResourceUndoMode(4);
        private static final long serialVersionUID = 3521620626485212068L;

        private CmsResourceUndoMode(int mode) {
            super(mode);
        }

        public static CmsResourceUndoMode getUndoMode(boolean move, boolean recursive) {
            if (move) {
                return recursive ? MODE_UNDO_MOVE_CONTENT_RECURSIVE : MODE_UNDO_MOVE_CONTENT;
            }
            return recursive ? MODE_UNDO_CONTENT_RECURSIVE : MODE_UNDO_CONTENT;
        }

        public static CmsResourceUndoMode valueOf(int mode) {
            switch (mode) {
                case 1: {
                    return MODE_UNDO_CONTENT;
                }
                case 2: {
                    return MODE_UNDO_CONTENT_RECURSIVE;
                }
                case 3: {
                    return MODE_UNDO_MOVE_CONTENT;
                }
            }
            return MODE_UNDO_MOVE_CONTENT_RECURSIVE;
        }

        public CmsResourceUndoMode includeMove() {
            if (!this.isUndoMove()) {
                return CmsResourceUndoMode.valueOf(this.getMode() + 2);
            }
            return this;
        }

        public boolean isRecursive() {
            return this.getMode() > UNDO_CONTENT.getMode();
        }

        public boolean isUndoMove() {
            return this.getMode() > UNDO_CONTENT_RECURSIVE.getMode();
        }

        @Override
        public String toString() {
            return String.valueOf(this.getMode());
        }
    }

    public static final class CmsResourceDeleteMode
    extends A_CmsModeIntEnumeration {
        protected static final CmsResourceDeleteMode MODE_DELETE_PRESERVE_SIBLINGS = new CmsResourceDeleteMode(1);
        protected static final CmsResourceDeleteMode MODE_DELETE_REMOVE_SIBLINGS = new CmsResourceDeleteMode(2);
        private static final long serialVersionUID = 2010402524576925865L;

        private CmsResourceDeleteMode(int mode) {
            super(mode);
        }

        public static CmsResourceDeleteMode valueOf(int mode) {
            switch (mode) {
                case 1: {
                    return MODE_DELETE_PRESERVE_SIBLINGS;
                }
            }
            return MODE_DELETE_REMOVE_SIBLINGS;
        }
    }

    public static final class CmsResourceCopyMode
    extends A_CmsModeIntEnumeration {
        protected static final CmsResourceCopyMode MODE_COPY_AS_NEW = new CmsResourceCopyMode(1);
        protected static final CmsResourceCopyMode MODE_COPY_AS_SIBLING = new CmsResourceCopyMode(2);
        protected static final CmsResourceCopyMode MODE_COPY_PRESERVE_SIBLING = new CmsResourceCopyMode(3);
        private static final long serialVersionUID = 9081630878178799137L;

        private CmsResourceCopyMode(int mode) {
            super(mode);
        }

        public static CmsResourceCopyMode valueOf(int mode) {
            switch (mode) {
                case 1: {
                    return MODE_COPY_AS_NEW;
                }
                case 2: {
                    return MODE_COPY_AS_SIBLING;
                }
            }
            return MODE_COPY_PRESERVE_SIBLING;
        }
    }
}

