/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSolrCollector
extends A_CmsResourceCollector {
    private static final String[] COLLECTORS = new String[]{"byQuery", "byContext"};
    private static final List<String> COLLECTORS_LIST = Collections.unmodifiableList(Arrays.asList(COLLECTORS));
    private static final String PARAM_CREATE_PATH = "createPath";
    private static final String PARAM_DECODE_URL = "decodeUrl";
    private static final String SOLR_PART = "solrPart";

    @Override
    public List<String> getCollectorNames() {
        return COLLECTORS_LIST;
    }

    @Override
    public String getCreateLink(CmsObject cms, String collectorName, String param) throws CmsException {
        collectorName = collectorName == null ? COLLECTORS[1] : collectorName;
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: 
            case 1: {
                Map<String, String> paramsAsMap = this.getParamsAsMap(param);
                CmsSolrQuery q = new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(paramsAsMap.get(SOLR_PART), Boolean.valueOf(paramsAsMap.get(PARAM_DECODE_URL)), cms.getRequestContext().getEncoding()));
                String type = CmsSolrQuery.getResourceType(q.getFilterQueries());
                String path = paramsAsMap.get(PARAM_CREATE_PATH);
                if (type != null && path != null) {
                    return OpenCms.getResourceManager().getNameGenerator().getNewFileName(cms, path, 4);
                }
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public String getCreateParam(CmsObject cms, String collectorName, String param) throws CmsDataAccessException {
        collectorName = collectorName == null ? COLLECTORS[1] : collectorName;
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: 
            case 1: {
                Map<String, String> paramsAsMap = this.getParamsAsMap(param);
                CmsSolrQuery q = new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(paramsAsMap.get(SOLR_PART), Boolean.valueOf(paramsAsMap.get(PARAM_DECODE_URL)), cms.getRequestContext().getEncoding()));
                String type = CmsSolrQuery.getResourceType(q.getFilterQueries());
                String path = paramsAsMap.get(PARAM_CREATE_PATH);
                if (type != null && path != null) {
                    return param;
                }
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public int getCreateTypeId(CmsObject cms, String collectorName, String param) throws CmsException {
        String solrParams;
        CmsSolrQuery q;
        String type;
        int result = -1;
        Map<String, String> paramsAsMap = this.getParamsAsMap(param);
        if (paramsAsMap.get(PARAM_CREATE_PATH) != null && (type = CmsSolrQuery.getResourceType((q = new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(solrParams = paramsAsMap.get(SOLR_PART), Boolean.valueOf(paramsAsMap.get(PARAM_DECODE_URL)), cms.getRequestContext().getEncoding()))).getFilterQueries())) != null) {
            result = OpenCms.getResourceManager().getResourceType(type).getTypeId();
        }
        return result;
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String collectorName, String param) throws CmsDataAccessException, CmsException {
        return this.getResults(cms, collectorName, param, -1);
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String name, String param, int numResults) throws CmsException {
        name = name == null ? COLLECTORS[1] : name;
        Map<String, String> paramsAsMap = this.getParamsAsMap(param);
        Map<String, String[]> pm = CmsRequestUtil.createParameterMap(paramsAsMap.get(SOLR_PART), Boolean.valueOf(paramsAsMap.get(PARAM_DECODE_URL)), cms.getRequestContext().getEncoding());
        CmsSolrQuery q = COLLECTORS_LIST.indexOf(name) == 0 ? new CmsSolrQuery(null, pm) : new CmsSolrQuery(cms, pm);
        boolean excludeTimerange = Boolean.valueOf(paramsAsMap.get("excludeTimerange"));
        if (excludeTimerange) {
            q.removeExpiration();
        }
        if (numResults > 0) {
            q.setRows(numResults);
        }
        CmsSolrIndex index = CmsSearchManager.getIndexSolr(cms, pm);
        return new ArrayList<CmsResource>(index.search(cms, q, true));
    }

    private Map<String, String> getParamsAsMap(String param) {
        Map<String, String> result = new HashMap<String, String>();
        if (param != null) {
            int in = param.indexOf(124);
            if (in != -1) {
                String solrPart = param.substring(0, in);
                String cmsPart = param.substring(in);
                result = CmsStringUtil.splitAsMap(cmsPart, "|", "=");
                result.put(SOLR_PART, solrPart);
            } else {
                result.put(SOLR_PART, param);
            }
        }
        return result;
    }
}

