/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.history;

import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsException;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsUUID;

public class CmsHistoryFile
extends CmsFile
implements I_CmsHistoryResource {
    private static final long serialVersionUID = 4073076414399668662L;
    private CmsUUID m_parentId;
    private int m_publishTag;
    private int m_structureVersion;
    private int m_resourceVersion;

    public CmsHistoryFile(CmsResource resource) {
        super(resource);
        this.m_publishTag = 0;
        this.m_parentId = null;
    }

    public CmsHistoryFile(I_CmsHistoryResource resource) {
        this(resource.getPublishTag(), resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), resource.getTypeId(), resource.getFlags(), resource.getProjectLastModified(), resource.getState(), resource.getDateCreated(), resource.getUserCreated(), resource.getDateLastModified(), resource.getUserLastModified(), resource.getDateReleased(), resource.getDateExpired(), resource.getLength(), resource.getDateContent(), resource.getVersion(), resource.getParentId(), resource.isFile() ? ((CmsFile)((Object)resource)).getContents() : null, resource.getResourceVersion(), resource.getStructureVersion());
    }

    public CmsHistoryFile(int publishTag, CmsUUID structureId, CmsUUID resourceId, String path, int type, int flags, CmsUUID projectId, CmsResourceState state, long dateCreated, CmsUUID userCreated, long dateLastModified, CmsUUID userLastModified, long dateReleased, long dateExpired, int size, long dateContent, int version, CmsUUID parentId, byte[] content, int resourceVersion, int structureVersion) {
        super(structureId, resourceId, path, type, flags, projectId, state, dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, 0, size, dateContent, version, content);
        this.m_publishTag = publishTag;
        this.m_parentId = parentId;
        this.m_resourceVersion = resourceVersion;
        this.m_structureVersion = structureVersion;
    }

    @Override
    public Object clone() {
        return new CmsHistoryFile(this.getPublishTag(), this.getStructureId(), this.getResourceId(), this.getRootPath(), this.getTypeId(), this.getFlags(), this.getProjectLastModified(), this.getState(), this.getDateCreated(), this.getUserCreated(), this.getDateLastModified(), this.getUserLastModified(), this.getDateReleased(), this.getDateExpired(), this.getLength(), this.getDateContent(), this.getVersion(), this.getParentId(), this.getContents(), this.getResourceVersion(), this.getStructureVersion());
    }

    @Override
    public CmsUUID getParentId() {
        return this.m_parentId;
    }

    @Override
    public int getPublishTag() {
        return this.m_publishTag;
    }

    public String getUserCreatedName(CmsObject cms) {
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, this.getUserCreated()).getName();
        }
        catch (CmsException e) {
            return this.getUserCreated().toString();
        }
    }

    public String getUserLastModifiedName(CmsObject cms) {
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, this.getUserLastModified()).getName();
        }
        catch (CmsException e) {
            return this.getUserLastModified().toString();
        }
    }

    @Override
    public int getResourceVersion() {
        return this.m_resourceVersion;
    }

    @Override
    public int getStructureVersion() {
        return this.m_structureVersion;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(super.toString());
        result.append(", resource version: ");
        result.append(this.m_resourceVersion);
        result.append(", structure version ");
        result.append(this.m_structureVersion);
        result.append(", parent id: ");
        result.append(this.m_parentId);
        result.append(", publish tag: ");
        result.append(this.m_publishTag);
        result.append("]");
        return result.toString();
    }
}

