/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsLruCache;
import org.opencms.cache.I_CmsLruCacheObject;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexCacheConfiguration;
import org.opencms.flex.CmsFlexCacheEntry;
import org.opencms.flex.CmsFlexCacheKey;
import org.opencms.flex.CmsFlexRequestKey;
import org.opencms.flex.Messages;
import org.opencms.loader.CmsJspLoader;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;

public class CmsFlexCache
implements I_CmsEventListener {
    public static final String CACHE_OFFLINESUFFIX = " [offline]";
    public static final String CACHE_ONLINESUFFIX = " [online]";
    public static final int CLEAR_ALL = 0;
    public static final int CLEAR_ENTRIES = 1;
    public static final int CLEAR_OFFLINE_ALL = 4;
    public static final int CLEAR_OFFLINE_ENTRIES = 5;
    public static final int CLEAR_ONLINE_ALL = 2;
    public static final int CLEAR_ONLINE_ENTRIES = 3;
    public static final int INITIAL_CAPACITY_CACHE = 512;
    public static final int INITIAL_CAPACITY_VARIATIONS = 8;
    public static final String REPOSITORY_OFFLINE = "offline";
    public static final String REPOSITORY_ONLINE = "online";
    private static final Log LOG = CmsLog.getLog(CmsFlexCache.class);
    protected CmsLruCache m_variationCache;
    private boolean m_cacheOffline;
    private boolean m_enabled;
    private Map<String, CmsFlexCacheVariation> m_keyCache;
    private int m_size;

    public CmsFlexCache(CmsFlexCacheConfiguration configuration) {
        this.m_enabled = configuration.isCacheEnabled();
        this.m_cacheOffline = configuration.isCacheOffline();
        long maxCacheBytes = configuration.getMaxCacheBytes();
        long avgCacheBytes = configuration.getAvgCacheBytes();
        int maxEntryBytes = configuration.getMaxEntryBytes();
        int maxKeys = configuration.getMaxKeys();
        this.m_variationCache = new CmsLruCache(maxCacheBytes, avgCacheBytes, maxEntryBytes);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_entryLruCache", this.m_variationCache);
        if (this.m_enabled) {
            CmsFlexKeyMap flexKeyMap = new CmsFlexKeyMap(maxKeys);
            this.m_keyCache = Collections.synchronizedMap(CmsCollectionsGenericWrapper.map((Object)flexKeyMap));
            OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_resourceMap", (Object)flexKeyMap);
            OpenCms.addCmsEventListener(this, new int[]{2, 5, 8, 9});
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("INIT_FLEXCACHE_CREATED_2", this.m_enabled, this.m_cacheOffline));
        }
    }

    public boolean cacheOffline() {
        return this.m_cacheOffline;
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        block1 : switch (event.getType()) {
            case 2: 
            case 5: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_RECEIVED_EVENT_CLEAR_CACHE_0"));
                }
                this.clear();
                break;
            }
            case 8: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_RECEIVED_EVENT_PURGE_REPOSITORY_0"));
                }
                this.purgeJspRepository();
                break;
            }
            case 9: {
                Map<String, Object> m;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_RECEIVED_EVENT_CLEAR_CACHE_PARTIALLY_0"));
                }
                if ((m = event.getData()) == null) break;
                Integer it = null;
                try {
                    it = (Integer)m.get("action");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (it == null) break;
                int i = it;
                switch (i) {
                    case 0: {
                        this.clear();
                        break block1;
                    }
                    case 1: {
                        this.clearEntries();
                        break block1;
                    }
                    case 2: {
                        this.clearOnline();
                        break block1;
                    }
                    case 3: {
                        this.clearOnlineEntries();
                        break block1;
                    }
                    case 4: {
                        this.clearOffline();
                        break block1;
                    }
                    case 5: {
                        this.clearOfflineEntries();
                        break block1;
                    }
                }
                break;
            }
        }
    }

    public CmsFlexCacheKey getCachedKey(String key, CmsObject cms) {
        if (!this.isEnabled() || !OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_MANAGER)) {
            return null;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(key);
        if (o != null) {
            return o.m_key;
        }
        return null;
    }

    public Set<String> getCachedResources(CmsObject cms) {
        if (!this.isEnabled() || !OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_MANAGER)) {
            return null;
        }
        return this.m_keyCache.keySet();
    }

    public Set<String> getCachedVariations(String key, CmsObject cms) {
        if (!this.isEnabled() || !OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_MANAGER)) {
            return null;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(key);
        if (o != null) {
            return o.m_map.keySet();
        }
        return null;
    }

    public CmsLruCache getEntryLruCache() {
        return this.m_variationCache;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public int keySize() {
        if (!this.isEnabled()) {
            return 0;
        }
        return this.m_keyCache.size();
    }

    public int size() {
        return this.m_variationCache.size();
    }

    CmsFlexCacheEntry get(CmsFlexRequestKey key) {
        if (!this.isEnabled()) {
            return null;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(key.getResource());
        if (o != null) {
            CmsFlexCacheVariation v = o;
            String variation = v.m_key.matchRequestKey(key);
            if (CmsStringUtil.isEmpty(variation)) {
                return null;
            }
            CmsFlexCacheEntry entry = (CmsFlexCacheEntry)v.m_map.get(variation);
            if (entry == null) {
                return null;
            }
            if (entry.getDateExpires() < System.currentTimeMillis()) {
                this.m_variationCache.remove(entry);
                return null;
            }
            return entry;
        }
        return null;
    }

    CmsFlexCacheKey getKey(String resource) {
        if (!this.isEnabled()) {
            return null;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(resource);
        if (o != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_FOUND_1", resource));
            }
            return o.m_key;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_NOT_FOUND_1", resource));
        }
        return null;
    }

    boolean isEmpty() {
        if (!this.isEnabled()) {
            return true;
        }
        return this.m_keyCache.isEmpty();
    }

    boolean put(CmsFlexCacheKey key, CmsFlexCacheEntry entry, String variation) {
        if (!this.isEnabled()) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADD_ENTRY_1", key.getResource()));
        }
        if (variation != null) {
            key.setVariation(variation);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADD_ENTRY_WITH_VARIATION_2", key.getResource(), key.getVariation()));
            }
            this.put(key, entry);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_RESOURCE_NOT_CACHEABLE_0"));
        }
        return false;
    }

    void putKey(CmsFlexCacheKey key) {
        if (!this.isEnabled()) {
            return;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(key.getResource());
        if (o == null) {
            CmsFlexCacheVariation variationMap = new CmsFlexCacheVariation(key);
            this.m_keyCache.put(key.getResource(), variationMap);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADD_KEY_1", key.getResource()));
            }
        }
    }

    void remove(CmsFlexCacheKey key) {
        I_CmsLruCacheObject old;
        if (!this.isEnabled()) {
            return;
        }
        CmsFlexCacheVariation o = this.m_keyCache.get(key.getResource());
        if (o != null && (old = o.m_map.get(key.getVariation())) != null) {
            this.getEntryLruCache().remove(old);
        }
    }

    private synchronized void clear() {
        if (!this.isEnabled()) {
            return;
        }
        this.m_keyCache.clear();
        this.m_size = 0;
        this.m_variationCache.clear();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_0"));
        }
    }

    private synchronized void clearAccordingToSuffix(String suffix, boolean entriesOnly) {
        HashSet<String> keys = new HashSet<String>(this.m_keyCache.keySet());
        for (String s : keys) {
            I_CmsLruCacheObject nextObject;
            Iterator<I_CmsLruCacheObject> allEntries;
            if (!s.endsWith(suffix)) continue;
            CmsFlexCacheVariation v = this.m_keyCache.get(s);
            if (entriesOnly) {
                this.m_size -= v.m_map.size();
                allEntries = v.m_map.values().iterator();
                while (allEntries.hasNext()) {
                    nextObject = allEntries.next();
                    allEntries.remove();
                    this.m_variationCache.remove(nextObject);
                }
                v.m_map = new Hashtable<String, I_CmsLruCacheObject>(8);
                continue;
            }
            this.m_size -= v.m_map.size();
            allEntries = v.m_map.values().iterator();
            while (allEntries.hasNext()) {
                nextObject = allEntries.next();
                allEntries.remove();
                this.m_variationCache.remove(nextObject);
            }
            v.m_map = null;
            v.m_key = null;
            this.m_keyCache.remove(s);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_HALF_2", suffix, entriesOnly));
        }
    }

    private synchronized void clearEntries() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_ALL_0"));
        }
        HashSet<String> cacheKeys = new HashSet<String>(this.m_keyCache.keySet());
        Iterator i = cacheKeys.iterator();
        while (i.hasNext()) {
            CmsFlexCacheVariation v = this.m_keyCache.get(i.next());
            Iterator<I_CmsLruCacheObject> allEntries = v.m_map.values().iterator();
            while (allEntries.hasNext()) {
                I_CmsLruCacheObject nextObject = allEntries.next();
                allEntries.remove();
                this.m_variationCache.remove(nextObject);
            }
            v.m_map = new Hashtable<String, I_CmsLruCacheObject>(8);
        }
        this.m_size = 0;
    }

    private void clearOffline() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_KEYS_AND_ENTRIES_0"));
        }
        this.clearAccordingToSuffix(CACHE_OFFLINESUFFIX, false);
    }

    private void clearOfflineEntries() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_OFFLINE_ENTRIES_0"));
        }
        this.clearAccordingToSuffix(CACHE_OFFLINESUFFIX, true);
    }

    private void clearOnline() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_ONLINE_KEYS_AND_ENTRIES_0"));
        }
        this.clearAccordingToSuffix(CACHE_ONLINESUFFIX, false);
    }

    private void clearOnlineEntries() {
        if (!this.isEnabled()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_CLEAR_ONLINE_ENTRIES_0"));
        }
        this.clearAccordingToSuffix(CACHE_ONLINESUFFIX, true);
    }

    private synchronized void purgeJspRepository() {
        CmsJspLoader cmsJspLoader = (CmsJspLoader)OpenCms.getResourceManager().getLoader(6);
        cmsJspLoader.triggerPurge(new Runnable(){

            @Override
            public void run() {
                CmsFlexCache.this.clear();
            }
        });
    }

    private void put(CmsFlexCacheKey key, CmsFlexCacheEntry theCacheEntry) {
        CmsFlexCacheVariation o = this.m_keyCache.get(key.getResource());
        if (key.getTimeout() > 0L) {
            theCacheEntry.setDateExpiresToNextTimeout(key.getTimeout());
        }
        if (o != null) {
            Map<String, I_CmsLruCacheObject> m = o.m_map;
            boolean wasAdded = true;
            wasAdded = !m.containsKey(key.getVariation()) ? this.m_variationCache.add(theCacheEntry) : this.m_variationCache.touch(theCacheEntry);
            if (wasAdded) {
                theCacheEntry.setVariationData(key.getVariation(), m);
                m.put(key.getVariation(), theCacheEntry);
            }
        } else {
            CmsFlexCacheVariation list = new CmsFlexCacheVariation(key);
            boolean wasAdded = this.m_variationCache.add(theCacheEntry);
            if (wasAdded) {
                theCacheEntry.setVariationData(key.getVariation(), list.m_map);
                list.m_map.put(key.getVariation(), theCacheEntry);
                this.m_keyCache.put(key.getResource(), list);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADDED_ENTRY_FOR_RESOURCE_WITH_VARIATION_3", new Integer(this.m_size), key.getResource(), key.getVariation()));
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHE_ADDED_ENTRY_1", theCacheEntry.toString()));
        }
    }

    class CmsFlexKeyMap
    extends LRUMap {
        private static final long serialVersionUID = 6931995916013396902L;

        public CmsFlexKeyMap(int maxSize) {
            super(maxSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            CmsFlexCacheVariation v = (CmsFlexCacheVariation)entry.getValue();
            if (v == null) {
                return true;
            }
            Map<String, I_CmsLruCacheObject> m = v.m_map;
            if (m == null || m.size() == 0) {
                return true;
            }
            Collection<I_CmsLruCacheObject> entries = m.values();
            CmsLruCache cmsLruCache = CmsFlexCache.this.m_variationCache;
            synchronized (cmsLruCache) {
                for (I_CmsLruCacheObject e : entries) {
                    CmsFlexCache.this.m_variationCache.remove(e);
                }
                v.m_map.clear();
                v.m_map = null;
                v.m_key = null;
            }
            return true;
        }
    }

    public static class CmsFlexCacheVariation {
        public CmsFlexCacheKey m_key;
        public Map<String, I_CmsLruCacheObject> m_map;

        public CmsFlexCacheVariation(CmsFlexCacheKey theKey) {
            this.m_key = theKey;
            this.m_map = new Hashtable<String, I_CmsLruCacheObject>(8);
        }
    }
}

