/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexRequestKey;
import org.opencms.flex.Messages;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsFlexCacheKey {
    private static final String CACHE_00_ALWAYS = "always";
    private static final String CACHE_01_NEVER = "never";
    private static final String CACHE_02_URI = "uri";
    private static final String CACHE_03_USER = "user";
    private static final String CACHE_04_PARAMS = "params";
    private static final String CACHE_05_NO_PARAMS = "no-params";
    private static final String CACHE_06_TIMEOUT = "timeout";
    private static final String CACHE_07_SESSION = "session";
    private static final String CACHE_08_SCHEMES = "schemes";
    private static final String CACHE_09_PORTS = "ports";
    private static final String CACHE_10_FALSE = CmsStringUtil.FALSE;
    private static final String CACHE_11_PARSE_ERROR = "parse-error";
    private static final String CACHE_12_TRUE = CmsStringUtil.TRUE;
    private static final String CACHE_13_IP = "ip";
    private static final String CACHE_14_ELEMENT = "element";
    private static final String CACHE_15_LOCALE = "locale";
    private static final String CACHE_16_ENCODING = "encoding";
    private static final String CACHE_17_SITE = "site";
    private static final String CACHE_18_ATTRS = "attrs";
    private static final String CACHE_19_NO_ATTRS = "no-attrs";
    private static final String CACHE_20_DEVICE = "device";
    private static final String CACHE_21_CONTAINER_ELEMENT = "container-element";
    private static final List<String> CACHE_COMMANDS = Arrays.asList("always", "never", "uri", "user", "params", "no-params", "timeout", "session", "schemes", "ports", CACHE_10_FALSE, "parse-error", CACHE_12_TRUE, "ip", "element", "locale", "encoding", "site", "attrs", "no-attrs", "device", "container-element");
    private static final String IS_USED = "/ /";
    private static final Log LOG = CmsLog.getLog(CmsFlexCacheKey.class);
    private int m_always;
    private Set<String> m_attrs;
    private String m_containerElement;
    private String m_device;
    private String m_element;
    private String m_encoding;
    private String m_ip;
    private String m_locale;
    private Set<String> m_noattrs;
    private Set<String> m_noparams;
    private Set<String> m_params;
    private boolean m_parseError;
    private Set<Integer> m_ports;
    private String m_resource;
    private Set<String> m_schemes;
    private Set<String> m_session;
    private String m_site;
    private long m_timeout;
    private String m_uri;
    private String m_user;
    private String m_variation;

    public CmsFlexCacheKey(String resourcename, String cacheDirectives, boolean online) {
        this.m_resource = CmsFlexCacheKey.getKeyName(resourcename, online);
        this.m_variation = CACHE_01_NEVER;
        this.m_always = -1;
        this.m_timeout = -1L;
        if (cacheDirectives != null) {
            this.parseFlexKey(cacheDirectives);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_GENERATED_1", this.toString()));
        }
    }

    public static String getKeyName(String resourcename, boolean online) {
        return resourcename.concat(online ? " [online]" : " [offline]");
    }

    private static void appendKeyValue(StringBuffer str, String key, String value) {
        str.append(key);
        if (value == IS_USED) {
            str.append(";");
        } else {
            str.append("=(");
            str.append(value);
            str.append(");");
        }
    }

    public boolean hadParseError() {
        return this.m_parseError;
    }

    public String matchRequestKey(CmsFlexRequestKey key) {
        Map.Entry entry;
        Iterator<Object> i;
        Object i2;
        StringBuffer str = new StringBuffer(100);
        if (this.m_always < 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_KEYMATCH_CACHE_NEVER_0"));
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_KEYMATCH_CHECK_NO_PARAMS_0"));
        }
        if (this.m_noparams != null && key.getParams() != null) {
            if (this.m_noparams.size() == 0 && key.getParams().size() > 0) {
                return null;
            }
            i2 = key.getParams().keySet().iterator();
            while (i2.hasNext()) {
                if (!this.m_noparams.contains(i2.next())) continue;
                return null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_KEYMATCH_CHECK_NO_ATTRS_0"));
        }
        if (this.m_noattrs != null && key.getAttributes() != null) {
            if (this.m_noattrs.size() == 0 && key.getAttributes().size() > 0) {
                return null;
            }
            i2 = key.getAttributes().keySet().iterator();
            while (i2.hasNext()) {
                if (!this.m_noattrs.contains(i2.next())) continue;
                return null;
            }
        }
        if (this.m_always > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_KEYMATCH_CACHE_ALWAYS_0"));
            }
            str.append(CACHE_00_ALWAYS);
            return str.toString();
        }
        if (this.m_uri != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_02_URI, key.getUri());
        }
        if (this.m_site != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_17_SITE, key.getSite());
        }
        if (this.m_element != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_14_ELEMENT, key.getElement());
        }
        if (this.m_device != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_20_DEVICE, key.getDevice());
        }
        if (this.m_containerElement != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_21_CONTAINER_ELEMENT, key.getContainerElement());
        }
        if (this.m_locale != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_15_LOCALE, key.getLocale());
        }
        if (this.m_encoding != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_16_ENCODING, key.getEncoding());
        }
        if (this.m_ip != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_13_IP, key.getIp());
        }
        if (this.m_user != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_03_USER, key.getUser());
        }
        if (this.m_params != null) {
            str.append(CACHE_04_PARAMS);
            str.append("=(");
            Map<String, String[]> keyParams = key.getParams();
            if (keyParams != null) {
                String[] values;
                if (this.m_params.size() > 0) {
                    i = this.m_params.iterator();
                    while (i.hasNext()) {
                        Object o = i.next();
                        if (!keyParams.containsKey(o)) continue;
                        str.append(o);
                        str.append("=");
                        values = keyParams.get(o);
                        str.append(values[0]);
                        if (!i.hasNext()) continue;
                        str.append(",");
                    }
                } else {
                    i = keyParams.entrySet().iterator();
                    while (i.hasNext()) {
                        entry = (Map.Entry)i.next();
                        str.append((String)entry.getKey());
                        str.append("=");
                        values = (String[])entry.getValue();
                        str.append(values[0]);
                        if (!i.hasNext()) continue;
                        str.append(",");
                    }
                }
            }
            str.append(");");
        }
        if (this.m_attrs != null) {
            str.append(CACHE_18_ATTRS);
            str.append("=(");
            Map<String, Object> keyAttrs = key.getAttributes();
            if (keyAttrs != null) {
                Object value;
                if (this.m_attrs.size() > 0) {
                    i = this.m_attrs.iterator();
                    while (i.hasNext()) {
                        String s = (String)i.next();
                        if (!keyAttrs.containsKey(s)) continue;
                        str.append(s);
                        str.append("=");
                        value = keyAttrs.get(s);
                        str.append(value);
                        if (!i.hasNext()) continue;
                        str.append(",");
                    }
                } else {
                    i = keyAttrs.entrySet().iterator();
                    while (i.hasNext()) {
                        entry = (Map.Entry)i.next();
                        str.append((String)entry.getKey());
                        str.append("=");
                        value = entry.getValue();
                        str.append(value);
                        if (!i.hasNext()) continue;
                        str.append(",");
                    }
                }
            }
            str.append(");");
        }
        if (this.m_session != null) {
            StringBuffer buf = new StringBuffer(32);
            boolean found = false;
            buf.append(CACHE_07_SESSION);
            buf.append("=(");
            HttpSession keySession = key.getSession();
            if (keySession != null) {
                Iterator<String> i3 = this.m_session.iterator();
                while (i3.hasNext()) {
                    String name = i3.next();
                    Object val = keySession.getAttribute(name);
                    if (val == null) continue;
                    found = true;
                    buf.append(name);
                    buf.append("=");
                    buf.append(val);
                    if (!i3.hasNext()) continue;
                    buf.append(",");
                }
            }
            if (found) {
                buf.append(");");
                str.append(buf);
            }
        }
        if (this.m_schemes != null) {
            String s = key.getScheme();
            if (this.m_schemes.size() > 0 && !this.m_schemes.contains(s)) {
                return null;
            }
            CmsFlexCacheKey.appendKeyValue(str, CACHE_08_SCHEMES, s);
        }
        if (this.m_ports != null) {
            i2 = key.getPort();
            if (this.m_ports.size() > 0 && !this.m_ports.contains(i2)) {
                return null;
            }
            str.append(CACHE_09_PORTS);
            str.append("=(");
            str.append(i2);
            str.append(");");
        }
        if (this.m_timeout > 0L) {
            str.append(CACHE_06_TIMEOUT);
            str.append("=(");
            str.append(this.m_timeout);
            str.append(");");
        }
        if (str.length() > 0) {
            return str.toString();
        }
        return null;
    }

    public String toString() {
        String s;
        String o;
        Iterator<Object> i;
        StringBuffer str = new StringBuffer(100);
        if (this.m_always < 0) {
            str.append(CACHE_01_NEVER);
            if (this.m_parseError) {
                str.append(";");
                str.append(CACHE_11_PARSE_ERROR);
            }
            return str.toString();
        }
        if (this.m_noparams != null) {
            str.append(CACHE_05_NO_PARAMS);
            if (this.m_noparams.size() == 0) {
                str.append(";");
            } else {
                str.append("=(");
                i = this.m_noparams.iterator();
                while (i.hasNext()) {
                    o = i.next();
                    str.append((Object)o);
                    if (!i.hasNext()) continue;
                    str.append(",");
                }
                str.append(");");
            }
        }
        if (this.m_noattrs != null) {
            str.append(CACHE_19_NO_ATTRS);
            if (this.m_noattrs.size() == 0) {
                str.append(";");
            } else {
                str.append("=(");
                i = this.m_noattrs.iterator();
                while (i.hasNext()) {
                    s = i.next();
                    str.append(s);
                    if (!i.hasNext()) continue;
                    str.append(",");
                }
                str.append(");");
            }
        }
        if (this.m_always > 0) {
            str.append(CACHE_00_ALWAYS);
            if (this.m_parseError) {
                str.append(";");
                str.append(CACHE_11_PARSE_ERROR);
            }
            return str.toString();
        }
        if (this.m_uri != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_02_URI, this.m_uri);
        }
        if (this.m_site != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_17_SITE, this.m_site);
        }
        if (this.m_element != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_14_ELEMENT, this.m_element);
        }
        if (this.m_device != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_20_DEVICE, this.m_device);
        }
        if (this.m_containerElement != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_21_CONTAINER_ELEMENT, this.m_containerElement);
        }
        if (this.m_locale != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_15_LOCALE, this.m_locale);
        }
        if (this.m_encoding != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_16_ENCODING, this.m_encoding);
        }
        if (this.m_ip != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_13_IP, this.m_ip);
        }
        if (this.m_user != null) {
            CmsFlexCacheKey.appendKeyValue(str, CACHE_03_USER, this.m_user);
        }
        if (this.m_params != null) {
            str.append(CACHE_04_PARAMS);
            if (this.m_params.size() == 0) {
                str.append(";");
            } else {
                str.append("=(");
                i = this.m_params.iterator();
                while (i.hasNext()) {
                    o = i.next();
                    if ("__element".equals(o)) continue;
                    str.append((Object)o);
                    if (!i.hasNext()) continue;
                    str.append(",");
                }
                str.append(");");
            }
        }
        if (this.m_attrs != null) {
            str.append(CACHE_18_ATTRS);
            if (this.m_attrs.size() == 0) {
                str.append(";");
            } else {
                str.append("=(");
                i = this.m_attrs.iterator();
                while (i.hasNext()) {
                    s = i.next();
                    str.append(s);
                    if (!i.hasNext()) continue;
                    str.append(",");
                }
                str.append(");");
            }
        }
        if (this.m_session != null) {
            str.append(CACHE_07_SESSION);
            str.append("=(");
            i = this.m_session.iterator();
            while (i.hasNext()) {
                o = i.next();
                str.append((Object)o);
                if (!i.hasNext()) continue;
                str.append(",");
            }
            str.append(");");
        }
        if (this.m_timeout >= 0L) {
            str.append(CACHE_06_TIMEOUT);
            str.append("=(");
            str.append(this.m_timeout);
            str.append(");");
        }
        if (this.m_schemes != null) {
            str.append(CACHE_08_SCHEMES);
            if (this.m_schemes.size() == 0) {
                str.append(";");
            } else {
                str.append("=(");
                i = this.m_schemes.iterator();
                while (i.hasNext()) {
                    str.append((String)i.next());
                    if (!i.hasNext()) continue;
                    str.append(",");
                }
                str.append(");");
            }
        }
        if (this.m_ports != null) {
            str.append(CACHE_09_PORTS);
            if (this.m_ports.size() == 0) {
                str.append(";");
            } else {
                str.append("=(");
                i = this.m_ports.iterator();
                while (i.hasNext()) {
                    str.append(i.next());
                    if (!i.hasNext()) continue;
                    str.append(",");
                }
                str.append(");");
            }
        }
        if (this.m_parseError) {
            str.append(CACHE_11_PARSE_ERROR);
        }
        return str.toString();
    }

    protected String getResource() {
        return this.m_resource;
    }

    protected long getTimeout() {
        return this.m_timeout;
    }

    protected String getVariation() {
        return this.m_variation;
    }

    protected void setVariation(String variation) {
        this.m_variation = variation;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseFlexKey(String key) {
        tokens = CmsStringUtil.splitAsList(key, ';', false);
        i = tokens.iterator();
lbl3:
        // 22 sources

        try {
            block26: while (i.hasNext()) {
                t = i.next();
                k = null;
                v = null;
                idx = t.indexOf(61);
                if (idx >= 0) {
                    k = t.substring(0, idx).trim();
                    if (t.length() > idx) {
                        v = t.substring(idx + 1).trim();
                    }
                } else {
                    k = t.trim();
                }
                this.m_always = 0;
                if (CmsFlexCacheKey.LOG.isDebugEnabled()) {
                    CmsFlexCacheKey.LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_PARSE_FLEXKEY_3", t, k, v));
                }
                switch (CmsFlexCacheKey.CACHE_COMMANDS.indexOf(k)) {
                    case 0: 
                    case 12: {
                        this.m_always = 1;
                        ** GOTO lbl3
                    }
                    case 1: 
                    case 10: {
                        this.m_always = -1;
                        return;
                    }
                    case 2: {
                        this.m_uri = "/ /";
                        ** GOTO lbl3
                    }
                    case 3: {
                        this.m_user = "/ /";
                        ** GOTO lbl3
                    }
                    case 4: {
                        this.m_params = v != null ? this.parseValueList(v) : Collections.emptySet();
                        if (!this.m_params.contains("__element")) continue block26;
                        this.m_element = "/ /";
                        this.m_params.remove("__element");
                        if (this.m_params.size() != 0) continue block26;
                        this.m_params = null;
                        ** GOTO lbl3
                    }
                    case 5: {
                        if (v == null) ** GOTO lbl44
                        this.m_noparams = this.parseValueList(v);
                        ** GOTO lbl3
lbl44:
                        // 1 sources

                        this.m_noparams = Collections.emptySet();
                        ** GOTO lbl3
                    }
                    case 6: {
                        this.m_timeout = Integer.parseInt(v);
                        ** GOTO lbl3
                    }
                    case 7: {
                        this.m_session = this.parseValueList(v);
                        if (this.m_session.size() > 0) continue block26;
                        this.m_parseError = true;
                        ** GOTO lbl3
                    }
                    case 8: {
                        this.m_schemes = this.parseValueList(v);
                        ** GOTO lbl3
                    }
                    case 9: {
                        ports = this.parseValueList(v);
                        this.m_ports = new HashSet<Integer>(ports.size());
                        for (String p : ports) {
                            try {
                                this.m_ports.add(Integer.valueOf(p));
                            }
                            catch (NumberFormatException var11_12) {}
                        }
                        continue block26;
                    }
                    case 11: {
                        ** GOTO lbl3
                    }
                    case 13: {
                        this.m_ip = "/ /";
                        ** GOTO lbl3
                    }
                    case 14: {
                        this.m_element = "/ /";
                        ** GOTO lbl3
                    }
                    case 15: {
                        this.m_locale = "/ /";
                        ** GOTO lbl3
                    }
                    case 16: {
                        this.m_encoding = "/ /";
                        ** GOTO lbl3
                    }
                    case 17: {
                        this.m_site = "/ /";
                        ** GOTO lbl3
                    }
                    case 18: {
                        if (v == null) ** GOTO lbl89
                        this.m_attrs = this.parseValueList(v);
                        ** GOTO lbl3
lbl89:
                        // 1 sources

                        this.m_attrs = null;
                        ** GOTO lbl3
                    }
                    case 19: {
                        if (v == null) ** GOTO lbl95
                        this.m_noattrs = this.parseValueList(v);
                        ** GOTO lbl3
lbl95:
                        // 1 sources

                        this.m_noattrs = Collections.emptySet();
                        ** GOTO lbl3
                    }
                    case 20: {
                        this.m_device = "/ /";
                        ** GOTO lbl3
                    }
                    case 21: {
                        this.m_containerElement = "/ /";
                        ** GOTO lbl3
                    }
                }
                this.m_parseError = true;
            }
        }
        catch (Exception e) {
            if (CmsFlexCacheKey.LOG.isErrorEnabled()) {
                CmsFlexCacheKey.LOG.error((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_PARSE_ERROR_1", e.toString()), (Throwable)e);
            }
            this.m_parseError = true;
        }
        if (this.m_parseError) {
            this.m_always = -1;
        }
    }

    private Set<String> parseValueList(String value) {
        int len;
        if (value.charAt(0) == '(') {
            value = value.substring(1);
        }
        if (value.charAt(len = value.length() - 1) == ')') {
            value = value.substring(0, len);
        }
        if (value.charAt(len - 1) == ',') {
            value = value.substring(0, len - 1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEKEY_PARSE_VALUES_1", value));
        }
        List<String> tokens = CmsStringUtil.splitAsList(value, ',', true);
        HashSet<String> result = new HashSet<String>();
        result.addAll(tokens);
        return result;
    }
}

