/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Buffer;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsClientUserSettingConverter;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.I_CmsFormValidator;
import org.opencms.gwt.I_CmsValidationService;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsBroadcastMessage;
import org.opencms.gwt.shared.CmsCategoryTreeEntry;
import org.opencms.gwt.shared.CmsContextMenuEntryBean;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.gwt.shared.CmsLockInfo;
import org.opencms.gwt.shared.CmsResourceCategoryInfo;
import org.opencms.gwt.shared.CmsReturnLinkInfo;
import org.opencms.gwt.shared.CmsUserSettingsBean;
import org.opencms.gwt.shared.CmsValidationQuery;
import org.opencms.gwt.shared.CmsValidationResult;
import org.opencms.gwt.shared.CmsWorkplaceLinkMode;
import org.opencms.gwt.shared.rpc.I_CmsCoreService;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.security.CmsPasswordInfo;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleManager;
import org.opencms.security.CmsSecurityException;
import org.opencms.site.CmsSite;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.dialogs.CmsEmbeddedDialogsUI;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsExplorerContextMenu;
import org.opencms.workplace.explorer.CmsExplorerContextMenuItem;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.explorer.menu.A_CmsMenuItemRule;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;
import org.opencms.workplace.explorer.menu.CmsMenuRule;
import org.opencms.workplace.explorer.menu.I_CmsMenuItemRule;
import org.opencms.xml.containerpage.CmsADESessionCache;

public class CmsCoreService
extends CmsGwtService
implements I_CmsCoreService {
    private static final String EDITOR_BACKLINK_URI = "/system/modules/org.opencms.gwt/editor-backlink.html";
    private static final String EDITOR_URI = "/system/workplace/editors/editor.jsp";
    private static final Log LOG = CmsLog.getLog(CmsCoreService.class);
    private static final long serialVersionUID = 5915848952948986278L;

    public static List<CmsCategoryTreeEntry> buildCategoryTree(CmsObject cms, List<CmsCategory> categories) {
        ArrayList<CmsCategoryTreeEntry> result = new ArrayList<CmsCategoryTreeEntry>();
        for (CmsCategory category : categories) {
            CmsCategoryTreeEntry current = new CmsCategoryTreeEntry(category);
            current.setSitePath(cms.getRequestContext().removeSiteRoot(category.getRootPath()));
            String parentPath = CmsResource.getParentFolder(current.getPath());
            CmsCategoryTreeEntry parent = null;
            parent = CmsCoreService.findCategory(result, parentPath);
            if (parent != null) {
                parent.addChild(current);
                continue;
            }
            result.add(current);
        }
        return result;
    }

    public static List<CmsCategoryTreeEntry> getCategoriesForSitePathStatic(CmsObject cms, String sitePath) throws CmsException {
        return CmsCoreService.getCategoriesForSitePathStatic(cms, sitePath, null);
    }

    public static List<CmsCategoryTreeEntry> getCategoriesForSitePathStatic(CmsObject cms, String sitePath, String localCategoryRepositoryPath) throws CmsException {
        List<CmsCategoryTreeEntry> result;
        CmsCategoryService catService = CmsCategoryService.getInstance();
        if (null == localCategoryRepositoryPath) {
            List<CmsCategory> categories = catService.readCategories(cms, "", true, sitePath);
            result = CmsCoreService.buildCategoryTree(cms, categories);
        } else {
            List<String> repositories = catService.getCategoryRepositories(cms, sitePath);
            repositories.remove(localCategoryRepositoryPath);
            List<CmsCategory> categories = catService.readCategoriesForRepositories(cms, "", true, repositories);
            result = CmsCoreService.buildCategoryTree(cms, categories);
            categories = catService.readCategoriesForRepositories(cms, "", true, Collections.singletonList(localCategoryRepositoryPath));
            List<CmsCategoryTreeEntry> localCategories = CmsCoreService.buildCategoryTree(cms, categories);
            result.addAll(localCategories);
        }
        return result;
    }

    public static List<CmsContextMenuEntryBean> getContextMenuEntries(CmsObject cms, CmsUUID structureId, CmsCoreData.AdeContext context) {
        List<CmsContextMenuEntryBean> result;
        block5: {
            result = Collections.emptyList();
            try {
                String[] lookupTypes;
                CmsResourceUtil[] resUtil;
                CmsResource resource;
                if (context != null) {
                    cms.getRequestContext().setAttribute("__contextInfo", context.toString());
                }
                if (!CmsCoreService.hasViewPermissions(cms, resource = (resUtil = new CmsResourceUtil[]{new CmsResourceUtil(cms, cms.readResource(structureId, CmsResourceFilter.ALL))})[0].getResource())) break block5;
                String fallbackType = resource.isFolder() ? CmsResourceTypeFolder.getStaticTypeName() : CmsResourceTypePlain.getStaticTypeName();
                for (String currentType : lookupTypes = new String[]{resUtil[0].getResourceTypeName(), fallbackType}) {
                    CmsExplorerContextMenu contextMenu;
                    List<CmsContextMenuEntryBean> allEntries;
                    CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(currentType);
                    if (settings == null || (result = CmsCoreService.filterEntries(allEntries = CmsCoreService.transformToMenuEntries(cms, (contextMenu = settings.getContextMenu()).getAllEntries(), resUtil))).isEmpty()) {
                        continue;
                    }
                    break;
                }
            }
            catch (CmsException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static String getFileExplorerLink(CmsObject cms, String siteRoot) {
        return CmsVaadinUtils.getWorkplaceLink() + "#!" + "explorer" + "/" + cms.getRequestContext().getCurrentProject().getUuid() + "!!" + siteRoot + "!!";
    }

    public static String getVaadinWorkplaceLink(CmsObject cms, CmsUUID structureId) {
        String resourceRootFolder = null;
        if (structureId != null) {
            try {
                resourceRootFolder = CmsResource.getFolderPath(cms.readResource(structureId).getRootPath());
            }
            catch (CmsException e) {
                LOG.debug((Object)"Error reading resource for workplace link.", (Throwable)e);
            }
        }
        if (resourceRootFolder == null) {
            resourceRootFolder = cms.getRequestContext().getSiteRoot();
        }
        return CmsCoreService.getVaadinWorkplaceLink(cms, resourceRootFolder);
    }

    public static String getVaadinWorkplaceLink(CmsObject cms, String resourceRootFolder) {
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(resourceRootFolder);
        String siteRoot = site != null ? site.getSiteRoot() : (OpenCms.getSiteManager().startsWithShared(resourceRootFolder) ? OpenCms.getSiteManager().getSharedFolder() : "");
        String link = CmsCoreService.getFileExplorerLink(cms, siteRoot) + cms.getRequestContext().removeSiteRoot(resourceRootFolder);
        return link;
    }

    public static I_CmsValidationService getValidationService(String name) throws CmsException {
        try {
            Class<?> cls = Class.forName(name, false, I_CmsValidationService.class.getClassLoader());
            if (!I_CmsValidationService.class.isAssignableFrom(cls)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_VALIDATOR_INCORRECT_TYPE_1", name));
            }
            return (I_CmsValidationService)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CmsException(Messages.get().container("ERR_VALIDATOR_INSTANTIATION_FAILED_1", name), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CmsException(Messages.get().container("ERR_VALIDATOR_INSTANTIATION_FAILED_1", name), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CmsException(Messages.get().container("ERR_VALIDATOR_INSTANTIATION_FAILED_1", name), (Throwable)e);
        }
    }

    public static <T> T instantiate(Class<T> anInterface, String className) throws CmsException {
        try {
            Class<?> cls = Class.forName(className, false, anInterface.getClassLoader());
            if (!anInterface.isAssignableFrom(cls)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_INSTANTIATION_INCORRECT_TYPE_2", className, anInterface.getName()));
            }
            Class<?> typedClass = cls;
            return (T)typedClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CmsException(Messages.get().container("ERR_INSTANTIATION_FAILED_1", className), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CmsException(Messages.get().container("ERR_INSTANTIATION_FAILED_1", className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CmsException(Messages.get().container("ERR_INSTANTIATION_FAILED_1", className), (Throwable)e);
        }
    }

    public static CmsReturnLinkInfo internalGetLinkForReturnCode(CmsObject cms, String returnCode) throws CmsException {
        if (CmsUUID.isValidUUID(returnCode)) {
            try {
                CmsResource pageRes = cms.readResource(new CmsUUID(returnCode), CmsResourceFilter.IGNORE_EXPIRATION);
                return new CmsReturnLinkInfo(OpenCms.getLinkManager().substituteLink(cms, pageRes), CmsReturnLinkInfo.Status.ok);
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                return new CmsReturnLinkInfo(null, CmsReturnLinkInfo.Status.notfound);
            }
        }
        int colonIndex = returnCode.indexOf(58);
        if (colonIndex >= 0) {
            String before = returnCode.substring(0, colonIndex);
            String after = returnCode.substring(colonIndex + 1);
            if (CmsUUID.isValidUUID(before) && CmsUUID.isValidUUID(after)) {
                try {
                    CmsUUID pageId = new CmsUUID(before);
                    CmsUUID detailId = new CmsUUID(after);
                    CmsResource pageRes = cms.readResource(pageId);
                    CmsResource folder = pageRes.isFolder() ? pageRes : cms.readParentFolder(pageRes.getStructureId());
                    String pageLink = OpenCms.getLinkManager().substituteLink(cms, folder);
                    CmsResource detailRes = cms.readResource(detailId);
                    String detailName = cms.getDetailName(detailRes, cms.getRequestContext().getLocale(), OpenCms.getLocaleManager().getDefaultLocales());
                    String link = CmsFileUtil.removeTrailingSeparator(pageLink) + "/" + detailName;
                    return new CmsReturnLinkInfo(link, CmsReturnLinkInfo.Status.ok);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    return new CmsReturnLinkInfo(null, CmsReturnLinkInfo.Status.notfound);
                }
            }
        }
        throw new IllegalArgumentException("return code has wrong format");
    }

    public static CmsCoreData prefetch(HttpServletRequest request) {
        CmsCoreService srv = new CmsCoreService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsCoreData result = null;
        try {
            result = srv.prefetch();
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    private static List<CmsContextMenuEntryBean> filterEntries(List<CmsContextMenuEntryBean> allEntries) {
        ArrayList<CmsContextMenuEntryBean> result = new ArrayList<CmsContextMenuEntryBean>();
        CmsContextMenuEntryBean lastBean = null;
        for (CmsContextMenuEntryBean entry : allEntries) {
            if (!entry.isVisible()) continue;
            if (entry.isSeparator()) {
                if (!result.isEmpty() && lastBean != null && !lastBean.isSeparator()) {
                    result.add(entry);
                }
            } else if (entry.getSubMenu() != null && !entry.getSubMenu().isEmpty()) {
                entry.setSubMenu(CmsCoreService.filterEntries(entry.getSubMenu()));
                result.add(entry);
            } else {
                result.add(entry);
            }
            lastBean = entry;
        }
        if (result.size() > 1 && ((CmsContextMenuEntryBean)result.get(result.size() - 1)).isSeparator()) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    private static CmsCategoryTreeEntry findCategory(List<CmsCategoryTreeEntry> tree, String path) {
        if (path == null) {
            return null;
        }
        List<CmsCategoryTreeEntry> children = tree;
        boolean found = true;
        block0: while (found) {
            if (children == null) {
                return null;
            }
            found = false;
            for (int i = children.size() - 1; i >= 0; --i) {
                CmsCategoryTreeEntry child = children.get(i);
                if (path.equals(child.getPath())) {
                    return child;
                }
                if (!path.startsWith(child.getPath())) continue;
                children = child.getChildren();
                found = true;
                continue block0;
            }
        }
        return null;
    }

    private static void getSubItemRules(CmsObject cms, CmsExplorerContextMenuItem item, List<I_CmsMenuItemRule> itemRules, CmsResourceUtil[] resourceUtil) {
        for (CmsExplorerContextMenuItem subItem : item.getSubItems()) {
            I_CmsMenuItemRule rule;
            if (subItem.isParentItem()) {
                CmsCoreService.getSubItemRules(cms, subItem, itemRules, resourceUtil);
                continue;
            }
            if (!"entry".equals(subItem.getType())) continue;
            String subItemRuleName = subItem.getRule();
            CmsMenuRule subItemRule = OpenCms.getWorkplaceManager().getMenuRule(subItemRuleName);
            if (subItemRule == null || (rule = subItemRule.getMatchingRule(cms, resourceUtil)) == null) continue;
            itemRules.add(rule);
        }
    }

    private static boolean hasViewPermissions(CmsObject cms, CmsResource resource) {
        try {
            return cms.hasPermissions(resource, CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.ALL);
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private static List<CmsContextMenuEntryBean> transformToMenuEntries(CmsObject cms, List<CmsExplorerContextMenuItem> items, CmsResourceUtil[] resUtil) {
        ArrayList<CmsContextMenuEntryBean> result = new ArrayList<CmsContextMenuEntryBean>();
        CmsWorkplaceManager wpManager = OpenCms.getWorkplaceManager();
        CmsWorkplaceMessages messages = wpManager.getMessages(wpManager.getWorkplaceLocale(cms));
        for (CmsExplorerContextMenuItem item : items) {
            CmsContextMenuEntryBean bean = new CmsContextMenuEntryBean();
            if (!"sep".equals(item.getType())) {
                I_CmsMenuItemRule itemRule;
                CmsMenuRule rule;
                if (item.getKey() != null) {
                    bean.setLabel(messages.key(item.getKey()));
                }
                CmsMenuItemVisibilityMode mode = CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                String itemRuleName = item.getRule();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(itemRuleName) && (rule = wpManager.getMenuRule(itemRuleName)) != null && (itemRule = rule.getMatchingRule(cms, resUtil)) != null) {
                    if (item.isParentItem()) {
                        ArrayList<I_CmsMenuItemRule> itemRules = new ArrayList<I_CmsMenuItemRule>(item.getSubItems().size());
                        CmsCoreService.getSubItemRules(cms, item, itemRules, resUtil);
                        I_CmsMenuItemRule[] itemRulesArray = new I_CmsMenuItemRule[itemRules.size()];
                        mode = itemRule.getVisibility(cms, resUtil, itemRules.toArray(itemRulesArray));
                    } else {
                        mode = itemRule instanceof A_CmsMenuItemRule ? ((A_CmsMenuItemRule)itemRule).getVisibility(cms, resUtil, item) : itemRule.getVisibility(cms, resUtil);
                    }
                }
                bean.setVisible(!mode.isInVisible());
                if (item.isParentItem()) {
                    bean.setActive(true);
                } else {
                    bean.setActive(mode.isActive());
                    if (CmsStringUtil.isNotEmpty(mode.getMessageKey())) {
                        bean.setReason(messages.key(CmsEncoder.escapeXml(mode.getMessageKey())));
                    }
                }
                String jspPath = item.getUri();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(jspPath)) {
                    jspPath = item.getUri().startsWith("/") ? OpenCms.getLinkManager().substituteLink(cms, item.getUri()) : OpenCms.getLinkManager().substituteLink(cms, "/system/workplace/" + item.getUri());
                }
                bean.setJspPath(jspPath);
                String params = item.getParams();
                if (params != null) {
                    params = CmsVfsService.prepareFileNameForEditor(cms, resUtil[0].getResource(), params);
                    bean.setParams(CmsStringUtil.splitAsMap(params, "|", "="));
                }
                bean.setName(item.getName());
            }
            if (item.isParentItem()) {
                bean.setSubMenu(CmsCoreService.transformToMenuEntries(cms, item.getSubItems(), resUtil));
            }
            if ("sep".equals(item.getType())) {
                bean.setVisible(true);
                bean.setSeparator(true);
            }
            result.add(bean);
        }
        return result;
    }

    @Override
    public String changePassword(String oldPassword, String newPassword, String newPasswordConfirm) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsPasswordInfo passwordBean = new CmsPasswordInfo(cms);
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        try {
            passwordBean.setCurrentPwd(oldPassword);
            passwordBean.setNewPwd(newPassword);
            passwordBean.setConfirmation(newPasswordConfirm);
            passwordBean.applyChanges();
            return null;
        }
        catch (CmsSecurityException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return e.getMessageContainer().key(wpLocale);
        }
        catch (CmsIllegalArgumentException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return e.getMessageContainer().key(wpLocale);
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsUUID createUUID() {
        return new CmsUUID();
    }

    @Override
    public List<CmsBroadcastMessage> getBroadcast() {
        OpenCms.getWorkplaceManager().checkWorkplaceRequest(this.getRequest(), this.getCmsObject());
        CmsSessionInfo sessionInfo = OpenCms.getSessionManager().getSessionInfo(this.getRequest().getSession());
        if (sessionInfo == null) {
            return null;
        }
        String sessionId = sessionInfo.getSessionId().toString();
        Buffer messageQueue = OpenCms.getSessionManager().getBroadcastQueue(sessionId);
        if (!messageQueue.isEmpty()) {
            CmsMessages messages = org.opencms.workplace.Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject()));
            ArrayList<CmsBroadcastMessage> result = new ArrayList<CmsBroadcastMessage>();
            while (!messageQueue.isEmpty()) {
                CmsBroadcast broadcastMessage = (CmsBroadcast)messageQueue.remove();
                CmsBroadcastMessage message = new CmsBroadcastMessage(broadcastMessage.getUser() != null ? broadcastMessage.getUser().getName() : messages.key("GUI_LABEL_BROADCAST_FROM_SYSTEM_0"), messages.getDateTime(broadcastMessage.getSendTime()), broadcastMessage.getMessage());
                result.add(message);
            }
            return result;
        }
        return null;
    }

    @Override
    public List<CmsCategoryTreeEntry> getCategories(String fromPath, boolean includeSubCats, List<String> refPaths) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCategoryService catService = CmsCategoryService.getInstance();
        ArrayList<String> repositories = new ArrayList<String>();
        if (refPaths != null && !refPaths.isEmpty()) {
            for (String refPath : refPaths) {
                repositories.addAll(catService.getCategoryRepositories(this.getCmsObject(), refPath));
            }
        } else {
            repositories.add("/system/categories/");
        }
        List<CmsCategoryTreeEntry> result = null;
        try {
            List<CmsCategory> categories = catService.readCategoriesForRepositories(cms, fromPath, includeSubCats, repositories);
            result = CmsCoreService.buildCategoryTree(cms, categories);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsCategoryTreeEntry> getCategoriesForSitePath(String sitePath) throws CmsRpcException {
        List<CmsCategoryTreeEntry> result = null;
        CmsObject cms = this.getCmsObject();
        try {
            result = CmsCoreService.getCategoriesForSitePathStatic(cms, sitePath);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsResourceCategoryInfo getCategoryInfo(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCategoryService catService = CmsCategoryService.getInstance();
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ignoreExpirationOffline(cms));
            List<CmsCategory> categories = catService.readResourceCategories(cms, resource);
            ArrayList<String> currentCategories = new ArrayList<String>();
            for (CmsCategory category : categories) {
                currentCategories.add(category.getPath());
            }
            return new CmsResourceCategoryInfo(structureId, CmsVfsService.getPageInfoWithLock(cms, resource), currentCategories, this.getCategories(null, true, Collections.singletonList(cms.getSitePath(resource))));
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsContextMenuEntryBean> getContextMenuEntries(CmsUUID structureId, CmsCoreData.AdeContext context) throws CmsRpcException {
        List<CmsContextMenuEntryBean> result = null;
        try {
            result = CmsCoreService.getContextMenuEntries(this.getCmsObject(), structureId, context);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsReturnLinkInfo getLinkForReturnCode(String returnCode) throws CmsRpcException {
        try {
            return CmsCoreService.internalGetLinkForReturnCode(this.getCmsObject(), returnCode);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsResourceState getResourceState(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsResourceState result = null;
        try {
            try {
                CmsResource res = cms.readResource(structureId);
                result = res.getState();
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                result = CmsResourceState.STATE_DELETED;
            }
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public String getUniqueFileName(String parentFolder, String baseName) {
        return OpenCms.getResourceManager().getNameGenerator().getUniqueFileName(this.getCmsObject(), parentFolder, baseName);
    }

    @Override
    public CmsCoreData.UserInfo getUserInfo() {
        CmsObject cms = this.getCmsObject();
        CmsRoleManager roleManager = OpenCms.getRoleManager();
        boolean isAdmin = roleManager.hasRole(cms, CmsRole.ADMINISTRATOR);
        boolean isDeveloper = roleManager.hasRole(cms, CmsRole.DEVELOPER);
        boolean isCategoryManager = roleManager.hasRole(cms, CmsRole.CATEGORY_EDITOR);
        boolean isWorkplaceUser = roleManager.hasRole(cms, CmsRole.WORKPLACE_USER);
        CmsCoreData.UserInfo userInfo = new CmsCoreData.UserInfo(cms.getRequestContext().getCurrentUser().getName(), OpenCms.getWorkplaceAppManager().getUserIconHelper().getSmallIconPath(cms, cms.getRequestContext().getCurrentUser()), isAdmin, isDeveloper, isCategoryManager, isWorkplaceUser, cms.getRequestContext().getCurrentUser().isManaged());
        return userInfo;
    }

    @Override
    public String getWorkplaceLink(CmsUUID structureId, CmsWorkplaceLinkMode linkMode) throws CmsRpcException {
        String result = null;
        CmsObject cms = this.getCmsObject();
        try {
            String resourceRootFolder = structureId != null ? CmsResource.getFolderPath(cms.readResource(structureId).getRootPath()) : cms.getRequestContext().getSiteRoot();
            switch (linkMode) {
                case oldWorkplace: {
                    result = CmsWorkplace.getWorkplaceExplorerLink(cms, resourceRootFolder);
                    break;
                }
                case newWorkplace: {
                    result = CmsCoreService.getVaadinWorkplaceLink(cms, resourceRootFolder);
                    break;
                }
                default: {
                    boolean newWp = CmsWorkplace.getWorkplaceSettings(cms, this.getRequest()).getUserSettings().usesNewWorkplace();
                    result = this.getWorkplaceLink(structureId, newWp ? CmsWorkplaceLinkMode.newWorkplace : CmsWorkplaceLinkMode.oldWorkplace);
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsUserSettingsBean loadUserSettings() throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsClientUserSettingConverter converter = new CmsClientUserSettingConverter(cms, this.getRequest(), this.getResponse());
        try {
            return converter.loadSettings();
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public String lockIfExists(String sitePath) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        String errorMessage = null;
        try {
            if (cms.existsResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION)) {
                try {
                    this.ensureLock(cms.readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION));
                }
                catch (CmsException e) {
                    errorMessage = e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
                }
            } else {
                String parentFolder = CmsResource.getParentFolder(sitePath);
                while (parentFolder != null && !cms.existsResource(parentFolder, CmsResourceFilter.IGNORE_EXPIRATION)) {
                    parentFolder = CmsResource.getParentFolder(parentFolder);
                }
                if (parentFolder != null) {
                    CmsResource ancestorFolder = cms.readResource(parentFolder, CmsResourceFilter.IGNORE_EXPIRATION);
                    CmsUser user = cms.getRequestContext().getCurrentUser();
                    CmsLock lock = cms.getLock(ancestorFolder);
                    if (!lock.isLockableBy(user)) {
                        errorMessage = "Can not lock parent folder '" + parentFolder + "'.";
                    }
                } else {
                    errorMessage = "Can not access any parent folder.";
                }
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return errorMessage;
    }

    @Override
    public String lockTemp(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            try {
                this.ensureLock(structureId);
            }
            catch (CmsException e) {
                return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return null;
    }

    @Override
    public CmsLockInfo lockTempAndCheckModification(CmsUUID structureId, long modification) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            if (resource.getDateLastModified() != modification) {
                CmsUser user = cms.readUser(resource.getUserLastModified());
                return CmsLockInfo.forChangedResource(user.getFullName());
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        try {
            return this.getLock(structureId);
        }
        catch (CmsException e) {
            return CmsLockInfo.forError(e.getLocalizedMessage());
        }
    }

    @Override
    public void ping() {
    }

    @Override
    public CmsCoreData prefetch() {
        CmsObject cms = this.getCmsObject();
        String navigationUri = cms.getRequestContext().getUri();
        boolean toolbarVisible = CmsADESessionCache.getCache(this.getRequest(), this.getCmsObject()).isToolbarVisible();
        boolean isShowHelp = OpenCms.getADEManager().isShowEditorHelp(cms);
        CmsUUID structureId = null;
        try {
            CmsResource requestedResource = cms.readResource(cms.getRequestContext().getUri());
            structureId = requestedResource.getStructureId();
        }
        catch (CmsException e) {
            LOG.debug((Object)"Could not read resource for URI.", (Throwable)e);
            structureId = CmsUUID.getNullUUID();
        }
        String loginUrl = "/system/login/index.html";
        try {
            loginUrl = cms.readPropertyObject(cms.getRequestContext().getUri(), "login-form", true).getValue(loginUrl);
        }
        catch (CmsException e) {
            this.log(e.getLocalizedMessage(), e);
        }
        String defaultWorkplaceLink = CmsWorkplace.getWorkplaceExplorerLink(cms, cms.getRequestContext().getSiteRoot());
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsCoreData.UserInfo userInfo = this.getUserInfo();
        String aboutLink = OpenCms.getLinkManager().substituteLink(this.getCmsObject(), "/system/modules/org.opencms.gwt/about.jsp");
        CmsCoreData data = new CmsCoreData(EDITOR_URI, EDITOR_BACKLINK_URI, loginUrl, OpenCms.getStaticExportManager().getVfsPrefix(), CmsCoreService.getFileExplorerLink(cms, cms.getRequestContext().getSiteRoot()), OpenCms.getSystemInfo().getStaticResourceContext(), CmsEmbeddedDialogsUI.getEmbeddedDialogsContextPath(), cms.getRequestContext().getSiteRoot(), cms.getRequestContext().getLocale().toString(), wpLocale.toString(), cms.getRequestContext().getUri(), navigationUri, structureId, new HashMap<String, String>(OpenCms.getResourceManager().getExtensionMapping()), System.currentTimeMillis(), isShowHelp, toolbarVisible, defaultWorkplaceLink, aboutLink, userInfo, OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(this.getCmsObject()), OpenCms.getWorkplaceManager().isKeepAlive(), OpenCms.getADEManager().getParameters(this.getCmsObject()));
        return data;
    }

    @Override
    public void saveUserSettings(Map<String, String> userSettings, Set<String> edited) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsClientUserSettingConverter converter = new CmsClientUserSettingConverter(cms, this.getRequest(), this.getResponse());
            userSettings.keySet().retainAll(edited);
            converter.saveSettings(userSettings);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void setResourceCategories(CmsUUID structureId, List<String> categories) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCategoryService catService = CmsCategoryService.getInstance();
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            this.ensureLock(resource);
            String sitePath = cms.getSitePath(resource);
            List<CmsCategory> previousCategories = catService.readResourceCategories(cms, resource);
            for (CmsCategory category : previousCategories) {
                if (categories.contains(category.getPath())) {
                    categories.remove(category.getPath());
                    continue;
                }
                catService.removeResourceFromCategory(cms, sitePath, category);
            }
            for (String path : categories) {
                catService.addResourceToCategory(cms, sitePath, path);
            }
            this.tryUnlock(resource);
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    @Override
    public void setShowEditorHelp(boolean visible) throws CmsRpcException {
        try {
            OpenCms.getADEManager().setShowEditorHelp(this.getCmsObject(), visible);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void setToolbarVisible(boolean visible) throws CmsRpcException {
        try {
            this.ensureSession();
            CmsADESessionCache.getCache(this.getRequest(), this.getCmsObject()).setToolbarVisible(visible);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public String unlock(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            this.tryUnlock(resource);
        }
        catch (CmsException e) {
            return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return null;
    }

    @Override
    public String unlock(String sitePath) throws CmsRpcException {
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            if (cms.existsResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION)) {
                CmsResource resource = cms.readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
                this.tryUnlock(resource);
            }
        }
        catch (CmsException e) {
            return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject()));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return null;
    }

    @Override
    public Map<String, CmsValidationResult> validate(Map<String, CmsValidationQuery> validationQueries) throws CmsRpcException {
        try {
            HashMap<String, CmsValidationResult> result = new HashMap<String, CmsValidationResult>();
            for (Map.Entry<String, CmsValidationQuery> queryEntry : validationQueries.entrySet()) {
                String fieldName = queryEntry.getKey();
                CmsValidationQuery query = queryEntry.getValue();
                result.put(fieldName, this.validate(query.getValidatorId(), query.getValue(), query.getConfig()));
            }
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public Map<String, CmsValidationResult> validate(String formValidatorClass, Map<String, CmsValidationQuery> validationQueries, Map<String, String> values, String config) throws CmsRpcException {
        try {
            I_CmsFormValidator formValidator = CmsCoreService.instantiate(I_CmsFormValidator.class, formValidatorClass);
            return formValidator.validate(this.getCmsObject(), validationQueries, values, config);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    protected Map<String, String> getBuildIds() {
        List<CmsModule> modules = OpenCms.getModuleManager().getAllInstalledModules();
        HashMap<String, String> result = new HashMap<String, String>();
        for (CmsModule module : modules) {
            String buildid = module.getParameter("gwt.buildid");
            if (buildid == null) continue;
            result.put(module.getName(), buildid);
        }
        return result;
    }

    protected CmsLockInfo getLock(CmsUUID structureId) throws CmsException {
        CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.getLock(this.getCmsObject().getSitePath(res));
    }

    protected CmsLockInfo getLock(String sitepath) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsLock lock = cms.getLock(sitepath);
        if (lock.isOwnedBy(user)) {
            return CmsLockInfo.forSuccess();
        }
        if (lock.getUserId().isNullUUID()) {
            cms.lockResourceTemporary(sitepath);
            return CmsLockInfo.forSuccess();
        }
        CmsUser owner = cms.readUser(lock.getUserId());
        return CmsLockInfo.forLockedResource(owner.getName());
    }

    private CmsValidationResult validate(String validator, String value, String config) throws Exception {
        I_CmsValidationService validationService = CmsCoreService.getValidationService(validator);
        return validationService.validate(this.getCmsObject(), value, config);
    }
}

