/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.gwt.CmsTemplateFinder;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.gwt.shared.property.CmsPropertiesBean;
import org.opencms.gwt.shared.property.CmsPropertyChangeSet;
import org.opencms.gwt.shared.property.CmsPropertyModification;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsPropertyEditorHelper {
    private CmsObject m_cms;
    private CmsUUID m_overrideStructureId;

    public CmsPropertyEditorHelper(CmsObject cms) {
        this.m_cms = cms;
    }

    public Map<CmsUUID, Map<String, CmsXmlContentProperty>> getDefaultProperties(List<CmsUUID> structureIds) throws CmsException {
        CmsObject cms = this.m_cms;
        HashMap result = Maps.newHashMap();
        for (CmsUUID structureId : structureIds) {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL);
            String typeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
            Map<String, CmsXmlContentProperty> propertyConfig = this.getDefaultPropertiesForType(typeName);
            result.put(structureId, propertyConfig);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPropertiesBean loadPropertyData(CmsUUID id) throws CmsException {
        CmsObject cms = this.m_cms;
        String originalSiteRoot = cms.getRequestContext().getSiteRoot();
        CmsPropertiesBean result = new CmsPropertiesBean();
        CmsResource resource = cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
        result.setReadOnly(!this.isWritable(cms, resource));
        result.setFolder(resource.isFolder());
        result.setContainerPage(CmsResourceTypeXmlContainerPage.isContainerPage(resource));
        String sitePath = cms.getSitePath(resource);
        Map<String, CmsXmlContentProperty> propertyConfig = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath()).getPropertyConfigurationAsMap();
        Map<String, CmsXmlContentProperty> defaultProperties = this.getDefaultProperties(Collections.singletonList(resource.getStructureId())).get(resource.getStructureId());
        LinkedHashMap<String, CmsXmlContentProperty> mergedConfig = new LinkedHashMap<String, CmsXmlContentProperty>();
        mergedConfig.putAll(defaultProperties);
        mergedConfig.putAll(propertyConfig);
        propertyConfig = mergedConfig;
        propertyConfig = CmsXmlContentPropertyHelper.resolveMacrosInProperties(propertyConfig, CmsMacroResolver.newWorkplaceLocaleResolver(cms));
        result.setPropertyDefinitions(new LinkedHashMap<String, CmsXmlContentProperty>(propertyConfig));
        try {
            cms.getRequestContext().setSiteRoot("");
            String parentPath = CmsResource.getParentFolder(resource.getRootPath());
            CmsResource parent = cms.readResource(parentPath, CmsResourceFilter.IGNORE_EXPIRATION);
            List<CmsProperty> parentProperties = cms.readPropertyObjects(parent, true);
            List<CmsProperty> ownProperties = cms.readPropertyObjects(resource, false);
            result.setOwnProperties(this.convertProperties(ownProperties));
            result.setInheritedProperties(this.convertProperties(parentProperties));
            result.setPageInfo(CmsVfsService.getPageInfo(cms, resource));
            List<CmsPropertyDefinition> propDefs = cms.readAllPropertyDefinitions();
            ArrayList<String> propNames = new ArrayList<String>();
            for (CmsPropertyDefinition propDef : propDefs) {
                propNames.add(propDef.getName());
            }
            CmsTemplateFinder templateFinder = new CmsTemplateFinder(cms);
            result.setTemplates(templateFinder.getTemplates());
            result.setAllProperties(propNames);
            result.setStructureId(id);
            result.setSitePath(sitePath);
            CmsPropertiesBean cmsPropertiesBean = result;
            return cmsPropertiesBean;
        }
        finally {
            cms.getRequestContext().setSiteRoot(originalSiteRoot);
        }
    }

    public void overrideStructureId(CmsUUID structureId) {
        this.m_overrideStructureId = structureId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties(CmsPropertyChangeSet changes) throws CmsException {
        CmsObject cms = this.m_cms;
        CmsUUID structureId = changes.getTargetStructureId();
        if (this.m_overrideStructureId != null) {
            structureId = this.m_overrideStructureId;
        }
        CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsLockActionRecord actionRecord = CmsLockUtil.ensureLock(cms, resource);
        try {
            Map<String, CmsProperty> ownProps = this.getPropertiesByName(cms.readPropertyObjects(resource, false));
            boolean changeOwnTitle = this.shouldChangeTitle(ownProps);
            String hasNavTextChange = null;
            ArrayList<CmsProperty> ownPropertyChanges = new ArrayList<CmsProperty>();
            for (CmsPropertyModification propMod : changes.getChanges()) {
                if (propMod.isFileNameProperty()) {
                    if (this.m_overrideStructureId == null && !resource.getStructureId().equals(propMod.getId()) && propMod.getId() != null) {
                        throw new IllegalStateException("Invalid structure id in property changes.");
                    }
                    CmsResource.checkResourceName(propMod.getValue());
                    String oldSitePath = CmsFileUtil.removeTrailingSeparator(cms.getSitePath(resource));
                    String parentPath = CmsResource.getParentFolder(oldSitePath);
                    String newSitePath = CmsFileUtil.removeTrailingSeparator(CmsStringUtil.joinPaths(parentPath, propMod.getValue()));
                    if (!oldSitePath.equals(newSitePath)) {
                        cms.moveResource(oldSitePath, newSitePath);
                    }
                    resource = cms.readResource(resource.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
                    continue;
                }
                CmsProperty propToModify = null;
                if (this.m_overrideStructureId != null || resource.getStructureId().equals(propMod.getId())) {
                    if ("NavText".equals(propMod.getName())) {
                        hasNavTextChange = propMod.getValue();
                    } else if ("Title".equals(propMod.getName())) {
                        changeOwnTitle = false;
                    }
                    propToModify = ownProps.get(propMod.getName());
                    if (propToModify == null) {
                        propToModify = new CmsProperty(propMod.getName(), null, null);
                    }
                } else {
                    throw new IllegalStateException("Invalid structure id in property changes!");
                }
                ownPropertyChanges.add(propToModify);
                String newValue = propMod.getValue();
                if (newValue == null) {
                    newValue = "";
                }
                if (propMod.isStructureValue()) {
                    propToModify.setStructureValue(newValue);
                    continue;
                }
                propToModify.setResourceValue(newValue);
            }
            if (hasNavTextChange != null && changeOwnTitle) {
                CmsProperty titleProp = ownProps.get("Title");
                if (titleProp == null) {
                    titleProp = new CmsProperty("Title", null, null);
                }
                titleProp.setStructureValue(hasNavTextChange);
                ownPropertyChanges.add(titleProp);
            }
            if (!ownPropertyChanges.isEmpty()) {
                cms.writePropertyObjects(resource, ownPropertyChanges);
            }
        }
        finally {
            if (actionRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
                cms.unlockResource(resource);
            }
        }
    }

    protected Map<String, CmsClientProperty> convertProperties(List<CmsProperty> properties) {
        HashMap<String, CmsClientProperty> result = new HashMap<String, CmsClientProperty>();
        for (CmsProperty prop : properties) {
            CmsClientProperty clientProp = new CmsClientProperty(prop.getName(), prop.getStructureValue(), prop.getResourceValue());
            clientProp.setOrigin(prop.getOrigin());
            result.put(clientProp.getName(), clientProp);
        }
        return result;
    }

    protected Map<String, CmsXmlContentProperty> getDefaultPropertiesForType(String typeName) {
        LinkedHashMap<String, CmsXmlContentProperty> propertyConfig = new LinkedHashMap<String, CmsXmlContentProperty>();
        CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
        if (explorerType != null) {
            List<String> defaultProps = explorerType.getProperties();
            for (String propName : defaultProps) {
                CmsXmlContentProperty property = new CmsXmlContentProperty(propName, "string", "string", "", "", "", "", null, "", "", "false");
                propertyConfig.put(propName, property);
            }
        }
        return propertyConfig;
    }

    protected Map<String, CmsProperty> getPropertiesByName(List<CmsProperty> properties) {
        HashMap<String, CmsProperty> result = new HashMap<String, CmsProperty>();
        for (CmsProperty property : properties) {
            String key = property.getName();
            result.put(key, property.clone());
        }
        return result;
    }

    protected boolean isWritable(CmsObject cms, CmsResource resource) throws CmsException {
        boolean writable = cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
        if (writable) {
            CmsLock lock = cms.getLock(resource);
            boolean bl = writable = lock.isUnlocked() || lock.isOwnedBy(cms.getRequestContext().getCurrentUser());
            if (writable) {
                CmsResourceUtil resUtil = new CmsResourceUtil(cms, resource);
                writable = resUtil.isInsideProject() && !resUtil.getProjectState().isLockedForPublishing();
            }
        }
        return writable;
    }

    private boolean shouldChangeTitle(Map<String, CmsProperty> properties) {
        return properties == null || properties.get("Title") == null || properties.get("Title").getValue() == null || properties.get("NavText") != null && properties.get("Title").getValue().equals(properties.get("NavText").getValue());
    }
}

