/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsAcceptLanguageHeaderParser {
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    protected static final Float DEFAULT_QUALITY = new Float(1.0f);
    private static final char LOCALE_SEPARATOR = ',';
    private static final char QUALITY_SEPARATOR = ';';
    private List<AcceptLanguage> m_acceptLanguage = new ArrayList<AcceptLanguage>(3);
    private List<Locale> m_locales;

    public CmsAcceptLanguageHeaderParser(HttpServletRequest req, Locale defaultLocale) {
        this(req.getHeader(ACCEPT_LANGUAGE), defaultLocale);
    }

    public CmsAcceptLanguageHeaderParser(String header, Locale defaultLocale) {
        if (header == null) {
            this.m_locales = new ArrayList<Locale>();
            this.m_locales.add(defaultLocale);
        } else {
            List<String> tokens = CmsStringUtil.splitAsList(header, ',', true);
            Iterator<String> it = tokens.iterator();
            while (it.hasNext()) {
                AcceptLanguage acceptLang = new AcceptLanguage();
                String element = it.next();
                int index = element.indexOf(59);
                if (index != -1) {
                    String q = element.substring(index);
                    element = element.substring(0, index);
                    index = q.indexOf(61);
                    if (index != -1) {
                        try {
                            acceptLang.m_quality = Float.valueOf(q.substring(index + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                acceptLang.m_locale = (index = (element = element.trim()).indexOf(45)) == -1 ? new Locale(element, "") : new Locale(element.substring(0, index), element.substring(index + 1));
                this.m_acceptLanguage.add(acceptLang);
            }
            Collections.sort(this.m_acceptLanguage, Collections.reverseOrder());
            this.m_locales = new ArrayList<Locale>(this.m_acceptLanguage.size());
            for (AcceptLanguage lang : this.m_acceptLanguage) {
                this.m_locales.add(lang.m_locale);
            }
        }
    }

    public static String createLanguageHeader() {
        List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales();
        Iterator<Locale> i = defaultLocales.iterator();
        String header = "";
        while (i.hasNext()) {
            Locale loc = i.next();
            header = header + loc.getLanguage() + ", ";
        }
        header = header.substring(0, header.length() - 2);
        return header;
    }

    public List<Locale> getAcceptedLocales() {
        return this.m_locales;
    }

    protected static class AcceptLanguage
    implements Comparable<AcceptLanguage> {
        Locale m_locale;
        Float m_quality = DEFAULT_QUALITY;

        protected AcceptLanguage() {
        }

        @Override
        public final int compareTo(AcceptLanguage acceptLang) {
            return this.m_quality.compareTo(acceptLang.m_quality);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AcceptLanguage) {
                AcceptLanguage other = (AcceptLanguage)obj;
                return this.m_locale.equals(other.m_locale) && this.m_quality.floatValue() == other.m_quality.floatValue();
            }
            return false;
        }

        public int hashCode() {
            return this.m_locale.hashCode() * (int)((double)this.m_quality.floatValue() * 1117.0);
        }
    }
}

