/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import com.google.common.base.Optional;
import java.util.Map;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.util.CmsStringUtil;

public class CmsReplaceMessageKeyPrefix
implements CmsMultiMessages.I_KeyFallbackHandler {
    private Map<String, String> m_substitutions;

    public CmsReplaceMessageKeyPrefix(String configuration) {
        this.m_substitutions = CmsStringUtil.splitAsMap(configuration, "|", ":");
    }

    @Override
    public Optional<String> getFallbackKey(String key) {
        for (String prefix : this.m_substitutions.keySet()) {
            if (!key.startsWith(prefix)) continue;
            return Optional.fromNullable((Object)(this.m_substitutions.get(prefix) + key.substring(prefix.length())));
        }
        return Optional.absent();
    }
}

