/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsUserExportSettings;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsExtendedHtmlImportDefault;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.I_CmsImport;
import org.opencms.importexport.I_CmsImportExportHandler;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.xml.CmsXmlException;

public class CmsImportExportManager {
    @Deprecated
    public static final String A_NAME = "name";
    @Deprecated
    public static final String A_TYPE = "type";
    public static final String EXPORT_MANIFEST = "manifest.xml";
    public static final String EXPORT_VERSION = "10";
    @Deprecated
    public static final String EXPORT_XMLFILENAME = "manifest.xml";
    @Deprecated
    public static final String N_ACCESS = "access";
    @Deprecated
    public static final String N_ACCESSCONTROL_ALLOWEDPERMISSIONS = "allowed";
    @Deprecated
    public static final String N_ACCESSCONTROL_DENIEDPERMISSIONS = "denied";
    @Deprecated
    public static final String N_ACCESSCONTROL_ENTRIES = "accesscontrol";
    @Deprecated
    public static final String N_ACCESSCONTROL_ENTRY = "accessentry";
    @Deprecated
    public static final String N_ACCESSCONTROL_PERMISSIONSET = "permissionset";
    @Deprecated
    public static final String N_ACCESSCONTROL_PRINCIPAL = "uuidprincipal";
    public static final String N_CREATOR = "creator";
    public static final String N_DATE = "createdate";
    @Deprecated
    public static final String N_DATECREATED = "datecreated";
    @Deprecated
    public static final String N_DATEEXPIRED = "dateexpired";
    @Deprecated
    public static final String N_DATELASTMODIFIED = "datelastmodified";
    @Deprecated
    public static final String N_DATERELEASED = "datereleased";
    @Deprecated
    public static final String N_DEFAULTGROUP = "defaultgroup";
    @Deprecated
    public static final String N_DESCRIPTION = "description";
    @Deprecated
    public static final String N_DESTINATION = "destination";
    @Deprecated
    public static final String N_EMAIL = "email";
    public static final String N_EXPORT = "export";
    @Deprecated
    public static final String N_FILE = "file";
    @Deprecated
    public static final String N_FIRSTNAME = "firstname";
    @Deprecated
    public static final String N_FLAGS = "flags";
    @Deprecated
    public static final String N_GROUPDATA = "groupdata";
    @Deprecated
    public static final String N_GROUPNAME = "groupname";
    @Deprecated
    public static final String N_ID = "id";
    public static final String N_INFO = "info";
    @Deprecated
    public static final String N_LASTMODIFIED = "lastmodified";
    @Deprecated
    public static final String N_LASTNAME = "lastname";
    @Deprecated
    public static final String N_NAME = "name";
    public static final String N_OC_VERSION = "opencms_version";
    @Deprecated
    public static final String N_PARENTGROUP = "parentgroup";
    @Deprecated
    public static final String N_PASSWORD = "password";
    public static final String N_INFO_PROJECT = "infoproject";
    @Deprecated
    public static final String N_PROPERTIES = "properties";
    @Deprecated
    public static final String N_PROPERTY = "property";
    @Deprecated
    public static final String N_PROPERTY_ATTRIB_TYPE = "type";
    @Deprecated
    public static final String N_PROPERTY_ATTRIB_TYPE_SHARED = "shared";
    @Deprecated
    public static final String N_RELATION = "relation";
    @Deprecated
    public static final String N_RELATION_ATTRIBUTE_ID = "id";
    @Deprecated
    public static final String N_RELATION_ATTRIBUTE_PATH = "path";
    @Deprecated
    public static final String N_RELATION_ATTRIBUTE_TYPE = "type";
    @Deprecated
    public static final String N_RELATIONS = "relations";
    @Deprecated
    public static final String N_SOURCE = "source";
    @Deprecated
    public static final String N_TAG_ADDRESS = "address";
    @Deprecated
    public static final String N_TYPE = "type";
    @Deprecated
    public static final String N_USER = "user";
    @Deprecated
    public static final String N_USERCREATED = "usercreated";
    @Deprecated
    public static final String N_USERDATA = "userdata";
    @Deprecated
    public static final String N_USERGROUPDATA = "usergroupdata";
    @Deprecated
    public static final String N_ORGUNITDATA = "orgunitdata";
    @Deprecated
    public static final String N_USERGROUPS = "usergroups";
    @Deprecated
    public static final String N_USERINFO = "userinfo";
    @Deprecated
    public static final String N_USERINFO_ENTRY = "entry";
    @Deprecated
    public static final String N_USERLASTMODIFIED = "userlastmodified";
    @Deprecated
    public static final String N_UUIDRESOURCE = "uuidresource";
    @Deprecated
    public static final String N_UUIDSTRUCTURE = "uuidstructure";
    @Deprecated
    public static final String N_VALUE = "value";
    public static final String N_VERSION = "export_version";
    public static final String PROP_EXPORT_TIMESTAMP = "export.timestamp";
    private static final Log LOG = CmsLog.getLog(CmsImportExportManager.class);
    private boolean m_convertToXmlPage;
    private CmsExtendedHtmlImportDefault m_extendedHtmlImportDefault;
    private List<String> m_ignoredProperties;
    private Map<String, TimestampMode> m_defaultTimestampModes;
    private List<String> m_immutableResources;
    private List<String> m_resourcetypes;
    private List<I_CmsImportExportHandler> m_importExportHandlers;
    private Map<String, String> m_importGroupTranslations;
    private Map<String, String> m_importUserTranslations;
    private List<I_CmsImport> m_importVersionClasses;
    private boolean m_overwriteCollidingResources;
    private CmsUserExportSettings m_userExportSettings;
    private String m_webAppUrl;

    public CmsImportExportManager() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("INIT_IMPORTEXPORT_INITIALIZING_0"));
        }
        this.m_importExportHandlers = new ArrayList<I_CmsImportExportHandler>();
        this.m_immutableResources = new ArrayList<String>();
        this.m_ignoredProperties = new ArrayList<String>();
        this.m_convertToXmlPage = true;
        this.m_importGroupTranslations = new HashMap<String, String>();
        this.m_importUserTranslations = new HashMap<String, String>();
        this.m_overwriteCollidingResources = true;
        this.m_importVersionClasses = new ArrayList<I_CmsImport>();
        this.m_defaultTimestampModes = new HashMap<String, TimestampMode>();
        this.m_resourcetypes = new ArrayList<String>();
    }

    public void addDefaultTimestampMode(String timestampMode) {
        if (null != timestampMode) {
            try {
                TimestampMode mode = TimestampMode.valueOf(timestampMode.toUpperCase());
                for (String resourcetype : this.m_resourcetypes) {
                    this.m_defaultTimestampModes.put(resourcetype, mode);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_EXPORT_SETTIMESTAMPMODE_2", timestampMode, resourcetype));
                }
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_IMPORTEXPORT_EXPORT_INVALID_TIMESTAMPMODE_2", timestampMode, this.m_resourcetypes.toString()), (Throwable)e);
            }
        } else {
            LOG.error((Object)Messages.get().getBundle().key("ERR_IMPORTEXPORT_EXPORT_MISSING_TIMESTAMPMODE_1", this.m_resourcetypes.toString()));
        }
        this.m_resourcetypes.clear();
    }

    public void addIgnoredProperty(String propertyName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IGNORING_PROPERTY_1", propertyName));
        }
        this.m_ignoredProperties.add(propertyName);
    }

    public void addImmutableResource(String immutableResource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ADDED_IMMUTABLE_RESOURCE_1", immutableResource));
        }
        this.m_immutableResources.add(immutableResource);
    }

    public void addImportExportHandler(I_CmsImportExportHandler handler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ADDED_IMPORTEXPORT_HANDLER_1", handler));
        }
        this.m_importExportHandlers.add(handler);
    }

    public void addImportPrincipalTranslation(String type, String from, String to) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ADDED_PRINCIPAL_TRANSLATION_3", type, from, to));
        }
        if ("GROUP".equalsIgnoreCase(type)) {
            this.m_importGroupTranslations.put(from, to);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("INIT_IMPORTEXPORT_ADDED_GROUP_TRANSLATION_2", from, to));
            }
        } else if ("USER".equalsIgnoreCase(type)) {
            this.m_importUserTranslations.put(from, to);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("INIT_IMPORTEXPORT_ADDED_USER_TRANSLATION_2", from, to));
            }
        }
    }

    public void addImportVersionClass(I_CmsImport importVersionClass) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ADDED_IMPORT_VERSION_1", importVersionClass));
        }
        this.m_importVersionClasses.add(importVersionClass);
    }

    public void addResourceTypeForDefaultTimestampMode(String resourcetypeName) {
        this.m_resourcetypes.add(resourcetypeName);
    }

    public boolean convertToXmlPage() {
        return this.m_convertToXmlPage;
    }

    public void exportData(CmsObject cms, I_CmsImportExportHandler handler, I_CmsReport report) throws CmsConfigurationException, CmsImportExportException, CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        handler.exportData(cms, report);
    }

    public TimestampMode getDefaultTimestampMode(String resourcetypeName) {
        return this.m_defaultTimestampModes.get(resourcetypeName);
    }

    public Map<TimestampMode, List<String>> getDefaultTimestampModes() {
        HashMap<TimestampMode, List<String>> result = new HashMap<TimestampMode, List<String>>();
        for (String resourcetype : this.m_defaultTimestampModes.keySet()) {
            TimestampMode mode = this.m_defaultTimestampModes.get(resourcetype);
            if (result.containsKey((Object)mode)) {
                ((List)result.get((Object)mode)).add(resourcetype);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(resourcetype);
            result.put(mode, list);
        }
        return result;
    }

    public CmsExtendedHtmlImportDefault getExtendedHtmlImportDefault() {
        return this.getExtendedHtmlImportDefault(false);
    }

    public CmsExtendedHtmlImportDefault getExtendedHtmlImportDefault(boolean withNull) {
        return withNull || this.m_extendedHtmlImportDefault != null ? this.m_extendedHtmlImportDefault : new CmsExtendedHtmlImportDefault();
    }

    public List<String> getIgnoredProperties() {
        return this.m_ignoredProperties;
    }

    public List<String> getImmutableResources() {
        return this.m_immutableResources;
    }

    public I_CmsImportExportHandler getImportExportHandler(CmsImportParameters parameters) throws CmsImportExportException {
        Document manifest;
        InputStream stream = null;
        CmsImportHelper helper = new CmsImportHelper(parameters);
        try {
            helper.openFile();
            stream = helper.getFileStream("manifest.xml");
            SAXReader reader = new SAXReader(false);
            reader.setValidation(false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            manifest = reader.read(stream);
        }
        catch (Throwable e) {
            throw new CmsImportExportException(Messages.get().container("ERR_IMPORTEXPORT_FILE_NOT_FOUND_1", "manifest.xml"), e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception reader) {}
            helper.closeFile();
        }
        for (int i = 0; i < this.m_importExportHandlers.size(); ++i) {
            I_CmsImportExportHandler handler = this.m_importExportHandlers.get(i);
            if (!handler.matches(manifest)) continue;
            return handler;
        }
        CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_NO_HANDLER_FOUND_1", "manifest.xml");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message.key());
        }
        throw new CmsImportExportException(message);
    }

    public List<I_CmsImportExportHandler> getImportExportHandlers() {
        return this.m_importExportHandlers;
    }

    public Map<String, String> getImportGroupTranslations() {
        return this.m_importGroupTranslations;
    }

    public Map<String, String> getImportUserTranslations() {
        return this.m_importUserTranslations;
    }

    public List<I_CmsImport> getImportVersionClasses() {
        return this.m_importVersionClasses;
    }

    public String getOldWebAppUrl() {
        return this.m_webAppUrl;
    }

    public CmsUserExportSettings getUserExportSettings() {
        return this.m_userExportSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(CmsObject cms, I_CmsReport report, CmsImportParameters parameters) throws CmsImportExportException, CmsXmlException, CmsRoleViolationException, CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        try {
            I_CmsImportExportHandler handler;
            OpenCms.fireCmsEvent(new CmsEvent(5, Collections.emptyMap()));
            I_CmsImportExportHandler i_CmsImportExportHandler = handler = this.getImportExportHandler(parameters);
            synchronized (i_CmsImportExportHandler) {
                handler.setImportParameters(parameters);
                handler.importData(cms, report);
            }
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(5, Collections.emptyMap()));
        }
    }

    @Deprecated
    public void importData(CmsObject cms, String importFile, String importPath, I_CmsReport report) throws CmsImportExportException, CmsXmlException, CmsRoleViolationException, CmsException {
        CmsImportParameters parameters = new CmsImportParameters(importFile, importPath, false);
        this.importData(cms, report, parameters);
    }

    public boolean overwriteCollidingResources() {
        return this.m_overwriteCollidingResources;
    }

    public void setConvertToXmlPage(boolean convertToXmlPage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_SET_CONVERT_PARAMETER_1", Boolean.toString(convertToXmlPage)));
        }
        this.m_convertToXmlPage = convertToXmlPage;
    }

    public void setConvertToXmlPage(String convertToXmlPage) {
        this.setConvertToXmlPage(Boolean.valueOf(convertToXmlPage));
    }

    public void setExtendedHtmlImportDefault(CmsExtendedHtmlImportDefault extendedHtmlImportDefault) {
        this.m_extendedHtmlImportDefault = extendedHtmlImportDefault;
    }

    public void setOldWebAppUrl(String webAppUrl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_SET_OLD_WEBAPP_URL_1", webAppUrl));
        }
        this.m_webAppUrl = webAppUrl;
    }

    public void setOverwriteCollidingResources(boolean overwriteCollidingResources) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_SET_OVERWRITE_PARAMETER_1", Boolean.toString(overwriteCollidingResources)));
        }
        this.m_overwriteCollidingResources = overwriteCollidingResources;
    }

    public void setOverwriteCollidingResources(String overwriteCollidingResources) {
        this.setOverwriteCollidingResources(Boolean.valueOf(overwriteCollidingResources));
    }

    public void setUserExportSettings(CmsUserExportSettings userExportSettings) {
        this.m_userExportSettings = userExportSettings;
    }

    public String translateGroup(String name) {
        if (this.m_importGroupTranslations == null) {
            return name;
        }
        String match = this.m_importGroupTranslations.get(name);
        if (match != null) {
            return match;
        }
        return name;
    }

    public String translateUser(String name) {
        if (this.m_importUserTranslations == null) {
            return name;
        }
        String match = this.m_importUserTranslations.get(name);
        if (match != null) {
            return match;
        }
        return name;
    }

    public static enum TimestampMode {
        IMPORTTIME,
        FILETIME,
        VFSTIME;


        public static TimestampMode getDefaultTimeStampMode() {
            return VFSTIME;
        }

        public static TimestampMode getEnum(String value) {
            if (null == value) {
                return TimestampMode.getDefaultTimeStampMode();
            }
            try {
                return TimestampMode.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return TimestampMode.getDefaultTimeStampMode();
            }
        }
    }
}

