/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jlan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.opencms.jlan.CmsJlanNetworkFile;

public class CmsJlanSearch
extends SearchContext {
    private List<CmsJlanNetworkFile> m_files;
    private int m_position;

    public CmsJlanSearch(List<CmsJlanNetworkFile> files) {
        this.m_files = new ArrayList<CmsJlanNetworkFile>(files);
    }

    public int getResumeId() {
        return this.m_position;
    }

    public boolean hasMoreFiles() {
        return this.m_position < this.m_files.size();
    }

    public boolean nextFileInfo(FileInfo info) {
        try {
            CmsJlanNetworkFile file = this.nextFile();
            if (file == null) {
                return false;
            }
            info.copyFrom(file.getFileInfo());
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String nextFileName() {
        return this.nextFile().getName();
    }

    public boolean restartAt(FileInfo info) {
        return false;
    }

    public boolean restartAt(int resumeId) {
        return false;
    }

    protected CmsJlanNetworkFile nextFile() {
        if (!this.hasMoreFiles()) {
            return null;
        }
        CmsJlanNetworkFile file = this.m_files.get(this.m_position);
        ++this.m_position;
        return file;
    }
}

