/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsLoginMessage;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAuthentificationException;

public class CmsJspLoginBean
extends CmsJspActionElement {
    private static final Log LOG = CmsLog.getLog(CmsJspLoginBean.class);
    private CmsException m_loginException;

    public CmsJspLoginBean() {
    }

    public CmsJspLoginBean(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public static void logLoginException(CmsRequestContext requestContext, String userName, CmsException currentLoginException) {
        if (currentLoginException instanceof CmsAuthentificationException) {
            if ("ERR_LOGIN_FAILED_DISABLED_2" == currentLoginException.getMessageContainer().getKey()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_LOGIN_FAILED_DISABLED_3", userName, requestContext.addSiteRoot(requestContext.getUri()), requestContext.getRemoteAddress()));
            } else if ("ERR_LOGIN_FAILED_TEMP_DISABLED_4" == currentLoginException.getMessageContainer().getKey()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_LOGIN_FAILED_TEMP_DISABLED_5", new Object[]{userName, requestContext.addSiteRoot(requestContext.getUri()), requestContext.getRemoteAddress(), currentLoginException.getMessageContainer().getArgs()[2], currentLoginException.getMessageContainer().getArgs()[3]}));
            } else if ("ERR_LOGIN_FAILED_NO_USER_2" == currentLoginException.getMessageContainer().getKey()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_LOGIN_FAILED_NO_USER_3", userName, requestContext.addSiteRoot(requestContext.getUri()), requestContext.getRemoteAddress()));
            } else if ("ERR_LOGIN_FAILED_WITH_MESSAGE_1" == currentLoginException.getMessageContainer().getKey()) {
                long endTime = CmsLoginMessage.DEFAULT_TIME_END;
                if (OpenCms.getLoginManager().getLoginMessage() != null) {
                    endTime = OpenCms.getLoginManager().getLoginMessage().getTimeEnd();
                }
                LOG.info((Object)Messages.get().getBundle().key("LOG_LOGIN_FAILED_WITH_MESSAGE_4", new Object[]{userName, requestContext.addSiteRoot(requestContext.getUri()), requestContext.getRemoteAddress(), new Date(endTime)}));
            } else {
                CmsMessageContainer message = Messages.get().container("LOG_LOGIN_FAILED_3", userName, requestContext.addSiteRoot(requestContext.getUri()), requestContext.getRemoteAddress());
                if (OpenCms.getDefaultUsers().isUserAdmin(userName)) {
                    LOG.error((Object)message.key());
                } else {
                    LOG.warn((Object)message.key());
                }
            }
        } else {
            LOG.error((Object)Messages.get().getBundle().key("LOG_LOGIN_FAILED_DB_REASON_3", userName, requestContext.addSiteRoot(requestContext.getUri()), requestContext.getRemoteAddress()), (Throwable)currentLoginException);
        }
    }

    public String getFormLink() {
        return this.link(this.getRequestContext().getUri());
    }

    public CmsException getLoginException() {
        return this.m_loginException;
    }

    public CmsUser getUser() {
        return this.getRequestContext().getCurrentUser();
    }

    public String getUserName() {
        return this.getRequestContext().getCurrentUser().getName();
    }

    public boolean isLoggedIn() {
        return !this.getCmsObject().getRequestContext().getCurrentUser().isGuestUser();
    }

    public boolean isLoginSuccess() {
        return this.m_loginException == null;
    }

    public void login(String userName, String password) {
        this.login(userName, password, null);
    }

    public void login(String userName, String password, String projectName) {
        HttpSession session = null;
        this.m_loginException = null;
        try {
            CmsLoginMessage loginMessage;
            CmsUser user = this.getCmsObject().readUser(userName);
            OpenCms.getSessionManager().checkCreateSessionForUser(user);
            this.getCmsObject().loginUser(userName, password, this.getRequestContext().getRemoteAddress());
            session = this.getRequest().getSession(false);
            if (session != null) {
                session.invalidate();
            }
            session = this.getRequest().getSession(true);
            if (projectName != null) {
                this.getCmsObject().getRequestContext().setCurrentProject(this.getCmsObject().readProject(projectName));
            }
            if (!this.getCmsObject().getRequestContext().getCurrentProject().isOnlineProject() && (loginMessage = OpenCms.getLoginManager().getLoginMessage()) != null && loginMessage.isActive()) {
                OpenCms.getSessionManager().updateSessionInfo(this.getCmsObject(), this.getRequest());
                OpenCms.getSessionManager().sendBroadcast(null, loginMessage.getMessage(), user);
            }
        }
        catch (CmsException e) {
            this.m_loginException = e;
        }
        if (this.m_loginException == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_LOGIN_SUCCESSFUL_3", userName, this.getRequestContext().addSiteRoot(this.getRequestContext().getUri()), this.getRequestContext().getRemoteAddress()));
            }
        } else {
            if (session != null) {
                session.invalidate();
            }
            CmsException currentLoginException = this.m_loginException;
            CmsJspLoginBean.logLoginException(this.getRequestContext(), userName, currentLoginException);
        }
    }

    public void login(String userName, String password, String projectName, String redirectUri) throws IOException {
        this.login(userName, password, projectName);
        if (this.m_loginException == null) {
            if (redirectUri != null) {
                this.getResponse().sendRedirect(OpenCms.getLinkManager().substituteLink(this.getCmsObject(), redirectUri, null, true));
            } else {
                this.getResponse().sendRedirect(this.getFormLink());
            }
        }
    }

    public void logout() throws IOException {
        String loggedInUserName = this.getRequestContext().getCurrentUser().getName();
        HttpSession session = this.getRequest().getSession(false);
        if (session != null) {
            session.invalidate();
            this.getCmsObject().getRequestContext().setUpdateSessionEnabled(false);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_LOGOUT_SUCCESFUL_3", loggedInUserName, this.getRequestContext().addSiteRoot(this.getRequestContext().getUri()), this.getRequestContext().getRemoteAddress()));
        }
        this.getResponse().sendRedirect(this.getFormLink());
    }
}

