/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleGroup;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsJspResourceWrapper
extends CmsResource {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = CmsLog.getLog(CmsJspResourceWrapper.class);
    private CmsObject m_cms;
    private Map<String, CmsJspResourceWrapper> m_localeResources;
    private Locale m_mainLocale;

    public CmsJspResourceWrapper(CmsObject cms, CmsResource res) {
        super(res.getStructureId(), res.getResourceId(), res.getRootPath(), res.getTypeId(), res.isFolder(), res.getFlags(), res.getProjectLastModified(), res.getState(), res.getDateCreated(), res.getUserCreated(), res.getDateLastModified(), res.getUserLastModified(), res.getDateReleased(), res.getDateExpired(), res.getSiblingCount(), res.getLength(), res.getDateContent(), res.getVersion());
        this.m_cms = cms;
    }

    public String getLink() {
        return OpenCms.getLinkManager().substituteLinkForUnknownTarget(this.m_cms, this.m_cms.getRequestContext().getSitePath(this));
    }

    public Map<String, CmsJspResourceWrapper> getLocaleResource() {
        if (this.m_localeResources != null) {
            return this.m_localeResources;
        }
        try {
            CmsLocaleGroup localeGroup = this.m_cms.getLocaleGroupService().readLocaleGroup(this);
            Map<Locale, CmsResource> resourcesByLocale = localeGroup.getResourcesByLocale();
            HashMap result = Maps.newHashMap();
            for (Map.Entry<Locale, CmsResource> entry : resourcesByLocale.entrySet()) {
                result.put(entry.getKey().toString(), new CmsJspResourceWrapper(this.m_cms, entry.getValue()));
            }
            this.m_localeResources = result;
            return result;
        }
        catch (CmsException e) {
            return new HashMap<String, CmsJspResourceWrapper>();
        }
    }

    public Locale getMainLocale() {
        if (this.m_mainLocale != null) {
            return this.m_mainLocale;
        }
        try {
            CmsLocaleGroup localeGroup = this.m_cms.getLocaleGroupService().readLocaleGroup(this);
            this.m_mainLocale = localeGroup.getMainLocale();
            return this.m_mainLocale;
        }
        catch (CmsException e) {
            return null;
        }
    }
}

