/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.tagext.TagSupport;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.pdftools.CmsPdfLink;

public class CmsJspTagPdf
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String m_content;
    private String m_format;
    private String m_locale;

    public static String pdfTagAction(ServletRequest request, String format, String content, String localeStr) throws CmsException {
        CmsFlexController controller = CmsFlexController.getController(request);
        CmsObject cms = OpenCms.initCmsObject(controller.getCmsObject());
        if (localeStr != null) {
            Locale localeObj = CmsLocaleManager.getLocale(localeStr);
            cms.getRequestContext().setLocale(localeObj);
        }
        CmsResource formatterRes = cms.readResource(format);
        CmsResource contentRes = cms.readResource(content, CmsResourceFilter.ignoreExpirationOffline(cms));
        CmsPdfLink pdfLink = new CmsPdfLink(cms, formatterRes, contentRes);
        return pdfLink.getLink();
    }

    public int doStartTag() {
        try {
            this.pageContext.getOut().print(CmsJspTagPdf.pdfTagAction(this.pageContext.getRequest(), this.m_format, this.m_content, this.m_locale));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    public void setContent(String content) {
        this.m_content = content;
    }

    public void setFormat(String format) {
        this.m_format = format;
    }

    public void setLocale(String locale) {
        this.m_locale = locale;
    }
}

