/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config;

import java.util.HashMap;
import java.util.Map;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;

public class CmsSearchConfigurationCommon
implements I_CmsSearchConfigurationCommon {
    private final String m_queryParam;
    private final String m_lastQueryParam;
    private final boolean m_escapeQueryChars;
    private final String m_reloadedParam;
    private final String m_queryModifier;
    private final boolean m_searchForEmptyQuery;
    private final boolean m_ignoreQuery;
    private final String m_solrIndex;
    private final String m_solrCore;
    private final String m_extraSolrParams;
    private final Map<String, String> m_additionalParameters;
    private boolean m_ignoreReleaseDate;
    private boolean m_ignoreExpirationDate;

    public CmsSearchConfigurationCommon(String queryParam, String lastQueryParam, Boolean escapeQueryChars, String reloadedParam, Boolean seachForEmptyQuery, Boolean ignoreQuery, String queryModifier, String solrIndex, String solrCore, String extraSolrParams, Map<String, String> additionalParameters, Boolean ignoreReleaseDate, Boolean ignoreExpirationDate) {
        this.m_queryParam = queryParam;
        this.m_lastQueryParam = lastQueryParam;
        this.m_escapeQueryChars = escapeQueryChars != null ? escapeQueryChars : true;
        this.m_reloadedParam = reloadedParam;
        this.m_searchForEmptyQuery = seachForEmptyQuery != null ? seachForEmptyQuery : false;
        this.m_ignoreQuery = ignoreQuery != null ? ignoreQuery : false;
        this.m_queryModifier = queryModifier;
        this.m_solrIndex = solrIndex;
        this.m_solrCore = solrCore;
        this.m_extraSolrParams = extraSolrParams == null ? "" : extraSolrParams;
        this.m_additionalParameters = additionalParameters != null ? additionalParameters : new HashMap();
        this.m_ignoreReleaseDate = null == ignoreReleaseDate ? false : ignoreReleaseDate;
        this.m_ignoreExpirationDate = null == ignoreExpirationDate ? false : ignoreExpirationDate;
    }

    @Override
    public Map<String, String> getAdditionalParameters() {
        return this.m_additionalParameters;
    }

    @Override
    public boolean getEscapeQueryChars() {
        return this.m_escapeQueryChars;
    }

    @Override
    public String getExtraSolrParams() {
        return this.m_extraSolrParams;
    }

    @Override
    public boolean getIgnoreExpirationDate() {
        return this.m_ignoreExpirationDate;
    }

    @Override
    public boolean getIgnoreQueryParam() {
        return this.m_ignoreQuery;
    }

    @Override
    public boolean getIgnoreReleaseDate() {
        return this.m_ignoreReleaseDate;
    }

    @Override
    public String getLastQueryParam() {
        return this.m_lastQueryParam;
    }

    @Override
    public String getModifiedQuery(String queryString) {
        if (null != this.m_queryModifier) {
            return this.m_queryModifier.replace("%(query)", queryString);
        }
        return queryString;
    }

    @Override
    public String getQueryParam() {
        return this.m_queryParam;
    }

    @Override
    public String getReloadedParam() {
        return this.m_reloadedParam;
    }

    @Override
    public boolean getSearchForEmptyQueryParam() {
        return this.m_searchForEmptyQuery;
    }

    @Override
    public String getSolrCore() {
        return this.m_solrCore;
    }

    @Override
    public String getSolrIndex() {
        return this.m_solrIndex;
    }
}

