/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.search.config.CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.config.CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.CmsSearchConfigurationSorting;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacet;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSorting;
import org.opencms.jsp.search.config.parser.I_CmsSearchConfigurationParser;
import org.opencms.jsp.search.config.parser.Messages;
import org.opencms.main.CmsLog;

public class CmsJSONSearchConfigurationParser
implements I_CmsSearchConfigurationParser {
    protected static final Log LOG = CmsLog.getLog(CmsJSONSearchConfigurationParser.class);
    private static final String JSON_KEY_QUERYPARAM = "queryparam";
    private static final String JSON_KEY_LAST_QUERYPARAM = "lastqueryparam";
    private static final String JSON_KEY_ESCAPE_QUERY_CHARACTERS = "escapequerychars";
    private static final String JSON_KEY_RELOADED_PARAM = "reloadedparam";
    private static final String JSON_KEY_SEARCH_FOR_EMPTY_QUERY = "searchforemptyquery";
    private static final String JSON_KEY_IGNORE_QUERY = "ignorequery";
    private static final String JSON_KEY_IGNORE_RELEASE_DATE = "ignoreReleaseDate";
    private static final String JSON_KEY_IGNORE_EXPIRATION_DATE = "ignoreExpirationDate";
    private static final String JSON_KEY_QUERY_MODIFIER = "querymodifier";
    private static final String JSON_KEY_PAGEPARAM = "pageparam";
    private static final String JSON_KEY_INDEX = "index";
    private static final String JSON_KEY_CORE = "core";
    private static final String JSON_KEY_EXTRASOLRPARAMS = "extrasolrparams";
    private static final String JSON_KEY_ADDITIONAL_PARAMETERS = "additionalrequestparams";
    private static final String JSON_KEY_ADDITIONAL_PARAMETERS_PARAM = "param";
    private static final String JSON_KEY_ADDITIONAL_PARAMETERS_SOLRQUERY = "solrquery";
    private static final String JSON_KEY_PAGESIZE = "pagesize";
    private static final String JSON_KEY_PAGENAVLENGTH = "pagenavlength";
    private static final String JSON_KEY_FIELD_FACETS = "fieldfacets";
    private static final String JSON_KEY_RANGE_FACETS = "rangefacets";
    private static final String JSON_KEY_QUERY_FACET = "queryfacet";
    private static final String JSON_KEY_FACET_LIMIT = "limit";
    private static final String JSON_KEY_FACET_MINCOUNT = "mincount";
    private static final String JSON_KEY_FACET_LABEL = "label";
    private static final String JSON_KEY_FACET_FIELD = "field";
    private static final String JSON_KEY_FACET_NAME = "name";
    private static final String JSON_KEY_FACET_PREFIX = "prefix";
    private static final String JSON_KEY_FACET_ORDER = "order";
    private static final String JSON_KEY_FACET_FILTERQUERYMODIFIER = "filterquerymodifier";
    private static final String JSON_KEY_FACET_ISANDFACET = "isAndFacet";
    private static final String JSON_KEY_FACET_IGNOREALLFACETFILTERS = "ignoreAllFacetFilters";
    private static final String JSON_KEY_FACET_PRESELECTION = "preselection";
    private static final String JSON_KEY_RANGE_FACET_RANGE = "range";
    private static final String JSON_KEY_RANGE_FACET_START = "start";
    private static final String JSON_KEY_RANGE_FACET_END = "end";
    private static final String JSON_KEY_RANGE_FACET_GAP = "gap";
    private static final String JSON_KEY_RANGE_FACET_OTHER = "other";
    private static final String JSON_KEY_RANGE_FACET_HARDEND = "hardend";
    private static final String JSON_KEY_QUERY_FACET_QUERY = "queryitems";
    private static final String JSON_KEY_QUERY_FACET_QUERY_QUERY = "query";
    private static final String JSON_KEY_QUERY_FACET_QUERY_LABEL = "label";
    private static final String JSON_KEY_SORTPARAM = "sortby";
    private static final String JSON_KEY_SORTOPTIONS = "sortoptions";
    private static final String JSON_KEY_SORTOPTION_LABEL = "label";
    private static final String JSON_KEY_SORTOPTION_PARAMVALUE = "paramvalue";
    private static final String JSON_KEY_SORTOPTION_SOLRVALUE = "solrvalue";
    private static final String JSON_KEY_HIGHLIGHTER = "highlighter";
    private static final String JSON_KEY_HIGHLIGHTER_FIELD = "field";
    private static final String JSON_KEY_HIGHLIGHTER_SNIPPETS = "snippets";
    private static final String JSON_KEY_HIGHLIGHTER_FRAGSIZE = "fragsize";
    private static final String JSON_KEY_HIGHLIGHTER_ALTERNATE_FIELD = "alternateField";
    private static final String JSON_KEY_HIGHLIGHTER_MAX_LENGTH_ALTERNATE_FIELD = "maxAlternateFieldLength";
    private static final String JSON_KEY_HIGHLIGHTER_SIMPLE_PRE = "simple.pre";
    private static final String JSON_KEY_HIGHLIGHTER_SIMPLE_POST = "simple.post";
    private static final String JSON_KEY_HIGHLIGHTER_FORMATTER = "formatter";
    private static final String JSON_KEY_HIGHLIGHTER_FRAGMENTER = "fragmenter";
    private static final String JSON_KEY_HIGHLIGHTER_FASTVECTORHIGHLIGHTING = "useFastVectorHighlighting";
    private static final String JSON_KEY_DIDYOUMEAN = "didYouMean";
    private static final String JSON_KEY_DIDYOUMEAN_QUERYPARAM = "didYouMeanQueryParam";
    private static final String JSON_KEY_DIDYOUMEAN_COLLATE = "didYouMeanCollate";
    private static final String JSON_KEY_DIDYOUMEAN_COUNT = "didYouMeanCount";
    private static final String DEFAULT_QUERY_PARAM = "q";
    private static final String DEFAULT_LAST_QUERY_PARAM = "lq";
    private static final String DEFAULT_RELOADED_PARAM = "reloaded";
    private static final String DEFAULT_SORT_PARAM = "sort";
    private static final String DEFAULT_PAGE_PARAM = "page";
    private static final Integer DEFAULT_PAGE_SIZE = 10;
    private static final Integer DEFAULT_PAGENAVLENGTH = 5;
    JSONObject m_configObject;

    public CmsJSONSearchConfigurationParser(String json) throws JSONException {
        this.init(json);
    }

    @Override
    public I_CmsSearchConfigurationCommon parseCommon() {
        return new CmsSearchConfigurationCommon(this.getQueryParam(), this.getLastQueryParam(), this.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_ESCAPE_QUERY_CHARACTERS), this.getFirstCallParam(), this.getSearchForEmtpyQuery(), this.getIgnoreQuery(), this.getQueryModifier(), this.getIndex(), this.getCore(), this.getExtraSolrParams(), this.getAdditionalParameters(), this.getIgnoreReleaseDate(), this.getIgnoreExpirationDate());
    }

    @Override
    public I_CmsSearchConfigurationDidYouMean parseDidYouMean() {
        try {
            JSONObject didYouMean = this.m_configObject.getJSONObject(JSON_KEY_DIDYOUMEAN);
            String param = this.parseOptionalStringValue(didYouMean, JSON_KEY_DIDYOUMEAN_QUERYPARAM);
            if (null == param) {
                param = this.getQueryParam();
            }
            Boolean collate = this.parseOptionalBooleanValue(didYouMean, JSON_KEY_DIDYOUMEAN_COLLATE);
            Integer count = this.parseOptionalIntValue(didYouMean, JSON_KEY_DIDYOUMEAN_COUNT);
            return new CmsSearchConfigurationDidYouMean(param, collate, count);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_HIGHLIGHTING_CONFIG_0"));
            return null;
        }
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetField> parseFieldFacets() {
        LinkedHashMap<String, I_CmsSearchConfigurationFacetField> facetConfigs = new LinkedHashMap<String, I_CmsSearchConfigurationFacetField>();
        try {
            JSONArray fieldFacets = this.m_configObject.getJSONArray(JSON_KEY_FIELD_FACETS);
            for (int i = 0; i < fieldFacets.length(); ++i) {
                I_CmsSearchConfigurationFacetField config = this.parseFieldFacet(fieldFacets.getJSONObject(i));
                if (config == null) continue;
                facetConfigs.put(config.getName(), config);
            }
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_FACET_CONFIG_0"), (Throwable)e);
        }
        return facetConfigs;
    }

    @Override
    public I_CmsSearchConfigurationHighlighting parseHighlighter() {
        try {
            JSONObject highlighter = this.m_configObject.getJSONObject(JSON_KEY_HIGHLIGHTER);
            String field = highlighter.getString("field");
            Integer snippets = this.parseOptionalIntValue(highlighter, JSON_KEY_HIGHLIGHTER_SNIPPETS);
            Integer fragsize = this.parseOptionalIntValue(highlighter, JSON_KEY_HIGHLIGHTER_FRAGSIZE);
            String alternateField = this.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_ALTERNATE_FIELD);
            Integer maxAlternateFieldLength = this.parseOptionalIntValue(highlighter, JSON_KEY_HIGHLIGHTER_MAX_LENGTH_ALTERNATE_FIELD);
            String pre = this.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_SIMPLE_PRE);
            String post = this.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_SIMPLE_POST);
            String formatter = this.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_FORMATTER);
            String fragmenter = this.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_FRAGMENTER);
            Boolean useFastVectorHighlighting = this.parseOptionalBooleanValue(highlighter, JSON_KEY_HIGHLIGHTER_FASTVECTORHIGHLIGHTING);
            return new CmsSearchConfigurationHighlighting(field, snippets, fragsize, alternateField, maxAlternateFieldLength, pre, post, formatter, fragmenter, useFastVectorHighlighting);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_HIGHLIGHTING_CONFIG_0"));
            return null;
        }
    }

    @Override
    public I_CmsSearchConfigurationPagination parsePagination() {
        return new CmsSearchConfigurationPagination(this.getPageParam(), this.getPageSize(), this.getPageNavLength());
    }

    @Override
    public I_CmsSearchConfigurationFacetQuery parseQueryFacet() {
        try {
            JSONObject queryFacetObject = this.m_configObject.getJSONObject(JSON_KEY_QUERY_FACET);
            try {
                List<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem> queries = this.parseFacetQueryItems(queryFacetObject);
                String label = this.parseOptionalStringValue(queryFacetObject, "label");
                Boolean isAndFacet = this.parseOptionalBooleanValue(queryFacetObject, JSON_KEY_FACET_ISANDFACET);
                List<String> preselection = this.parseOptionalStringValues(queryFacetObject, JSON_KEY_FACET_PRESELECTION);
                Boolean ignoreAllFacetFilters = this.parseOptionalBooleanValue(queryFacetObject, JSON_KEY_FACET_IGNOREALLFACETFILTERS);
                return new CmsSearchConfigurationFacetQuery(queries, label, isAndFacet, preselection, ignoreAllFacetFilters);
            }
            catch (JSONException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_QUERY_FACET_MANDATORY_KEY_MISSING_1", JSON_KEY_QUERY_FACET_QUERY), (Throwable)e);
                return null;
            }
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetRange> parseRangeFacets() {
        LinkedHashMap<String, I_CmsSearchConfigurationFacetRange> facetConfigs = new LinkedHashMap<String, I_CmsSearchConfigurationFacetRange>();
        try {
            JSONArray rangeFacets = this.m_configObject.getJSONArray(JSON_KEY_RANGE_FACETS);
            for (int i = 0; i < rangeFacets.length(); ++i) {
                I_CmsSearchConfigurationFacetRange config = this.parseRangeFacet(rangeFacets.getJSONObject(i));
                if (config == null) continue;
                facetConfigs.put(config.getName(), config);
            }
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_FACET_CONFIG_0"), (Throwable)e);
        }
        return facetConfigs;
    }

    @Override
    public I_CmsSearchConfigurationSorting parseSorting() {
        List<I_CmsSearchConfigurationSortOption> options = this.getSortOptions();
        I_CmsSearchConfigurationSortOption defaultOption = options != null && !options.isEmpty() ? options.get(0) : null;
        return new CmsSearchConfigurationSorting(this.getSortParam(), options, defaultOption);
    }

    protected void init(String configString) throws JSONException {
        this.m_configObject = new JSONObject(configString);
    }

    protected I_CmsSearchConfigurationFacetField parseFieldFacet(JSONObject fieldFacetObject) {
        try {
            I_CmsSearchConfigurationFacet.SortOrder order;
            String field = fieldFacetObject.getString("field");
            String name = this.parseOptionalStringValue(fieldFacetObject, JSON_KEY_FACET_NAME);
            String label = this.parseOptionalStringValue(fieldFacetObject, "label");
            Integer minCount = this.parseOptionalIntValue(fieldFacetObject, JSON_KEY_FACET_MINCOUNT);
            Integer limit = this.parseOptionalIntValue(fieldFacetObject, JSON_KEY_FACET_LIMIT);
            String prefix = this.parseOptionalStringValue(fieldFacetObject, JSON_KEY_FACET_PREFIX);
            String sorder = this.parseOptionalStringValue(fieldFacetObject, JSON_KEY_FACET_ORDER);
            try {
                order = I_CmsSearchConfigurationFacet.SortOrder.valueOf(sorder);
            }
            catch (Exception e) {
                order = null;
            }
            String filterQueryModifier = this.parseOptionalStringValue(fieldFacetObject, JSON_KEY_FACET_FILTERQUERYMODIFIER);
            Boolean isAndFacet = this.parseOptionalBooleanValue(fieldFacetObject, JSON_KEY_FACET_ISANDFACET);
            List<String> preselection = this.parseOptionalStringValues(fieldFacetObject, JSON_KEY_FACET_PRESELECTION);
            Boolean ignoreFilterAllFacetFilters = this.parseOptionalBooleanValue(fieldFacetObject, JSON_KEY_FACET_IGNOREALLFACETFILTERS);
            return new CmsSearchConfigurationFacetField(field, name, minCount, limit, prefix, label, order, filterQueryModifier, isAndFacet, preselection, ignoreFilterAllFacetFilters);
        }
        catch (JSONException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_FIELD_FACET_MANDATORY_KEY_MISSING_1", "field"), (Throwable)e);
            return null;
        }
    }

    protected List<String> parseMandatoryStringValues(JSONObject json, String key) throws JSONException {
        ArrayList<String> list = null;
        JSONArray array = json.getJSONArray(key);
        list = new ArrayList<String>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            try {
                String entry = array.getString(i);
                list.add(entry);
                continue;
            }
            catch (JSONException e) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_STRING_ENTRY_UNPARSABLE_1", key), (Throwable)e);
            }
        }
        return list;
    }

    protected Boolean parseOptionalBooleanValue(JSONObject json, String key) {
        try {
            return json.getBoolean(key);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_BOOLEAN_MISSING_1", key), (Throwable)e);
            return null;
        }
    }

    protected Integer parseOptionalIntValue(JSONObject json, String key) {
        try {
            return json.getInt(key);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_INTEGER_MISSING_1", key), (Throwable)e);
            return null;
        }
    }

    protected String parseOptionalStringValue(JSONObject json, String key) {
        try {
            return json.getString(key);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_STRING_MISSING_1", key), (Throwable)e);
            return null;
        }
    }

    protected List<String> parseOptionalStringValues(JSONObject json, String key) {
        List<String> list = null;
        try {
            list = this.parseMandatoryStringValues(json, key);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_STRING_LIST_MISSING_1", key), (Throwable)e);
            return null;
        }
        return list;
    }

    protected I_CmsSearchConfigurationFacetRange parseRangeFacet(JSONObject rangeFacetObject) {
        try {
            String range = rangeFacetObject.getString(JSON_KEY_RANGE_FACET_RANGE);
            String name = this.parseOptionalStringValue(rangeFacetObject, JSON_KEY_FACET_NAME);
            String label = this.parseOptionalStringValue(rangeFacetObject, "label");
            Integer minCount = this.parseOptionalIntValue(rangeFacetObject, JSON_KEY_FACET_MINCOUNT);
            String start = rangeFacetObject.getString(JSON_KEY_RANGE_FACET_START);
            String end = rangeFacetObject.getString(JSON_KEY_RANGE_FACET_END);
            String gap = rangeFacetObject.getString(JSON_KEY_RANGE_FACET_GAP);
            List<String> sother = this.parseOptionalStringValues(rangeFacetObject, JSON_KEY_RANGE_FACET_OTHER);
            Boolean hardEnd = this.parseOptionalBooleanValue(rangeFacetObject, JSON_KEY_RANGE_FACET_HARDEND);
            ArrayList<I_CmsSearchConfigurationFacetRange.Other> other = null;
            if (sother != null) {
                other = new ArrayList<I_CmsSearchConfigurationFacetRange.Other>(sother.size());
                for (String so : sother) {
                    try {
                        I_CmsSearchConfigurationFacetRange.Other o = I_CmsSearchConfigurationFacetRange.Other.valueOf(so);
                        other.add(o);
                    }
                    catch (Exception e) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_INVALID_OTHER_OPTION_1", so), (Throwable)e);
                    }
                }
            }
            Boolean isAndFacet = this.parseOptionalBooleanValue(rangeFacetObject, JSON_KEY_FACET_ISANDFACET);
            List<String> preselection = this.parseOptionalStringValues(rangeFacetObject, JSON_KEY_FACET_PRESELECTION);
            Boolean ignoreAllFacetFilters = this.parseOptionalBooleanValue(rangeFacetObject, JSON_KEY_FACET_IGNOREALLFACETFILTERS);
            return new CmsSearchConfigurationFacetRange(range, start, end, gap, other, hardEnd, name, minCount, label, isAndFacet, preselection, ignoreAllFacetFilters);
        }
        catch (JSONException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_RANGE_FACET_MANDATORY_KEY_MISSING_1", "range, start, end, gap"), (Throwable)e);
            return null;
        }
    }

    private Map<String, String> getAdditionalParameters() {
        HashMap<String, String> result;
        try {
            JSONArray additionalParams = this.m_configObject.getJSONArray(JSON_KEY_ADDITIONAL_PARAMETERS);
            result = new HashMap<String, String>(additionalParams.length());
            for (int i = 0; i < additionalParams.length(); ++i) {
                try {
                    JSONObject currentParam = additionalParams.getJSONObject(i);
                    String param = currentParam.getString(JSON_KEY_ADDITIONAL_PARAMETERS_PARAM);
                    String solrQuery = currentParam.getString(JSON_KEY_ADDITIONAL_PARAMETERS_SOLRQUERY);
                    result.put(param, solrQuery);
                    continue;
                }
                catch (JSONException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_ADDITIONAL_PARAMETER_CONFIG_WRONG_0"), (Throwable)e);
                }
            }
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_ADDITIONAL_PARAMETER_CONFIG_NOT_PARSED_0"), (Throwable)e);
            return new HashMap<String, String>();
        }
        return result;
    }

    private String getCore() {
        try {
            return this.m_configObject.getString(JSON_KEY_CORE);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_CORE_SPECIFIED_0"), (Throwable)e);
            return null;
        }
    }

    private String getExtraSolrParams() {
        try {
            return this.m_configObject.getString(JSON_KEY_EXTRASOLRPARAMS);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_EXTRA_PARAMETERS_0"), (Throwable)e);
            return "";
        }
    }

    private String getFirstCallParam() {
        String param = this.parseOptionalStringValue(this.m_configObject, JSON_KEY_RELOADED_PARAM);
        if (param == null) {
            return DEFAULT_RELOADED_PARAM;
        }
        return param;
    }

    private Boolean getIgnoreExpirationDate() {
        return this.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_IGNORE_EXPIRATION_DATE);
    }

    private Boolean getIgnoreQuery() {
        return this.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_IGNORE_QUERY);
    }

    private Boolean getIgnoreReleaseDate() {
        return this.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_IGNORE_RELEASE_DATE);
    }

    private String getIndex() {
        try {
            return this.m_configObject.getString(JSON_KEY_INDEX);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_INDEX_SPECIFIED_0"), (Throwable)e);
            return null;
        }
    }

    private String getLastQueryParam() {
        String param = this.parseOptionalStringValue(this.m_configObject, JSON_KEY_LAST_QUERYPARAM);
        if (param == null) {
            return DEFAULT_LAST_QUERY_PARAM;
        }
        return param;
    }

    private Integer getPageNavLength() {
        Integer param = this.parseOptionalIntValue(this.m_configObject, JSON_KEY_PAGENAVLENGTH);
        if (param == null) {
            return DEFAULT_PAGENAVLENGTH;
        }
        return param;
    }

    private String getPageParam() {
        String param = this.parseOptionalStringValue(this.m_configObject, JSON_KEY_PAGEPARAM);
        if (param == null) {
            return DEFAULT_PAGE_PARAM;
        }
        return param;
    }

    private Integer getPageSize() {
        try {
            return this.m_configObject.getInt(JSON_KEY_PAGESIZE);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_PAGESIZE_SPECIFIED_0"), (Throwable)e);
            return DEFAULT_PAGE_SIZE;
        }
    }

    private String getQueryModifier() {
        return this.parseOptionalStringValue(this.m_configObject, JSON_KEY_QUERY_MODIFIER);
    }

    private String getQueryParam() {
        String param = this.parseOptionalStringValue(this.m_configObject, JSON_KEY_QUERYPARAM);
        if (param == null) {
            return DEFAULT_QUERY_PARAM;
        }
        return param;
    }

    private Boolean getSearchForEmtpyQuery() {
        return this.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_SEARCH_FOR_EMPTY_QUERY);
    }

    private List<I_CmsSearchConfigurationSortOption> getSortOptions() {
        LinkedList<I_CmsSearchConfigurationSortOption> options = new LinkedList<I_CmsSearchConfigurationSortOption>();
        try {
            JSONArray sortOptions = this.m_configObject.getJSONArray(JSON_KEY_SORTOPTIONS);
            for (int i = 0; i < sortOptions.length(); ++i) {
                I_CmsSearchConfigurationSortOption option = this.parseSortOption(sortOptions.getJSONObject(i));
                if (option == null) continue;
                options.add(option);
            }
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_SORT_CONFIG_0"), (Throwable)e);
        }
        return options;
    }

    private String getSortParam() {
        String param = this.parseOptionalStringValue(this.m_configObject, JSON_KEY_SORTPARAM);
        if (param == null) {
            return DEFAULT_SORT_PARAM;
        }
        return param;
    }

    private I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem parseFacetQueryItem(JSONObject item) {
        String query;
        try {
            query = item.getString(JSON_KEY_QUERY_FACET_QUERY_QUERY);
        }
        catch (JSONException e) {
            return null;
        }
        String label = this.parseOptionalStringValue(item, "label");
        return new CmsSearchConfigurationFacetQuery.CmsFacetQueryItem(query, label);
    }

    private List<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem> parseFacetQueryItems(JSONObject queryFacetObject) throws JSONException {
        JSONArray items = queryFacetObject.getJSONArray(JSON_KEY_QUERY_FACET_QUERY);
        ArrayList<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem> result = new ArrayList<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem>(items.length());
        for (int i = 0; i < items.length(); ++i) {
            I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem item = this.parseFacetQueryItem(items.getJSONObject(i));
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    private I_CmsSearchConfigurationSortOption parseSortOption(JSONObject json) {
        try {
            String solrValue = json.getString(JSON_KEY_SORTOPTION_SOLRVALUE);
            String paramValue = this.parseOptionalStringValue(json, JSON_KEY_SORTOPTION_PARAMVALUE);
            paramValue = paramValue == null ? solrValue : paramValue;
            String label = this.parseOptionalStringValue(json, "label");
            label = label == null ? paramValue : label;
            return new CmsSearchConfigurationSortOption(label, paramValue, solrValue);
        }
        catch (JSONException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_SORT_OPTION_NOT_PARSABLE_1", JSON_KEY_SORTOPTION_SOLRVALUE), (Throwable)e);
            return null;
        }
    }
}

