/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.Map;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.controller.I_CmsSearchControllerHighlighting;
import org.opencms.search.solr.CmsSolrQuery;

public class CmsSearchControllerHighlighting
implements I_CmsSearchControllerHighlighting {
    private final I_CmsSearchConfigurationHighlighting m_config;

    public CmsSearchControllerHighlighting(I_CmsSearchConfigurationHighlighting config) {
        this.m_config = config;
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
    }

    @Override
    public void addQueryParts(CmsSolrQuery query) {
        query.set("hl", new String[]{"true"});
        query.set("hl.fl", new String[]{this.m_config.getHightlightField()});
        if (this.m_config.getSnippetsCount() != null) {
            query.set("hl.snippets", new String[]{this.m_config.getSnippetsCount().toString()});
        }
        if (this.m_config.getFragSize() != null) {
            query.set("hl.fragsize", new String[]{this.m_config.getFragSize().toString()});
        }
        if (this.m_config.getAlternateHighlightField() != null) {
            query.set("hl.alternateField", new String[]{this.m_config.getAlternateHighlightField()});
        }
        if (this.m_config.getMaxAlternateHighlightFieldLength() != null) {
            query.set("hl.maxAlternateFieldLength", new String[]{this.m_config.getMaxAlternateHighlightFieldLength().toString()});
        }
        if (this.m_config.getSimplePre() != null) {
            query.set("hl.simple.pre", new String[]{this.m_config.getSimplePre()});
        }
        if (this.m_config.getSimplePost() != null) {
            query.set("hl.simple.post", new String[]{this.m_config.getSimplePost()});
        }
        if (this.m_config.getFormatter() != null) {
            query.set("hl.formatter", new String[]{this.m_config.getFormatter()});
        }
        if (this.m_config.getFragmenter() != null) {
            query.set("hl.fragmenter", new String[]{this.m_config.getFragmenter()});
        }
        if (this.m_config.getUseFastVectorHighlighting() != null) {
            query.set("hl.useFastVectorHighlighting", new String[]{this.m_config.getUseFastVectorHighlighting().toString()});
        }
    }

    @Override
    public I_CmsSearchConfigurationHighlighting getConfig() {
        return this.m_config;
    }

    @Override
    public void updateForQueryChange() {
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean isReloaded) {
    }
}

