/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.result;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetField;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetQuery;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetRange;
import org.opencms.jsp.search.result.I_CmsSearchResultWrapper;
import org.opencms.jsp.search.result.I_CmsSearchStateParameters;
import org.opencms.jsp.search.result.Messages;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsCollectionsGenericWrapper;

public class CmsSearchStateParameters
implements I_CmsSearchStateParameters {
    protected static final Log LOG = CmsLog.getLog(CmsSearchStateParameters.class);
    Map<String, String[]> m_params;
    I_CmsSearchResultWrapper m_result;
    Map<String, I_CmsSearchStateParameters> m_paginationMap;
    Map<String, I_CmsSearchStateParameters> m_sortingMap;
    Map<String, I_CmsSearchStateParameters> m_resetFacetMap;
    Map<String, I_CmsSearchStateParameters> m_ignoreLimitFacetMap;
    Map<String, I_CmsSearchStateParameters> m_newQueryMap;
    Map<String, I_CmsSearchStateParameters> m_respectLimitFacetMap;
    Map<String, Map<String, I_CmsSearchStateParameters>> m_uncheckFacetMap;
    Map<String, Map<String, I_CmsSearchStateParameters>> m_checkFacetMap;

    CmsSearchStateParameters(I_CmsSearchResultWrapper result, Map<String, String[]> params) {
        this.m_params = params;
        this.m_result = result;
    }

    public static String paramMapToString(Map<String, String[]> parameters) {
        StringBuffer result = new StringBuffer();
        for (String key : parameters.keySet()) {
            String[] values = parameters.get(key);
            if (null == values) {
                result.append(key).append('&');
                continue;
            }
            for (String value : parameters.get(key)) {
                result.append(key).append('=').append(value).append('&');
            }
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    @Override
    public Map<String, I_CmsSearchStateParameters> getAddIgnoreFacetLimit() {
        if (this.m_ignoreLimitFacetMap == null) {
            this.m_ignoreLimitFacetMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object facet) {
                    HashMap<String, String[]> parameters = new HashMap<String, String[]>(CmsSearchStateParameters.this.m_params);
                    String facetParamKey = null;
                    try {
                        facetParamKey = CmsSearchStateParameters.this.m_result.getController().getFieldFacets().getFieldFacetController().get(facet).getConfig().getIgnoreMaxParamKey();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_FACET_NOT_CONFIGURED_1", facet), (Throwable)e);
                    }
                    if (facetParamKey != null && !parameters.containsKey(facetParamKey)) {
                        parameters.put(facetParamKey, null);
                    }
                    return new CmsSearchStateParameters(CmsSearchStateParameters.this.m_result, parameters);
                }
            });
        }
        return this.m_ignoreLimitFacetMap;
    }

    @Override
    public Map<String, Map<String, I_CmsSearchStateParameters>> getCheckFacetItem() {
        if (this.m_uncheckFacetMap == null) {
            this.m_uncheckFacetMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(final Object facet) {
                    Map m_uncheckEntries = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                        public Object transform(Object facetItem) {
                            HashMap<String, String[]> parameters = new HashMap<String, String[]>(CmsSearchStateParameters.this.m_params);
                            String facetParamKey = null;
                            try {
                                facetParamKey = CmsSearchStateParameters.this.getFacetParamKey((String)facet);
                            }
                            catch (Exception e) {
                                LOG.warn((Object)Messages.get().getBundle().key("LOG_FACET_NOT_CONFIGURED_1", facet), (Throwable)e);
                            }
                            if (facetParamKey != null) {
                                if (parameters.containsKey(facetParamKey)) {
                                    String[] values = (String[])parameters.get(facetParamKey);
                                    Arrays.asList(values).contains(facetItem);
                                    if (Arrays.asList(values).contains(facetItem)) {
                                        String[] newValues = new String[Arrays.asList(values).size() + 1];
                                        boolean j = false;
                                        for (int i = 0; i < values.length; ++i) {
                                            newValues[i] = values[i];
                                        }
                                        newValues[values.length] = (String)facetItem;
                                        parameters.put(facetParamKey, newValues);
                                    }
                                } else {
                                    parameters.put(facetParamKey, new String[]{(String)facetItem});
                                }
                            }
                            return new CmsSearchStateParameters(CmsSearchStateParameters.this.m_result, parameters);
                        }
                    });
                    return m_uncheckEntries;
                }
            });
        }
        return this.m_uncheckFacetMap;
    }

    @Override
    public Map<String, I_CmsSearchStateParameters> getNewQuery() {
        if (this.m_newQueryMap == null) {
            this.m_newQueryMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object queryString) {
                    HashMap<String, String[]> parameters = new HashMap<String, String[]>(CmsSearchStateParameters.this.m_params);
                    String queryKey = CmsSearchStateParameters.this.m_result.getController().getCommon().getConfig().getQueryParam();
                    if (parameters.containsKey(queryKey)) {
                        parameters.remove(queryKey);
                    }
                    parameters.put(queryKey, new String[]{(String)queryString});
                    return new CmsSearchStateParameters(CmsSearchStateParameters.this.m_result, parameters);
                }
            });
        }
        return this.m_newQueryMap;
    }

    @Override
    public Map<String, I_CmsSearchStateParameters> getRemoveIgnoreFacetLimit() {
        if (this.m_ignoreLimitFacetMap == null) {
            this.m_ignoreLimitFacetMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object facet) {
                    HashMap<String, String[]> parameters = new HashMap<String, String[]>(CmsSearchStateParameters.this.m_params);
                    String facetParamKey = null;
                    try {
                        facetParamKey = CmsSearchStateParameters.this.m_result.getController().getFieldFacets().getFieldFacetController().get(facet).getConfig().getIgnoreMaxParamKey();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_FACET_NOT_CONFIGURED_1", facet), (Throwable)e);
                    }
                    if (facetParamKey != null && parameters.containsKey(facetParamKey)) {
                        parameters.remove(facetParamKey);
                    }
                    return new CmsSearchStateParameters(CmsSearchStateParameters.this.m_result, parameters);
                }
            });
        }
        return this.m_ignoreLimitFacetMap;
    }

    @Override
    public I_CmsSearchStateParameters getResetAllFacetStates() {
        String facetParamKey;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>(this.m_params);
        Collection<I_CmsSearchControllerFacetField> fieldFacets = this.m_result.getController().getFieldFacets().getFieldFacetControllers();
        for (I_CmsSearchControllerFacetField i_CmsSearchControllerFacetField : fieldFacets) {
            facetParamKey = i_CmsSearchControllerFacetField.getConfig().getParamKey();
            if (!parameters.containsKey(facetParamKey)) continue;
            parameters.remove(facetParamKey);
        }
        Collection<I_CmsSearchControllerFacetRange> rangeFacets = this.m_result.getController().getRangeFacets().getRangeFacetControllers();
        for (I_CmsSearchControllerFacetRange facet3 : rangeFacets) {
            String facetParamKey2 = facet3.getConfig().getParamKey();
            if (!parameters.containsKey(facetParamKey2)) continue;
            parameters.remove(facetParamKey2);
        }
        I_CmsSearchControllerFacetQuery i_CmsSearchControllerFacetQuery = this.m_result.getController().getQueryFacet();
        if (null != i_CmsSearchControllerFacetQuery && parameters.containsKey(facetParamKey = i_CmsSearchControllerFacetQuery.getConfig().getParamKey())) {
            parameters.remove(facetParamKey);
        }
        return new CmsSearchStateParameters(this.m_result, parameters);
    }

    @Override
    public Map<String, I_CmsSearchStateParameters> getResetFacetState() {
        if (this.m_resetFacetMap == null) {
            this.m_resetFacetMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object facet) {
                    HashMap<String, String[]> parameters = new HashMap<String, String[]>(CmsSearchStateParameters.this.m_params);
                    String facetParamKey = CmsSearchStateParameters.this.getFacetParamKey((String)facet);
                    if (facetParamKey != null && parameters.containsKey(facetParamKey)) {
                        parameters.remove(facetParamKey);
                    }
                    return new CmsSearchStateParameters(CmsSearchStateParameters.this.m_result, parameters);
                }
            });
        }
        return this.m_resetFacetMap;
    }

    @Override
    public Map<String, I_CmsSearchStateParameters> getSetPage() {
        if (this.m_paginationMap == null) {
            this.m_paginationMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object page) {
                    HashMap<String, String[]> parameters = new HashMap<String, String[]>(CmsSearchStateParameters.this.m_params);
                    parameters.put(CmsSearchStateParameters.this.m_result.getController().getPagination().getConfig().getPageParam(), new String[]{(String)page});
                    return new CmsSearchStateParameters(CmsSearchStateParameters.this.m_result, parameters);
                }
            });
        }
        return this.m_paginationMap;
    }

    @Override
    public Map<String, I_CmsSearchStateParameters> getSetSortOption() {
        if (this.m_sortingMap == null) {
            this.m_sortingMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object sortOption) {
                    HashMap<String, String[]> parameters = new HashMap<String, String[]>(CmsSearchStateParameters.this.m_params);
                    CmsSearchStateParameters.this.m_result.getController().addParametersForCurrentState(parameters);
                    parameters.put(CmsSearchStateParameters.this.m_result.getController().getSorting().getConfig().getSortParam(), new String[]{(String)sortOption});
                    return new CmsSearchStateParameters(CmsSearchStateParameters.this.m_result, parameters);
                }
            });
        }
        return this.m_sortingMap;
    }

    @Override
    public Map<String, Map<String, I_CmsSearchStateParameters>> getUncheckFacetItem() {
        if (this.m_checkFacetMap == null) {
            this.m_checkFacetMap = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(final Object facet) {
                    Map m_checkEntries = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                        public Object transform(Object facetItem) {
                            HashMap<String, String[]> parameters = new HashMap<String, String[]>(CmsSearchStateParameters.this.m_params);
                            String facetParamKey = CmsSearchStateParameters.this.getFacetParamKey((String)facet);
                            if (facetParamKey != null && parameters.containsKey(facetParamKey)) {
                                String[] values = (String[])parameters.get(facetParamKey);
                                List<String> valueList = Arrays.asList(values);
                                String item = (String)facetItem;
                                if (valueList.contains(facetItem)) {
                                    String[] newValues = new String[valueList.size() - 1];
                                    int i = 0;
                                    for (String value : valueList) {
                                        if (value == item) continue;
                                        newValues[i++] = value;
                                    }
                                    parameters.put(facetParamKey, newValues);
                                }
                            }
                            return new CmsSearchStateParameters(CmsSearchStateParameters.this.m_result, parameters);
                        }
                    });
                    return m_checkEntries;
                }
            });
        }
        return this.m_checkFacetMap;
    }

    public String toString() {
        return CmsSearchStateParameters.paramMapToString(this.m_params);
    }

    String getFacetParamKey(String facet) {
        I_CmsSearchControllerFacetField fieldFacet = this.m_result.getController().getFieldFacets().getFieldFacetController().get(facet);
        if (fieldFacet != null) {
            return fieldFacet.getConfig().getParamKey();
        }
        I_CmsSearchControllerFacetRange rangeFacet = this.m_result.getController().getRangeFacets().getRangeFacetController().get(facet);
        if (rangeFacet != null) {
            return rangeFacet.getConfig().getParamKey();
        }
        I_CmsSearchControllerFacetQuery queryFacet = this.m_result.getController().getQueryFacet();
        if (queryFacet != null && queryFacet.getConfig().getName().equals(facet)) {
            return queryFacet.getConfig().getParamKey();
        }
        LOG.warn((Object)Messages.get().getBundle().key("LOG_FACET_NOT_CONFIGURED_1", facet), new Throwable());
        return null;
    }
}

