/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.opencms.ade.contenteditor.CmsContentService;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.util.CmsJspCategoryAccessBean;
import org.opencms.jsp.util.CmsJspContentAccessValueWrapper;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.jsp.util.CmsJspVfsAccessBean;
import org.opencms.jsp.util.Messages;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsConstantMap;
import org.opencms.util.CmsUUID;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.page.CmsXmlPageFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsJspContentAccessBean {
    protected static final Map<String, CmsJspContentAccessValueWrapper> CONSTANT_NULL_VALUE_WRAPPER_MAP = new CmsConstantMap<String, CmsJspContentAccessValueWrapper>(CmsJspContentAccessValueWrapper.NULL_VALUE_WRAPPER);
    private CmsObject m_cms;
    private I_CmsXmlDocument m_content;
    private Map<String, Boolean> m_hasLocale;
    private Map<String, Map<String, Boolean>> m_hasLocaleValue;
    private Map<String, String> m_imageDnd;
    private Locale m_locale;
    private Map<String, List<String>> m_localeNames;
    private Map<String, Map<String, String>> m_localeRdfa;
    private Map<String, Map<String, List<CmsJspContentAccessValueWrapper>>> m_localeSubValueList;
    private Map<String, Map<String, CmsJspContentAccessValueWrapper>> m_localeValue;
    private Map<String, Map<String, List<CmsJspContentAccessValueWrapper>>> m_localeValueList;
    private Locale m_requestedLocale;
    private CmsResource m_resource;
    private CmsJspCategoryAccessBean m_categories;

    public CmsJspContentAccessBean() {
    }

    public CmsJspContentAccessBean(CmsObject cms, CmsResource resource) {
        this(cms, cms.getRequestContext().getLocale(), resource);
    }

    public CmsJspContentAccessBean(CmsObject cms, Locale locale, CmsResource resource) {
        this.init(cms, locale, null, resource);
    }

    public CmsJspContentAccessBean(CmsObject cms, Locale locale, I_CmsXmlDocument content) {
        this.init(cms, locale, content, content.getFile());
    }

    protected static String createImageDndAttr(CmsUUID structureId, String imagePath, String locale) {
        String attrValue = structureId + "|" + imagePath + "|" + locale;
        String escapedAttrValue = CmsEncoder.escapeXml(attrValue);
        return "data-imagednd=\"" + escapedAttrValue + "\"";
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public CmsFile getFile() {
        return this.getRawContent().getFile();
    }

    public String getFilename() {
        return this.m_cms.getSitePath(this.getRawContent().getFile());
    }

    public Map<String, Boolean> getHasLocale() {
        if (this.m_hasLocale == null) {
            this.m_hasLocale = CmsCollectionsGenericWrapper.createLazyMap(new CmsHasLocaleTransformer());
        }
        return this.m_hasLocale;
    }

    public Map<String, Map<String, Boolean>> getHasLocaleValue() {
        if (this.m_hasLocaleValue == null) {
            this.m_hasLocaleValue = CmsCollectionsGenericWrapper.createLazyMap(new CmsHasLocaleValueTransformer());
        }
        return this.m_hasLocaleValue;
    }

    public Map<String, Boolean> getHasValue() {
        return this.getHasLocaleValue().get(this.getLocale());
    }

    public CmsUUID getId() {
        return this.getRawContent().getFile().getStructureId();
    }

    public Map<String, String> getImageDnd() {
        if (this.m_imageDnd == null) {
            this.m_imageDnd = CmsCollectionsGenericWrapper.createLazyMap(new CmsImageDndTransformer());
        }
        return this.m_imageDnd;
    }

    public boolean getIsEditable() {
        boolean result = false;
        try {
            CmsLock lock;
            CmsObject cms;
            if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                cms = OpenCms.initCmsObject(this.m_cms);
                List<CmsProject> projects = OpenCms.getOrgUnitManager().getAllAccessibleProjects(cms, cms.getRequestContext().getOuFqn(), false);
                if (projects != null && projects.size() > 0) {
                    for (CmsProject p : projects) {
                        if (p.isOnlineProject()) continue;
                        cms.getRequestContext().setCurrentProject(p);
                        break;
                    }
                }
            } else {
                cms = this.m_cms;
            }
            if ((result = cms.hasPermissions(this.m_resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) && !(lock = cms.getLock(this.m_resource)).isLockableBy(cms.getRequestContext().getCurrentUser())) {
                result = false;
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return result;
    }

    public Locale getLocale() {
        if (this.m_locale == null) {
            this.getRawContent();
        }
        return this.m_locale;
    }

    public Map<String, List<String>> getLocaleNames() {
        if (this.m_localeNames == null) {
            this.m_localeNames = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleNamesTransformer());
        }
        return this.m_localeNames;
    }

    public Map<String, Map<String, String>> getLocaleRdfa() {
        if (this.m_localeRdfa == null) {
            this.m_localeRdfa = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleRdfaTransformer());
        }
        return this.m_localeRdfa;
    }

    public Map<String, Map<String, List<CmsJspContentAccessValueWrapper>>> getLocaleSubValueList() {
        if (this.m_localeSubValueList == null) {
            this.m_localeSubValueList = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleSubValueListTransformer());
        }
        return this.m_localeSubValueList;
    }

    public Map<String, Map<String, CmsJspContentAccessValueWrapper>> getLocaleValue() {
        if (this.m_localeValue == null) {
            this.m_localeValue = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleValueTransformer());
        }
        return this.m_localeValue;
    }

    public Map<String, Map<String, List<CmsJspContentAccessValueWrapper>>> getLocaleValueList() {
        if (this.m_localeValueList == null) {
            this.m_localeValueList = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleValueListTransformer());
        }
        return this.m_localeValueList;
    }

    public List<String> getNames() {
        return this.getLocaleNames().get(this.getLocale());
    }

    public I_CmsXmlDocument getRawContent() {
        if (this.m_content == null) {
            try {
                CmsFile file = this.m_cms.readFile(this.m_resource);
                this.m_content = CmsResourceTypeXmlPage.isXmlPage(file) ? CmsXmlPageFactory.unmarshal(this.m_cms, file) : CmsXmlContentFactory.unmarshal(this.m_cms, file);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_XML_CONTENT_UNMARSHAL_1", this.m_resource.getRootPath()), (Throwable)e);
            }
        }
        if (this.m_locale == null) {
            this.m_locale = OpenCms.getLocaleManager().getBestMatchingLocale(this.m_requestedLocale, OpenCms.getLocaleManager().getDefaultLocales(this.m_cms, this.m_cms.getRequestContext().getUri()), this.m_content.getLocales());
        }
        return this.m_content;
    }

    public Map<String, String> getRdfa() {
        return this.getLocaleRdfa().get(this.getLocale());
    }

    public CmsJspCategoryAccessBean getReadCategories() {
        if (null == this.m_categories) {
            this.m_categories = this.readCategories();
        }
        return this.m_categories;
    }

    public Map<String, List<CmsJspContentAccessValueWrapper>> getSubValueList() {
        return this.getLocaleSubValueList().get(this.getLocale());
    }

    public Map<String, CmsJspContentAccessValueWrapper> getValue() {
        return this.getLocaleValue().get(this.getLocale());
    }

    public Map<String, List<CmsJspContentAccessValueWrapper>> getValueList() {
        return this.getLocaleValueList().get(this.getLocale());
    }

    public CmsJspVfsAccessBean getVfs() {
        return CmsJspVfsAccessBean.create(this.m_cms);
    }

    public void init(CmsObject cms, Locale locale, I_CmsXmlDocument content, CmsResource resource) {
        this.m_cms = cms;
        this.m_requestedLocale = locale;
        this.m_content = content;
        this.m_resource = resource;
    }

    private CmsJspCategoryAccessBean readCategories() {
        return new CmsJspCategoryAccessBean(this.getCmsObject(), this.m_resource);
    }

    public class CmsValueTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsValueTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            I_CmsXmlContentValue value = CmsJspContentAccessBean.this.getRawContent().getValue(String.valueOf(input), this.m_selectedLocale);
            return CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessBean.this.getCmsObject(), value, CmsJspContentAccessBean.this.getRawContent(), (String)input, this.m_selectedLocale);
        }
    }

    public class CmsValueListTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsValueListTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            List<I_CmsXmlContentValue> values = CmsJspContentAccessBean.this.getRawContent().getValues(String.valueOf(input), this.m_selectedLocale);
            ArrayList<CmsJspContentAccessValueWrapper> result = new ArrayList<CmsJspContentAccessValueWrapper>();
            for (I_CmsXmlContentValue value : values) {
                result.add(CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessBean.this.getCmsObject(), value, null, null));
            }
            return result;
        }
    }

    public class CmsSubValueListTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsSubValueListTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            List<I_CmsXmlContentValue> values = CmsJspContentAccessBean.this.getRawContent().getSubValues(String.valueOf(input), this.m_selectedLocale);
            ArrayList<CmsJspContentAccessValueWrapper> result = new ArrayList<CmsJspContentAccessValueWrapper>();
            for (I_CmsXmlContentValue value : values) {
                result.add(CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessBean.this.getCmsObject(), value, null, null));
            }
            return result;
        }
    }

    public class CmsRdfaTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsRdfaTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            if (CmsJspContentAccessValueWrapper.isDirectEditEnabled(CmsJspContentAccessBean.this.getCmsObject())) {
                return CmsContentService.getRdfaAttributes(CmsJspContentAccessBean.this.getRawContent(), this.m_selectedLocale, String.valueOf(input));
            }
            return "";
        }
    }

    public class CmsLocaleValueTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsLocaleManager.getLocale(String.valueOf(input));
            Map<String, CmsJspContentAccessValueWrapper> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsValueTransformer(locale)) : CONSTANT_NULL_VALUE_WRAPPER_MAP;
            return result;
        }
    }

    public class CmsLocaleValueListTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsJspElFunctions.convertLocale(input);
            Map<String, List<CmsJspContentAccessValueWrapper>> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsValueListTransformer(locale)) : CmsConstantMap.CONSTANT_EMPTY_LIST_MAP;
            return result;
        }
    }

    public class CmsLocaleSubValueListTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsJspElFunctions.convertLocale(input);
            Map<String, List<CmsJspContentAccessValueWrapper>> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsSubValueListTransformer(locale)) : CmsConstantMap.CONSTANT_EMPTY_LIST_MAP;
            return result;
        }
    }

    public class CmsLocaleRdfaTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsLocaleManager.getLocale(String.valueOf(input));
            Map<String, String> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsRdfaTransformer(locale)) : CmsConstantMap.CONSTANT_EMPTY_STRING_MAP;
            return result;
        }
    }

    public class CmsLocaleNamesTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsLocaleManager.getLocale(String.valueOf(input));
            return CmsJspContentAccessBean.this.getRawContent().getNames(locale);
        }
    }

    public class CmsImageDndTransformer
    implements Transformer {
        public Object transform(Object input) {
            String result = CmsJspContentAccessValueWrapper.isDirectEditEnabled(CmsJspContentAccessBean.this.getCmsObject()) ? CmsJspContentAccessBean.createImageDndAttr(CmsJspContentAccessBean.this.getRawContent().getFile().getStructureId(), String.valueOf(input), String.valueOf(CmsJspContentAccessBean.this.getLocale())) : "";
            return result;
        }
    }

    public class CmsHasValueTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsHasValueTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            return CmsJspContentAccessBean.this.getRawContent().hasValue(String.valueOf(input), this.m_selectedLocale);
        }
    }

    public class CmsHasLocaleValueTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsJspElFunctions.convertLocale(input);
            Map<String, Boolean> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsHasValueTransformer(locale)) : CmsConstantMap.CONSTANT_BOOLEAN_FALSE_MAP;
            return result;
        }
    }

    public class CmsHasLocaleTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspContentAccessBean.this.getRawContent().hasLocale(CmsJspElFunctions.convertLocale(input));
        }
    }
}

