/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsLocaleGroup;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.jsp.util.CmsJspValueTransformers;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsCollectionsGenericWrapper;

public final class CmsJspVfsAccessBean {
    public static final String ATTRIBUTE_VFS_ACCESS_BEAN = CmsJspVfsAccessBean.class.getName() + ".VFS_ACCESS_BEAN";
    private static final Log LOG = CmsLog.getLog(CmsJspVfsAccessBean.class);
    protected CmsObject m_cms;
    private Map<String, Boolean> m_existsResource;
    private Map<String, Boolean> m_existsXml;
    private Map<String, String> m_links;
    private Map<String, CmsPermissionSet> m_permissions;
    private Map<String, Map<String, String>> m_properties;
    private Map<String, Map<String, Map<String, String>>> m_propertiesLocale;
    private Map<String, Map<String, String>> m_propertiesSearch;
    private Map<String, Map<String, Map<String, String>>> m_propertiesSearchLocale;
    private Map<String, List<Locale>> m_availableLocales;
    private Map<String, CmsResource> m_resources;
    private Map<String, CmsJspContentAccessBean> m_xmlContent;

    private CmsJspVfsAccessBean(CmsObject cms) {
        this.m_cms = cms;
    }

    public static CmsJspVfsAccessBean create(CmsObject cms) {
        CmsJspVfsAccessBean result;
        Object attribute = cms.getRequestContext().getAttribute(ATTRIBUTE_VFS_ACCESS_BEAN);
        if (attribute != null) {
            result = (CmsJspVfsAccessBean)attribute;
        } else {
            result = new CmsJspVfsAccessBean(cms);
            cms.getRequestContext().setAttribute(ATTRIBUTE_VFS_ACCESS_BEAN, result);
        }
        return result;
    }

    public Map<String, List<Locale>> getAvailableLocales() {
        if (this.m_availableLocales == null) {
            this.m_availableLocales = CmsCollectionsGenericWrapper.createLazyMap(new CmsAvailableLocaleLoaderTransformer());
        }
        return this.m_availableLocales;
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public CmsRequestContext getContext() {
        return this.getRequestContext();
    }

    public CmsProject getCurrentProject() {
        return this.m_cms.getRequestContext().getCurrentProject();
    }

    public CmsUser getCurrentUser() {
        return this.m_cms.getRequestContext().getCurrentUser();
    }

    public Map<String, Boolean> getExists() {
        return this.getExistsResource();
    }

    public Map<String, Boolean> getExistsResource() {
        if (this.m_existsResource == null) {
            this.m_existsResource = CmsCollectionsGenericWrapper.createLazyMap(new CmsExistsResourceTransformer());
        }
        return this.m_existsResource;
    }

    public Map<String, Boolean> getExistsXml() {
        if (this.m_existsXml == null) {
            this.m_existsXml = CmsCollectionsGenericWrapper.createLazyMap(new CmsExistsXmlTransformer());
        }
        return this.m_existsXml;
    }

    public boolean getFlushCaches() {
        this.m_resources = null;
        this.m_properties = null;
        this.m_propertiesSearch = null;
        return true;
    }

    public Map<String, String> getLink() {
        if (this.m_links == null) {
            this.m_links = CmsCollectionsGenericWrapper.createLazyMap(new CmsVfsLinkTransformer());
        }
        return this.m_links;
    }

    public Map<String, Map<String, CmsJspResourceWrapper>> getLocaleResource() {
        return CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

            public Object transform(Object arg) {
                if (!(arg instanceof String)) {
                    return new HashMap();
                }
                String path = (String)arg;
                try {
                    CmsResource res = CmsJspVfsAccessBean.this.m_cms.readResource(path);
                    CmsJspResourceWrapper wrapper = new CmsJspResourceWrapper(CmsJspVfsAccessBean.this.m_cms, res);
                    return wrapper.getLocaleResource();
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return new HashMap();
                }
            }
        });
    }

    public Map<String, Locale> getMainLocale() {
        return CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

            public Object transform(Object arg) {
                if (!(arg instanceof String)) {
                    return null;
                }
                String path = (String)arg;
                try {
                    CmsResource res = CmsJspVfsAccessBean.this.m_cms.readResource(path);
                    CmsLocaleGroup localeGroup = CmsJspVfsAccessBean.this.m_cms.getLocaleGroupService().readLocaleGroup(res);
                    return localeGroup.getMainLocale();
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            }
        });
    }

    public Map<String, CmsPermissionSet> getPermissions() {
        return this.getReadPermissions();
    }

    public Map<String, Map<String, String>> getProperty() {
        return this.getReadProperties();
    }

    public Map<String, Map<String, Map<String, String>>> getPropertyLocale() {
        return this.getReadPropertiesLocale();
    }

    public Map<String, Map<String, String>> getPropertySearch() {
        return this.getReadPropertiesSearch();
    }

    public Map<String, Map<String, Map<String, String>>> getPropertySearchLocale() {
        return this.getReadPropertiesSearchLocale();
    }

    public Map<String, CmsPermissionSet> getReadPermissions() {
        if (this.m_permissions == null) {
            this.m_permissions = CmsCollectionsGenericWrapper.createLazyMap(new CmsPermissionsLoaderTransformer());
        }
        return this.m_permissions;
    }

    public Map<String, Map<String, String>> getReadProperties() {
        if (this.m_properties == null) {
            this.m_properties = CmsCollectionsGenericWrapper.createLazyMap(new CmsResourcePropertyLoaderTransformer(false));
        }
        return this.m_properties;
    }

    public Map<String, Map<String, Map<String, String>>> getReadPropertiesLocale() {
        if (this.m_propertiesLocale == null) {
            this.m_propertiesLocale = CmsCollectionsGenericWrapper.createLazyMap(new CmsResourceLocalePropertyLoaderTransformer(false));
        }
        return this.m_propertiesLocale;
    }

    public Map<String, Map<String, String>> getReadPropertiesSearch() {
        if (this.m_propertiesSearch == null) {
            this.m_propertiesSearch = CmsCollectionsGenericWrapper.createLazyMap(new CmsResourcePropertyLoaderTransformer(true));
        }
        return this.m_propertiesSearch;
    }

    public Map<String, Map<String, Map<String, String>>> getReadPropertiesSearchLocale() {
        if (this.m_propertiesSearchLocale == null) {
            this.m_propertiesSearchLocale = CmsCollectionsGenericWrapper.createLazyMap(new CmsResourceLocalePropertyLoaderTransformer(true));
        }
        return this.m_propertiesSearchLocale;
    }

    public Map<String, CmsResource> getReadResource() {
        if (this.m_resources == null) {
            this.m_resources = CmsCollectionsGenericWrapper.createLazyMap(new CmsResourceLoaderTransformer());
        }
        return this.m_resources;
    }

    public Map<String, CmsJspContentAccessBean> getReadXml() {
        if (this.m_xmlContent == null) {
            this.m_xmlContent = CmsCollectionsGenericWrapper.createLazyMap(new CmsXmlContentAccessTransformer());
        }
        return this.m_xmlContent;
    }

    public CmsRequestContext getRequestContext() {
        return this.m_cms.getRequestContext();
    }

    public Map<String, CmsResource> getResource() {
        return this.getReadResource();
    }

    public Map<String, CmsJspContentAccessBean> getXml() {
        return this.getReadXml();
    }

    public class CmsXmlContentAccessTransformer
    implements Transformer {
        public Object transform(Object input) {
            CmsJspContentAccessBean result = null;
            CmsResource resource = CmsJspVfsAccessBean.this.getReadResource().get(input);
            if (resource != null && (CmsResourceTypeXmlPage.isXmlPage(resource) || CmsResourceTypeXmlContent.isXmlContent(resource))) {
                result = new CmsJspContentAccessBean(CmsJspVfsAccessBean.this.getCmsObject(), resource);
            }
            return result;
        }
    }

    public class CmsVfsLinkTransformer
    implements Transformer {
        public Object transform(Object input) {
            return OpenCms.getLinkManager().substituteLink(CmsJspVfsAccessBean.this.getCmsObject(), CmsLinkManager.getAbsoluteUri(String.valueOf(input), CmsJspVfsAccessBean.this.getCmsObject().getRequestContext().getUri()));
        }
    }

    public class CmsResourcePropertyLoaderTransformer
    implements Transformer {
        private boolean m_search;

        public CmsResourcePropertyLoaderTransformer(boolean search) {
            this.m_search = search;
        }

        public Object transform(Object input) {
            Map result = null;
            CmsResource resource = CmsJspVfsAccessBean.this.getReadResource().get(input);
            if (resource != null) {
                result = CmsCollectionsGenericWrapper.createLazyMap(new CmsJspValueTransformers.CmsPropertyLoaderTransformer(CmsJspVfsAccessBean.this.getCmsObject(), resource, this.m_search));
            }
            return result == null ? Collections.EMPTY_MAP : result;
        }
    }

    public class CmsResourceLocalePropertyLoaderTransformer
    implements Transformer {
        private boolean m_search;

        public CmsResourceLocalePropertyLoaderTransformer(boolean search) {
            this.m_search = search;
        }

        public Object transform(Object input) {
            Map result = null;
            CmsResource resource = CmsJspVfsAccessBean.this.getReadResource().get(input);
            if (resource != null) {
                result = CmsCollectionsGenericWrapper.createLazyMap(new CmsJspValueTransformers.CmsLocalePropertyLoaderTransformer(CmsJspVfsAccessBean.this.getCmsObject(), resource, this.m_search));
            }
            return result == null ? Collections.EMPTY_MAP : result;
        }
    }

    public class CmsResourceLoaderTransformer
    implements Transformer {
        public Object transform(Object input) {
            CmsResource result;
            try {
                result = CmsJspElFunctions.convertResource(CmsJspVfsAccessBean.this.getCmsObject(), input);
            }
            catch (CmsException e) {
                result = null;
            }
            return result;
        }
    }

    public class CmsPropertyLoaderSingleTransformer
    implements Transformer {
        private CmsResource m_resource;
        private boolean m_search;

        public CmsPropertyLoaderSingleTransformer(CmsResource resource, boolean search) {
            this.m_resource = resource;
            this.m_search = search;
        }

        public Object transform(Object input) {
            String result;
            try {
                result = CmsJspVfsAccessBean.this.getCmsObject().readPropertyObject(this.m_resource, String.valueOf(input), this.m_search).getValue();
            }
            catch (CmsException e) {
                result = null;
            }
            return result;
        }
    }

    public class CmsPermissionsLoaderTransformer
    implements Transformer {
        public Object transform(Object input) {
            CmsPermissionSet result;
            try {
                result = CmsJspVfsAccessBean.this.getCmsObject().getPermissions((String)input);
            }
            catch (CmsException e) {
                result = null;
            }
            return result;
        }
    }

    public class CmsExistsXmlTransformer
    implements Transformer {
        public Object transform(Object input) {
            CmsResource resource = CmsJspVfsAccessBean.this.getReadResource().get(input);
            return resource != null && (CmsResourceTypeXmlPage.isXmlPage(resource) || CmsResourceTypeXmlContent.isXmlContent(resource));
        }
    }

    public class CmsExistsResourceTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspVfsAccessBean.this.getReadResource().get(input) != null;
        }
    }

    public class CmsAvailableLocaleLoaderTransformer
    implements Transformer {
        public Object transform(Object input) {
            List<Locale> result = OpenCms.getLocaleManager().getAvailableLocales(CmsJspVfsAccessBean.this.getCmsObject(), String.valueOf(input));
            return result;
        }
    }
}

