/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.containerpage.CmsContainerElementBean;

public class CmsMacroFormatterLoader
implements I_CmsResourceLoader {
    private static final String RENDER_JSP = "/system/modules/org.opencms.ade.config/pages/render-macro.jsp";
    public static final int LOADER_ID = 15;

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public byte[] dump(CmsObject cms, CmsResource resource, String element, Locale selectedLocale, HttpServletRequest req, HttpServletResponse res) throws CmsException, IOException, ServletException {
        CmsResource renderer = cms.readResource(RENDER_JSP);
        I_CmsResourceLoader loader = OpenCms.getResourceManager().getLoader(renderer);
        this.ensureElementFormatter(resource, req);
        return loader.dump(cms, renderer, element, selectedLocale, req, res);
    }

    @Override
    public byte[] export(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, CmsException {
        CmsResource renderer = cms.readResource(RENDER_JSP);
        I_CmsResourceLoader loader = OpenCms.getResourceManager().getLoader(renderer);
        this.ensureElementFormatter(resource, req);
        return loader.export(cms, renderer, req, res);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return null;
    }

    @Override
    public int getLoaderId() {
        return 15;
    }

    @Override
    public String getResourceLoaderInfo() {
        return Messages.get().getBundle().key("GUI_LOADER_MACRO_FORMATTER_DEFAULT_DESC_0");
    }

    @Override
    public void initConfiguration() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_INITIALIZED_1", this.getClass().getName()));
        }
    }

    @Override
    public boolean isStaticExportEnabled() {
        return true;
    }

    @Override
    public boolean isStaticExportProcessable() {
        return true;
    }

    @Override
    public boolean isUsableForTemplates() {
        return false;
    }

    @Override
    public boolean isUsingUriWhenLoadingTemplate() {
        return false;
    }

    @Override
    public void load(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, CmsException {
        CmsResource renderer = cms.readResource(RENDER_JSP);
        I_CmsResourceLoader loader = OpenCms.getResourceManager().getLoader(renderer);
        this.ensureElementFormatter(resource, req);
        loader.load(cms, renderer, req, res);
    }

    @Override
    public void service(CmsObject cms, CmsResource resource, ServletRequest req, ServletResponse res) throws IOException, CmsException, ServletException {
        CmsResource renderer = cms.readResource(RENDER_JSP);
        I_CmsResourceLoader loader = OpenCms.getResourceManager().getLoader(resource);
        loader.service(cms, renderer, req, res);
    }

    private void ensureElementFormatter(CmsResource resource, HttpServletRequest req) {
        CmsJspStandardContextBean contextBean = CmsJspStandardContextBean.getInstance((ServletRequest)req);
        CmsJspStandardContextBean.CmsContainerElementWrapper element = contextBean.getElement();
        if (!resource.getStructureId().equals(((CmsContainerElementBean)element).getFormatterId())) {
            ((CmsContainerElementBean)element).setFormatterId(resource.getStructureId());
        }
    }
}

