/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.I_CmsRequestHandler;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class OpenCmsSolrHandler
extends HttpServlet
implements I_CmsRequestHandler {
    public static final String PARAM_BASE_URI = "baseUri";
    public static final String PARAM_CORE = "core";
    public static final String PARAM_INDEX = "index";
    protected static final String HEADER_REFERER_KEY = "referer";
    private static final long serialVersionUID = 2460644631508735724L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.handle(req, res, HANDLER_NAMES.SolrSelect.toString());
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.doGet(req, res);
    }

    @Override
    public String[] getHandlerNames() {
        return CmsStringUtil.enumNameToStringArray((Enum[])HANDLER_NAMES.values());
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res, String name) throws IOException {
        HANDLER_NAMES handlerName = HANDLER_NAMES.valueOf(name);
        if (handlerName != null) {
            try {
                Context context = this.initializeRequest(req, res);
                if (context.m_params.get("q") != null || context.m_params.get("fq") != null) {
                    switch (handlerName) {
                        case SolrSelect: {
                            context.m_index.select((ServletResponse)res, context.m_cms, context.m_query, true);
                            break;
                        }
                        case SolrSpell: {
                            context.m_index.spellCheck((ServletResponse)res, context.m_cms, context.m_query);
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                res.setStatus(417);
                String message = Messages.get().getBundle().key("GUI_SOLR_UNEXPECTED_ERROR_0");
                String formattedException = CmsException.getStackTraceAsString(e).replace("\n", "<br/>");
                res.getWriter().println(Messages.get().getBundle().key("GUI_SOLR_ERROR_HTML_1", message + formattedException));
            }
        }
    }

    protected CmsObject getCmsObject(HttpServletRequest req) throws CmsException {
        String baseUri;
        CmsObject cms = OpenCmsCore.getInstance().initCmsObjectFromSession(req);
        if (cms == null) {
            cms = OpenCmsCore.getInstance().initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
            String siteRoot = OpenCmsCore.getInstance().getSiteManager().matchRequest(req).getSiteRoot();
            cms.getRequestContext().setSiteRoot(siteRoot);
        }
        if ((baseUri = this.getBaseUri(req, cms)) != null) {
            cms.getRequestContext().setUri(baseUri);
        }
        return cms;
    }

    protected Context initializeRequest(HttpServletRequest req, HttpServletResponse res) throws CmsException, Exception, CmsSearchException, IOException {
        Context context = new Context();
        context.m_cms = this.getCmsObject(req);
        context.m_params = CmsRequestUtil.createParameterMap(req.getParameterMap());
        context.m_index = CmsSearchManager.getIndexSolr(context.m_cms, context.m_params);
        if (context.m_index != null) {
            context.m_query = new CmsSolrQuery(context.m_cms, context.m_params);
        } else {
            res.setStatus(400);
            String indexName = context.m_params.get(PARAM_CORE) != null ? context.m_params.get(PARAM_CORE)[0] : (context.m_params.get(PARAM_INDEX) != null ? context.m_params.get(PARAM_INDEX)[0] : null);
            String message = Messages.get().getBundle().key("GUI_SOLR_INDEX_NOT_FOUND_1", indexName);
            res.getWriter().println(Messages.get().getBundle().key("GUI_SOLR_ERROR_HTML_1", message));
        }
        return context;
    }

    private String getBaseUri(HttpServletRequest req, CmsObject cms) {
        String baseUri = req.getParameter(PARAM_BASE_URI);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(baseUri)) {
            String referer = req.getHeader(HEADER_REFERER_KEY);
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(cms.getRequestContext().getSiteRoot());
            if (site != null) {
                String prefix = site.getServerPrefix(cms, "/") + OpenCms.getStaticExportManager().getVfsPrefix();
                if (referer != null && referer.startsWith(prefix)) {
                    baseUri = referer.substring(prefix.length());
                }
            }
        }
        return baseUri;
    }

    private static enum HANDLER_NAMES {
        SolrSelect,
        SolrSpell;

    }

    class Context {
        public CmsObject m_cms;
        public CmsSolrIndex m_index;
        public Map<String, String[]> m_params;
        public CmsSolrQuery m_query;

        Context() {
        }
    }
}

