/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.module.CmsModuleLog;
import org.opencms.module.Messages;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsModuleImportExportRepository {
    public static final String EXPORT_FOLDER_PATH = "packages/_export";
    public static final String IMPORT_FOLDER_PATH = "packages/_import";
    public static final String SUFFIX = ".zip";
    private static final Log LOG = CmsLog.getLog(CmsModuleImportExportRepository.class);
    private CmsModuleLog m_moduleLog = new CmsModuleLog();
    private CmsObject m_adminCms;
    private Map<CmsModule, String> m_moduleHashCache = new ConcurrentHashMap<CmsModule, String>();
    private Map<CmsModule, String> m_newModuleHashCache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.SECONDS).build().asMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deleteModule(String fileName) throws CmsException {
        CmsModule module;
        boolean ok;
        String moduleName;
        block7: {
            moduleName = null;
            ok = true;
            module = this.getModuleForFileName(fileName);
            if (module != null) break block7;
            LOG.error((Object)("Deletion request for invalid module file name: " + fileName));
            ok = false;
            boolean bl = false;
            this.m_moduleLog.log(moduleName, CmsModuleLog.Action.deleteModule, ok);
            return bl;
        }
        try {
            I_CmsReport report = this.createReport();
            moduleName = module.getName();
            OpenCms.getModuleManager().deleteModule(this.m_adminCms, module.getName(), false, report);
            ok = !report.hasWarning() && !report.hasError();
            boolean bl = true;
            this.m_moduleLog.log(moduleName, CmsModuleLog.Action.deleteModule, ok);
            return bl;
        }
        catch (Exception e) {
            try {
                ok = false;
                if (e instanceof CmsException) {
                    throw (CmsException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                boolean bl = true;
                this.m_moduleLog.log(moduleName, CmsModuleLog.Action.deleteModule, ok);
                return bl;
            }
            catch (Throwable throwable) {
                this.m_moduleLog.log(moduleName, CmsModuleLog.Action.deleteModule, ok);
                throw throwable;
            }
        }
    }

    public synchronized byte[] getExportedModuleData(String virtualModuleFileName, CmsProject project) throws CmsException {
        CmsModule module = this.getModuleForFileName(virtualModuleFileName);
        if (module == null) {
            LOG.warn((Object)("Invalid module export path requested: " + virtualModuleFileName));
            return null;
        }
        try {
            String moduleName = module.getName();
            this.ensureFoldersExist();
            String moduleFilePath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(CmsStringUtil.joinPaths(EXPORT_FOLDER_PATH, moduleName + SUFFIX));
            File moduleFile = new File(moduleFilePath);
            boolean needToRunExport = this.needToExportModule(module, moduleFile, project);
            if (needToRunExport) {
                LOG.info((Object)("Module export is needed for " + module.getName()));
                moduleFile.delete();
                CmsModuleImportExportHandler handler = new CmsModuleImportExportHandler();
                List<String> moduleResources = CmsModule.calculateModuleResourceNames(this.m_adminCms, module);
                handler.setAdditionalResources(moduleResources.toArray(new String[0]));
                String tempFileName = RandomStringUtils.randomAlphanumeric((int)8) + SUFFIX;
                String tempFilePath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(CmsStringUtil.joinPaths(EXPORT_FOLDER_PATH, tempFileName));
                handler.setFileName(tempFilePath);
                handler.setModuleName(moduleName);
                CmsException exportException = null;
                I_CmsReport report = this.createReport();
                try {
                    CmsObject exportCms = OpenCms.initCmsObject(this.m_adminCms);
                    exportCms.getRequestContext().setCurrentProject(project);
                    handler.exportData(exportCms, report);
                }
                catch (CmsException e) {
                    exportException = e;
                }
                boolean failed = exportException != null || report.hasWarning() || report.hasError();
                this.m_moduleLog.log(moduleName, CmsModuleLog.Action.exportModule, !failed);
                if (exportException != null) {
                    new File(tempFilePath).delete();
                    throw exportException;
                }
                new File(tempFilePath).renameTo(new File(moduleFilePath));
                LOG.info((Object)("Created module export " + moduleFilePath));
            }
            byte[] result = CmsFileUtil.readFully(new FileInputStream(moduleFilePath));
            return result;
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public List<String> getModuleFileNames() {
        ArrayList result = Lists.newArrayList();
        for (CmsModule module : OpenCms.getModuleManager().getAllInstalledModules()) {
            result.add(this.getFileNameForModule(module));
        }
        return result;
    }

    public CmsModuleLog getModuleLog() {
        return this.m_moduleLog;
    }

    public synchronized void importModule(String name, byte[] content) throws CmsException {
        block11: {
            String moduleName = null;
            boolean ok = true;
            try {
                if (content.length == 0) {
                    LOG.debug((Object)"Zero-length module import content, ignoring it...");
                    break block11;
                }
                this.ensureFoldersExist();
                String targetFilePath = this.createImportZipPath(name);
                try {
                    FileOutputStream out = new FileOutputStream(new File(targetFilePath));
                    out.write(content);
                    out.close();
                }
                catch (IOException e) {
                    throw new CmsImportExportException(Messages.get().container("ERR_FILE_IO_1", targetFilePath));
                }
                CmsModuleImportExportHandler importHandler = new CmsModuleImportExportHandler();
                CmsModule module = CmsModuleImportExportHandler.readModuleFromImport(targetFilePath);
                moduleName = module.getName();
                I_CmsReport report = this.createReport();
                if (OpenCms.getModuleManager().hasModule(moduleName)) {
                    OpenCms.getModuleManager().deleteModule(this.m_adminCms, moduleName, true, report);
                }
                CmsImportParameters params = new CmsImportParameters(targetFilePath, "/", false);
                importHandler.setImportParameters(params);
                importHandler.importData(this.m_adminCms, report);
                new File(targetFilePath).delete();
                if (report.hasError() || report.hasWarning()) {
                    ok = false;
                }
            }
            catch (CmsException e) {
                ok = false;
                throw e;
            }
            catch (RuntimeException e) {
                ok = false;
                throw e;
            }
            finally {
                this.m_moduleLog.log(moduleName, CmsModuleLog.Action.importModule, ok);
            }
        }
    }

    public void initialize(CmsObject adminCms) {
        this.m_adminCms = adminCms;
    }

    private String computeModuleHash(CmsModule module, CmsProject project) throws CmsException {
        LOG.info((Object)("Getting module hash for " + module.getName()));
        String cachedValue = this.m_newModuleHashCache.get(module);
        if (cachedValue != null) {
            LOG.info((Object)("Using cached value for module hash of " + module.getName()));
            return cachedValue;
        }
        CmsObject cms = OpenCms.initCmsObject(this.m_adminCms);
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(module.getImportSite())) {
            cms.getRequestContext().setSiteRoot(module.getImportSite());
        }
        cms.getRequestContext().setCurrentProject(project);
        ArrayList entries = Lists.newArrayList();
        for (String path : module.getResources()) {
            try {
                List<CmsResource> resources = cms.readResources(path, CmsResourceFilter.IGNORE_EXPIRATION, true);
                for (CmsResource res : resources) {
                    entries.add(res.getRootPath() + ":" + res.getDateLastModified());
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                entries.add(path + ":null");
            }
        }
        Collections.sort(entries);
        String inputString = CmsStringUtil.listAsString(entries, "\n") + "\nMETA:" + module.getObjectCreateTime();
        LOG.debug((Object)("Computing module hash from base string:\n" + inputString));
        return "" + inputString.hashCode();
    }

    private String createImportZipPath(String name) {
        String prefix;
        String path = "";
        do {
            prefix = RandomStringUtils.randomAlphanumeric((int)6) + "-";
        } while (new File(path = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(CmsStringUtil.joinPaths(IMPORT_FOLDER_PATH, prefix + name))).exists());
        return path;
    }

    private I_CmsReport createReport() {
        return new CmsLogReport(Locale.ENGLISH, CmsModuleImportExportRepository.class);
    }

    private void ensureFoldersExist() {
        for (String path : Arrays.asList(IMPORT_FOLDER_PATH, EXPORT_FOLDER_PATH)) {
            String folderPath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(path);
            File folder = new File(folderPath);
            if (folder.exists()) continue;
            folder.mkdirs();
        }
    }

    private String getFileNameForModule(CmsModule module) {
        return module.getName() + SUFFIX;
    }

    private CmsModule getModuleForFileName(String fileName) {
        String moduleName = fileName;
        if (fileName.endsWith(SUFFIX)) {
            moduleName = fileName.substring(0, fileName.length() - SUFFIX.length());
        }
        CmsModule result = OpenCms.getModuleManager().getModule(moduleName);
        return result;
    }

    private boolean needToExportModule(CmsModule module, File moduleFile, CmsProject project) {
        if (!moduleFile.exists()) {
            LOG.info((Object)"Module export file doesn't exist, export is needed.");
            try {
                String moduleSignature = this.computeModuleHash(module, project);
                if (moduleSignature != null) {
                    this.m_moduleHashCache.put(module, moduleSignature);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return true;
        }
        if (moduleFile.lastModified() < module.getObjectCreateTime()) {
            return true;
        }
        String oldModuleSignature = this.m_moduleHashCache.get(module);
        String newModuleSignature = null;
        try {
            newModuleSignature = this.computeModuleHash(module, project);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        LOG.info((Object)("Comparing module hashes for " + module.getName() + " to check if export is needed: old = " + oldModuleSignature + ",  new=" + newModuleSignature));
        if (newModuleSignature == null || !Objects.equal((Object)oldModuleSignature, (Object)newModuleSignature)) {
            if (newModuleSignature != null) {
                this.m_moduleHashCache.put(module, newModuleSignature);
            }
            return true;
        }
        return false;
    }
}

