/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.pdftools;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRLogger;

public class CmsXRLogAdapter
implements XRLogger {
    public static final String OCMS_PREFIX = "org.opencms.";
    private static final String DEFAULT_LOGGER_NAME = "org.xhtmlrenderer.other";
    private static final Map<Object, String> LOGGER_NAME_MAP = new HashMap<Object, String>();

    public void log(String where, Level level, String msg) {
        Log log = CmsLog.getLog(this.getLoggerName(where));
        this.sendMessageToLogger(level, msg, log, null);
    }

    public void log(String where, Level level, String msg, Throwable th) {
        Log log = CmsLog.getLog(this.getLoggerName(where));
        this.sendMessageToLogger(level, msg, log, th);
    }

    public void setLevel(String logger, Level level) {
        throw new UnsupportedOperationException("setLevel not supported");
    }

    private String getLoggerName(String xrLoggerName) {
        String result = LOGGER_NAME_MAP.get(xrLoggerName);
        if (result != null) {
            return OCMS_PREFIX + result;
        }
        return "org.opencms.org.xhtmlrenderer.other";
    }

    private void sendMessageToLogger(Level level, String message, Log log, Throwable e) {
        if (e == null) {
            if (level == Level.SEVERE) {
                log.error((Object)message);
            } else if (level == Level.WARNING) {
                log.warn((Object)message);
            } else if (level == Level.INFO) {
                log.info((Object)message);
            } else if (level == Level.CONFIG) {
                log.info((Object)message);
            } else if (level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
                log.debug((Object)message);
            } else {
                log.info((Object)message);
            }
        } else if (level == Level.SEVERE) {
            log.error((Object)message, e);
        } else if (level == Level.WARNING) {
            log.warn((Object)message, e);
        } else if (level == Level.INFO) {
            log.info((Object)message, e);
        } else if (level == Level.CONFIG) {
            log.info((Object)message, e);
        } else if (level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
            log.debug((Object)message, e);
        } else {
            log.info((Object)message, e);
        }
    }

    static {
        LOGGER_NAME_MAP.put(XRLog.CONFIG, "org.xhtmlrenderer.config");
        LOGGER_NAME_MAP.put(XRLog.EXCEPTION, "org.xhtmlrenderer.exception");
        LOGGER_NAME_MAP.put(XRLog.GENERAL, "org.xhtmlrenderer.general");
        LOGGER_NAME_MAP.put(XRLog.INIT, "org.xhtmlrenderer.init");
        LOGGER_NAME_MAP.put(XRLog.JUNIT, "org.xhtmlrenderer.junit");
        LOGGER_NAME_MAP.put(XRLog.LOAD, "org.xhtmlrenderer.load");
        LOGGER_NAME_MAP.put(XRLog.MATCH, "org.xhtmlrenderer.match");
        LOGGER_NAME_MAP.put(XRLog.CASCADE, "org.xhtmlrenderer.cascade");
        LOGGER_NAME_MAP.put(XRLog.XML_ENTITIES, "org.xhtmlrenderer.load.xmlentities");
        LOGGER_NAME_MAP.put(XRLog.CSS_PARSE, "org.xhtmlrenderer.cssparse");
        LOGGER_NAME_MAP.put(XRLog.LAYOUT, "org.xhtmlrenderer.layout");
        LOGGER_NAME_MAP.put(XRLog.RENDER, "org.xhtmlrenderer.render");
    }
}

