/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.util.Locale;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishReport;
import org.opencms.publish.Messages;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsUUID;

public final class CmsPublishJobInfoBean {
    public static final int C_PUBLISH_FLAG = 1;
    private CmsObject m_cms;
    private boolean m_directPublish;
    private long m_enqueueTime;
    private long m_finishTime;
    private Locale m_locale;
    private CmsUUID m_projectId;
    private String m_projectName;
    private CmsUUID m_publishHistoryId;
    private CmsPublishList m_publishList;
    private I_CmsReport m_publishReport;
    private I_CmsReport m_report;
    private int m_size;
    private long m_startTime;
    private CmsUUID m_threadUUID;
    private CmsUUID m_userId;

    public CmsPublishJobInfoBean(CmsUUID historyId, CmsUUID projectId, String projectName, CmsUUID userId, String localeName, int flags, int resourceCount, long enqueueTime, long startTime, long finishTime) {
        this.m_publishHistoryId = historyId;
        this.m_projectId = projectId;
        this.m_projectName = projectName;
        this.m_userId = userId;
        this.m_size = resourceCount;
        this.m_directPublish = (flags & 1) == 1;
        this.m_enqueueTime = enqueueTime;
        this.m_startTime = startTime;
        this.m_finishTime = finishTime;
        this.m_locale = CmsLocaleManager.getLocale(localeName);
    }

    protected CmsPublishJobInfoBean(CmsObject cms, CmsPublishList publishList, I_CmsReport report) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_projectId = this.m_cms.getRequestContext().getCurrentProject().getUuid();
        this.m_projectName = this.m_cms.getRequestContext().getCurrentProject().getName();
        this.m_userId = this.m_cms.getRequestContext().getCurrentUser().getId();
        this.m_locale = this.m_cms.getRequestContext().getLocale();
        this.m_publishList = publishList;
        this.m_publishHistoryId = this.m_publishList.getPublishHistoryId();
        this.m_size = this.m_publishList.size();
        this.m_directPublish = this.m_publishList.isDirectPublish();
        this.m_report = report;
    }

    public long getEnqueueTime() {
        return this.m_enqueueTime;
    }

    public long getFinishTime() {
        return this.m_finishTime;
    }

    public int getFlags() {
        return this.m_directPublish ? 1 : 0;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public CmsUUID getProjectId() {
        return this.m_projectId;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public CmsUUID getPublishHistoryId() {
        return this.m_publishHistoryId;
    }

    public CmsPublishList getPublishList() {
        return this.m_publishList;
    }

    public I_CmsReport getPublishReport() {
        if (this.m_publishReport == null && this.m_finishTime == 0L && this.m_startTime > 0L) {
            this.m_publishReport = this.getReport();
            this.m_publishReport = this.m_publishReport == null ? new CmsPublishReport(this.getCmsObject().getRequestContext().getLocale()) : CmsPublishReport.decorate(this.m_publishReport);
        }
        return this.m_publishReport;
    }

    public I_CmsReport getReport() {
        return this.m_report;
    }

    public int getSize() {
        return this.m_size;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public CmsUUID getThreadUUID() {
        return this.m_threadUUID;
    }

    public CmsUUID getUserId() {
        return this.m_userId;
    }

    public I_CmsReport removePublishReport() {
        I_CmsReport report = this.m_publishReport;
        this.m_publishReport = null;
        return report;
    }

    public void revive(CmsObject adminCms, CmsPublishList publishList) throws CmsException {
        CmsContextInfo context = new CmsContextInfo(adminCms.readUser(this.m_userId).getName());
        CmsProject project = adminCms.readProject(this.m_projectId);
        context.setLocale(this.m_locale);
        this.m_cms = OpenCms.initCmsObject(adminCms, context);
        this.m_cms.getRequestContext().setCurrentProject(project);
        this.m_publishList = publishList;
        this.m_publishList.revive(this.m_cms);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(this.getClass().getName());
        result.append(", history id: ");
        result.append(this.getPublishHistoryId().toString());
        result.append(", project id ");
        result.append(this.getProjectId().toString());
        result.append(", project name: ");
        result.append(this.getProjectName());
        result.append(", user id: ");
        result.append(this.getUserId().toString());
        result.append(", locale: ");
        result.append(this.getLocale().toString());
        result.append(", flags: ");
        result.append(this.getFlags());
        result.append(", size: ");
        result.append(this.getSize());
        result.append(", enqueue time: ");
        result.append(this.getEnqueueTime());
        result.append(", start time: ");
        result.append(this.getStartTime());
        result.append(", finish time: ");
        result.append(this.getFinishTime());
        result.append("]");
        return result.toString();
    }

    protected void enqueue() {
        if (this.m_enqueueTime == 0L) {
            this.m_enqueueTime = System.currentTimeMillis();
        }
    }

    protected void finish() {
        if (this.m_finishTime != 0L) {
            throw new CmsRuntimeException(Messages.get().container("ERR_PUBLISH_JOB_ALREADY_FINISHED_0"));
        }
        this.m_cms = null;
        this.m_report = null;
        this.m_size = this.m_publishList.size();
        this.m_publishList = null;
        if (this.m_publishReport instanceof CmsPublishReport) {
            ((CmsPublishReport)this.m_publishReport).finish();
        }
        this.m_threadUUID = null;
        this.m_finishTime = System.currentTimeMillis();
    }

    protected CmsObject getCmsObject() {
        return this.m_cms;
    }

    protected boolean isDirectPublish() {
        return this.m_directPublish;
    }

    protected boolean isFinished() {
        return this.m_finishTime != 0L;
    }

    protected boolean isStarted() {
        return this.m_startTime != 0L;
    }

    protected void start(CmsUUID threadUUID) {
        if (this.m_startTime != 0L) {
            throw new CmsRuntimeException(Messages.get().container("ERR_PUBLISH_JOB_ALREADY_STARTED_0"));
        }
        this.m_startTime = System.currentTimeMillis();
        this.m_threadUUID = threadUUID;
        if (this.getPublishReport() instanceof CmsPublishReport) {
            ((CmsPublishReport)this.m_publishReport).start();
        }
    }
}

