/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.util.Locale;
import org.opencms.main.CmsLog;
import org.opencms.report.A_CmsReport;

public class CmsLogReport
extends A_CmsReport {
    private StringBuffer m_buffer;
    private Object m_channel;

    public CmsLogReport(Locale locale, Class<?> channel) {
        this(locale, (Object)channel);
    }

    public CmsLogReport(Locale locale, Object channel) {
        this.init(locale, null);
        this.m_buffer = new StringBuffer();
        if (channel == null) {
            channel = CmsLogReport.class;
        }
        this.m_channel = channel;
    }

    @Override
    public String getReportUpdate() {
        return "";
    }

    @Override
    public synchronized void print(String value, int format) {
        switch (format) {
            case 2: {
                this.m_buffer.append("[ ");
                this.m_buffer.append(value);
                this.m_buffer.append(" ]");
                break;
            }
            case 1: {
                this.m_buffer.append("!!! ");
                this.m_buffer.append(value);
                this.m_buffer.append(" !!!");
                this.addWarning(value);
                break;
            }
            case 5: {
                this.m_buffer.append("!!! ");
                this.m_buffer.append(value);
                this.m_buffer.append(" !!!");
                this.addError(value);
                break;
            }
            default: {
                this.m_buffer.append(value);
            }
        }
        this.setLastEntryTime(System.currentTimeMillis());
    }

    @Override
    public synchronized void println() {
        if (CmsLog.getLog(this.m_channel).isInfoEnabled()) {
            CmsLog.getLog(this.m_channel).info((Object)this.m_buffer.toString());
        }
        this.m_buffer = new StringBuffer();
        this.setLastEntryTime(System.currentTimeMillis());
    }

    @Override
    public synchronized void println(Throwable t) {
        if (CmsLog.getLog(this.m_channel).isInfoEnabled()) {
            StringBuffer message = new StringBuffer();
            message.append(this.getMessages().key("RPT_EXCEPTION_0"));
            message.append(t.getMessage());
            this.m_buffer.append(message);
            this.addError(message.toString());
            CmsLog.getLog(this.m_channel).info((Object)this.m_buffer.toString(), t);
        }
        this.m_buffer = new StringBuffer();
        this.setLastEntryTime(System.currentTimeMillis());
    }
}

