/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler;

import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.scheduler.CmsSchedulerThreadPool;
import org.opencms.scheduler.Messages;

public class CmsSchedulerThread
extends Thread {
    private static final Log LOG = CmsLog.getLog(CmsSchedulerThread.class);
    private CmsSchedulerThreadPool m_pool;
    private boolean m_run = true;
    private Runnable m_runnable;

    CmsSchedulerThread(CmsSchedulerThreadPool pool, ThreadGroup threadGroup, String threadName, int prio, boolean isDaemon) {
        this(pool, threadGroup, threadName, prio, isDaemon, null);
    }

    CmsSchedulerThread(CmsSchedulerThreadPool pool, ThreadGroup threadGroup, String threadName, int prio, boolean isDaemon, Runnable runnable) {
        super(threadGroup, threadName);
        this.m_pool = pool;
        this.m_runnable = runnable;
        this.setPriority(prio);
        this.setDaemon(isDaemon);
    }

    @Override
    public void run() {
        boolean runOnce;
        boolean bl = runOnce = this.m_runnable != null;
        while (this.m_run) {
            this.setPriority(this.m_pool.getThreadPriority());
            try {
                if (this.m_runnable == null) {
                    this.m_runnable = this.m_pool.getNextRunnable();
                }
                if (this.m_runnable == null) continue;
                this.m_runnable.run();
            }
            catch (InterruptedException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_THREAD_INTERRUPTED_1", this.getName()), (Throwable)e);
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_THREAD_ERROR_1", this.getName()), t);
            }
            finally {
                if (runOnce) {
                    this.m_run = false;
                }
                this.m_runnable = null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_THREAD_SHUTDOWN_1", this.getName()));
        }
    }

    void shutdown() {
        this.m_run = false;
    }
}

