/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.CmsIndexNoContentException;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.galleries.CmsGalleryNameMacroResolver;
import org.opencms.search.solr.CmsSolrDocumentContainerPage;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsSolrDocumentXmlContent
extends A_CmsVfsDocument {
    public static final String MAPPING_GALLERY_NAME = "galleryName";
    public static final String TYPE_XMLCONTENT_SOLR = "xmlcontent-solr";
    private static final Log LOG = CmsLog.getLog(CmsSolrDocumentXmlContent.class);

    public CmsSolrDocumentXmlContent(String name) {
        super(name);
    }

    public static void collectSchemaXpathsForSimpleValues(CmsObject cms, CmsXmlContentDefinition def, String path, Set<String> result) {
        List<I_CmsXmlSchemaType> nestedTypes = def.getTypeSequence();
        for (I_CmsXmlSchemaType nestedType : nestedTypes) {
            String subPath = path + "/" + nestedType.getName();
            if (nestedType instanceof CmsXmlNestedContentDefinition) {
                CmsXmlContentDefinition nestedDef = ((CmsXmlNestedContentDefinition)nestedType).getNestedContentDefinition();
                CmsSolrDocumentXmlContent.collectSchemaXpathsForSimpleValues(cms, nestedDef, subPath, result);
                continue;
            }
            result.add(subPath);
        }
    }

    public static CmsExtractionResult extractXmlContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        return CmsSolrDocumentXmlContent.extractXmlContent(cms, resource, index, null);
    }

    public static CmsExtractionResult extractXmlContent(CmsObject cms, CmsResource resource, CmsSearchIndex index, Locale forceLocale) throws CmsException {
        CmsFile file = cms.readFile(resource);
        if (file.getLength() <= 0) {
            throw new CmsIndexNoContentException(Messages.get().container("ERR_NO_CONTENT_1", resource.getRootPath()));
        }
        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
        HashMap<Locale, LinkedHashMap<String, String>> items = new HashMap<Locale, LinkedHashMap<String, String>>();
        HashMap<String, String> fieldMappings = new HashMap<String, String>();
        List<Locale> contentLocales = forceLocale != null ? Collections.singletonList(forceLocale) : xmlContent.getLocales();
        Locale resourceLocale = index.getLocaleForResource(cms, resource, contentLocales);
        LinkedHashMap<String, String> localeItems = null;
        for (Locale locale : contentLocales) {
            GalleryNameChooser galleryNameChooser = new GalleryNameChooser(cms, xmlContent, locale);
            localeItems = new LinkedHashMap<String, String>();
            StringBuffer textContent = new StringBuffer();
            List<String> paths = xmlContent.getNames(locale);
            for (String string : paths) {
                List<String> mappings;
                String extracted = null;
                I_CmsXmlContentValue value = xmlContent.getValue(string, locale);
                try {
                    extracted = value.getPlainText(cms);
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(extracted) && value.isSimpleType()) {
                        extracted = value.getStringValue(cms);
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)Messages.get().container("LOG_EXTRACT_VALUE_2", string, resource), (Throwable)e);
                }
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) {
                    localeItems.put(string, extracted);
                }
                if (value.getContentDefinition().getContentHandler().isSearchable(value) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) {
                    textContent.append(extracted);
                    textContent.append('\n');
                }
                if ((mappings = xmlContent.getHandler().getMappings(value.getPath())).size() <= 0) continue;
                for (String mapping : mappings) {
                    if (mapping.startsWith("property:")) {
                        String propertyName = mapping.substring(mapping.lastIndexOf(58) + 1);
                        if (!"Title".equals(propertyName) && !"Description".equals(propertyName) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) continue;
                        String fieldName = null;
                        if ("Title".equals(propertyName)) {
                            galleryNameChooser.setMappedTitleValue(extracted);
                            continue;
                        }
                        fieldName = "description";
                        fieldMappings.put(CmsSearchFieldConfiguration.getLocaleExtendedName(fieldName, locale) + "_s", extracted);
                        continue;
                    }
                    if (!mapping.equals(MAPPING_GALLERY_NAME)) continue;
                    galleryNameChooser.setMappedGalleryNameValue(value.getPlainText(cms));
                }
            }
            HashSet xpaths = Sets.newHashSet();
            CmsSolrDocumentXmlContent.collectSchemaXpathsForSimpleValues(cms, xmlContent.getContentDefinition(), "", xpaths);
            for (String xpath3 : xpaths) {
                List<String> mappings = xmlContent.getHandler().getMappings(CmsXmlUtils.createXpath(xpath3, 1));
                for (String mapping : mappings) {
                    if (!mapping.equals(MAPPING_GALLERY_NAME) && !mapping.equals("property:Title")) continue;
                    String defaultValue = xmlContent.getHandler().getDefault(cms, xmlContent.getFile(), null, xpath3, locale);
                    if (mapping.equals(MAPPING_GALLERY_NAME)) {
                        galleryNameChooser.setDefaultGalleryNameValue(defaultValue);
                        continue;
                    }
                    galleryNameChooser.setDefaultTitleValue(defaultValue);
                }
            }
            String string = CmsSearchFieldConfiguration.getLocaleExtendedName("title", locale) + "_s";
            String galleryNameValue = galleryNameChooser.getGalleryName();
            fieldMappings.put(string, galleryNameValue);
            if (textContent.length() > 0) {
                localeItems.put("__content", textContent.toString());
            }
            items.put(locale, localeItems);
        }
        if (xmlContent instanceof CmsXmlContent && xmlContent.isLocaleIndependent()) {
            if (forceLocale != null) {
                items.put(forceLocale, localeItems);
            } else {
                for (Locale l : OpenCms.getLocaleManager().getAvailableLocales()) {
                    items.put(l, localeItems);
                }
            }
        }
        return new CmsExtractionResult(resourceLocale, items, fieldMappings);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        try {
            I_CmsExtractionResult result = null;
            ArrayList<I_CmsExtractionResult> ex = new ArrayList<I_CmsExtractionResult>();
            for (CmsResource detailContainers : CmsJspTagContainer.getDetailOnlyResources(cms, resource)) {
                CmsSolrDocumentContainerPage containerpageExtractor = new CmsSolrDocumentContainerPage("");
                String localeTemp = detailContainers.getRootPath();
                localeTemp = CmsResource.getParentFolder(localeTemp);
                localeTemp = CmsResource.getName(localeTemp);
                localeTemp = localeTemp.substring(0, localeTemp.length() - 1);
                Locale locale = CmsLocaleManager.getLocale(localeTemp);
                if (CmsJspTagContainer.useSingleLocaleDetailContainers(OpenCms.getSiteManager().getSiteRoot(resource.getRootPath())) && locale.equals(CmsLocaleManager.getDefaultLocale())) {
                    locale = null;
                }
                I_CmsExtractionResult containersExtractionResult = containerpageExtractor.extractContent(cms, detailContainers, index, locale);
                containersExtractionResult.getContentItems().remove("res_locales");
                ex.add(containersExtractionResult);
            }
            result = CmsSolrDocumentXmlContent.extractXmlContent(cms, resource, index);
            result = result.merge(ex);
            return result;
        }
        catch (Throwable t) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource), t);
        }
    }

    @Override
    public List<String> getDocumentKeys(List<String> resourceTypes, List<String> mimeTypes) throws CmsException {
        if (resourceTypes.contains("*")) {
            ArrayList<String> allTypes = new ArrayList<String>();
            for (I_CmsResourceType resourceType : OpenCms.getResourceManager().getResourceTypes()) {
                if (!(resourceType instanceof CmsResourceTypeXmlContent) || !((CmsResourceTypeXmlContent)resourceType).getConfiguration().containsKey("schema") && CmsResourceTypeXmlContent.class.equals(resourceType.getClass())) continue;
                allTypes.add(resourceType.getTypeName());
            }
            resourceTypes = allTypes;
        }
        return super.getDocumentKeys(resourceTypes, mimeTypes);
    }

    @Override
    public boolean isLocaleDependend() {
        return false;
    }

    @Override
    public boolean isUsingCache() {
        return true;
    }

    private static class GalleryNameChooser {
        private CmsObject m_cms;
        private A_CmsXmlDocument m_content;
        private String m_defaultGalleryNameValue;
        private String m_defaultTitleValue;
        private Locale m_locale;
        private String m_mappedGalleryNameValue;
        private String m_mappedTitleValue;

        public GalleryNameChooser(CmsObject cms, A_CmsXmlDocument content, Locale locale) {
            this.m_cms = cms;
            this.m_content = content;
            this.m_locale = locale;
        }

        public String getGalleryName() throws CmsException {
            String result = null;
            for (String resultCandidateWithMacros : new String[]{this.m_mappedGalleryNameValue, this.m_defaultGalleryNameValue, this.m_mappedTitleValue, this.m_defaultTitleValue}) {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(resultCandidateWithMacros)) continue;
                CmsGalleryNameMacroResolver resolver = new CmsGalleryNameMacroResolver(this.m_cms, this.m_content, this.m_locale);
                result = resolver.resolveMacros(resultCandidateWithMacros);
                return result;
            }
            result = this.m_cms.readPropertyObject(this.m_content.getFile(), "Title", false).getValue();
            return result;
        }

        public void setDefaultGalleryNameValue(String defaultGalleryNameValue) {
            this.m_defaultGalleryNameValue = defaultGalleryNameValue;
        }

        public void setDefaultTitleValue(String defaultTitleValue) {
            this.m_defaultTitleValue = defaultTitleValue;
        }

        public void setMappedGalleryNameValue(String mappedGalleryNameValue) {
            this.m_mappedGalleryNameValue = mappedGalleryNameValue;
        }

        public void setMappedTitleValue(String mappedTitleValue) {
            this.m_mappedTitleValue = mappedTitleValue;
        }
    }
}

