/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.Term;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.QParser;
import org.apache.solr.util.FastWriter;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResource;
import org.opencms.search.CmsSearchResultList;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.galleries.CmsGallerySearchResultList;
import org.opencms.search.solr.CmsSolrDocument;
import org.opencms.search.solr.CmsSolrIndexWriter;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.search.solr.I_CmsSolrPostSearchProcessor;
import org.opencms.search.solr.Messages;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSolrIndex
extends CmsSearchIndex {
    public static final String DEFAULT_INDEX_NAME_OFFLINE = "Solr Offline";
    public static final String DEFAULT_INDEX_NAME_ONLINE = "Solr Online";
    public static final String POST_PROCESSOR = "search.solr.postProcessor";
    public static final String PROPERTY_SEARCH_EXCLUDE_VALUE_SOLR = "solr";
    public static final int ROWS_MAX = 50;
    protected static final int DEBUG_PADDING_RIGHT = 50;
    private static final String HEADER_PARAMS_NAME = "params";
    private static final Log LOG = CmsLog.getLog(CmsSolrIndex.class);
    private static final CmsResource PSEUDO_RES = new CmsResource(null, null, null, 0, false, 0, null, null, 0L, null, 0L, null, 0L, 0L, 0, 0, 0L, 0);
    private static final String QUERY_RESPONSE_NAME = "response";
    private static final String QUERY_TIME_NAME = "QTime";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    SolrClient m_solr;
    private I_CmsSolrPostSearchProcessor m_postProcessor;
    private String m_coreName;

    public CmsSolrIndex() {
    }

    public CmsSolrIndex(String name) throws CmsIllegalArgumentException {
        super(name);
    }

    public static final String getType(CmsObject cms, String rootPath) {
        I_CmsSearchDocument doc;
        String type = null;
        CmsSolrIndex index = CmsSearchManager.getIndexSolr(cms, null);
        if (index != null && (doc = index.getDocument("path", rootPath)) != null) {
            type = doc.getFieldValueAsString("type");
        }
        return type;
    }

    @Override
    public void addConfigurationParameter(String key, String value) {
        if (POST_PROCESSOR.equals(key) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) {
            try {
                this.setPostProcessor((I_CmsSolrPostSearchProcessor)Class.forName(value).newInstance());
            }
            catch (Exception e) {
                CmsException ex = new CmsException(Messages.get().container("LOG_SOLR_ERR_POST_PROCESSOR_NOT_EXIST_1", value), (Throwable)e);
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        super.addConfigurationParameter(key, value);
    }

    @Override
    public I_CmsSearchDocument createEmptyDocument(CmsResource resource) {
        CmsSolrDocument doc = new CmsSolrDocument(new SolrInputDocument());
        doc.setId(resource.getStructureId());
        return doc;
    }

    @Override
    public I_CmsIndexWriter createIndexWriter(boolean create, I_CmsReport report) {
        return new CmsSolrIndexWriter(this.m_solr, this);
    }

    public CmsGallerySearchResultList gallerySearch(CmsObject cms, CmsGallerySearchParameters params) {
        CmsGallerySearchResultList resultList = new CmsGallerySearchResultList();
        try {
            CmsSolrResultList list = this.search(cms, params.getQuery(cms), false, null, true, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            if (null == list) {
                return null;
            }
            resultList.setHitCount(Long.valueOf(list.getNumFound()).intValue());
            for (CmsSearchResource resource : list) {
                I_CmsSearchDocument document = resource.getDocument();
                Locale locale = CmsLocaleManager.getLocale(params.getLocale());
                CmsGallerySearchResult result = new CmsGallerySearchResult(document, cms, (int)document.getScore(), locale);
                resultList.add(result);
            }
        }
        catch (CmsSearchException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return resultList;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = super.getConfiguration();
        if (this.getPostProcessor() != null) {
            result.put(POST_PROCESSOR, this.getPostProcessor().getClass().getName());
        }
        return result;
    }

    public String getCoreName() {
        return this.m_coreName;
    }

    @Override
    public synchronized I_CmsSearchDocument getDocument(String fieldname, String term) {
        try {
            SolrDocumentList sdl;
            SolrQuery query = new SolrQuery();
            if ("path".equals(fieldname)) {
                query.setQuery(fieldname + ":\"" + term + "\"");
            } else {
                query.setQuery(fieldname + ":" + term);
            }
            QueryResponse res = this.m_solr.query((SolrParams)query);
            if (res != null && (sdl = this.m_solr.query((SolrParams)query).getResults()).getNumFound() > 0L && sdl.get(0) != null) {
                return new CmsSolrDocument((SolrDocument)sdl.get(0));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public I_CmsDocumentFactory getDocumentFactory(CmsResource res) {
        if (this.isIndexing(res)) {
            if (OpenCms.getResourceManager().getResourceType(res) instanceof CmsResourceTypeXmlContainerPage) {
                return OpenCms.getSearchManager().getDocumentFactory("containerpage-solr", "text/html");
            }
            if (CmsResourceTypeXmlContent.isXmlContent(res)) {
                return OpenCms.getSearchManager().getDocumentFactory("xmlcontent-solr", "text/html");
            }
            return super.getDocumentFactory(res);
        }
        return null;
    }

    @Override
    public Locale getLocaleForResource(CmsObject cms, CmsResource resource, List<Locale> availableLocales) {
        Locale result = null;
        List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        if (availableLocales != null && availableLocales.size() > 0) {
            result = OpenCms.getLocaleManager().getBestMatchingLocale(defaultLocales.get(0), defaultLocales, availableLocales);
        }
        if (result == null) {
            result = availableLocales != null && availableLocales.isEmpty() ? availableLocales.get(0) : defaultLocales.get(0);
        }
        return result;
    }

    public I_CmsSolrPostSearchProcessor getPostProcessor() {
        return this.m_postProcessor;
    }

    @Override
    public void initialize() throws CmsSearchException {
        super.initialize();
        this.getFieldConfiguration().init();
        try {
            OpenCms.getSearchManager().registerSolrIndex(this);
        }
        catch (CmsConfigurationException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            this.setEnabled(false);
        }
    }

    public boolean isNoSolrServerSet() {
        return null == this.m_solr;
    }

    @Override
    @Deprecated
    public synchronized CmsSearchResultList search(CmsObject cms, CmsSearchParameters params) {
        throw new UnsupportedOperationException();
    }

    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query) throws CmsSearchException {
        return this.search(cms, query, false);
    }

    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows) throws CmsSearchException {
        return this.search(cms, query, ignoreMaxRows, null, false, null);
    }

    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows, CmsResourceFilter filter) throws CmsSearchException {
        return this.search(cms, query, ignoreMaxRows, null, false, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows, ServletResponse response, boolean ignoreSearchExclude, CmsResourceFilter filter) throws CmsSearchException {
        this.checkOfflineAccess(cms);
        if (!ignoreSearchExclude) {
            query.addFilterQuery(new String[]{"search_exclude:\"false\""});
        }
        int previousPriority = Thread.currentThread().getPriority();
        long startTime = System.currentTimeMillis();
        CmsSolrQuery initQuery = query.clone();
        query.setHighlight(false);
        LocalSolrQueryRequest solrQueryRequest = null;
        try {
            int rows;
            CmsObject searchCms = OpenCms.initCmsObject(cms);
            if (this.getPriority() > 0) {
                Thread.currentThread().setPriority(this.getPriority());
            }
            List<CmsSearchResource> resourceDocumentList = new ArrayList<CmsSearchResource>();
            SolrDocumentList solrDocumentList = new SolrDocumentList();
            int n = rows = query.getRows() != null ? query.getRows().intValue() : CmsSolrQuery.DEFAULT_ROWS.intValue();
            if (!ignoreMaxRows && rows > 50) {
                rows = 50;
            }
            int start = query.getStart() != null ? query.getStart() : 0;
            int end = start + rows;
            int page = 0;
            if (rows > 0) {
                page = Math.round(start / rows) + 1;
            }
            query.setStart(new Integer(0));
            query.setRows(new Integer(5 * rows * page + start));
            QueryResponse queryResponse = this.m_solr.query((SolrParams)query);
            long solrTime = System.currentTimeMillis() - startTime;
            long hitCount = queryResponse.getResults().getNumFound();
            start = -1;
            end = -1;
            if (rows > 0 && page > 0 && hitCount > 0L) {
                start = rows * (page - 1);
                end = start + rows;
                start = new Long((long)start > hitCount ? hitCount : (long)start).intValue();
                end = new Long((long)end > hitCount ? hitCount : (long)end).intValue();
            } else {
                start = 0;
                end = new Long(hitCount).intValue();
            }
            long visibleHitCount = hitCount;
            float maxScore = 0.0f;
            if (this.m_postProcessor != null) {
                this.m_postProcessor.init();
            }
            ArrayList<CmsSearchResource> allDocs = new ArrayList<CmsSearchResource>();
            int cnt = 0;
            for (int i = 0; i < queryResponse.getResults().size() && cnt < end; ++i) {
                try {
                    SolrDocument doc = (SolrDocument)queryResponse.getResults().get(i);
                    CmsSolrDocument searchDoc = new CmsSolrDocument(doc);
                    if (this.needsPermissionCheck(searchDoc)) {
                        CmsResource resource;
                        CmsResource cmsResource = resource = filter == null ? this.getResource(searchCms, searchDoc) : this.getResource(searchCms, searchDoc, filter);
                        if (resource != null) {
                            if (cnt >= start) {
                                if (this.m_postProcessor != null) {
                                    doc = this.m_postProcessor.process(searchCms, resource, (SolrInputDocument)searchDoc.getDocument());
                                }
                                resourceDocumentList.add(new CmsSearchResource(resource, searchDoc));
                                if (null != doc) {
                                    solrDocumentList.add((Object)doc);
                                }
                                maxScore = maxScore < searchDoc.getScore() ? searchDoc.getScore() : maxScore;
                            }
                            allDocs.add(new CmsSearchResource(resource, searchDoc));
                            ++cnt;
                            continue;
                        }
                        --visibleHitCount;
                        continue;
                    }
                    resourceDocumentList.add(new CmsSearchResource(PSEUDO_RES, searchDoc));
                    solrDocumentList.add((Object)doc);
                    maxScore = maxScore < searchDoc.getScore() ? searchDoc.getScore() : maxScore;
                    ++cnt;
                    continue;
                }
                catch (Exception e) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_SOLR_ERR_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                }
            }
            if (resourceDocumentList.isEmpty() && allDocs.size() > 0) {
                page = Math.round(allDocs.size() / rows) + 1;
                int showCount = allDocs.size() % rows;
                showCount = showCount == 0 ? rows : showCount;
                start = allDocs.size() - new Long(showCount).intValue();
                end = allDocs.size();
                if (allDocs.size() > start) {
                    resourceDocumentList = allDocs.subList(start, end);
                    for (CmsSearchResource r : resourceDocumentList) {
                        maxScore = maxScore < r.getDocument().getScore() ? r.getDocument().getScore() : maxScore;
                        solrDocumentList.add((Object)((CmsSolrDocument)r.getDocument()).getSolrDocument());
                    }
                }
            }
            long processTime = System.currentTimeMillis() - startTime - solrTime;
            solrDocumentList.setStart((long)start);
            solrDocumentList.setMaxScore(new Float(maxScore));
            solrDocumentList.setNumFound(visibleHitCount);
            queryResponse.getResponse().setVal(queryResponse.getResponse().indexOf(QUERY_RESPONSE_NAME, 0), (Object)solrDocumentList);
            queryResponse.getResponseHeader().setVal(queryResponse.getResponseHeader().indexOf(QUERY_TIME_NAME, 0), (Object)new Integer(new Long(System.currentTimeMillis() - startTime).intValue()));
            long highlightEndTime = System.currentTimeMillis();
            SolrCore core = this.m_solr instanceof EmbeddedSolrServer ? ((EmbeddedSolrServer)this.m_solr).getCoreContainer().getCore(this.getCoreName()) : null;
            CmsSolrResultList result = null;
            try {
                SearchComponent highlightComponenet = null;
                if (core != null) {
                    highlightComponenet = core.getSearchComponent("highlight");
                    solrQueryRequest = new LocalSolrQueryRequest(core, queryResponse.getResponseHeader());
                }
                SolrQueryResponse solrQueryResponse = null;
                if (solrQueryRequest != null) {
                    solrQueryResponse = new SolrQueryResponse();
                    solrQueryResponse.setAllValues(queryResponse.getResponse());
                    int paramsIndex = queryResponse.getResponseHeader().indexOf(HEADER_PARAMS_NAME, 0);
                    NamedList header = null;
                    Object o = queryResponse.getResponseHeader().getVal(paramsIndex);
                    if (o instanceof NamedList) {
                        header = (NamedList)o;
                        header.setVal(header.indexOf("rows", 0), (Object)new Integer(rows));
                        header.setVal(header.indexOf("start", 0), (Object)new Long(start));
                    }
                    solrQueryRequest.setParams((SolrParams)initQuery);
                    if (header != null && initQuery.getHighlight() && highlightComponenet != null) {
                        String formatter;
                        header.add("hl", (Object)"on");
                        if (initQuery.getHighlightFields() != null && initQuery.getHighlightFields().length > 0) {
                            header.add("hl.fl", (Object)CmsStringUtil.arrayAsString(initQuery.getHighlightFields(), ","));
                        }
                        String string = formatter = initQuery.getParams("hl.formatter") != null ? initQuery.getParams("hl.formatter")[0] : null;
                        if (formatter != null) {
                            header.add("hl.formatter", (Object)formatter);
                        }
                        if (initQuery.getHighlightFragsize() != 100) {
                            header.add("hl.fragsize", (Object)new Integer(initQuery.getHighlightFragsize()));
                        }
                        if (initQuery.getHighlightRequireFieldMatch()) {
                            header.add("hl.requireFieldMatch", (Object)new Boolean(initQuery.getHighlightRequireFieldMatch()));
                        }
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(initQuery.getHighlightSimplePost())) {
                            header.add("hl.simple.post", (Object)initQuery.getHighlightSimplePost());
                        }
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(initQuery.getHighlightSimplePre())) {
                            header.add("hl.simple.pre", (Object)initQuery.getHighlightSimplePre());
                        }
                        if (initQuery.getHighlightSnippets() != 1) {
                            header.add("hl.snippets", (Object)new Integer(initQuery.getHighlightSnippets()));
                        }
                        ResponseBuilder rb = new ResponseBuilder((SolrQueryRequest)solrQueryRequest, solrQueryResponse, Collections.singletonList(highlightComponenet));
                        try {
                            rb.doHighlights = true;
                            DocListAndSet res = new DocListAndSet();
                            SchemaField idField = OpenCms.getSearchManager().getSolrServerConfiguration().getSolrSchema().getUniqueKeyField();
                            int[] luceneIds = new int[rows];
                            int docs = 0;
                            for (SolrDocument doc : solrDocumentList) {
                                String idString = (String)doc.getFirstValue("id");
                                int id = solrQueryRequest.getSearcher().getFirstMatch(new Term(idField.getName(), idField.getType().toInternal(idString)));
                                luceneIds[docs++] = id;
                            }
                            res.docList = new DocSlice(0, docs, luceneIds, null, docs, 0.0f);
                            rb.setResults(res);
                            rb.setQuery(QParser.getParser((String)initQuery.getQuery(), null, (SolrQueryRequest)solrQueryRequest).getQuery());
                            rb.setQueryString(initQuery.getQuery());
                            highlightComponenet.prepare(rb);
                            highlightComponenet.process(rb);
                            highlightComponenet.finishStage(rb);
                        }
                        catch (Exception e) {
                            LOG.error((Object)(e.getMessage() + " in query: " + (Object)((Object)initQuery)), (Throwable)new Exception(e));
                        }
                        queryResponse.setResponse(solrQueryResponse.getValues());
                        highlightEndTime = System.currentTimeMillis();
                    }
                }
                result = new CmsSolrResultList(initQuery, queryResponse, solrDocumentList, resourceDocumentList, start, new Integer(rows), end, page, visibleHitCount, new Float(maxScore), startTime, highlightEndTime);
                if (LOG.isDebugEnabled()) {
                    Object[] logParams = new Object[]{new Long(System.currentTimeMillis() - startTime), new Long(result.getNumFound()), new Long(solrTime), new Long(processTime), new Long(result.getHighlightEndTime() != 0L ? result.getHighlightEndTime() - startTime : 0L)};
                    LOG.debug((Object)(query.toString() + "\n" + Messages.get().getBundle().key("LOG_SOLR_SEARCH_EXECUTED_5", logParams)));
                }
                if (response != null) {
                    this.writeResp(response, (SolrQueryRequest)solrQueryRequest, solrQueryResponse);
                }
            }
            finally {
                if (solrQueryRequest != null) {
                    solrQueryRequest.close();
                }
                if (core != null) {
                    core.close();
                }
            }
            CmsSolrResultList cmsSolrResultList = result;
            return cmsSolrResultList;
        }
        catch (Exception e) {
            throw new CmsSearchException(Messages.get().container("LOG_SOLR_ERR_SEARCH_EXECUTION_FAILD_1", CmsEncoder.decode(query.toString()), e), (Throwable)e);
        }
        finally {
            if (solrQueryRequest != null) {
                solrQueryRequest.close();
            }
            Thread.currentThread().setPriority(previousPriority);
        }
    }

    public CmsSolrResultList search(CmsObject cms, SolrQuery query) throws CmsSearchException {
        return this.search(cms, CmsEncoder.decode(query.toString()));
    }

    public CmsSolrResultList search(CmsObject cms, String solrQuery) throws CmsSearchException {
        return this.search(cms, new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(solrQuery)), false);
    }

    public void select(ServletResponse response, CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows) throws Exception {
        boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
        CmsResourceFilter filter = isOnline ? null : CmsResourceFilter.IGNORE_EXPIRATION;
        this.search(cms, query, ignoreMaxRows, response, false, filter);
    }

    @Override
    public void setName(String name) throws CmsIllegalArgumentException {
        super.setName(name);
        this.updateCoreName();
    }

    public void setPostProcessor(I_CmsSolrPostSearchProcessor postProcessor) {
        this.m_postProcessor = postProcessor;
    }

    public void setSolrServer(SolrClient client) {
        this.m_solr = client;
    }

    public void spellCheck(ServletResponse res, CmsObject cms, CmsSolrQuery q) throws CmsSearchException {
        SolrCore core = null;
        LocalSolrQueryRequest solrQueryRequest = null;
        try {
            q.setRequestHandler("/spell");
            QueryResponse queryResponse = this.m_solr.query((SolrParams)q);
            ArrayList<CmsSearchResource> resourceDocumentList = new ArrayList<CmsSearchResource>();
            SolrDocumentList solrDocumentList = new SolrDocumentList();
            if (this.m_postProcessor != null) {
                for (int i = 0; i < queryResponse.getResults().size(); ++i) {
                    try {
                        CmsResource resource;
                        SolrDocument doc = (SolrDocument)queryResponse.getResults().get(i);
                        CmsSolrDocument searchDoc = new CmsSolrDocument(doc);
                        if (!this.needsPermissionCheck(searchDoc) || (resource = this.getResource(cms, searchDoc)) == null) continue;
                        if (this.m_postProcessor != null) {
                            doc = this.m_postProcessor.process(cms, resource, (SolrInputDocument)searchDoc.getDocument());
                        }
                        resourceDocumentList.add(new CmsSearchResource(resource, searchDoc));
                        solrDocumentList.add((Object)doc);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_SOLR_ERR_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                    }
                }
                queryResponse.getResponse().setVal(queryResponse.getResponse().indexOf(QUERY_RESPONSE_NAME, 0), (Object)solrDocumentList);
            }
            core = this.m_solr instanceof EmbeddedSolrServer ? ((EmbeddedSolrServer)this.m_solr).getCoreContainer().getCore(this.getCoreName()) : null;
            SolrQueryResponse solrQueryResponse = new SolrQueryResponse();
            solrQueryResponse.setAllValues(queryResponse.getResponse());
            solrQueryRequest = new LocalSolrQueryRequest(core, solrQueryResponse.getResponseHeader());
            solrQueryRequest.setParams((SolrParams)q);
            this.writeResp(res, (SolrQueryRequest)solrQueryRequest, solrQueryResponse);
        }
        catch (Exception e) {
            throw new CmsSearchException(Messages.get().container("LOG_SOLR_ERR_SEARCH_EXECUTION_FAILD_1", (Object)q), (Throwable)e);
        }
        finally {
            if (solrQueryRequest != null) {
                solrQueryRequest.close();
            }
            if (core != null) {
                core.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String createIndexBackup() {
        EmbeddedSolrServer ser;
        CoreContainer con;
        SolrCore core;
        if (!this.isBackupReindexing()) {
            return null;
        }
        if (this.m_solr instanceof EmbeddedSolrServer && (core = (con = (ser = (EmbeddedSolrServer)this.m_solr).getCoreContainer()).getCore(this.getCoreName())) != null) {
            try {
                SolrRequestHandler h = core.getRequestHandler("/replication");
                if (h instanceof ReplicationHandler) {
                    h.handleRequest((SolrQueryRequest)new LocalSolrQueryRequest(core, CmsRequestUtil.createParameterMap("?command=backup")), new SolrQueryResponse());
                }
            }
            finally {
                core.close();
            }
        }
        return null;
    }

    @Override
    protected boolean excludeFromIndex(CmsObject cms, CmsResource resource) {
        return resource.isFolder() || resource.isTemporaryFile();
    }

    @Override
    protected void indexSearcherClose() {
    }

    @Override
    protected void indexSearcherOpen(String path) {
    }

    @Override
    protected void indexSearcherUpdate() {
    }

    protected boolean isIndexing(CmsResource res) {
        if (res != null && this.getSources() != null) {
            I_CmsDocumentFactory result = OpenCms.getSearchManager().getDocumentFactory(res);
            for (CmsSearchIndexSource source : this.getSources()) {
                if (!source.isIndexing(res.getRootPath(), "containerpage-solr") && !source.isIndexing(res.getRootPath(), "xmlcontent-solr") && !source.isIndexing(res.getRootPath(), result.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void checkOfflineAccess(CmsObject cms) throws CmsSearchException {
        if (!"Online".equals(this.getProject())) {
            try {
                OpenCms.getRoleManager().checkRole(cms, CmsRole.ELEMENT_AUTHOR);
            }
            catch (CmsRoleViolationException e) {
                throw new CmsSearchException(Messages.get().container("LOG_SOLR_ERR_SEARCH_PERMISSION_VIOLATION_2", this.getName(), cms.getRequestContext().getCurrentUser()), (Throwable)e);
            }
        }
    }

    private String generateCoreName(String name) {
        if (name != null) {
            return name.replace(" ", "-");
        }
        return null;
    }

    private void updateCoreName() {
        this.m_coreName = this.generateCoreName(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResp(ServletResponse response, SolrQueryRequest queryRequest, SolrQueryResponse queryResponse) throws IOException, UnsupportedEncodingException {
        if (this.m_solr instanceof EmbeddedSolrServer) {
            SolrCore core = ((EmbeddedSolrServer)this.m_solr).getCoreContainer().getCore(this.getCoreName());
            Writer out = null;
            try {
                QueryResponseWriter responseWriter = core.getQueryResponseWriter(queryRequest);
                String ct = responseWriter.getContentType(queryRequest, queryResponse);
                if (null != ct) {
                    response.setContentType(ct);
                }
                if (responseWriter instanceof BinaryQueryResponseWriter) {
                    BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
                    binWriter.write((OutputStream)response.getOutputStream(), queryRequest, queryResponse);
                }
                String charset = ContentStreamBase.getCharsetFromContentType((String)ct);
                out = charset == null || charset.equalsIgnoreCase(UTF8.toString()) ? new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF8) : new OutputStreamWriter((OutputStream)response.getOutputStream(), charset);
                out = new FastWriter(out);
                responseWriter.write(out, queryRequest, queryResponse);
                out.flush();
            }
            finally {
                core.close();
                if (out != null) {
                    out.close();
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

