/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr.spellchecking;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.opencms.file.CmsObject;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.search.solr.spellchecking.CmsSpellcheckDictionaryIndexer;
import org.opencms.search.solr.spellchecking.CmsSpellcheckingRequest;
import org.opencms.security.CmsPermissionViolationException;

public final class CmsSolrSpellchecker {
    public static final String SPELLCHECKER_INDEX_CORE = "spellcheck";
    private static final Log LOG = CmsLog.getLog(CmsSolrSpellchecker.class);
    private static CmsSolrSpellchecker instance;
    private static final String LANG_DEFAULT = "en";
    private static final String JSON_ID = "id";
    private static final String JSON_LANG = "lang";
    private static final String JSON_ERROR = "error";
    private static final String JSON_WORDS = "words";
    private static final String JSON_PARAMS = "params";
    private static final String JSON_RESULT = "result";
    private static final String HTTP_PARAMETER_WORDS = "words";
    private static final String HTTP_PARAMETER_LANG = "lang";
    private static final String HTTP_PARAMTER_REBUILD = "rebuild";
    private static final String HTTP_PARAMETER_CHECKREBUILD = "check";
    private SolrCore m_core;
    private CoreContainer m_coreContainer;
    private SolrClient m_solrClient;

    private CmsSolrSpellchecker(CoreContainer container, SolrCore core) {
        if (null == container || null == core) {
            throw new IllegalArgumentException();
        }
        this.m_core = core;
        this.m_coreContainer = container;
        this.m_solrClient = new EmbeddedSolrServer(this.m_coreContainer, this.m_core.getName());
    }

    public static CmsSolrSpellchecker getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CmsSolrSpellchecker getInstance(CoreContainer container, SolrCore core) {
        if (null != instance) return instance;
        Class<CmsSolrSpellchecker> clazz = CmsSolrSpellchecker.class;
        synchronized (CmsSolrSpellchecker.class) {
            if (null != instance) return instance;
            instance = new CmsSolrSpellchecker(container, core);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public void getSpellcheckingResult(HttpServletResponse res, ServletRequest servletRequest, CmsObject cms) throws CmsPermissionViolationException, IOException {
        this.performPermissionCheck(cms);
        this.setResponeHeaders(res);
        CmsSpellcheckingRequest cmsSpellcheckingRequest = null;
        try {
            String requestBody = this.getRequestBody(servletRequest);
            JSONObject jsonRequest = new JSONObject(requestBody);
            cmsSpellcheckingRequest = this.parseJsonRequest(jsonRequest);
        }
        catch (Exception e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            cmsSpellcheckingRequest = this.parseHttpRequest(servletRequest, cms);
        }
        if (null != cmsSpellcheckingRequest && cmsSpellcheckingRequest.isInitialized()) {
            SpellCheckResponse spellCheckResponse = this.performSpellcheckQuery(cmsSpellcheckingRequest);
            cmsSpellcheckingRequest.m_wordSuggestions = null == spellCheckResponse ? new JSONObject() : this.getConvertedResponseAsJson(spellCheckResponse);
        }
        this.sendResponse(res, cmsSpellcheckingRequest);
    }

    void parseAndAddDictionaries(CmsObject cms) {
        CmsSpellcheckDictionaryIndexer.parseAndAddZippedDictionaries(this.m_solrClient, cms);
        CmsSpellcheckDictionaryIndexer.parseAndAddDictionaries(this.m_solrClient, cms);
    }

    private JSONObject getConvertedResponseAsJson(SpellCheckResponse response) {
        if (null == response) {
            return null;
        }
        JSONObject suggestions = new JSONObject();
        Map solrSuggestions = response.getSuggestionMap();
        for (String key : solrSuggestions.keySet()) {
            String lowercaseKey;
            boolean ignoreWord = false;
            if (Character.isUpperCase(key.codePointAt(0)) && !solrSuggestions.containsKey(lowercaseKey = key.toLowerCase())) {
                ignoreWord = true;
            }
            if (ignoreWord) continue;
            try {
                List l = ((SpellCheckResponse.Suggestion)solrSuggestions.get(key)).getAlternatives();
                suggestions.put(key, (Object)l);
            }
            catch (JSONException e) {
                LOG.debug((Object)"Exception while converting Solr spellcheckresponse to JSON. ", (Throwable)e);
            }
        }
        return suggestions;
    }

    private JSONObject getJsonFormattedSpellcheckResult(CmsSpellcheckingRequest request) {
        JSONObject response = new JSONObject();
        try {
            if (null != request.m_id) {
                response.put(JSON_ID, request.m_id);
            }
            response.put(JSON_RESULT, request.m_wordSuggestions);
        }
        catch (Exception e) {
            try {
                response.put(JSON_ERROR, true);
                LOG.debug((Object)"Error while assembling spellcheck response in JSON format.", (Throwable)e);
            }
            catch (JSONException ex) {
                LOG.debug((Object)"Error while assembling spellcheck response in JSON format.", (Throwable)ex);
            }
        }
        return response;
    }

    private String getRequestBody(ServletRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = request.getReader().readLine();
        while (null != line) {
            sb.append(line);
            line = request.getReader().readLine();
        }
        return sb.toString();
    }

    private CmsSpellcheckingRequest parseHttpRequest(ServletRequest req, CmsObject cms) {
        String q;
        if (null != cms && !cms.getRequestContext().getCurrentUser().isGuestUser()) {
            if (null != req.getParameter(HTTP_PARAMETER_CHECKREBUILD) && CmsSpellcheckDictionaryIndexer.updatingIndexNecessesary(cms)) {
                this.parseAndAddDictionaries(cms);
            }
            if (null != req.getParameter(HTTP_PARAMTER_REBUILD)) {
                this.parseAndAddDictionaries(cms);
            }
        }
        if (null == (q = req.getParameter("words"))) {
            LOG.debug((Object)"Invalid HTTP request: No parameter \"words\" defined. ");
            return null;
        }
        StringTokenizer st = new StringTokenizer(q);
        ArrayList<String> wordsToCheck = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            wordsToCheck.add(word);
            if (!Character.isUpperCase(word.codePointAt(0))) continue;
            wordsToCheck.add(word.toLowerCase());
        }
        String[] w = wordsToCheck.toArray(new String[wordsToCheck.size()]);
        String dict = req.getParameter("lang") == null ? LANG_DEFAULT : req.getParameter("lang");
        return new CmsSpellcheckingRequest(w, dict);
    }

    private CmsSpellcheckingRequest parseJsonRequest(JSONObject jsonRequest) {
        String id = jsonRequest.optString(JSON_ID);
        JSONObject params = jsonRequest.optJSONObject(JSON_PARAMS);
        if (null == params) {
            LOG.debug((Object)"Invalid JSON request: No field \"params\" defined. ");
            return null;
        }
        JSONArray words = params.optJSONArray("words");
        String lang = params.optString("lang", LANG_DEFAULT);
        if (null == words) {
            LOG.debug((Object)"Invalid JSON request: No field \"words\" defined. ");
            return null;
        }
        LinkedList<String> wordsToCheck = new LinkedList<String>();
        for (int i = 0; i < words.length(); ++i) {
            String word = words.opt(i).toString();
            wordsToCheck.add(word);
            if (!Character.isUpperCase(word.codePointAt(0))) continue;
            wordsToCheck.add(word.toLowerCase());
        }
        return new CmsSpellcheckingRequest(wordsToCheck.toArray(new String[wordsToCheck.size()]), lang, id);
    }

    private void performPermissionCheck(CmsObject cms) throws CmsPermissionViolationException {
        if (cms.getRequestContext().getCurrentUser().isGuestUser()) {
            throw new CmsPermissionViolationException(null);
        }
    }

    private SpellCheckResponse performSpellcheckQuery(CmsSpellcheckingRequest request) {
        if (null == request || !request.isInitialized()) {
            return null;
        }
        String[] wordsToCheck = request.m_wordsToCheck;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set(SPELLCHECKER_INDEX_CORE, new String[]{"true"});
        params.set("spellcheck.dictionary", new String[]{request.m_dictionaryToUse});
        params.set("spellcheck.extendedResults", new String[]{"true"});
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < wordsToCheck.length; ++i) {
            builder.append(wordsToCheck[i] + " ");
        }
        params.set("spellcheck.q", new String[]{builder.toString()});
        SolrQuery query = new SolrQuery();
        query.setRequestHandler("/spell");
        query.add((SolrParams)params);
        try {
            QueryResponse qres = this.m_solrClient.query((SolrParams)query);
            return qres.getSpellCheckResponse();
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception while performing spellcheck query...", (Throwable)e);
            return null;
        }
    }

    private void sendResponse(HttpServletResponse res, CmsSpellcheckingRequest request) throws IOException {
        PrintWriter pw = res.getWriter();
        JSONObject response = this.getJsonFormattedSpellcheckResult(request);
        pw.println(response.toString());
        pw.close();
    }

    private void setResponeHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", System.currentTimeMillis());
        response.setContentType("text/plain; charset=utf-8");
        response.setCharacterEncoding("utf-8");
    }
}

