/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public final class CmsRole {
    public static final CmsRole ACCOUNT_MANAGER;
    public static final CmsRole ADMINISTRATOR;
    public static final CmsRole CATEGORY_EDITOR;
    public static final String CONFIRM_ROLE_PREFIX = "confirm.role.";
    public static final CmsRole DATABASE_MANAGER;
    public static final CmsRole DEVELOPER;
    public static final CmsRole EDITOR;
    public static final CmsRole ELEMENT_AUTHOR;
    public static final CmsRole GALLERY_EDITOR;
    public static final String PRINCIPAL_ROLE = "ROLE";
    public static final CmsRole PROJECT_MANAGER;
    public static final CmsRole ROOT_ADMIN;
    public static final CmsRole VFS_MANAGER;
    public static final CmsRole WORKPLACE_MANAGER;
    public static final CmsRole WORKPLACE_USER;
    private static final List<CmsRole> SYSTEM_ROLES;
    private final List<CmsRole> m_children = new ArrayList<CmsRole>();
    private List<String> m_distictGroupNames = new ArrayList<String>();
    private final String m_groupName;
    private final CmsUUID m_id;
    private boolean m_ouDependent;
    private String m_ouFqn;
    private final CmsRole m_parentRole;
    private final String m_roleName;
    private boolean m_systemRole;

    public CmsRole(String roleName, CmsRole parentRole, String groupName, boolean ouDependent) {
        this(roleName, parentRole, groupName);
        this.m_ouDependent = ouDependent;
        this.m_systemRole = false;
        this.initialize();
    }

    private CmsRole(CmsRole role) {
        this.m_roleName = role.m_roleName;
        this.m_id = role.m_id;
        this.m_groupName = role.m_groupName;
        this.m_parentRole = role.m_parentRole;
        this.m_systemRole = role.m_systemRole;
        this.m_ouDependent = role.m_ouDependent;
        this.m_children.addAll(role.m_children);
        this.m_distictGroupNames.addAll(Collections.unmodifiableList(role.m_distictGroupNames));
    }

    private CmsRole(String roleName, CmsRole parentRole, String groupName) {
        this.m_roleName = roleName;
        this.m_id = CmsUUID.getConstantUUID(this.m_roleName);
        this.m_ouDependent = !groupName.startsWith("/");
        this.m_parentRole = parentRole;
        this.m_systemRole = true;
        this.m_groupName = !this.m_ouDependent ? groupName.substring(1) : groupName;
        if (parentRole != null) {
            parentRole.m_children.add(this);
        }
    }

    public static void applySystemRoleOrder(List<CmsRole> roles) {
        HashMap<String, CmsRole> ouRoles = new HashMap<String, CmsRole>();
        for (CmsRole role : roles) {
            ouRoles.put(role.getRoleName(), role);
        }
        roles.clear();
        for (CmsRole sysRole : CmsRole.getSystemRoles()) {
            if (!ouRoles.containsKey(sysRole.getRoleName())) continue;
            roles.add((CmsRole)ouRoles.get(sysRole.getRoleName()));
        }
    }

    public static List<CmsRole> getSystemRoles() {
        return SYSTEM_ROLES;
    }

    public static boolean hasPrefix(String principalName) {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly(principalName) && principalName.trim().toUpperCase().startsWith("ROLE.");
    }

    public static String removePrefix(String principalName) {
        String result = principalName;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(principalName) && CmsRole.hasPrefix(principalName)) {
            result = principalName.trim().substring(PRINCIPAL_ROLE.length() + 1);
        }
        return result;
    }

    public static CmsRole valueOf(CmsGroup group) {
        CmsRole role;
        if (group.isRole() && (role = CmsRole.valueOfGroupName(group.getName())) != null) {
            return role;
        }
        if (group.isVirtual()) {
            int index = group.getFlags() & 0xFFFF;
            CmsRole role2 = CmsRole.getSystemRoles().get(index /= 2048);
            return role2.forOrgUnit(group.getOuFqn());
        }
        return null;
    }

    public static CmsRole valueOfGroupName(String groupName) {
        String groupOu = CmsOrganizationalUnit.getParentFqn(groupName);
        for (CmsRole role : SYSTEM_ROLES) {
            if (groupName.equals(role.getGroupName())) {
                return role.forOrgUnit(groupOu);
            }
            if (role.isOrganizationalUnitIndependent() || !groupName.endsWith("/" + role.getGroupName())) continue;
            return role.forOrgUnit(groupOu);
        }
        return null;
    }

    public static CmsRole valueOfId(CmsUUID roleId) {
        for (CmsRole role : SYSTEM_ROLES) {
            if (!roleId.equals(role.getId())) continue;
            return role;
        }
        return null;
    }

    public static CmsRole valueOfRoleName(String roleName) {
        String roleOu = CmsOrganizationalUnit.getParentFqn(roleName);
        for (CmsRole role : SYSTEM_ROLES) {
            if (roleName.equals(role.getRoleName())) {
                return role.forOrgUnit(roleOu);
            }
            if (role.isOrganizationalUnitIndependent() || !roleName.endsWith("/" + role.getRoleName())) continue;
            return role.forOrgUnit(roleOu);
        }
        return null;
    }

    public CmsRoleViolationException createRoleViolationException(CmsRequestContext requestContext) {
        return new CmsRoleViolationException(Messages.get().container("ERR_USER_NOT_IN_ROLE_2", requestContext.getCurrentUser().getName(), this.getName(requestContext.getLocale())));
    }

    public CmsRoleViolationException createRoleViolationExceptionForOrgUnit(CmsRequestContext requestContext, String orgUnitFqn) {
        return new CmsRoleViolationException(Messages.get().container("ERR_USER_NOT_IN_ROLE_FOR_ORGUNIT_3", requestContext.getCurrentUser().getName(), this.getName(requestContext.getLocale()), orgUnitFqn));
    }

    public CmsRoleViolationException createRoleViolationExceptionForResource(CmsRequestContext requestContext, CmsResource resource) {
        return new CmsRoleViolationException(Messages.get().container("ERR_USER_NOT_IN_ROLE_FOR_RESOURCE_3", requestContext.getCurrentUser().getName(), this.getName(requestContext.getLocale()), requestContext.removeSiteRoot(resource.getRootPath())));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsRole) {
            CmsRole that = (CmsRole)obj;
            if (this.m_roleName.equals(that.m_roleName)) {
                if (this.isOrganizationalUnitIndependent()) {
                    return true;
                }
                if (this.m_ouFqn == null) {
                    return that.m_ouFqn == null;
                }
                return this.m_ouFqn.equals(that.m_ouFqn);
            }
        }
        return false;
    }

    public CmsRole forOrgUnit(String ouFqn) {
        CmsRole newRole = new CmsRole(this);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(ouFqn) && !ouFqn.endsWith("/")) {
            ouFqn = ouFqn + "/";
        }
        newRole.m_ouFqn = ouFqn;
        return newRole;
    }

    public List<CmsRole> getChildren(boolean recursive) {
        ArrayList<CmsRole> children = new ArrayList<CmsRole>();
        for (CmsRole child : this.m_children) {
            child = child.isOrganizationalUnitIndependent() ? child.forOrgUnit(null) : child.forOrgUnit(this.m_ouFqn);
            children.add(child);
            if (!recursive) continue;
            for (CmsRole grandChild : child.getChildren(true)) {
                if (children.contains(grandChild)) continue;
                children.add(grandChild);
            }
        }
        return children;
    }

    public String getDescription(Locale locale) {
        if (this.m_systemRole) {
            return Messages.get().getBundle(locale).key("GUI_ROLE_DESCRIPTION_" + this.m_roleName + "_0");
        }
        return this.getName(locale);
    }

    public String getDisplayName(CmsObject cms, Locale locale) throws CmsException {
        return Messages.get().getBundle(locale).key("GUI_PRINCIPAL_DISPLAY_NAME_2", this.getName(locale), OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, this.getOuFqn()).getDisplayName(locale));
    }

    public List<String> getDistinctGroupNames() {
        return this.m_distictGroupNames;
    }

    public String getFqn() {
        if (this.getOuFqn() == null) {
            return this.getRoleName();
        }
        return this.getOuFqn() + this.getRoleName();
    }

    public String getGroupName() {
        if (this.m_ouFqn == null || this.isOrganizationalUnitIndependent()) {
            return this.m_groupName;
        }
        return this.m_ouFqn + this.m_groupName;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public String getName(Locale locale) {
        if (this.m_systemRole) {
            return Messages.get().getBundle(locale).key("GUI_ROLENAME_" + this.m_roleName + "_0");
        }
        return this.getRoleName();
    }

    public String getOuFqn() {
        return CmsOrganizationalUnit.removeLeadingSeparator(this.m_ouFqn);
    }

    public CmsRole getParentRole() {
        if (this.m_parentRole == null) {
            return null;
        }
        return this.m_parentRole.forOrgUnit(this.m_ouFqn);
    }

    public String getRoleName() {
        return this.m_roleName;
    }

    public int getVirtualGroupFlags() {
        int flags = 1024;
        return flags += 2048 * CmsRole.getSystemRoles().indexOf(this.forOrgUnit(null));
    }

    public int hashCode() {
        return this.m_roleName.hashCode() + (this.m_ouFqn == null || this.isOrganizationalUnitIndependent() ? 13 : this.m_ouFqn.hashCode());
    }

    public boolean isOrganizationalUnitIndependent() {
        return !this.m_ouDependent;
    }

    public boolean isSystemRole() {
        return this.m_systemRole;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(this.getClass().getName());
        result.append(", role: ");
        result.append(this.getRoleName());
        result.append(", org unit: ");
        result.append(this.getOuFqn());
        result.append(", group: ");
        result.append(this.getGroupName());
        result.append("]");
        return result.toString();
    }

    private Set<String> getAllGroupNames() {
        CmsRole root = this;
        while (root.getParentRole() != null) {
            root = root.getParentRole();
        }
        List<CmsRole> allRoles = root.getChildren(true);
        allRoles.add(root);
        HashMultimap mapOfParents = HashMultimap.create();
        for (CmsRole parent : allRoles) {
            for (CmsRole child : parent.getChildren(false)) {
                mapOfParents.put((Object)child, (Object)parent);
            }
        }
        HashSet visited = Sets.newHashSet();
        HashSet workingSet = Sets.newHashSet();
        HashSet result = Sets.newHashSet();
        workingSet.add(this);
        while (!workingSet.isEmpty()) {
            CmsRole current = (CmsRole)workingSet.iterator().next();
            result.add(current.getGroupName());
            workingSet.remove(current);
            for (CmsRole parent : mapOfParents.get((Object)current)) {
                if (visited.contains(parent)) continue;
                workingSet.add(parent);
            }
            visited.add(current);
        }
        return result;
    }

    private void initialize() {
        HashSet<String> distinctGroups = new HashSet<String>(this.getAllGroupNames());
        this.m_distictGroupNames = Collections.unmodifiableList(new ArrayList<String>(distinctGroups));
    }

    static {
        ROOT_ADMIN = new CmsRole("ROOT_ADMIN", null, "/RoleRootAdmins");
        WORKPLACE_MANAGER = new CmsRole("WORKPLACE_MANAGER", ROOT_ADMIN, "/RoleWorkplaceManager");
        DATABASE_MANAGER = new CmsRole("DATABASE_MANAGER", ROOT_ADMIN, "/RoleDatabaseManager");
        ADMINISTRATOR = new CmsRole("ADMINISTRATOR", ROOT_ADMIN, "RoleAdministrators");
        PROJECT_MANAGER = new CmsRole("PROJECT_MANAGER", ADMINISTRATOR, "RoleProjectmanagers");
        ACCOUNT_MANAGER = new CmsRole("ACCOUNT_MANAGER", ADMINISTRATOR, "RoleAccountManagers");
        VFS_MANAGER = new CmsRole("VFS_MANAGER", ADMINISTRATOR, "RoleVfsManagers");
        DEVELOPER = new CmsRole("DEVELOPER", VFS_MANAGER, "RoleDevelopers");
        WORKPLACE_USER = new CmsRole("WORKPLACE_USER", DEVELOPER, "RoleWorkplaceUsers");
        CmsRole.PROJECT_MANAGER.m_children.add(WORKPLACE_USER);
        CmsRole.ACCOUNT_MANAGER.m_children.add(WORKPLACE_USER);
        GALLERY_EDITOR = new CmsRole("GALLERY_EDITOR", WORKPLACE_USER, "RoleGalleryEditor");
        CATEGORY_EDITOR = new CmsRole("CATEGORY_EDITOR", WORKPLACE_USER, "RoleCategoryEditor");
        EDITOR = new CmsRole("EDITOR", GALLERY_EDITOR, "RoleEditor");
        CmsRole.CATEGORY_EDITOR.m_children.add(EDITOR);
        ELEMENT_AUTHOR = new CmsRole("ELEMENT_AUTHOR", EDITOR, "RoleElementAuthor");
        SYSTEM_ROLES = Collections.unmodifiableList(Arrays.asList(ROOT_ADMIN, WORKPLACE_MANAGER, DATABASE_MANAGER, ADMINISTRATOR, PROJECT_MANAGER, ACCOUNT_MANAGER, VFS_MANAGER, DEVELOPER, WORKPLACE_USER, GALLERY_EDITOR, CATEGORY_EDITOR, EDITOR, ELEMENT_AUTHOR));
        for (int i = 0; i < SYSTEM_ROLES.size(); ++i) {
            SYSTEM_ROLES.get(i).initialize();
        }
    }
}

