/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.site.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public final class CmsSiteManagerImpl {
    public static final String SHARED_FOLDER_TITLE = "%SHARED_FOLDER%";
    private static final Log LOG = CmsLog.getLog(CmsSiteManagerImpl.class);
    private static final String SITES_FOLDER = "/sites/";
    private static final int SITES_FOLDER_POS = "/sites/".length() + 1;
    private List<String> m_additionalSiteRoots;
    private List<CmsSiteMatcher> m_aliases;
    private CmsSite m_defaultSite;
    private String m_defaultUri;
    private boolean m_frozen;
    private String m_sharedFolder;
    private List<CmsSiteMatcher> m_siteMatchers;
    private Map<CmsSiteMatcher, CmsSite> m_siteMatcherSites = new HashMap<CmsSiteMatcher, CmsSite>();
    private SortedMap<String, String> m_siteParams;
    private Map<String, CmsSite> m_siteRootSites = new HashMap<String, CmsSite>();
    private List<CmsSiteMatcher> m_workplaceMatchers;
    private List<String> m_workplaceServers;

    public CmsSiteManagerImpl() {
        this.m_aliases = new ArrayList<CmsSiteMatcher>();
        this.m_siteParams = new TreeMap<String, String>();
        this.m_additionalSiteRoots = new ArrayList<String>();
        this.m_workplaceServers = new ArrayList<String>();
        this.m_workplaceMatchers = new ArrayList<CmsSiteMatcher>();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_START_SITE_CONFIG_0"));
        }
    }

    public void addAliasToConfigSite(String alias, String offset) {
        long timeOffset = 0L;
        try {
            timeOffset = Long.parseLong(offset);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CmsSiteMatcher siteMatcher = new CmsSiteMatcher(alias, timeOffset);
        this.m_aliases.add(siteMatcher);
    }

    public void addParamToConfigSite(String name, String value) {
        this.m_siteParams.put(name, value);
    }

    public void addSite(CmsObject cms, CmsSite site) throws CmsException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        }
        this.m_frozen = false;
        this.m_siteParams = site.getParameters();
        this.m_aliases = site.getAliases();
        String secureUrl = null;
        if (site.hasSecureServer()) {
            secureUrl = site.getSecureUrl();
        }
        this.addSite(site.getUrl(), site.getSiteRoot(), site.getTitle(), Float.toString(site.getPosition()), site.getErrorPage(), Boolean.toString(site.isWebserver()), secureUrl, Boolean.toString(site.isExclusiveUrl()), Boolean.toString(site.isExclusiveError()), Boolean.toString(site.usesPermanentRedirects()));
        this.initialize(cms);
        OpenCms.writeConfiguration(CmsSystemConfiguration.class);
    }

    public void addSite(String server, String uri, String title, String position, String errorPage, String webserver, String secureServer, String exclusive, String error, String usePermanentRedirects) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        if (this.getSiteRoots().contains(uri)) {
            throw new CmsRuntimeException(Messages.get().container("ERR_SITE_ALREADY_CONFIGURED_1", uri));
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(server)) {
            throw new CmsRuntimeException(Messages.get().container("ERR_EMPTY_SERVER_URL_0"));
        }
        CmsSiteMatcher matcher2 = new CmsSiteMatcher(server);
        CmsSite site = new CmsSite(uri, matcher2);
        site.setTitle(title);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(position)) {
            float pos = Float.MAX_VALUE;
            try {
                pos = Float.parseFloat(position);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            site.setPosition(pos);
        }
        site.setErrorPage(errorPage);
        site.setWebserver(Boolean.valueOf(webserver));
        this.addServer(matcher2, site);
        if (CmsStringUtil.isNotEmpty(secureServer)) {
            matcher2 = new CmsSiteMatcher(secureServer);
            site.setSecureServer(matcher2);
            site.setExclusiveUrl(Boolean.valueOf(exclusive));
            site.setExclusiveError(Boolean.valueOf(error));
            site.setUsePermanentRedirects(Boolean.valueOf(usePermanentRedirects));
            this.addServer(matcher2, site);
        }
        site.setAliases(this.m_aliases);
        for (CmsSiteMatcher matcher2 : this.m_aliases) {
            this.addServer(matcher2, site);
        }
        this.m_aliases = new ArrayList<CmsSiteMatcher>();
        site.setParameters(this.m_siteParams);
        this.m_siteParams = new TreeMap<String, String>();
        this.m_siteRootSites = new HashMap<String, CmsSite>(this.m_siteRootSites);
        this.m_siteRootSites.put(site.getSiteRoot(), site);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SITE_ROOT_ADDED_1", site.toString()));
        }
    }

    public void addWorkplaceServer(String workplaceServer) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        if (!this.m_workplaceServers.contains(workplaceServer)) {
            this.m_workplaceServers.add(workplaceServer);
        }
    }

    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode) {
        return this.getAvailableSites(cms, workplaceMode, cms.getRequestContext().getOuFqn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode, boolean showShared, String ouFqn) {
        String folder;
        ArrayList<String> siteroots = new ArrayList<String>(this.m_siteMatcherSites.size() + 1);
        HashMap<String, CmsSiteMatcher> siteServers = new HashMap<String, CmsSiteMatcher>(this.m_siteMatcherSites.size() + 1);
        ArrayList<CmsSite> result = new ArrayList<CmsSite>(this.m_siteMatcherSites.size() + 1);
        Iterator<CmsSiteMatcher> i = this.m_siteMatcherSites.keySet().iterator();
        while (i.hasNext()) {
            CmsSite site = this.m_siteMatcherSites.get(i.next());
            String folder2 = CmsFileUtil.addTrailingSeparator(site.getSiteRoot());
            if (siteroots.contains(folder2)) continue;
            siteroots.add(folder2);
            siteServers.put(folder2, site.getSiteMatcher());
        }
        if (workplaceMode && this.m_defaultSite != null && !siteroots.contains(folder = CmsFileUtil.addTrailingSeparator(this.m_defaultSite.getSiteRoot()))) {
            siteroots.add(folder);
        }
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            List<CmsResource> resources;
            cms.getRequestContext().setSiteRoot("/");
            if (workplaceMode && OpenCms.getRoleManager().hasRole(cms, CmsRole.VFS_MANAGER)) {
                if (!siteroots.contains("/")) {
                    siteroots.add("/");
                }
                if (!siteroots.contains(CmsFileUtil.addTrailingSeparator(storedSiteRoot))) {
                    siteroots.add(CmsFileUtil.addTrailingSeparator(storedSiteRoot));
                }
            }
            String shared = OpenCms.getSiteManager().getSharedFolder();
            if (showShared && shared != null && !siteroots.contains(shared)) {
                siteroots.add(shared);
            }
            try {
                resources = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(cms, ouFqn);
            }
            catch (CmsException e) {
                List<CmsSite> list = Collections.emptyList();
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
                return list;
            }
            Collections.sort(siteroots);
            for (String folder3 : siteroots) {
                boolean compatible = false;
                for (CmsResource resource : resources) {
                    if (!resource.getRootPath().startsWith(folder3) && !folder3.startsWith(resource.getRootPath())) continue;
                    compatible = true;
                    break;
                }
                if (!compatible) continue;
                try {
                    CmsResource res = cms.readResource(folder3);
                    if (workplaceMode && !cms.hasPermissions(res, CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.ONLY_VISIBLE)) continue;
                    CmsSite configuredSite = this.m_siteRootSites.get(CmsFileUtil.removeTrailingSeparator(folder3));
                    String title = null;
                    if (configuredSite != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuredSite.getTitle())) {
                        title = configuredSite.getTitle();
                    }
                    if (title == null) {
                        title = this.getSiteTitle(cms, res);
                    }
                    String position = null;
                    if (configuredSite != null && configuredSite.getPosition() != Float.MAX_VALUE) {
                        position = Float.toString(configuredSite.getPosition());
                    }
                    if (position == null) {
                        position = cms.readPropertyObject(res, "NavPos", false).getValue();
                    }
                    if (configuredSite != null) {
                        float pos = Float.MAX_VALUE;
                        try {
                            pos = Float.parseFloat(position);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        CmsSite clone = (CmsSite)configuredSite.clone();
                        clone.setPosition(pos);
                        clone.setTitle(title);
                        result.add(clone);
                        continue;
                    }
                    result.add(new CmsSite(folder3, res.getStructureId(), title, (CmsSiteMatcher)siteServers.get(folder3), position));
                }
                catch (CmsException cmsException) {}
            }
            Collections.sort(result, new Comparator<CmsSite>(){

                @Override
                public int compare(CmsSite o1, CmsSite o2) {
                    if (CmsSiteManagerImpl.this.isSharedFolder(o1.getSiteRoot())) {
                        return 1;
                    }
                    if (CmsSiteManagerImpl.this.isSharedFolder(o2.getSiteRoot())) {
                        return -1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READ_SITE_PROP_FAILED_0"), t);
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
        return result;
    }

    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode, String ouFqn) {
        return this.getAvailableSites(cms, workplaceMode, workplaceMode, ouFqn);
    }

    public CmsSite getCurrentSite(CmsObject cms) {
        CmsSite site = this.getSiteForSiteRoot(cms.getRequestContext().getSiteRoot());
        return site == null ? this.m_defaultSite : site;
    }

    public CmsSite getDefaultSite() {
        return this.m_defaultSite;
    }

    public String getDefaultUri() {
        return this.m_defaultUri;
    }

    public String getSharedFolder() {
        return this.m_sharedFolder;
    }

    public CmsSite getSite(String rootPath, String fallbackSiteRoot) {
        CmsSite result = this.getSiteForRootPath(rootPath);
        if (result == null && (result = this.getSiteForSiteRoot(fallbackSiteRoot)) == null) {
            result = this.getDefaultSite();
        }
        return result;
    }

    public Optional<CmsSite> getSiteForDefaultUri() {
        String defaultUri = this.getDefaultUri();
        CmsSite candidate = this.m_siteRootSites.get(CmsFileUtil.removeTrailingSeparator(defaultUri));
        return Optional.fromNullable((Object)candidate);
    }

    public CmsSite getSiteForRootPath(String rootPath) {
        CmsSite result;
        if (rootPath.length() > 0 && !rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if ((result = this.lookupSitesFolder(rootPath)) != null) {
            return result;
        }
        String siteRoot = this.lookupAdditionalSite(rootPath);
        return siteRoot != null ? this.getSiteForSiteRoot(siteRoot) : null;
    }

    public CmsSite getSiteForSiteRoot(String siteRoot) {
        return this.m_siteRootSites.get(siteRoot);
    }

    public String getSiteRoot(String rootPath) {
        CmsSite site;
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if ((site = this.lookupSitesFolder(rootPath)) != null) {
            return site.getSiteRoot();
        }
        return this.lookupAdditionalSite(rootPath);
    }

    public Set<String> getSiteRoots() {
        return this.m_siteRootSites.keySet();
    }

    public Map<CmsSiteMatcher, CmsSite> getSites() {
        return this.m_siteMatcherSites;
    }

    public String getSiteTitle(CmsObject cms, CmsResource resource) throws CmsException {
        String title = cms.readPropertyObject(resource, "Title", false).getValue();
        if (title == null) {
            title = resource.getRootPath();
        }
        if (resource.getRootPath().equals(this.getSharedFolder())) {
            title = SHARED_FOLDER_TITLE;
        }
        return title;
    }

    public String getWorkplaceServer() {
        return this.m_workplaceServers.isEmpty() ? null : this.m_workplaceServers.get(0);
    }

    public List<String> getWorkplaceServers() {
        return Collections.unmodifiableList(this.m_workplaceServers);
    }

    public CmsSiteMatcher getWorkplaceSiteMatcher() {
        return this.m_workplaceMatchers.isEmpty() ? null : this.m_workplaceMatchers.get(0);
    }

    public void initialize(CmsObject cms) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_SITE_ROOTS_CONFIGURED_1", new Integer(this.m_siteMatcherSites.size() + (this.m_defaultUri != null ? 1 : 0))));
        }
        try {
            block19: {
                CmsObject clone = OpenCms.initCmsObject(cms);
                clone.getRequestContext().setSiteRoot("");
                for (CmsSite site : this.m_siteMatcherSites.values()) {
                    try {
                        String title;
                        CmsResource siteRes = clone.readResource(site.getSiteRoot());
                        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(site.getTitle()) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(title = clone.readPropertyObject(siteRes, "Title", false).getValue())) continue;
                        site.setTitle(title);
                    }
                    catch (Throwable t) {
                        if (!CmsLog.INIT.isWarnEnabled()) continue;
                        CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_NO_ROOT_FOLDER_1", site));
                    }
                }
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_defaultUri)) {
                    this.m_defaultSite = null;
                } else {
                    this.m_defaultSite = new CmsSite(this.m_defaultUri, CmsSiteMatcher.DEFAULT_MATCHER);
                    try {
                        clone.readResource(this.m_defaultSite.getSiteRoot());
                    }
                    catch (Throwable t) {
                        if (!CmsLog.INIT.isWarnEnabled()) break block19;
                        CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_NO_ROOT_FOLDER_DEFAULT_SITE_1", this.m_defaultSite));
                    }
                }
            }
            if (this.m_defaultSite == null) {
                this.m_defaultSite = new CmsSite("/", CmsSiteMatcher.DEFAULT_MATCHER);
            }
            if (CmsLog.INIT.isInfoEnabled()) {
                if (this.m_defaultSite != null) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_SITE_ROOT_1", this.m_defaultSite));
                } else {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_SITE_ROOT_0"));
                }
            }
            if (!this.m_workplaceServers.isEmpty()) {
                for (String server : this.m_workplaceServers) {
                    CmsSiteMatcher matcher = new CmsSiteMatcher(server);
                    this.m_workplaceMatchers.add(matcher);
                    if (!CmsLog.INIT.isInfoEnabled()) continue;
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_SITE_1", matcher));
                }
            } else if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_SITE_0"));
            }
            this.setSiteMatcherSites(this.m_siteMatcherSites);
            for (String root : this.m_siteRootSites.keySet()) {
                if (root.startsWith(SITES_FOLDER)) continue;
                this.m_additionalSiteRoots.add(root);
            }
            this.m_frozen = true;
        }
        catch (CmsException e) {
            LOG.warn((Object)e);
        }
    }

    public boolean isMatching(CmsSiteMatcher matcher) {
        boolean result;
        boolean bl = result = this.m_siteMatcherSites.get(matcher) != null;
        if (!result) {
            result = this.isWorkplaceRequest(matcher);
        }
        return result;
    }

    public boolean isMatchingCurrentSite(CmsObject cms, CmsSiteMatcher matcher) {
        return this.m_siteMatcherSites.get(matcher) == this.getCurrentSite(cms);
    }

    public boolean isSharedFolder(String name) {
        return this.m_sharedFolder != null && this.m_sharedFolder.equals(CmsStringUtil.joinPaths("/", name, "/"));
    }

    public boolean isSiteRoot(String rootPath) {
        String siteRoot = this.getSiteRoot(rootPath);
        rootPath = CmsStringUtil.joinPaths(rootPath, "/");
        return rootPath.equals(siteRoot);
    }

    public boolean isWorkplaceRequest(CmsSiteMatcher matcher) {
        return this.m_workplaceMatchers.contains(matcher);
    }

    public boolean isWorkplaceRequest(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        return this.isWorkplaceRequest(this.getRequestMatcher(req));
    }

    public CmsSite matchRequest(HttpServletRequest req) {
        HttpSession session;
        CmsSiteMatcher matcher = this.getRequestMatcher(req);
        if (matcher.getTimeOffset() != 0L && (session = req.getSession()) != null) {
            session.setAttribute("__org.opencms.main.CmsContextInfo#m_requestTime", (Object)new Long(System.currentTimeMillis() + matcher.getTimeOffset()));
        }
        CmsSite site = this.matchSite(matcher);
        if (LOG.isDebugEnabled()) {
            String requestServer = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MATCHING_REQUEST_TO_SITE_2", requestServer, site.toString()));
        }
        return site;
    }

    public CmsSite matchSite(CmsSiteMatcher matcher) {
        CmsSite site = this.m_siteMatcherSites.get(matcher);
        if (site == null) {
            site = this.m_defaultSite;
        }
        return site;
    }

    public void removeSite(CmsObject cms, CmsSite site) throws CmsException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        }
        this.m_frozen = false;
        HashMap<CmsSiteMatcher, CmsSite> siteMatcherSites = new HashMap<CmsSiteMatcher, CmsSite>();
        for (Map.Entry<CmsSiteMatcher, CmsSite> entry : this.m_siteMatcherSites.entrySet()) {
            boolean isSite = site.getUrl().equals(entry.getKey().getUrl());
            boolean isSecure = site.hasSecureServer() ? site.getSecureUrl().equals(entry.getKey().getUrl()) : false;
            boolean isAlias = site.getAliases().contains(entry.getKey());
            if (isSite || isSecure || isAlias) continue;
            siteMatcherSites.put(entry.getKey(), entry.getValue());
        }
        this.setSiteMatcherSites(siteMatcherSites);
        HashMap<String, CmsSite> siteRootSites = new HashMap<String, CmsSite>(this.m_siteRootSites);
        siteRootSites.remove(site.getSiteRoot());
        this.m_siteRootSites = Collections.unmodifiableMap(siteRootSites);
        this.initialize(cms);
        OpenCms.writeConfiguration(CmsSystemConfiguration.class);
    }

    public void setDefaultUri(String defaultUri) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_defaultUri = defaultUri;
    }

    public void setSharedFolder(String sharedFolder) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_sharedFolder = CmsStringUtil.joinPaths("/", sharedFolder, "/");
    }

    public boolean startsWithShared(String path) {
        return this.m_sharedFolder != null && CmsFileUtil.addTrailingSeparator(path).startsWith(this.m_sharedFolder);
    }

    public void updateGeneralSettings(CmsObject cms, String defaulrUri, String workplaceServer, String sharedFolder) throws CmsException {
        CmsObject clone = OpenCms.initCmsObject(cms);
        clone.getRequestContext().setSiteRoot("");
        if (sharedFolder == null || sharedFolder.equals("") || sharedFolder.equals("/") || !sharedFolder.startsWith("/") || !sharedFolder.endsWith("/") || sharedFolder.startsWith(SITES_FOLDER)) {
            throw new CmsException(Messages.get().container("ERR_INVALID_PATH_FOR_SHARED_FOLDER_1", sharedFolder));
        }
        this.m_frozen = false;
        this.setDefaultUri(clone.readResource(defaulrUri).getRootPath());
        this.setSharedFolder(clone.readResource(sharedFolder).getRootPath());
        this.m_frozen = true;
    }

    public void updateSite(CmsObject cms, CmsSite oldSite, CmsSite newSite) throws CmsException {
        if (oldSite != null) {
            this.removeSite(cms, oldSite);
        }
        if (newSite != null) {
            this.addSite(cms, newSite);
        }
    }

    public boolean usesSecureSite(HttpServletRequest req) {
        CmsSite site = this.matchRequest(req);
        if (site == null) {
            return false;
        }
        CmsSiteMatcher secureMatcher = site.getSecureServerMatcher();
        boolean result = false;
        if (secureMatcher != null) {
            result = secureMatcher.equals(this.getRequestMatcher(req));
        }
        return result;
    }

    private void addServer(CmsSiteMatcher matcher, CmsSite site) throws CmsConfigurationException {
        if (this.m_siteMatcherSites.containsKey(matcher)) {
            throw new CmsConfigurationException(Messages.get().container("ERR_DUPLICATE_SERVER_NAME_1", matcher.getUrl()));
        }
        HashMap<CmsSiteMatcher, CmsSite> siteMatcherSites = new HashMap<CmsSiteMatcher, CmsSite>(this.m_siteMatcherSites);
        siteMatcherSites.put(matcher, site);
        this.setSiteMatcherSites(siteMatcherSites);
    }

    private CmsSiteMatcher getRequestMatcher(HttpServletRequest req) {
        CmsSiteMatcher matcher = new CmsSiteMatcher(req.getScheme(), req.getServerName(), req.getServerPort());
        int index = this.m_siteMatchers.indexOf(matcher);
        if (index < 0) {
            return matcher;
        }
        return this.m_siteMatchers.get(index);
    }

    private String lookupAdditionalSite(String rootPath) {
        int size = this.m_additionalSiteRoots.size();
        for (int i = 0; i < size; ++i) {
            String siteRoot = this.m_additionalSiteRoots.get(i);
            if (!rootPath.startsWith(siteRoot)) continue;
            return siteRoot;
        }
        return null;
    }

    private CmsSite lookupSitesFolder(String rootPath) {
        int pos = rootPath.indexOf(47, SITES_FOLDER_POS);
        if (pos > 0) {
            return this.m_siteRootSites.get(rootPath.substring(0, pos));
        }
        return null;
    }

    private void setSiteMatcherSites(Map<CmsSiteMatcher, CmsSite> siteMatcherSites) {
        this.m_siteMatcherSites = Collections.unmodifiableMap(siteMatcherSites);
        this.m_siteMatchers = Collections.unmodifiableList(new ArrayList<CmsSiteMatcher>(this.m_siteMatcherSites.keySet()));
    }
}

