/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site.xmlsitemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsPathIncludeExcludeSet {
    private Set<String> m_allPaths = new TreeSet<String>();
    private Set<String> m_excludes = new HashSet<String>();
    private Set<String> m_includes = new HashSet<String>();

    public void addExclude(String exclude) {
        exclude = this.normalizePath(exclude);
        this.m_excludes.add(exclude);
        this.m_allPaths.add(exclude);
    }

    public void addInclude(String include) {
        include = this.normalizePath(include);
        this.m_includes.add(include);
        this.m_allPaths.add(include);
    }

    public Set<String> getIncludeRoots() {
        ArrayList<String> pathList = new ArrayList<String>(this.m_includes);
        HashSet<String> includeRoots = new HashSet<String>();
        Collections.sort(pathList);
        while (!pathList.isEmpty()) {
            Iterator iterator = pathList.iterator();
            String firstPath = (String)iterator.next();
            includeRoots.add(firstPath);
            iterator.remove();
            while (iterator.hasNext()) {
                String currentPath = (String)iterator.next();
                if (!CmsStringUtil.isPrefixPath(firstPath, currentPath)) continue;
                iterator.remove();
            }
        }
        return includeRoots;
    }

    public boolean isExcluded(String path) {
        path = this.normalizePath(path);
        ArrayList<String> pathList = new ArrayList<String>(this.m_allPaths);
        Collections.reverse(pathList);
        for (String pathInList : pathList) {
            if (!CmsStringUtil.isPrefixPath(pathInList, path)) continue;
            return this.m_excludes.contains(pathInList);
        }
        return false;
    }

    protected String normalizePath(String path) {
        if (path.equals("/")) {
            return path;
        }
        return CmsFileUtil.removeTrailingSeparator(path);
    }
}

