/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site.xmlsitemap;

import java.lang.reflect.Constructor;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.xmlsitemap.CmsPathIncludeExcludeSet;
import org.opencms.site.xmlsitemap.CmsXmlSeoConfiguration;
import org.opencms.site.xmlsitemap.CmsXmlSitemapGenerator;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsXmlSitemapActionElement
extends CmsJspActionElement {
    private static final Log LOG = CmsLog.getLog(CmsXmlSitemapActionElement.class);
    private static final String PARAM_DEFAULT_SITEMAP_GENERATOR = "sitemap.generator";
    protected CmsXmlSeoConfiguration m_configuration;

    public CmsXmlSitemapActionElement(PageContext pageContext, HttpServletRequest request, HttpServletResponse response) {
        super(pageContext, request, response);
    }

    public CmsXmlSitemapGenerator createSitemapGenerator(String className, String folderRootPath) throws CmsException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(className)) {
            className = (String)OpenCms.getRuntimeProperty(PARAM_DEFAULT_SITEMAP_GENERATOR);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(className)) {
            className = CmsXmlSitemapGenerator.class.getName();
        }
        try {
            Class<CmsXmlSitemapGenerator> generatorClass = Class.forName(className).asSubclass(CmsXmlSitemapGenerator.class);
            Constructor<CmsXmlSitemapGenerator> constructor = generatorClass.getConstructor(String.class);
            CmsXmlSitemapGenerator generator = constructor.newInstance(folderRootPath);
            return generator;
        }
        catch (Exception e) {
            LOG.error((Object)("Could not create configured sitemap generator " + className + ", using the default class instead"), (Throwable)e);
            return new CmsXmlSitemapGenerator(folderRootPath);
        }
    }

    public void renderXmlSitemap() throws Exception {
        CmsObject cms = this.getCmsObject();
        String baseFolderRootPath = CmsFileUtil.removeTrailingSeparator(CmsResource.getParentFolder(cms.getRequestContext().addSiteRoot(cms.getRequestContext().getUri())));
        CmsXmlSitemapGenerator xmlSitemapGenerator = this.createSitemapGenerator(this.m_configuration.getSitemapGeneratorClassName(), baseFolderRootPath);
        xmlSitemapGenerator.setComputeContainerPageDates(this.m_configuration.shouldComputeContainerPageModificationDates());
        CmsPathIncludeExcludeSet inexcludeSet = xmlSitemapGenerator.getIncludeExcludeSet();
        for (String include : this.m_configuration.getIncludes()) {
            inexcludeSet.addInclude(include);
        }
        for (String exclude : this.m_configuration.getExcludes()) {
            inexcludeSet.addExclude(exclude);
        }
        xmlSitemapGenerator.setServerUrl(this.m_configuration.getServerUrl());
        String xmlSitemap = xmlSitemapGenerator.renderSitemap();
        this.getResponse().getWriter().print(xmlSitemap);
    }

    public void run() throws Exception {
        CmsObject cms = this.getCmsObject();
        String seoFilePath = cms.getRequestContext().getUri();
        CmsResource seoFile = cms.readResource(seoFilePath);
        this.m_configuration = new CmsXmlSeoConfiguration();
        this.m_configuration.load(cms, seoFile);
        String mode = this.m_configuration.getMode();
        if (mode.equals(CmsXmlSeoConfiguration.MODE_ROBOTS_TXT)) {
            this.showRobotsTxt();
        } else {
            this.renderXmlSitemap();
        }
    }

    private void showRobotsTxt() throws Exception {
        CmsObject cms = this.getCmsObject();
        StringBuffer buffer = new StringBuffer();
        I_CmsResourceType seoFileType = OpenCms.getResourceManager().getResourceType("seo_file");
        List<CmsResource> seoFiles = cms.readResources("/", CmsResourceFilter.DEFAULT_FILES.addRequireVisible().addRequireType(seoFileType));
        for (CmsResource seoFile : seoFiles) {
            try {
                CmsXmlSeoConfiguration seoFileConfig = new CmsXmlSeoConfiguration();
                seoFileConfig.load(cms, seoFile);
                if (!seoFileConfig.isXmlSitemapMode()) continue;
                buffer.append("Sitemap: " + CmsXmlSitemapGenerator.replaceServerUri(OpenCms.getLinkManager().getOnlineLink(cms, cms.getSitePath(seoFile)), this.m_configuration.getServerUrl()));
                buffer.append("\n");
            }
            catch (CmsException e) {
                LOG.error((Object)("Error while generating robots.txt : " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        buffer.append("\n");
        buffer.append(this.m_configuration.getRobotsTxtText());
        buffer.append("\n");
        this.getResponse().getWriter().print(buffer.toString());
    }
}

