/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ugc.CmsUgcConfiguration;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsUgcConfigurationReader {
    public static final String N_CONTENT_TYPE = "ContentType";
    public static final String N_CONTENT_PATH = "ContentPath";
    public static final String N_NAME_PATTERN = "NamePattern";
    public static final String N_LOCALE = "Locale";
    public static final String N_UPLOAD_PATH = "UploadPath";
    public static final String N_MAX_UPLOAD_SIZE = "MaxUploadSize";
    public static final String N_MAX_NUM_CONTENTS = "MaxNumContents";
    public static final String N_QUEUE_WAIT_TIME = "QueueWaitTime";
    public static final String N_QUEUE_MAX_LENGTH = "QueueMaxLength";
    public static final String N_AUTO_PUBLISH = "AutoPublish";
    public static final String N_VALID_EXTENSIONS = "ValidExtensions";
    public static final String N_USER_FOR_GUEST = "UserForGuest";
    public static final String N_PROJECT_GROUP = "ProjectGroup";
    private CmsObject m_cms;
    private CmsXmlContent m_content;
    public static final String EXTENSIONS_SEPARATOR = ";";

    public CmsUgcConfigurationReader(CmsObject cms) {
        this.m_cms = cms;
    }

    public CmsUgcConfiguration readConfiguration(CmsFile configFile) throws CmsException {
        this.m_content = CmsXmlContentFactory.unmarshal(this.m_cms, configFile);
        String resourceType = this.getStringValue(N_CONTENT_TYPE);
        String contentPath = this.getStringValue(N_CONTENT_PATH);
        CmsResource contentPathResource = this.m_cms.readResource(contentPath);
        String namePattern = this.getStringValue(N_NAME_PATTERN);
        String localeStr = this.getStringValue(N_LOCALE);
        OpenCms.getLocaleManager();
        Locale locale = CmsLocaleManager.getLocale(localeStr);
        Optional uploadPathResource = Optional.absent();
        String uploadPath = this.getStringValue(N_UPLOAD_PATH);
        if (uploadPath != null) {
            uploadPathResource = Optional.of((Object)this.m_cms.readResource(uploadPath));
        }
        Optional<Long> maxUploadSize = this.getLongValue(N_MAX_UPLOAD_SIZE);
        Optional<Integer> maxNumContents = this.getIntValue(N_MAX_NUM_CONTENTS);
        Optional<Long> queueWaitTime = this.getLongValue(N_QUEUE_WAIT_TIME);
        Optional<Integer> maxQueueLength = this.getIntValue(N_QUEUE_MAX_LENGTH);
        boolean autoPublish = Boolean.parseBoolean(this.getStringValue(N_AUTO_PUBLISH));
        String validExtensionsStr = this.getStringValue(N_VALID_EXTENSIONS);
        Optional validExtensions = Optional.absent();
        if (validExtensionsStr != null) {
            validExtensionsStr = validExtensionsStr.trim();
            List<String> extensions = CmsStringUtil.splitAsList(validExtensionsStr, EXTENSIONS_SEPARATOR);
            validExtensions = Optional.of(extensions);
        }
        String userForGuestStr = this.getStringValue(N_USER_FOR_GUEST);
        Optional userForGuest = Optional.absent();
        if (userForGuestStr != null) {
            userForGuest = Optional.of((Object)this.m_cms.readUser(userForGuestStr.trim()));
        }
        String projectGroupStr = this.getStringValue(N_PROJECT_GROUP);
        CmsGroup projectGroup = this.m_cms.readGroup(projectGroupStr.trim());
        CmsUUID id = configFile.getStructureId();
        CmsUgcConfiguration result = new CmsUgcConfiguration(id, (Optional<CmsUser>)userForGuest, projectGroup, resourceType, contentPathResource, namePattern, locale, (Optional<CmsResource>)uploadPathResource, maxUploadSize, maxNumContents, queueWaitTime, maxQueueLength, autoPublish, (Optional<List<String>>)validExtensions);
        result.setPath(configFile.getRootPath());
        return result;
    }

    private Optional<Integer> getIntValue(String path) {
        return this.longToInt(this.getLongValue(path));
    }

    private Optional<Long> getLongValue(String path) {
        String stringValue = this.getStringValue(path);
        if (stringValue == null) {
            return Optional.absent();
        }
        try {
            return Optional.of((Object)Long.valueOf(stringValue.trim()));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Could not read a number from " + path + " ,value= " + stringValue);
        }
    }

    private String getStringValue(String path) {
        I_CmsXmlContentValue value = this.m_content.getValue(path, Locale.ENGLISH);
        if (value == null) {
            return null;
        }
        return value.getStringValue(this.m_cms);
    }

    private Optional<Integer> longToInt(Optional<Long> optLong) {
        if (optLong.isPresent()) {
            return Optional.fromNullable((Object)((int)((Long)optLong.get()).longValue()));
        }
        return Optional.absent();
    }
}

