/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinService;
import com.vaadin.shared.Version;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Label;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.declarative.Design;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;
import org.opencms.ade.galleries.CmsSiteSelectorOptionBuilder;
import org.opencms.ade.galleries.shared.CmsSiteSelectorOption;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.types.A_CmsResourceTypeFolderBase;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.Messages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public final class CmsVaadinUtils {
    public static final Container.Filter FILTER_NO_FOLDERS = new Container.Filter(){
        private static final long serialVersionUID = 1L;

        public boolean appliesToProperty(Object propertyId) {
            return PropertyId.isFolder.equals(propertyId);
        }

        public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
            return (Boolean)item.getItemProperty((Object)PropertyId.isFolder).getValue() == false;
        }
    };
    public static final Container.Filter FILTER_XML_CONTENTS = new Container.Filter(){
        private static final long serialVersionUID = 1L;

        public boolean appliesToProperty(Object propertyId) {
            return PropertyId.isXmlContent.equals(propertyId);
        }

        public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
            return (Boolean)item.getItemProperty((Object)PropertyId.isXmlContent).getValue();
        }
    };
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_VALUE = "value";
    protected static final String BOOTSTRAP_SCRIPT = "vaadin.initApplication(\"%(elementId)\", {\n        \"browserDetailsUrl\": \"%(vaadinServlet)\",\n        \"serviceUrl\": \"%(vaadinServlet)\",\n        \"widgetset\": \"org.opencms.ui.WidgetSet\",\n        \"theme\": \"opencms\",\n        \"versionInfo\": {\"vaadinVersion\": \"%(vaadinVersion)\"},\n        \"vaadinDir\": \"%(vaadinDir)\",\n        \"heartbeatInterval\": 30,\n        \"debug\": false,\n        \"standalone\": false,\n        \"authErrMsg\": {\n            \"message\": \"Take note of any unsaved data, \"+\n                       \"and <u>click here<\\/u> to continue.\",\n            \"caption\": \"Authentication problem\"\n        },\n        \"comErrMsg\": {\n            \"message\": \"Take note of any unsaved data, \"+\n                       \"and <u>click here<\\/u> to continue.\",\n            \"caption\": \"Communication problem\"\n        },\n        \"sessExpMsg\": {\n            \"message\": \"Take note of any unsaved data, \"+\n                       \"and <u>click here<\\/u> to continue.\",\n            \"caption\": \"Session Expired\"\n        }\n    });";
    private static final Logger LOG = Logger.getLogger(CmsVaadinUtils.class);

    private CmsVaadinUtils() {
    }

    public static IndexedContainer buildContainerFromMap(String captionProperty, Map<String, String> map) {
        IndexedContainer container = new IndexedContainer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            container.addItem((Object)entry.getKey()).getItemProperty((Object)captionProperty).setValue((Object)entry.getValue());
        }
        return container;
    }

    public static Button.ClickListener createClickListener(final Runnable action) {
        return new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                action.run();
            }
        };
    }

    public static InputStream filterUtf8ResourceStream(InputStream stream, Function<String, String> transformation) {
        try {
            byte[] streamData = CmsFileUtil.readFully(stream);
            String dataAsString = new String(streamData, "UTF-8");
            byte[] transformedData = ((String)transformation.apply((Object)dataAsString)).getBytes("UTF-8");
            return new ByteArrayInputStream(transformedData);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<CmsProject> getAvailableProjects(CmsObject cms) {
        List<CmsProject> allProjects;
        try {
            String ouFqn = "";
            CmsUserSettings settings = new CmsUserSettings(cms);
            if (!settings.getListAllProjects()) {
                ouFqn = cms.getRequestContext().getCurrentUser().getOuFqn();
            }
            allProjects = new ArrayList<CmsProject>(OpenCms.getOrgUnitManager().getAllAccessibleProjects(cms, ouFqn, settings.getListAllProjects()));
            Iterator<CmsProject> itProjects = allProjects.iterator();
            while (itProjects.hasNext()) {
                CmsProject prj = itProjects.next();
                if (!prj.isHiddenFromSelector()) continue;
                itProjects.remove();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            allProjects = Collections.emptyList();
        }
        return allProjects;
    }

    public static IndexedContainer getAvailableSitesContainer(CmsObject cms, String captionPropertyName) {
        CmsSiteSelectorOptionBuilder optBuilder = new CmsSiteSelectorOptionBuilder(cms);
        optBuilder.addNormalSites(true, new CmsUserSettings(cms).getStartFolder());
        optBuilder.addSharedSite();
        IndexedContainer availableSites = new IndexedContainer();
        availableSites.addContainerProperty((Object)captionPropertyName, String.class, null);
        for (CmsSiteSelectorOption option : optBuilder.getOptions()) {
            Item siteItem = availableSites.addItem((Object)option.getSiteRoot());
            siteItem.getItemProperty((Object)captionPropertyName).setValue((Object)option.getMessage());
        }
        String currentSiteRoot = cms.getRequestContext().getSiteRoot();
        if (!availableSites.containsId((Object)currentSiteRoot)) {
            availableSites.addItem((Object)currentSiteRoot).getItemProperty((Object)captionPropertyName).setValue((Object)currentSiteRoot);
        }
        return availableSites;
    }

    public static String getBootstrapScript(CmsObject cms, String elementId, String servicePath) throws Exception {
        String script = BOOTSTRAP_SCRIPT;
        CmsMacroResolver resolver = new CmsMacroResolver();
        String context = OpenCms.getSystemInfo().getContextPath();
        String vaadinDir = CmsStringUtil.joinPaths(context, "VAADIN/");
        String vaadinVersion = Version.getFullVersion();
        String vaadinServlet = CmsStringUtil.joinPaths(context, servicePath);
        String vaadinBootstrap = CmsStringUtil.joinPaths(context, "VAADIN/vaadinBootstrap.js");
        resolver.addMacro("vaadinDir", vaadinDir);
        resolver.addMacro("vaadinVersion", vaadinVersion);
        resolver.addMacro("elementId", elementId);
        resolver.addMacro("vaadinServlet", vaadinServlet);
        resolver.addMacro("vaadinBootstrap", vaadinBootstrap);
        script = resolver.resolveMacros(script);
        return script;
    }

    public static String getDefaultDesignPath(Component component) {
        String className = component.getClass().getName();
        String designPath = className.replace(".", "/") + ".html";
        return designPath;
    }

    public static String getMessageText(String key, Object ... args) {
        return CmsVaadinUtils.getWpMessagesForCurrentLocale().key(key, args);
    }

    public static IndexedContainer getProjectsContainer(CmsObject cms, String captionPropertyName) {
        IndexedContainer result = new IndexedContainer();
        result.addContainerProperty((Object)captionPropertyName, String.class, null);
        Locale locale = A_CmsUI.get().getLocale();
        List<CmsProject> projects = CmsVaadinUtils.getAvailableProjects(cms);
        boolean isSingleOu = CmsVaadinUtils.isSingleOu(projects);
        for (CmsProject project : projects) {
            String projectName = project.getSimpleName();
            if (!isSingleOu && !project.isOnlineProject()) {
                try {
                    projectName = projectName + " - " + OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, project.getOuFqn()).getDisplayName(locale);
                }
                catch (CmsException e) {
                    LOG.debug((Object)"Error reading project OU.", (Throwable)e);
                    projectName = projectName + " - " + project.getOuFqn();
                }
            }
            Item projectItem = result.addItem((Object)project.getUuid());
            projectItem.getItemProperty((Object)captionPropertyName).setValue((Object)projectName);
        }
        return result;
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)VaadinService.getCurrentRequest();
    }

    public static IndexedContainer getResourceTypesContainer() {
        IndexedContainer types = new IndexedContainer();
        types.addContainerProperty((Object)PropertyId.caption, String.class, null);
        types.addContainerProperty((Object)PropertyId.icon, Resource.class, null);
        types.addContainerProperty((Object)PropertyId.isFolder, Boolean.class, null);
        types.addContainerProperty((Object)PropertyId.isXmlContent, Boolean.class, null);
        for (I_CmsResourceType type : OpenCms.getResourceManager().getResourceTypes()) {
            CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
            if (typeSetting == null) continue;
            Item typeItem = types.addItem((Object)type);
            typeItem.getItemProperty((Object)PropertyId.caption).setValue((Object)CmsVaadinUtils.getMessageText(typeSetting.getKey(), new Object[0]));
            typeItem.getItemProperty((Object)PropertyId.icon).setValue((Object)new ExternalResource(CmsWorkplace.getResourceUri("filetypes/" + typeSetting.getIcon())));
            typeItem.getItemProperty((Object)PropertyId.isXmlContent).setValue((Object)(type instanceof CmsResourceTypeXmlContent));
            typeItem.getItemProperty((Object)PropertyId.isFolder).setValue((Object)(type instanceof A_CmsResourceTypeFolderBase));
        }
        return types;
    }

    public static Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return CmsVaadinUtils.getWindow((Component)component.getParent());
    }

    public static String getWorkplaceLink() {
        return CmsStringUtil.joinPaths("/", OpenCms.getSystemInfo().getContextPath(), "workplace");
    }

    public static ExternalResource getWorkplaceResource(String subPath) {
        return new ExternalResource(CmsWorkplace.getResourceUri(subPath));
    }

    public static CmsMessages getWpMessagesForCurrentLocale() {
        return OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale());
    }

    public static String localizeString(String baseString) {
        if (baseString == null) {
            return null;
        }
        CmsWorkplaceMessages wpMessages = OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale());
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setMessages(wpMessages);
        String result = resolver.resolveMacros(baseString);
        return result;
    }

    public static String messageCancel() {
        return CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CANCEL_0", new Object[0]);
    }

    public static String messageOk() {
        return CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_OK_0", new Object[0]);
    }

    public static void prepareComboBox(ComboBox box, Map<?, String> options) {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)PROPERTY_VALUE, Object.class, null);
        container.addContainerProperty((Object)PROPERTY_LABEL, String.class, (Object)"");
        for (Map.Entry<?, String> entry : options.entrySet()) {
            Item item = container.addItem(entry.getKey());
            item.getItemProperty((Object)PROPERTY_VALUE).setValue(entry.getKey());
            item.getItemProperty((Object)PROPERTY_LABEL).setValue((Object)entry.getValue());
        }
        box.setContainerDataSource((Container)container);
        box.setItemCaptionPropertyId((Object)PROPERTY_LABEL);
    }

    public static void readAndLocalizeDesign(Component component, CmsMessages messages, Map<String, String> macros) {
        String filename;
        Class cls;
        Class<?> componentClass = component.getClass();
        ArrayList classes = Lists.newArrayList();
        classes.add(componentClass);
        classes.addAll(ClassUtils.getAllSuperclasses(componentClass));
        InputStream designStream = null;
        Iterator iterator = classes.iterator();
        while (iterator.hasNext() && !(cls = (Class)iterator.next()).getName().startsWith("com.vaadin") && (designStream = cls.getResourceAsStream(filename = cls.getSimpleName() + ".html")) == null) {
        }
        if (designStream == null) {
            throw new IllegalArgumentException("Design not found for : " + component.getClass());
        }
        CmsVaadinUtils.readAndLocalizeDesign(component, designStream, messages, macros);
    }

    public static InputStream readCustomLayout(Class<? extends Component> layoutClass, String relativeName) {
        CmsMacroResolver resolver = new CmsMacroResolver(){

            @Override
            public String getMacroValue(String macro) {
                return CmsEncoder.escapeXml(super.getMacroValue(macro));
            }
        };
        resolver.setMessages(CmsVaadinUtils.getWpMessagesForCurrentLocale());
        InputStream layoutStream = CmsVaadinUtils.filterUtf8ResourceStream(layoutClass.getResourceAsStream(relativeName), resolver.toFunction());
        return layoutStream;
    }

    public static <T> void setReadonlyValue(AbstractField<T> field, T value) {
        boolean readonly = field.isReadOnly();
        try {
            field.setReadOnly(false);
            field.setValue(value);
        }
        finally {
            field.setReadOnly(readonly);
        }
    }

    public static void showAlert(String title, String message, final Runnable callback) {
        final Window window = new Window();
        window.setModal(true);
        Panel panel = new Panel();
        panel.setCaption(title);
        panel.setWidth("500px");
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        panel.setContent((Component)layout);
        layout.addComponent((Component)new Label(message));
        Button okButton = new Button();
        okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
                if (callback != null) {
                    callback.run();
                }
            }
        });
        layout.addComponent((Component)okButton);
        layout.setComponentAlignment((Component)okButton, Alignment.BOTTOM_RIGHT);
        okButton.setCaption(Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_DIALOG_BUTTON_OK_0"));
        window.setContent((Component)panel);
        window.setClosable(false);
        window.setResizable(false);
        A_CmsUI.get().addWindow(window);
    }

    public static OptionGroupBuilder startOptionGroup() {
        return new OptionGroupBuilder();
    }

    public static void visitDescendants(Component component, Predicate<Component> handler) {
        ArrayList stack = Lists.newArrayList();
        stack.add(component);
        while (!stack.isEmpty()) {
            Component currentComponent = (Component)stack.get(stack.size() - 1);
            stack.remove(stack.size() - 1);
            if (!handler.apply((Object)currentComponent)) {
                return;
            }
            if (!(currentComponent instanceof HasComponents)) continue;
            ArrayList children = Lists.newArrayList((Iterable)((HasComponents)currentComponent));
            Collections.reverse(children);
            stack.addAll(children);
        }
    }

    protected static void readAndLocalizeDesign(Component component, InputStream designStream, CmsMessages messages, Map<String, String> macros) {
        try {
            byte[] designBytes = CmsFileUtil.readFully(designStream, true);
            String encoding = "UTF-8";
            String design = new String(designBytes, "UTF-8");
            CmsMacroResolver resolver = new CmsMacroResolver(){

                @Override
                public String getMacroValue(String macro) {
                    String result = super.getMacroValue(macro);
                    return CmsEncoder.escapeXml(result);
                }
            };
            if (macros != null) {
                for (Map.Entry<String, String> entry : macros.entrySet()) {
                    resolver.addMacro(entry.getKey(), entry.getValue());
                }
            }
            if (messages != null) {
                resolver.setMessages(messages);
            }
            String resolvedDesign = resolver.resolveMacros(design);
            Design.read((InputStream)new ByteArrayInputStream(resolvedDesign.getBytes("UTF-8")), (Component)component);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read design", e);
        }
        finally {
            try {
                designStream.close();
            }
            catch (IOException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private static boolean isSingleOu(List<CmsProject> projects) {
        String ouFqn = null;
        for (CmsProject project : projects) {
            if (project.isOnlineProject()) continue;
            if (ouFqn == null) {
                ouFqn = project.getOuFqn();
                continue;
            }
            if (ouFqn.equals(project.getOuFqn())) continue;
            return false;
        }
        return true;
    }

    public static enum PropertyId {
        caption,
        icon,
        isFolder,
        isXmlContent;

    }

    public static class OptionGroupBuilder {
        private OptionGroup m_optionGroup = new OptionGroup();

        public OptionGroupBuilder add(String key, String text) {
            this.m_optionGroup.addItem((Object)key);
            this.m_optionGroup.setItemCaption((Object)key, text);
            return this;
        }

        public OptionGroup build() {
            return this.m_optionGroup;
        }

        public OptionGroupBuilder horizontal() {
            this.m_optionGroup.addStyleName("horizontal");
            return this;
        }
    }
}

