/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.I_CmsWorkplaceAction;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsLockedResourcesList;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public abstract class A_CmsWorkplaceAction
implements I_CmsWorkplaceAction {
    private static final Log LOG = CmsLog.getLog(A_CmsWorkplaceAction.class);

    public String getDialogTitle() {
        return this.getTitle();
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        return this.getVisibility(context.getCms(), context.getResources());
    }

    @Override
    public boolean isActive(I_CmsDialogContext context) {
        return this.getVisibility(context).isActive();
    }

    protected String getWorkplaceMessage(String key) {
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(UI.getCurrent().getLocale());
        return messages.key(key);
    }

    protected boolean hasBlockingLocks(final I_CmsDialogContext context) {
        CmsObject cms = context.getCms();
        List<CmsResource> resources = context.getResources();
        ArrayList blocked = Lists.newArrayList();
        for (CmsResource resource : resources) {
            try {
                blocked.addAll(cms.getBlockingLockedResources(resource));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (blocked.isEmpty()) {
            return false;
        }
        CmsLockedResourcesList dialog = new CmsLockedResourcesList(cms, blocked, CmsVaadinUtils.getMessageText("GUI_CANT_PERFORM_OPERATION_BECAUSE_OF_LOCKED_RESOURCES_0", new Object[0]), new Runnable(){

            @Override
            public void run() {
                List<CmsUUID> noStructureIds = Collections.emptyList();
                context.finish(noStructureIds);
            }
        }, null);
        context.start(CmsVaadinUtils.getMessageText("GUI_EXPLORER_CONTEXT_LOCKS_0", new Object[0]), (Component)dialog);
        return true;
    }

    protected void openDialog(CmsBasicDialog dialog, I_CmsDialogContext context) {
        context.start(this.getDialogTitle(), (Component)dialog);
    }
}

